/*
 * Decompiled with CFR 0.152.
 */
package org.jparsec;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import org.jparsec.BestParser;
import org.jparsec.IntOrder;
import org.jparsec.InternalFunctors;
import org.jparsec.ParseContext;
import org.jparsec.Parser;
import org.jparsec.ParserState;
import org.jparsec.SourceLocation;
import org.jparsec.Token;
import org.jparsec.TokenMap;
import org.jparsec.functors.Map3;
import org.jparsec.functors.Map4;
import org.jparsec.functors.Map5;
import org.jparsec.functors.Map6;
import org.jparsec.functors.Map7;
import org.jparsec.functors.Map8;
import org.jparsec.functors.Pair;
import org.jparsec.functors.Tuple3;
import org.jparsec.functors.Tuple4;
import org.jparsec.functors.Tuple5;
import org.jparsec.internal.annotations.Private;
import org.jparsec.internal.util.Lists;

public final class Parsers {
    public static final Parser<?> EOF = Parsers.eof("EOF");
    public static final Parser<Object> ANY_TOKEN = Parsers.token(new TokenMap<Object>(){

        @Override
        public Object map(Token tok) {
            return tok.value();
        }

        public String toString() {
            return "any token";
        }
    });
    @Deprecated
    public static final Parser<Integer> INDEX = new Parser<Integer>(){

        @Override
        boolean apply(ParseContext ctxt) {
            ctxt.result = ctxt.getIndex();
            return true;
        }

        public String toString() {
            return "getIndex";
        }
    };
    public static final Parser<SourceLocation> SOURCE_LOCATION = new Parser<SourceLocation>(){

        @Override
        boolean apply(ParseContext ctxt) {
            ctxt.result = new SourceLocation(ctxt.getIndex(), ctxt.locator);
            return true;
        }

        public String toString() {
            return "SOURCE_LOCATION";
        }
    };
    private static final Parser ALWAYS = Parsers.constant(null);
    private static final Parser NEVER = new Parser<Object>(){

        @Override
        boolean apply(ParseContext ctxt) {
            return false;
        }

        public String toString() {
            return "never";
        }
    };
    static final Parser<Boolean> TRUE = Parsers.constant(true);
    static final Parser<Boolean> FALSE = Parsers.constant(false);

    public static <T> Parser<T> always() {
        return ALWAYS;
    }

    public static <T> Parser<T> never() {
        return NEVER;
    }

    static Parser<?> eof(final String message) {
        return new Parser<Object>(){

            @Override
            boolean apply(ParseContext ctxt) {
                if (ctxt.isEof()) {
                    return true;
                }
                ctxt.missing(message);
                return false;
            }

            public String toString() {
                return message;
            }
        };
    }

    public static <T> Parser<T> fail(final String message) {
        return new Parser<T>(){

            @Override
            boolean apply(ParseContext ctxt) {
                ctxt.fail(message);
                return false;
            }

            public String toString() {
                return message;
            }
        };
    }

    @Deprecated
    public static Parser<?> runnable(final Runnable runnable) {
        return new Parser<Object>(){

            @Override
            boolean apply(ParseContext ctxt) {
                runnable.run();
                return true;
            }

            public String toString() {
                return runnable.toString();
            }
        };
    }

    static Parser<Token[]> tokens(Parser<? extends Collection<Token>> parser) {
        return parser.map(list -> list.toArray(new Token[list.size()]));
    }

    static <T> Parser<T> nested(final Parser<Token[]> lexer, final Parser<? extends T> parser) {
        return new Parser<T>(){

            @Override
            boolean apply(ParseContext ctxt) {
                if (!lexer.apply(ctxt)) {
                    return false;
                }
                Token[] tokens = (Token[])lexer.getReturn(ctxt);
                ParserState parserState = new ParserState(ctxt.module, ctxt.source, tokens, 0, ctxt.locator, ctxt.getIndex(), tokens);
                ctxt.getTrace().startFresh(parserState);
                return ctxt.applyNested(parser, parserState);
            }

            public String toString() {
                return parser.toString();
            }
        };
    }

    public static <T> Parser<T> constant(final T v) {
        return new Parser<T>(){

            @Override
            boolean apply(ParseContext ctxt) {
                ctxt.result = v;
                return true;
            }

            public String toString() {
                return String.valueOf(v);
            }
        };
    }

    public static <T> Parser<T> sequence(Parser<?> p1, Parser<T> p2) {
        return Parsers.sequence(p1, p2, InternalFunctors.lastOfTwo());
    }

    public static <T> Parser<T> sequence(Parser<?> p1, Parser<?> p2, Parser<T> p3) {
        return Parsers.sequence(p1, p2, p3, InternalFunctors.lastOfThree());
    }

    public static <T> Parser<T> sequence(Parser<?> p1, Parser<?> p2, Parser<?> p3, Parser<T> p4) {
        return Parsers.sequence(p1, p2, p3, p4, InternalFunctors.lastOfFour());
    }

    public static <T> Parser<T> sequence(Parser<?> p1, Parser<?> p2, Parser<?> p3, Parser<?> p4, Parser<T> p5) {
        return Parsers.sequence(p1, p2, p3, p4, p5, InternalFunctors.lastOfFive());
    }

    @Deprecated
    public static <A, B> Parser<Pair<A, B>> pair(Parser<? extends A> p1, Parser<? extends B> p2) {
        return Parsers.sequence(p1, p2, Pair::new);
    }

    @Deprecated
    public static <A, B> Parser<Pair<A, B>> tuple(Parser<? extends A> p1, Parser<? extends B> p2) {
        return Parsers.pair(p1, p2);
    }

    @Deprecated
    public static <A, B, C> Parser<Tuple3<A, B, C>> tuple(Parser<? extends A> p1, Parser<? extends B> p2, Parser<? extends C> p3) {
        return Parsers.sequence(p1, p2, p3, Tuple3::new);
    }

    @Deprecated
    public static <A, B, C, D> Parser<Tuple4<A, B, C, D>> tuple(Parser<? extends A> p1, Parser<? extends B> p2, Parser<? extends C> p3, Parser<? extends D> p4) {
        return Parsers.sequence(p1, p2, p3, p4, Tuple4::new);
    }

    @Deprecated
    public static <A, B, C, D, E> Parser<Tuple5<A, B, C, D, E>> tuple(Parser<? extends A> p1, Parser<? extends B> p2, Parser<? extends C> p3, Parser<? extends D> p4, Parser<? extends E> p5) {
        return Parsers.sequence(p1, p2, p3, p4, p5, Tuple5::new);
    }

    public static Parser<Object[]> array(final Parser<?> ... parsers) {
        return new Parser<Object[]>(){

            @Override
            boolean apply(ParseContext ctxt) {
                Object[] ret = new Object[parsers.length];
                for (int i = 0; i < parsers.length; ++i) {
                    Parser parser = parsers[i];
                    if (!parser.apply(ctxt)) {
                        return false;
                    }
                    ret[i] = parser.getReturn(ctxt);
                }
                ctxt.result = ret;
                return true;
            }

            public String toString() {
                return "array";
            }
        };
    }

    public static <T> Parser<List<T>> list(Iterable<? extends Parser<? extends T>> parsers) {
        final Parser[] array = Parsers.toArray(parsers);
        return new Parser<List<T>>(){

            @Override
            boolean apply(ParseContext ctxt) {
                ArrayList list = Lists.arrayList(array.length);
                for (Parser parser : array) {
                    if (!parser.apply(ctxt)) {
                        return false;
                    }
                    list.add(parser.getReturn(ctxt));
                }
                ctxt.result = list;
                return true;
            }

            public String toString() {
                return "list";
            }
        };
    }

    public static <T> Parser<T> between(Parser<?> before, Parser<T> parser, Parser<?> after) {
        return parser.between(before, after);
    }

    public static <A, B, T> Parser<T> sequence(final Parser<A> p1, final Parser<B> p2, final BiFunction<? super A, ? super B, ? extends T> map) {
        return new Parser<T>(){

            @Override
            boolean apply(ParseContext ctxt) {
                boolean r1 = p1.apply(ctxt);
                if (!r1) {
                    return false;
                }
                Object o1 = p1.getReturn(ctxt);
                boolean r2 = p2.apply(ctxt);
                if (!r2) {
                    return false;
                }
                Object o2 = p2.getReturn(ctxt);
                ctxt.result = map.apply(o1, o2);
                return true;
            }

            public String toString() {
                return map.toString();
            }
        };
    }

    public static <A, B, C, T> Parser<T> sequence(final Parser<A> p1, final Parser<B> p2, final Parser<C> p3, final Map3<? super A, ? super B, ? super C, ? extends T> map) {
        return new Parser<T>(){

            @Override
            boolean apply(ParseContext ctxt) {
                boolean r1 = p1.apply(ctxt);
                if (!r1) {
                    return false;
                }
                Object o1 = p1.getReturn(ctxt);
                boolean r2 = p2.apply(ctxt);
                if (!r2) {
                    return false;
                }
                Object o2 = p2.getReturn(ctxt);
                boolean r3 = p3.apply(ctxt);
                if (!r3) {
                    return false;
                }
                Object o3 = p3.getReturn(ctxt);
                ctxt.result = map.map(o1, o2, o3);
                return true;
            }

            public String toString() {
                return map.toString();
            }
        };
    }

    public static <A, B, C, D, T> Parser<T> sequence(final Parser<A> p1, final Parser<B> p2, final Parser<C> p3, final Parser<D> p4, final Map4<? super A, ? super B, ? super C, ? super D, ? extends T> map) {
        return new Parser<T>(){

            @Override
            boolean apply(ParseContext ctxt) {
                boolean r1 = p1.apply(ctxt);
                if (!r1) {
                    return false;
                }
                Object o1 = p1.getReturn(ctxt);
                boolean r2 = p2.apply(ctxt);
                if (!r2) {
                    return false;
                }
                Object o2 = p2.getReturn(ctxt);
                boolean r3 = p3.apply(ctxt);
                if (!r3) {
                    return false;
                }
                Object o3 = p3.getReturn(ctxt);
                boolean r4 = p4.apply(ctxt);
                if (!r4) {
                    return false;
                }
                Object o4 = p4.getReturn(ctxt);
                ctxt.result = map.map(o1, o2, o3, o4);
                return true;
            }

            public String toString() {
                return map.toString();
            }
        };
    }

    public static <A, B, C, D, E, T> Parser<T> sequence(final Parser<A> p1, final Parser<B> p2, final Parser<C> p3, final Parser<D> p4, final Parser<E> p5, final Map5<? super A, ? super B, ? super C, ? super D, ? super E, ? extends T> map) {
        return new Parser<T>(){

            @Override
            boolean apply(ParseContext ctxt) {
                boolean r1 = p1.apply(ctxt);
                if (!r1) {
                    return false;
                }
                Object o1 = p1.getReturn(ctxt);
                boolean r2 = p2.apply(ctxt);
                if (!r2) {
                    return false;
                }
                Object o2 = p2.getReturn(ctxt);
                boolean r3 = p3.apply(ctxt);
                if (!r3) {
                    return false;
                }
                Object o3 = p3.getReturn(ctxt);
                boolean r4 = p4.apply(ctxt);
                if (!r4) {
                    return false;
                }
                Object o4 = p4.getReturn(ctxt);
                boolean r5 = p5.apply(ctxt);
                if (!r5) {
                    return false;
                }
                Object o5 = p5.getReturn(ctxt);
                ctxt.result = map.map(o1, o2, o3, o4, o5);
                return true;
            }

            public String toString() {
                return map.toString();
            }
        };
    }

    public static <A, B, C, D, E, F, T> Parser<T> sequence(final Parser<A> p1, final Parser<B> p2, final Parser<C> p3, final Parser<D> p4, final Parser<E> p5, final Parser<F> p6, final Map6<? super A, ? super B, ? super C, ? super D, ? super E, ? super F, ? extends T> map) {
        return new Parser<T>(){

            @Override
            boolean apply(ParseContext ctxt) {
                boolean r1 = p1.apply(ctxt);
                if (!r1) {
                    return false;
                }
                Object o1 = p1.getReturn(ctxt);
                boolean r2 = p2.apply(ctxt);
                if (!r2) {
                    return false;
                }
                Object o2 = p2.getReturn(ctxt);
                boolean r3 = p3.apply(ctxt);
                if (!r3) {
                    return false;
                }
                Object o3 = p3.getReturn(ctxt);
                boolean r4 = p4.apply(ctxt);
                if (!r4) {
                    return false;
                }
                Object o4 = p4.getReturn(ctxt);
                boolean r5 = p5.apply(ctxt);
                if (!r5) {
                    return false;
                }
                Object o5 = p5.getReturn(ctxt);
                boolean r6 = p6.apply(ctxt);
                if (!r6) {
                    return false;
                }
                Object o6 = p6.getReturn(ctxt);
                ctxt.result = map.map(o1, o2, o3, o4, o5, o6);
                return true;
            }

            public String toString() {
                return map.toString();
            }
        };
    }

    public static <A, B, C, D, E, F, G, T> Parser<T> sequence(final Parser<A> p1, final Parser<B> p2, final Parser<C> p3, final Parser<D> p4, final Parser<E> p5, final Parser<F> p6, final Parser<G> p7, final Map7<? super A, ? super B, ? super C, ? super D, ? super E, ? super F, ? super G, ? extends T> map) {
        return new Parser<T>(){

            @Override
            boolean apply(ParseContext ctxt) {
                boolean r1 = p1.apply(ctxt);
                if (!r1) {
                    return false;
                }
                Object o1 = p1.getReturn(ctxt);
                boolean r2 = p2.apply(ctxt);
                if (!r2) {
                    return false;
                }
                Object o2 = p2.getReturn(ctxt);
                boolean r3 = p3.apply(ctxt);
                if (!r3) {
                    return false;
                }
                Object o3 = p3.getReturn(ctxt);
                boolean r4 = p4.apply(ctxt);
                if (!r4) {
                    return false;
                }
                Object o4 = p4.getReturn(ctxt);
                boolean r5 = p5.apply(ctxt);
                if (!r5) {
                    return false;
                }
                Object o5 = p5.getReturn(ctxt);
                boolean r6 = p6.apply(ctxt);
                if (!r6) {
                    return false;
                }
                Object o6 = p6.getReturn(ctxt);
                boolean r7 = p7.apply(ctxt);
                if (!r7) {
                    return false;
                }
                Object o7 = p7.getReturn(ctxt);
                ctxt.result = map.map(o1, o2, o3, o4, o5, o6, o7);
                return true;
            }

            public String toString() {
                return map.toString();
            }
        };
    }

    public static <A, B, C, D, E, F, G, H, T> Parser<T> sequence(final Parser<A> p1, final Parser<B> p2, final Parser<C> p3, final Parser<D> p4, final Parser<E> p5, final Parser<F> p6, final Parser<G> p7, final Parser<H> p8, final Map8<? super A, ? super B, ? super C, ? super D, ? super E, ? super F, ? super G, ? super H, ? extends T> map) {
        return new Parser<T>(){

            @Override
            boolean apply(ParseContext ctxt) {
                boolean r1 = p1.apply(ctxt);
                if (!r1) {
                    return false;
                }
                Object o1 = p1.getReturn(ctxt);
                boolean r2 = p2.apply(ctxt);
                if (!r2) {
                    return false;
                }
                Object o2 = p2.getReturn(ctxt);
                boolean r3 = p3.apply(ctxt);
                if (!r3) {
                    return false;
                }
                Object o3 = p3.getReturn(ctxt);
                boolean r4 = p4.apply(ctxt);
                if (!r4) {
                    return false;
                }
                Object o4 = p4.getReturn(ctxt);
                boolean r5 = p5.apply(ctxt);
                if (!r5) {
                    return false;
                }
                Object o5 = p5.getReturn(ctxt);
                boolean r6 = p6.apply(ctxt);
                if (!r6) {
                    return false;
                }
                Object o6 = p6.getReturn(ctxt);
                boolean r7 = p7.apply(ctxt);
                if (!r7) {
                    return false;
                }
                Object o7 = p7.getReturn(ctxt);
                boolean r8 = p8.apply(ctxt);
                if (!r8) {
                    return false;
                }
                Object o8 = p8.getReturn(ctxt);
                ctxt.result = map.map(o1, o2, o3, o4, o5, o6, o7, o8);
                return true;
            }

            public String toString() {
                return map.toString();
            }
        };
    }

    public static Parser<Object> sequence(final Parser<?> ... parsers) {
        return new Parser<Object>(){

            @Override
            boolean apply(ParseContext ctxt) {
                for (Parser p : parsers) {
                    if (p.apply(ctxt)) continue;
                    return false;
                }
                return true;
            }

            public String toString() {
                return "sequence";
            }
        };
    }

    public static Parser<Object> sequence(Iterable<? extends Parser<?>> parsers) {
        return Parsers.sequence(Parsers.toArray(parsers));
    }

    public static <T> Parser<T> or(Parser<? extends T> p1, Parser<? extends T> p2) {
        return Parsers.alt(p1, p2).cast();
    }

    public static <T> Parser<T> or(Parser<? extends T> p1, Parser<? extends T> p2, Parser<? extends T> p3) {
        return Parsers.alt(p1, p2, p3).cast();
    }

    public static <T> Parser<T> or(Parser<? extends T> p1, Parser<? extends T> p2, Parser<? extends T> p3, Parser<? extends T> p4) {
        return Parsers.alt(p1, p2, p3, p4).cast();
    }

    public static <T> Parser<T> or(Parser<? extends T> p1, Parser<? extends T> p2, Parser<? extends T> p3, Parser<? extends T> p4, Parser<? extends T> p5) {
        return Parsers.alt(p1, p2, p3, p4, p5).cast();
    }

    public static <T> Parser<T> or(Parser<? extends T> p1, Parser<? extends T> p2, Parser<? extends T> p3, Parser<? extends T> p4, Parser<? extends T> p5, Parser<? extends T> p6) {
        return Parsers.alt(p1, p2, p3, p4, p5, p6).cast();
    }

    public static <T> Parser<T> or(Parser<? extends T> p1, Parser<? extends T> p2, Parser<? extends T> p3, Parser<? extends T> p4, Parser<? extends T> p5, Parser<? extends T> p6, Parser<? extends T> p7) {
        return Parsers.alt(p1, p2, p3, p4, p5, p6, p7).cast();
    }

    public static <T> Parser<T> or(Parser<? extends T> p1, Parser<? extends T> p2, Parser<? extends T> p3, Parser<? extends T> p4, Parser<? extends T> p5, Parser<? extends T> p6, Parser<? extends T> p7, Parser<? extends T> p8) {
        return Parsers.alt(p1, p2, p3, p4, p5, p6, p7, p8).cast();
    }

    public static <T> Parser<T> or(Parser<? extends T> p1, Parser<? extends T> p2, Parser<? extends T> p3, Parser<? extends T> p4, Parser<? extends T> p5, Parser<? extends T> p6, Parser<? extends T> p7, Parser<? extends T> p8, Parser<? extends T> p9) {
        return Parsers.alt(p1, p2, p3, p4, p5, p6, p7, p8, p9).cast();
    }

    public static <T> Parser<T> or(final Parser<? extends T> ... alternatives) {
        if (alternatives.length == 0) {
            return Parsers.never();
        }
        if (alternatives.length == 1) {
            return alternatives[0].cast();
        }
        return new Parser<T>(){

            @Override
            boolean apply(ParseContext ctxt) {
                Object result = ctxt.result;
                int at = ctxt.at;
                int step = ctxt.step;
                for (Parser p : alternatives) {
                    if (p.apply(ctxt)) {
                        return true;
                    }
                    ctxt.set(step, at, result);
                }
                return false;
            }

            public String toString() {
                return "or";
            }
        };
    }

    public static <T> Parser<T> or(Iterable<? extends Parser<? extends T>> alternatives) {
        return Parsers.or(Parsers.toArray(alternatives));
    }

    private static Parser<Object> alt(Parser<?> ... alternatives) {
        return Parsers.or(alternatives);
    }

    public static <T> Parser<T> longer(Parser<? extends T> p1, Parser<? extends T> p2) {
        return Parsers.longest(p1, p2);
    }

    public static <T> Parser<T> longest(Parser<? extends T> ... parsers) {
        if (parsers.length == 0) {
            return Parsers.never();
        }
        if (parsers.length == 1) {
            return parsers[0].cast();
        }
        return new BestParser<T>(parsers, IntOrder.GT);
    }

    public static <T> Parser<T> longest(Iterable<? extends Parser<? extends T>> parsers) {
        return Parsers.longest(Parsers.toArray(parsers));
    }

    public static <T> Parser<T> shorter(Parser<? extends T> p1, Parser<? extends T> p2) {
        return Parsers.shortest(p1, p2);
    }

    public static <T> Parser<T> shortest(Parser<? extends T> ... parsers) {
        if (parsers.length == 0) {
            return Parsers.never();
        }
        if (parsers.length == 1) {
            return parsers[0].cast();
        }
        return new BestParser<T>(parsers, IntOrder.LT);
    }

    public static <T> Parser<T> shortest(Iterable<? extends Parser<? extends T>> parsers) {
        return Parsers.shortest(Parsers.toArray(parsers));
    }

    public static <T> Parser<T> expect(final String name) {
        return new Parser<T>(){

            @Override
            boolean apply(ParseContext ctxt) {
                ctxt.expected(name);
                return false;
            }

            public String toString() {
                return name;
            }
        };
    }

    public static <T> Parser<T> unexpected(final String name) {
        return new Parser<T>(){

            @Override
            boolean apply(ParseContext ctxt) {
                ctxt.unexpected(name);
                return false;
            }

            public String toString() {
                return name;
            }
        };
    }

    public static <T> Parser<T> token(final TokenMap<? extends T> fromToken) {
        return new Parser<T>(){

            @Override
            boolean apply(ParseContext ctxt) {
                if (ctxt.isEof()) {
                    ctxt.missing(fromToken);
                    return false;
                }
                Token token = ctxt.getToken();
                Object v = fromToken.map(token);
                if (v == null) {
                    ctxt.missing(fromToken);
                    return false;
                }
                ctxt.result = v;
                ctxt.next();
                return true;
            }

            public String toString() {
                return fromToken.toString();
            }
        };
    }

    public static <T> Parser<T> tokenType(final Class<? extends T> type, final String name) {
        return Parsers.token(new TokenMap<T>(){

            @Override
            public T map(Token token) {
                if (type.isInstance(token.value())) {
                    return type.cast(token.value());
                }
                return null;
            }

            public String toString() {
                return name;
            }
        });
    }

    @Private
    static <T> Parser<T>[] toArrayWithIteration(Iterable<? extends Parser<? extends T>> parsers) {
        ArrayList list = Lists.arrayList();
        for (Parser<T> parser : parsers) {
            list.add(parser);
        }
        return Parsers.toArray(list);
    }

    @Private
    static <T> Parser<T>[] toArray(Iterable<? extends Parser<? extends T>> parsers) {
        if (parsers instanceof Collection) {
            return Parsers.toArray((Collection)parsers);
        }
        return Parsers.toArrayWithIteration(parsers);
    }

    private static <T> Parser<T>[] toArray(Collection<? extends Parser<? extends T>> parsers) {
        return parsers.toArray(new Parser[parsers.size()]);
    }

    private Parsers() {
    }
}

