/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.api.resource;

import java.util.Collection;
import java.util.Date;
import javax.annotation.security.PermitAll;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.traccar.api.BaseObjectResource;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.helper.LogAction;
import org.traccar.model.ManagedUser;
import org.traccar.model.Permission;
import org.traccar.model.User;
import org.traccar.storage.StorageException;
import org.traccar.storage.query.Columns;
import org.traccar.storage.query.Condition;
import org.traccar.storage.query.Request;

@Path(value="users")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class UserResource
extends BaseObjectResource<User> {
    @Inject
    private Config config;

    public UserResource() {
        super(User.class);
    }

    @GET
    public Collection<User> get(@QueryParam(value="userId") long userId) throws StorageException {
        if (userId > 0L) {
            this.permissionsService.checkUser(this.getUserId(), userId);
            return this.storage.getObjects(this.baseClass, new Request(new Columns.All(), new Condition.Permission(User.class, userId, ManagedUser.class).excludeGroups()));
        }
        if (this.permissionsService.notAdmin(this.getUserId())) {
            return this.storage.getObjects(this.baseClass, new Request(new Columns.All(), new Condition.Permission(User.class, this.getUserId(), ManagedUser.class).excludeGroups()));
        }
        return this.storage.getObjects(this.baseClass, new Request(new Columns.All()));
    }

    @Override
    @PermitAll
    @POST
    public Response add(User entity) throws StorageException {
        User currentUser;
        User user = currentUser = this.getUserId() > 0L ? this.permissionsService.getUser(this.getUserId()) : null;
        if (currentUser == null || !currentUser.getAdministrator()) {
            this.permissionsService.checkUserUpdate(this.getUserId(), new User(), entity);
            if (currentUser != null && currentUser.getUserLimit() != 0) {
                int userCount;
                int userLimit = currentUser.getUserLimit();
                if (userLimit > 0 && (userCount = this.storage.getObjects(this.baseClass, new Request(new Columns.All(), new Condition.Permission(User.class, this.getUserId(), ManagedUser.class).excludeGroups())).size()) >= userLimit) {
                    throw new SecurityException("Manager user limit reached");
                }
            } else {
                if (!this.permissionsService.getServer().getRegistration()) {
                    throw new SecurityException("Registration disabled");
                }
                entity.setDeviceLimit(this.config.getInteger(Keys.USERS_DEFAULT_DEVICE_LIMIT));
                int expirationDays = this.config.getInteger(Keys.USERS_DEFAULT_EXPIRATION_DAYS);
                if (expirationDays > 0) {
                    entity.setExpirationTime(new Date(System.currentTimeMillis() + (long)expirationDays * 86400000L));
                }
            }
        }
        entity.setId(this.storage.addObject(entity, new Request(new Columns.Exclude("id"))));
        this.storage.updateObject(entity, new Request(new Columns.Include("hashedPassword", "salt"), new Condition.Equals("id", "id")));
        LogAction.create(this.getUserId(), entity);
        if (currentUser != null && currentUser.getUserLimit() != 0) {
            this.storage.addPermission(new Permission(User.class, this.getUserId(), ManagedUser.class, entity.getId()));
            LogAction.link(this.getUserId(), User.class, this.getUserId(), ManagedUser.class, entity.getId());
        }
        return Response.ok((Object)entity).build();
    }
}

