/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.handler.events;

import io.netty.channel.ChannelHandler;
import java.util.Collections;
import java.util.Map;
import javax.inject.Inject;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.handler.events.BaseEventHandler;
import org.traccar.helper.model.AttributeUtil;
import org.traccar.helper.model.PositionUtil;
import org.traccar.model.Device;
import org.traccar.model.Event;
import org.traccar.model.Geofence;
import org.traccar.model.Position;
import org.traccar.session.ConnectionManager;
import org.traccar.session.DeviceState;
import org.traccar.session.cache.CacheManager;

@ChannelHandler.Sharable
public class OverspeedEventHandler
extends BaseEventHandler {
    public static final String ATTRIBUTE_SPEED = "speed";
    private final ConnectionManager connectionManager;
    private final CacheManager cacheManager;
    private final boolean notRepeat;
    private final long minimalDuration;
    private final boolean preferLowest;

    @Inject
    public OverspeedEventHandler(Config config, ConnectionManager connectionManager, CacheManager cacheManager) {
        this.connectionManager = connectionManager;
        this.cacheManager = cacheManager;
        this.notRepeat = config.getBoolean(Keys.EVENT_OVERSPEED_NOT_REPEAT);
        this.minimalDuration = config.getLong(Keys.EVENT_OVERSPEED_MINIMAL_DURATION) * 1000L;
        this.preferLowest = config.getBoolean(Keys.EVENT_OVERSPEED_PREFER_LOWEST);
    }

    private Map<Event, Position> newEvent(DeviceState deviceState, double speedLimit) {
        Position position = deviceState.getOverspeedPosition();
        Event event = new Event("deviceOverspeed", position);
        event.set(ATTRIBUTE_SPEED, deviceState.getOverspeedPosition().getSpeed());
        event.set("speedLimit", speedLimit);
        event.setGeofenceId(deviceState.getOverspeedGeofenceId());
        deviceState.setOverspeedState(this.notRepeat);
        deviceState.setOverspeedPosition(null);
        deviceState.setOverspeedGeofenceId(0L);
        return Collections.singletonMap(event, position);
    }

    public Map<Event, Position> updateOverspeedState(DeviceState deviceState, double speedLimit) {
        Map<Event, Position> result = null;
        if (deviceState.getOverspeedState() != null && !deviceState.getOverspeedState().booleanValue() && deviceState.getOverspeedPosition() != null && speedLimit != 0.0) {
            long currentTime = System.currentTimeMillis();
            Position overspeedPosition = deviceState.getOverspeedPosition();
            long overspeedTime = overspeedPosition.getFixTime().getTime();
            if (overspeedTime + this.minimalDuration <= currentTime) {
                result = this.newEvent(deviceState, speedLimit);
            }
        }
        return result;
    }

    public Map<Event, Position> updateOverspeedState(DeviceState deviceState, Position position, double speedLimit, long geofenceId) {
        Position overspeedPosition;
        boolean newOverspeed;
        Map<Event, Position> result = null;
        Boolean oldOverspeed = deviceState.getOverspeedState();
        long currentTime = position.getFixTime().getTime();
        boolean bl = newOverspeed = position.getSpeed() > speedLimit;
        if (newOverspeed && !oldOverspeed.booleanValue()) {
            if (deviceState.getOverspeedPosition() == null) {
                deviceState.setOverspeedPosition(position);
                deviceState.setOverspeedGeofenceId(geofenceId);
            }
        } else if (oldOverspeed.booleanValue() && !newOverspeed) {
            deviceState.setOverspeedState(false);
            deviceState.setOverspeedPosition(null);
            deviceState.setOverspeedGeofenceId(0L);
        } else {
            deviceState.setOverspeedPosition(null);
            deviceState.setOverspeedGeofenceId(0L);
        }
        if ((overspeedPosition = deviceState.getOverspeedPosition()) != null) {
            long overspeedTime = overspeedPosition.getFixTime().getTime();
            if (newOverspeed && overspeedTime + this.minimalDuration <= currentTime) {
                result = this.newEvent(deviceState, speedLimit);
            }
        }
        return result;
    }

    @Override
    protected Map<Event, Position> analyzePosition(Position position) {
        long deviceId = position.getDeviceId();
        Device device = this.cacheManager.getObject(Device.class, position.getDeviceId());
        if (device == null) {
            return null;
        }
        if (!PositionUtil.isLatest(this.cacheManager, position) || !position.getValid()) {
            return null;
        }
        double speedLimit = AttributeUtil.lookup(this.cacheManager, Keys.EVENT_OVERSPEED_LIMIT, deviceId);
        double positionSpeedLimit = position.getDouble("speedLimit");
        if (positionSpeedLimit > 0.0) {
            speedLimit = positionSpeedLimit;
        }
        double geofenceSpeedLimit = 0.0;
        long overspeedGeofenceId = 0L;
        if (device.getGeofenceIds() != null) {
            for (long geofenceId : device.getGeofenceIds()) {
                double currentSpeedLimit;
                Geofence geofence = this.cacheManager.getObject(Geofence.class, geofenceId);
                if (geofence == null || !((currentSpeedLimit = geofence.getDouble(Keys.EVENT_OVERSPEED_LIMIT.getKey())) > 0.0 && geofenceSpeedLimit == 0.0 || this.preferLowest && currentSpeedLimit < geofenceSpeedLimit) && (this.preferLowest || !(currentSpeedLimit > geofenceSpeedLimit))) continue;
                geofenceSpeedLimit = currentSpeedLimit;
                overspeedGeofenceId = geofenceId;
            }
        }
        if (geofenceSpeedLimit > 0.0) {
            speedLimit = geofenceSpeedLimit;
        }
        if (speedLimit == 0.0) {
            return null;
        }
        Map<Event, Position> result = null;
        DeviceState deviceState = this.connectionManager.getDeviceState(deviceId);
        if (deviceState.getOverspeedState() == null) {
            deviceState.setOverspeedState(position.getSpeed() > speedLimit);
            deviceState.setOverspeedGeofenceId(position.getSpeed() > speedLimit ? overspeedGeofenceId : 0L);
        } else {
            result = this.updateOverspeedState(deviceState, position, speedLimit, overspeedGeofenceId);
        }
        this.connectionManager.setDeviceState(deviceId, deviceState);
        return result;
    }
}

