/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.guice.bridge.internal;

import com.google.inject.Binding;
import com.google.inject.ConfigurationException;
import com.google.inject.Injector;
import com.google.inject.Key;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashSet;
import javax.inject.Singleton;
import org.glassfish.hk2.api.Injectee;
import org.glassfish.hk2.api.JustInTimeInjectionResolver;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.ServiceLocatorUtilities;
import org.jvnet.hk2.guice.bridge.internal.GuiceServiceHk2Bean;

@Singleton
public class GuiceToHk2JITResolver
implements JustInTimeInjectionResolver {
    private final ServiceLocator locator;
    private final Injector guiceInjector;

    GuiceToHk2JITResolver(ServiceLocator locator, Injector guiceInjector) {
        this.locator = locator;
        this.guiceInjector = guiceInjector;
    }

    private Binding<?> findBinding(Injectee injectee) {
        if (injectee.getRequiredQualifiers().isEmpty()) {
            Key key = Key.get((Type)injectee.getRequiredType());
            try {
                return this.guiceInjector.getBinding(key);
            }
            catch (ConfigurationException ce) {
                return null;
            }
        }
        if (injectee.getRequiredQualifiers().size() > 1) {
            return null;
        }
        for (Annotation annotation : injectee.getRequiredQualifiers()) {
            Key key = Key.get((Type)injectee.getRequiredType(), (Annotation)annotation);
            Binding retVal = null;
            try {
                retVal = this.guiceInjector.getBinding(key);
            }
            catch (ConfigurationException ce) {
                return null;
            }
            if (retVal == null) continue;
            return retVal;
        }
        return null;
    }

    public static Class<?> getClassFromType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            return (Class)pt.getRawType();
        }
        return null;
    }

    public boolean justInTimeResolution(Injectee failedInjectionPoint) {
        if (failedInjectionPoint.getParent() == null) {
            return false;
        }
        Class<?> implClass = GuiceToHk2JITResolver.getClassFromType(failedInjectionPoint.getRequiredType());
        if (implClass == null) {
            return false;
        }
        Binding<?> binding = this.findBinding(failedInjectionPoint);
        if (binding == null) {
            return false;
        }
        HashSet<Type> contracts = new HashSet<Type>();
        contracts.add(failedInjectionPoint.getRequiredType());
        HashSet<Annotation> qualifiers = new HashSet<Annotation>(failedInjectionPoint.getRequiredQualifiers());
        GuiceServiceHk2Bean guiceBean = new GuiceServiceHk2Bean(contracts, qualifiers, implClass, binding);
        ServiceLocatorUtilities.addOneDescriptor((ServiceLocator)this.locator, guiceBean);
        return true;
    }
}

