/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.selectors.attributes;

import org.w3c.css.selectors.AttributeSelector;
import org.w3c.css.selectors.Selector;
import org.w3c.css.selectors.attributes.AttributeAny;
import org.w3c.css.selectors.attributes.AttributeBegin;
import org.w3c.css.selectors.attributes.AttributeOneOf;
import org.w3c.css.selectors.attributes.AttributeStart;
import org.w3c.css.selectors.attributes.AttributeSubstr;
import org.w3c.css.selectors.attributes.AttributeSuffix;
import org.w3c.css.util.ApplContext;

public class AttributeExact
extends AttributeSelector {
    private String value;

    public AttributeExact(String name, String value) {
        this.setName(name);
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public boolean canApply(Selector other) {
        if (this.getName().equals(other.getName())) {
            if (other instanceof AttributeAny) {
                return true;
            }
            if (other instanceof AttributeExact || other instanceof AttributeOneOf || other instanceof AttributeBegin) {
                return this.value.equals(((AttributeExact)other).getValue());
            }
            return false;
        }
        return true;
    }

    @Override
    public void applyAttribute(ApplContext ac, AttributeSelector attr) {
        String name = this.getName();
        if (name.equals(attr.getName())) {
            String othervalue;
            if (attr instanceof AttributeExact) {
                if (!this.value.equals(((AttributeExact)attr).getValue())) {
                    ac.getFrame().addWarning("incompatible", new String[]{this.toString(), attr.toString()});
                }
            } else if (attr instanceof AttributeOneOf) {
                ((AttributeOneOf)attr).applyAttribute(ac, this);
            } else if (attr instanceof AttributeBegin) {
                String othervalue2 = ((AttributeBegin)attr).getValue();
                if (!this.value.equals(othervalue2) && !this.value.startsWith(othervalue2 + "-")) {
                    ac.getFrame().addWarning("incompatible", new String[]{this.toString(), attr.toString()});
                }
            } else if (attr instanceof AttributeSubstr) {
                String othervalue3 = ((AttributeSubstr)attr).getValue();
                if (this.value.indexOf(othervalue3) < 0) {
                    ac.getFrame().addWarning("incompatible", new String[]{this.toString(), attr.toString()});
                }
            } else if (attr instanceof AttributeStart) {
                String othervalue4 = ((AttributeStart)attr).getValue();
                if (!this.value.startsWith(othervalue4)) {
                    ac.getFrame().addWarning("incompatible", new String[]{this.toString(), attr.toString()});
                }
            } else if (attr instanceof AttributeSuffix && !this.value.endsWith(othervalue = ((AttributeSuffix)attr).getValue())) {
                ac.getFrame().addWarning("incompatible", new String[]{this.toString(), attr.toString()});
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[').append(this.getName()).append("=\"").append(this.value).append("\"]");
        return sb.toString();
    }
}

