/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.jdbc.permission;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleSecurityException;
import org.apache.guacamole.auth.jdbc.base.EntityModel;
import org.apache.guacamole.auth.jdbc.base.ModeledPermissions;
import org.apache.guacamole.auth.jdbc.permission.AbstractPermissionService;
import org.apache.guacamole.auth.jdbc.permission.PermissionMapper;
import org.apache.guacamole.auth.jdbc.user.ModeledAuthenticatedUser;
import org.apache.guacamole.net.auth.permission.Permission;
import org.apache.guacamole.net.auth.permission.PermissionSet;

public abstract class ModeledPermissionService<PermissionSetType extends PermissionSet<PermissionType>, PermissionType extends Permission, ModelType>
extends AbstractPermissionService<PermissionSetType, PermissionType> {
    protected abstract PermissionMapper<ModelType> getPermissionMapper();

    protected abstract PermissionType getPermissionInstance(ModelType var1);

    protected Set<PermissionType> getPermissionInstances(Collection<ModelType> models) {
        HashSet<PermissionType> permissions = new HashSet<PermissionType>(models.size());
        for (ModelType model : models) {
            permissions.add(this.getPermissionInstance(model));
        }
        return permissions;
    }

    protected abstract ModelType getModelInstance(ModeledPermissions<? extends EntityModel> var1, PermissionType var2);

    protected Collection<ModelType> getModelInstances(ModeledPermissions<? extends EntityModel> targetEntity, Collection<PermissionType> permissions) {
        ArrayList<ModelType> models = new ArrayList<ModelType>(permissions.size());
        for (Permission permission : permissions) {
            models.add(this.getModelInstance(targetEntity, permission));
        }
        return models;
    }

    @Override
    public Set<PermissionType> retrievePermissions(ModeledAuthenticatedUser user, ModeledPermissions<? extends EntityModel> targetEntity, Set<String> effectiveGroups) throws GuacamoleException {
        if (this.canReadPermissions(user, targetEntity)) {
            return this.getPermissionInstances(this.getPermissionMapper().select((EntityModel)targetEntity.getModel(), effectiveGroups));
        }
        throw new GuacamoleSecurityException("Permission denied.");
    }
}

