/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.util.List;
import java.util.Locale;
import org.eclipse.jetty.http.ComplianceViolation;
import org.eclipse.jetty.http.CookieCompliance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CookieCutter {
    protected static final Logger LOG = LoggerFactory.getLogger(CookieCutter.class);
    protected final CookieCompliance _complianceMode;
    private final ComplianceViolation.Listener _complianceListener;

    protected CookieCutter(CookieCompliance compliance, ComplianceViolation.Listener complianceListener) {
        this._complianceMode = compliance;
        this._complianceListener = complianceListener;
    }

    protected void parseFields(List<String> rawFields) {
        StringBuilder unquoted = null;
        for (String hdr : rawFields) {
            String name = null;
            String cookieName = null;
            String cookieValue = null;
            String cookiePath = null;
            String cookieDomain = null;
            String cookieComment = null;
            int cookieVersion = 0;
            boolean invalue = false;
            boolean inQuoted = false;
            boolean quoted = false;
            boolean escaped = false;
            boolean reject = false;
            int tokenstart = -1;
            int tokenend = -1;
            int length = hdr.length();
            block32: for (int i = 0; i <= length; ++i) {
                char c;
                char c2 = c = i == length ? (char)'\u0000' : hdr.charAt(i);
                if (inQuoted) {
                    if (escaped) {
                        escaped = false;
                        if (c > '\u0000') {
                            unquoted.append(c);
                            continue;
                        }
                        unquoted.setLength(0);
                        inQuoted = false;
                        --i;
                        continue;
                    }
                    switch (c) {
                        case '\"': {
                            inQuoted = false;
                            quoted = true;
                            tokenstart = i;
                            tokenend = -1;
                            break;
                        }
                        case '\\': {
                            escaped = true;
                            break;
                        }
                        case '\u0000': {
                            unquoted.setLength(0);
                            inQuoted = false;
                            --i;
                            break;
                        }
                        default: {
                            unquoted.append(c);
                            break;
                        }
                    }
                    continue;
                }
                if (invalue) {
                    switch (c) {
                        case '\t': 
                        case ' ': {
                            break;
                        }
                        case ',': {
                            if (CookieCompliance.Violation.COMMA_NOT_VALID_OCTET.isAllowedBy(this._complianceMode)) {
                                this.reportComplianceViolation(CookieCompliance.Violation.COMMA_NOT_VALID_OCTET, "Cookie " + cookieName);
                            } else {
                                if (quoted) {
                                    unquoted.append(hdr, tokenstart, i--);
                                    inQuoted = true;
                                    quoted = false;
                                    break;
                                }
                                if (tokenstart < 0) {
                                    tokenstart = i;
                                }
                                tokenend = i;
                                break;
                            }
                        }
                        case '\u0000': 
                        case ';': {
                            String value2;
                            if (quoted) {
                                value2 = unquoted.toString();
                                unquoted.setLength(0);
                                quoted = false;
                            } else {
                                value2 = tokenstart >= 0 ? (tokenend >= tokenstart ? hdr.substring(tokenstart, tokenend + 1) : hdr.substring(tokenstart)) : "";
                            }
                            try {
                                if (name.startsWith("$")) {
                                    if (CookieCompliance.Violation.RESERVED_NAMES_NOT_DOLLAR_PREFIXED.isAllowedBy(this._complianceMode)) {
                                        String lowercaseName;
                                        this.reportComplianceViolation(CookieCompliance.Violation.RESERVED_NAMES_NOT_DOLLAR_PREFIXED, "Cookie " + cookieName + " field " + name);
                                        switch (lowercaseName = name.toLowerCase(Locale.ENGLISH)) {
                                            case "$path": {
                                                cookiePath = value2;
                                                break;
                                            }
                                            case "$domain": {
                                                cookieDomain = value2;
                                                break;
                                            }
                                            case "$port": {
                                                cookieComment = "$port=" + value2;
                                                break;
                                            }
                                            case "$version": {
                                                cookieVersion = Integer.parseInt(value2);
                                                break;
                                            }
                                        }
                                    }
                                } else {
                                    if (cookieName != null) {
                                        if (!reject) {
                                            this.addCookie(cookieName, cookieValue, cookieDomain, cookiePath, cookieVersion, cookieComment);
                                            reject = false;
                                        }
                                        cookieDomain = null;
                                        cookiePath = null;
                                        cookieComment = null;
                                    }
                                    cookieName = name;
                                    cookieValue = value2;
                                }
                            }
                            catch (Exception e) {
                                LOG.debug("Unable to process Cookie", e);
                            }
                            name = null;
                            tokenstart = -1;
                            invalue = false;
                            break;
                        }
                        case '\"': {
                            if (tokenstart < 0) {
                                tokenstart = i;
                                inQuoted = true;
                                if (unquoted != null) continue block32;
                                unquoted = new StringBuilder();
                                break;
                            }
                        }
                        default: {
                            if (quoted) {
                                unquoted.append(hdr, tokenstart, i--);
                                inQuoted = true;
                                quoted = false;
                                break;
                            }
                            if (this._complianceMode == CookieCompliance.RFC6265 && this.isRFC6265RejectedCharacter(inQuoted, c)) {
                                reject = true;
                            }
                            if (tokenstart < 0) {
                                tokenstart = i;
                            }
                            tokenend = i;
                            break;
                        }
                    }
                    continue;
                }
                switch (c) {
                    case '\u0000': 
                    case '\t': 
                    case ' ': {
                        continue block32;
                    }
                    case '\"': {
                        reject = true;
                        continue block32;
                    }
                    case ';': {
                        tokenstart = -1;
                        invalue = false;
                        reject = false;
                        continue block32;
                    }
                    case '=': {
                        if (quoted) {
                            name = unquoted.toString();
                            unquoted.setLength(0);
                            quoted = false;
                        } else if (tokenstart >= 0) {
                            name = tokenend >= tokenstart ? hdr.substring(tokenstart, tokenend + 1) : hdr.substring(tokenstart);
                        }
                        tokenstart = -1;
                        invalue = true;
                        continue block32;
                    }
                    default: {
                        if (quoted) {
                            unquoted.append(hdr, tokenstart, i--);
                            inQuoted = true;
                            quoted = false;
                            continue block32;
                        }
                        if (this._complianceMode == CookieCompliance.RFC6265 && this.isRFC6265RejectedCharacter(inQuoted, c)) {
                            reject = true;
                        }
                        if (tokenstart < 0) {
                            tokenstart = i;
                        }
                        tokenend = i;
                        continue block32;
                    }
                }
            }
            if (cookieName == null || reject) continue;
            this.addCookie(cookieName, cookieValue, cookieDomain, cookiePath, cookieVersion, cookieComment);
        }
    }

    protected void reportComplianceViolation(CookieCompliance.Violation violation, String reason) {
        if (this._complianceListener != null) {
            this._complianceListener.onComplianceViolation(this._complianceMode, violation, reason);
        }
    }

    protected abstract void addCookie(String var1, String var2, String var3, String var4, int var5, String var6);

    protected boolean isRFC6265RejectedCharacter(boolean inQuoted, char c) {
        if (inQuoted) {
            return Character.isISOControl(c);
        }
        return Character.isISOControl(c) || c > '\u007f' || c == ',' || c == ';';
    }
}

