/*
 * Decompiled with CFR 0.152.
 */
package com.ca.directory.jxplorer.broker;

import com.ca.commons.jndi.SchemaOps;
import com.ca.commons.naming.DN;
import com.ca.commons.naming.DXEntry;
import com.ca.commons.naming.DXNamingEnumeration;
import com.ca.directory.jxplorer.DataListener;
import com.ca.directory.jxplorer.DataQuery;
import com.ca.directory.jxplorer.DataSource;
import com.ca.directory.jxplorer.broker.StopMonitor;
import java.util.ArrayList;
import java.util.Vector;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;

public abstract class Broker
implements Runnable,
DataSource {
    protected Vector requestQueue = new Vector(10);
    protected Vector listeners = new Vector();
    private static int noBrokers = 0;
    public int id = noBrokers++;
    protected DataQuery current = null;
    StopMonitor stopMonitor = null;
    private static boolean debug = false;

    public void registerStopMonitor(StopMonitor monitor) {
        this.stopMonitor = monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataQuery push(DataQuery request) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            request.addDataListener((DataListener)this.listeners.get(i));
        }
        Vector vector = this.requestQueue;
        synchronized (vector) {
            this.requestQueue.add(request);
        }
        if (this.stopMonitor != null) {
            this.stopMonitor.updateWatchers();
        }
        vector = this.requestQueue;
        synchronized (vector) {
            this.requestQueue.notifyAll();
        }
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataQuery pop() {
        DataQuery request = null;
        Vector vector = this.requestQueue;
        synchronized (vector) {
            if (this.requestQueue.isEmpty()) {
                return null;
            }
            request = (DataQuery)this.requestQueue.firstElement();
            this.requestQueue.removeElementAt(0);
            request.setRunning();
        }
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeQuery(DataQuery query) {
        Vector vector = this.requestQueue;
        synchronized (vector) {
            this.requestQueue.remove(query);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasRequests() {
        Vector vector = this.requestQueue;
        synchronized (vector) {
            return !this.requestQueue.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            if (debug) {
                System.out.println("Thread: " + Thread.currentThread().getName() + " processing Queue of length: " + this.requestQueue.size() + " in broker " + this.id);
            }
            if (!this.processQueue()) {
                if (debug) {
                    System.out.println("Thread: " + Thread.currentThread().getName() + " ending." + this.requestQueue.size());
                }
                return;
            }
            try {
                if (debug) {
                    System.out.println("Thread: " + Thread.currentThread().getName() + " waiting in run() loop");
                }
                Vector vector = this.requestQueue;
                synchronized (vector) {
                    this.requestQueue.wait();
                }
                if (!debug) continue;
                System.out.println("Thread: " + Thread.currentThread().getName() + " notified in run() loop");
                continue;
            }
            catch (Exception e) {
                if (!debug) continue;
                System.out.println("Thread: " + Thread.currentThread().getName() + " interrupted in run() loop \n    " + e);
                continue;
            }
            break;
        }
    }

    protected boolean processQueue() {
        while (this.hasRequests()) {
            this.current = this.pop();
            if (this.current == null) {
                return true;
            }
            this.processRequest(this.current);
            if (this.stopMonitor != null) {
                this.stopMonitor.updateWatchers();
            }
            if (this.current != null && this.current.isCancelled()) {
                return false;
            }
            this.current = null;
        }
        return true;
    }

    protected void processRequest(DataQuery request) {
        if (debug) {
            System.out.println("Thread: " + Thread.currentThread().getName() + " process request " + request.id);
        }
        if (request.isCancelled()) {
            request.finish();
            return;
        }
        try {
            if (!this.isActive()) {
                request.setException(new Exception("No Data Connection Enabled"));
            }
            if (debug) {
                System.out.println("Thread: " + Thread.currentThread().getName() + " process request " + request.id + " of type " + request.getTypeString());
            }
            switch (request.getType()) {
                case 1: {
                    this.doExistsQuery(request);
                    break;
                }
                case 2: {
                    this.doEntryQuery(request);
                    break;
                }
                case 4: {
                    this.doListQuery(request);
                    break;
                }
                case 8: {
                    this.doSearchQuery(request);
                    break;
                }
                case 16: {
                    this.doModifyQuery(request);
                    break;
                }
                case 32: {
                    this.doCopyQuery(request);
                    break;
                }
                case 128: {
                    this.doGetRecOCsQuery(request);
                    break;
                }
                case 256: {
                    this.doExtendedQuery(request);
                    break;
                }
                default: {
                    throw new NamingException("JX Internal Error: Unknown Data Broker Request type: " + request.getType());
                }
            }
        }
        catch (Exception e) {
            request.setException(e);
        }
        request.finish();
    }

    public DataQuery getChildren(DN nodeDN) {
        return this.push(new DataQuery(4, nodeDN));
    }

    public DataQuery getEntry(DN nodeDN) {
        return this.push(new DataQuery(2, nodeDN));
    }

    public DataQuery exists(DN nodeDN) {
        return this.push(new DataQuery(1, nodeDN));
    }

    public DataQuery getRecommendedObjectClasses(DN dn) {
        return this.push(new DataQuery(128, dn));
    }

    public DataQuery modifyEntry(DXEntry oldEntry, DXEntry newEntry) {
        return this.push(new DataQuery(16, oldEntry, newEntry));
    }

    public DataQuery copyTree(DN oldNodeDN, DN newNodeDN) {
        return this.push(new DataQuery(32, oldNodeDN, newNodeDN));
    }

    public DataQuery search(DN nodeDN, String filter, int searchLevel, String[] returnAttributes) {
        return this.push(new DataQuery(8, nodeDN, filter, searchLevel, returnAttributes));
    }

    public DataQuery extendedRequest(DataQuery query) {
        return this.push(query);
    }

    public void addDataListener(DataListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    public void removeDataListener(DataListener l) {
        if (this.listeners.contains(l)) {
            this.listeners.remove(l);
        }
    }

    public abstract boolean isModifiable();

    public abstract DirContext getDirContext();

    public abstract boolean isActive();

    public abstract SchemaOps getSchemaOps();

    protected DataQuery finish(DataQuery request) {
        if (debug) {
            System.out.println("Thread: " + Thread.currentThread().getName() + " request " + request.id + " finished ");
        }
        request.finish();
        return request;
    }

    public DataQuery getCurrent() {
        return this.current;
    }

    public synchronized Vector getRequestQueue() {
        return this.requestQueue;
    }

    protected DataQuery doExtendedQuery(DataQuery request) throws NamingException {
        request.doExtendedRequest(this);
        return this.finish(request);
    }

    protected DataQuery doExistsQuery(DataQuery request) throws NamingException {
        this.unthreadedExists(request.requestDN());
        request.setStatus(true);
        return this.finish(request);
    }

    protected DataQuery doListQuery(DataQuery request) throws NamingException {
        request.setEnum(this.unthreadedList(request.requestDN()));
        return this.finish(request);
    }

    protected DataQuery doEntryQuery(DataQuery request) throws NamingException {
        request.setEntry(this.unthreadedReadEntry(request.requestDN(), null));
        return this.finish(request);
    }

    protected DataQuery doSearchQuery(DataQuery request) throws NamingException {
        DXNamingEnumeration en = this.unthreadedSearch(request.requestDN(), request.filter(), request.searchLevel(), request.returnAttributes());
        request.setEnum(en);
        return this.finish(request);
    }

    protected DataQuery doModifyQuery(DataQuery request) throws NamingException {
        this.unthreadedModify(request.oldEntry(), request.newEntry());
        request.setStatus(true);
        return this.finish(request);
    }

    protected DataQuery doCopyQuery(DataQuery request) throws NamingException {
        this.unthreadedCopy(request.oldDN(), request.requestDN());
        request.setStatus(true);
        return this.finish(request);
    }

    protected DataQuery doGetRecOCsQuery(DataQuery request) throws NamingException {
        request.setArrayList(this.unthreadedGetRecOCs(request.requestDN()));
        return this.finish(request);
    }

    public abstract DXNamingEnumeration unthreadedList(DN var1) throws NamingException;

    public abstract DXNamingEnumeration unthreadedSearch(DN var1, String var2, int var3, String[] var4) throws NamingException;

    public abstract void unthreadedCopy(DN var1, DN var2) throws NamingException;

    public abstract boolean unthreadedExists(DN var1) throws NamingException;

    public abstract DXEntry unthreadedReadEntry(DN var1, String[] var2) throws NamingException;

    public abstract void unthreadedModify(DXEntry var1, DXEntry var2) throws NamingException;

    public abstract ArrayList unthreadedGetRecOCs(DN var1) throws NamingException;

    public Exception getException() {
        return null;
    }

    public void clearException() {
    }

    public Broker getBroker() {
        return this;
    }
}

