"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiDataGridCell = void 0;

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _tabbable = _interopRequireDefault(require("tabbable"));

var _popover = require("../popover");

var _accessibility = require("../accessibility");

var _i18n = require("../i18n");

var _button = require("../button");

var _mutation_observer = require("../observer/mutation_observer");

var _data_grid_context = require("./data_grid_context");

var _focus_trap = require("../focus_trap");

var _services = require("../../services");

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

var EuiDataGridCellContent = /*#__PURE__*/(0, _react.memo)(function (props) {
  var renderCellValue = props.renderCellValue,
      rest = (0, _objectWithoutProperties2.default)(props, ["renderCellValue"]); // React is more permissible than the TS types indicate

  var CellElement = renderCellValue;
  return /*#__PURE__*/_react.default.createElement(CellElement, (0, _extends2.default)({
    isDetails: false,
    "data-test-subj": "cell-content"
  }, rest));
});
EuiDataGridCellContent.propTypes = {
  rowIndex: _propTypes.default.number.isRequired,
  visibleRowIndex: _propTypes.default.number.isRequired,
  colIndex: _propTypes.default.number.isRequired,
  columnId: _propTypes.default.string.isRequired,
  columnType: _propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.oneOf([null])]),
  isExpandable: _propTypes.default.bool.isRequired,
  className: _propTypes.default.string,
  renderCellValue: _propTypes.default.oneOfType([_propTypes.default.func.isRequired, _propTypes.default.func.isRequired]).isRequired,
  setCellProps: _propTypes.default.func.isRequired,
  isExpanded: _propTypes.default.bool.isRequired
};

var EuiDataGridCell = /*#__PURE__*/function (_Component) {
  (0, _inherits2.default)(EuiDataGridCell, _Component);

  var _super = _createSuper(EuiDataGridCell);

  function EuiDataGridCell() {
    var _this;

    (0, _classCallCheck2.default)(this, EuiDataGridCell);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "cellRef", /*#__PURE__*/(0, _react.createRef)());
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "popoverPanelRef", /*#__PURE__*/(0, _react.createRef)());
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "cellContentsRef", null);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "state", {
      cellProps: {},
      popoverIsOpen: false,
      isEntered: false,
      disableCellTabIndex: false
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "unsubscribeCell", function () {});
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "getInteractables", function () {
      var tabbingRef = _this.cellContentsRef;

      if (tabbingRef) {
        return tabbingRef.querySelectorAll('[data-datagrid-interactable=true]');
      }

      return [];
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "updateFocus", function () {
      var cell = _this.cellRef.current;
      var isFocused = _this.props.isFocused;

      if (cell && isFocused) {
        // only update focus if we are not already focused on something in this cell
        var element = document.activeElement;

        while (element != null && element !== cell) {
          element = element.parentElement;
        }

        var doFocusUpdate = element !== cell;

        if (doFocusUpdate) {
          var interactables = _this.getInteractables();

          if (_this.props.isExpandable === false && interactables.length === 1) {
            // Only one element can be interacted with
            interactables[0].focus();
          } else {
            cell.focus();
          }
        }
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "setCellProps", function (cellProps) {
      _this.setState({
        cellProps: cellProps
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "setCellContentsRef", function (ref) {
      _this.cellContentsRef = ref;

      _this.preventTabbing();
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onFocus", function (e) {
      // only perform this logic when the event's originating element (e.target) is
      // the wrapping element with the onFocus logic
      // reasons:
      //  * the outcome is only meaningful when the focus shifts to the wrapping element
      //  * if the cell children include portalled content React will bubble the focus
      //      event up, which can trigger the focus() call below, causing focus lock fighting
      if (_this.cellRef.current === e.target) {
        var _this$props = _this.props,
            onCellFocus = _this$props.onCellFocus,
            colIndex = _this$props.colIndex,
            visibleRowIndex = _this$props.visibleRowIndex,
            isExpandable = _this$props.isExpandable;
        onCellFocus([colIndex, visibleRowIndex]);

        var interactables = _this.getInteractables();

        if (interactables.length === 1 && isExpandable === false) {
          interactables[0].focus();

          _this.setState({
            disableCellTabIndex: true
          });
        }
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onBlur", function () {
      _this.setState({
        disableCellTabIndex: false
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "preventTabbing", function () {
      if (_this.cellContentsRef) {
        var tabbables = (0, _tabbable.default)(_this.cellContentsRef);

        for (var i = 0; i < tabbables.length; i++) {
          var element = tabbables[i];
          element.setAttribute('tabIndex', '-1');
          element.setAttribute('data-datagrid-interactable', 'true');
        }
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "enableTabbing", function () {
      if (_this.cellContentsRef) {
        var interactables = _this.getInteractables();

        for (var i = 0; i < interactables.length; i++) {
          var element = interactables[i];
          element.removeAttribute('tabIndex');
        }
      }
    });
    return _this;
  }

  (0, _createClass2.default)(EuiDataGridCell, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this.unsubscribeCell = this.context.onFocusUpdate([this.props.colIndex, this.props.visibleRowIndex], this.updateFocus);
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      if (this.unsubscribeCell) {
        this.unsubscribeCell();
      }
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      var didFocusChange = prevProps.isFocused !== this.props.isFocused;

      if (didFocusChange) {
        this.updateFocus();
      }
    }
  }, {
    key: "shouldComponentUpdate",
    value: function shouldComponentUpdate(nextProps, nextState) {
      if (nextProps.rowIndex !== this.props.rowIndex) return true;
      if (nextProps.visibleRowIndex !== this.props.visibleRowIndex) return true;
      if (nextProps.colIndex !== this.props.colIndex) return true;
      if (nextProps.columnId !== this.props.columnId) return true;
      if (nextProps.columnType !== this.props.columnType) return true;
      if (nextProps.width !== this.props.width) return true;
      if (nextProps.renderCellValue !== this.props.renderCellValue) return true;
      if (nextProps.onCellFocus !== this.props.onCellFocus) return true;
      if (nextProps.isFocused !== this.props.isFocused) return true;
      if (nextProps.interactiveCellId !== this.props.interactiveCellId) return true;
      if (nextProps.popoverContent !== this.props.popoverContent) return true;
      if (nextState.cellProps !== this.state.cellProps) return true;
      if (nextState.popoverIsOpen !== this.state.popoverIsOpen) return true;
      if (nextState.isEntered !== this.state.isEntered) return true;
      if (nextState.disableCellTabIndex !== this.state.disableCellTabIndex) return true;
      return false;
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;

      var _this$props2 = this.props,
          width = _this$props2.width,
          isFocused = _this$props2.isFocused,
          isExpandable = _this$props2.isExpandable,
          PopoverContent = _this$props2.popoverContent,
          interactiveCellId = _this$props2.interactiveCellId,
          columnType = _this$props2.columnType,
          onCellFocus = _this$props2.onCellFocus,
          className = _this$props2.className,
          rest = (0, _objectWithoutProperties2.default)(_this$props2, ["width", "isFocused", "isExpandable", "popoverContent", "interactiveCellId", "columnType", "onCellFocus", "className"]);
      var colIndex = rest.colIndex,
          rowIndex = rest.rowIndex;
      var cellClasses = (0, _classnames.default)('euiDataGridRowCell', (0, _defineProperty2.default)({}, "euiDataGridRowCell--".concat(columnType), columnType), className);

      var cellProps = _objectSpread(_objectSpread({}, this.state.cellProps), {}, {
        'data-test-subj': (0, _classnames.default)('dataGridRowCell', this.state.cellProps['data-test-subj']),
        className: (0, _classnames.default)(cellClasses, this.state.cellProps.className)
      });

      var widthStyle = width != null ? {
        width: "".concat(width, "px")
      } : {};

      if (cellProps.hasOwnProperty('style')) {
        cellProps.style = _objectSpread(_objectSpread({}, cellProps.style), widthStyle);
      } else {
        cellProps.style = widthStyle;
      }

      var handleCellKeyDown = function handleCellKeyDown(event) {
        if (isExpandable) {
          switch (event.key) {
            case _services.keys.ENTER:
            case _services.keys.F2:
              event.preventDefault();

              _this2.setState({
                popoverIsOpen: true
              });

              break;
          }
        } else {
          if (event.key === _services.keys.ENTER || event.key === _services.keys.F2 || event.key === _services.keys.ESCAPE) {
            var interactables = _this2.getInteractables();

            if (interactables.length >= 2) {
              switch (event.key) {
                case _services.keys.ENTER:
                  // `Enter` only activates the trap
                  if (_this2.state.isEntered === false) {
                    _this2.enableTabbing();

                    _this2.setState({
                      isEntered: true
                    }); // result of this keypress is focus shifts to the first interactive element
                    // and then the browser fires the onClick event because that's how [Enter] works
                    // so we need to prevent that default action otherwise entering the trap triggers the first element


                    event.preventDefault();
                  }

                  break;

                case _services.keys.F2:
                  // toggle interactives' focus trap
                  _this2.setState(function (_ref) {
                    var isEntered = _ref.isEntered;

                    if (isEntered) {
                      _this2.preventTabbing();
                    } else {
                      _this2.enableTabbing();
                    }

                    return {
                      isEntered: !isEntered
                    };
                  });

                  break;

                case _services.keys.ESCAPE:
                  // `Escape` only de-activates the trap
                  _this2.preventTabbing();

                  if (_this2.state.isEntered === true) {
                    _this2.setState({
                      isEntered: false
                    });
                  }

                  break;
              }
            }
          }
        }
      };

      var cellContentProps = _objectSpread(_objectSpread({}, rest), {}, {
        setCellProps: this.setCellProps,
        columnType: columnType,
        isExpandable: isExpandable,
        isExpanded: this.state.popoverIsOpen,
        isDetails: false
      });

      var buttonIconClasses = (0, _classnames.default)('euiDataGridRowCell__expandButtonIcon', {
        'euiDataGridRowCell__expandButtonIcon-isActive': this.state.popoverIsOpen
      });
      var buttonClasses = (0, _classnames.default)('euiDataGridRowCell__expandButton', {
        'euiDataGridRowCell__expandButton-isActive': this.state.popoverIsOpen
      });

      var expandButton = /*#__PURE__*/_react.default.createElement(_i18n.EuiI18n, {
        token: "euiDataGridCell.expandButtonTitle",
        default: "Click or hit enter to interact with cell content"
      }, function (expandButtonTitle) {
        return /*#__PURE__*/_react.default.createElement(_button.EuiButtonIcon, {
          className: buttonIconClasses,
          color: "text",
          iconSize: "s",
          iconType: "expandMini",
          "aria-hidden": true,
          onClick: function onClick() {
            return _this2.setState(function (_ref2) {
              var popoverIsOpen = _ref2.popoverIsOpen;
              return {
                popoverIsOpen: !popoverIsOpen
              };
            });
          },
          title: expandButtonTitle
        });
      });

      var screenReaderPosition = /*#__PURE__*/_react.default.createElement(_accessibility.EuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18n.EuiI18n, {
        tokens: ['euiDataGridCell.row', 'euiDataGridCell.column'],
        defaults: ['Row', 'Column']
      }, function (_ref3) {
        var _ref4 = (0, _slicedToArray2.default)(_ref3, 2),
            row = _ref4[0],
            column = _ref4[1];

        return /*#__PURE__*/_react.default.createElement("span", null, row, ": ", rowIndex + 1, ", ", column, ": ", colIndex + 1, ":");
      })));

      var anchorContent = /*#__PURE__*/_react.default.createElement(_focus_trap.EuiFocusTrap, {
        disabled: !this.state.isEntered,
        autoFocus: true,
        onDeactivation: function onDeactivation() {
          _this2.setState({
            isEntered: false
          }, _this2.preventTabbing);
        },
        clickOutsideDisables: true
      }, /*#__PURE__*/_react.default.createElement("div", {
        className: "euiDataGridRowCell__expandFlex"
      }, /*#__PURE__*/_react.default.createElement(_mutation_observer.EuiMutationObserver, {
        observerOptions: {
          subtree: true,
          childList: true
        },
        onMutation: this.preventTabbing
      }, function (mutationRef) {
        return /*#__PURE__*/_react.default.createElement("div", {
          ref: mutationRef,
          className: "euiDataGridRowCell__expandContent"
        }, screenReaderPosition, /*#__PURE__*/_react.default.createElement("div", {
          ref: _this2.setCellContentsRef,
          className: "euiDataGridRowCell__truncate"
        }, /*#__PURE__*/_react.default.createElement(EuiDataGridCellContent, cellContentProps)));
      })));

      if (isExpandable) {
        anchorContent = /*#__PURE__*/_react.default.createElement("div", {
          className: "euiDataGridRowCell__expandFlex"
        }, /*#__PURE__*/_react.default.createElement(_mutation_observer.EuiMutationObserver, {
          observerOptions: {
            subtree: true,
            childList: true
          },
          onMutation: this.preventTabbing
        }, function (mutationRef) {
          return /*#__PURE__*/_react.default.createElement("div", {
            ref: mutationRef,
            className: "euiDataGridRowCell__expandContent"
          }, screenReaderPosition, /*#__PURE__*/_react.default.createElement("div", {
            ref: _this2.setCellContentsRef,
            className: "euiDataGridRowCell__truncate"
          }, /*#__PURE__*/_react.default.createElement(EuiDataGridCellContent, cellContentProps)));
        }), /*#__PURE__*/_react.default.createElement("div", {
          className: buttonClasses
        }, expandButton));
      }

      var innerContent = anchorContent;

      if (isExpandable) {
        var CellElement = rest.renderCellValue;

        var popoverContent = /*#__PURE__*/_react.default.createElement(PopoverContent, {
          cellContentsElement: this.cellContentsRef
        }, /*#__PURE__*/_react.default.createElement(CellElement, (0, _extends2.default)({}, cellContentProps, {
          isDetails: true
        })));

        innerContent = /*#__PURE__*/_react.default.createElement("div", {
          className: "euiDataGridRowCell__content"
        }, /*#__PURE__*/_react.default.createElement(_popover.EuiPopover, {
          hasArrow: false,
          anchorClassName: "euiDataGridRowCell__expand",
          button: anchorContent,
          isOpen: this.state.popoverIsOpen,
          panelRef: function panelRef(ref) {
            return _this2.popoverPanelRef.current = ref;
          },
          ownFocus: true,
          panelClassName: "euiDataGridRowCell__popover",
          zIndex: 8001,
          display: "block",
          closePopover: function closePopover() {
            return _this2.setState({
              popoverIsOpen: false
            });
          },
          onKeyDown: function onKeyDown(event) {
            if (event.key === _services.keys.F2 || event.key === _services.keys.ESCAPE) {
              event.preventDefault();
              event.stopPropagation();

              _this2.setState({
                popoverIsOpen: false
              });
            }
          },
          onTrapDeactivation: this.updateFocus
        }, popoverContent));
      }

      return /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({
        role: "gridcell",
        tabIndex: isFocused && !this.state.disableCellTabIndex ? 0 : -1,
        ref: this.cellRef
      }, cellProps, {
        "data-test-subj": "dataGridRowCell",
        onKeyDown: handleCellKeyDown,
        onFocus: this.onFocus,
        onBlur: this.onBlur
      }), innerContent);
    }
  }]);
  return EuiDataGridCell;
}(_react.Component);

exports.EuiDataGridCell = EuiDataGridCell;
(0, _defineProperty2.default)(EuiDataGridCell, "contextType", _data_grid_context.DataGridContext);
EuiDataGridCell.propTypes = {
  rowIndex: _propTypes.default.number.isRequired,
  visibleRowIndex: _propTypes.default.number.isRequired,
  colIndex: _propTypes.default.number.isRequired,
  columnId: _propTypes.default.string.isRequired,
  columnType: _propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.oneOf([null])]),
  width: _propTypes.default.number,
  isFocused: _propTypes.default.bool.isRequired,
  onCellFocus: _propTypes.default.func.isRequired,
  interactiveCellId: _propTypes.default.string.isRequired,
  isExpandable: _propTypes.default.bool.isRequired,
  className: _propTypes.default.string,
  popoverContent: _propTypes.default.elementType.isRequired,
  renderCellValue: _propTypes.default.oneOfType([_propTypes.default.func.isRequired, _propTypes.default.func.isRequired]).isRequired
};