/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_ARB_gpu_shader_fp64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (dvec2(-0.1lf, -1.2lf) / dvec2(-0.1lf, -1.2lf)) => dvec2(1.0lf, 1.0lf)
 * (dvec2(-0.1lf, -1.2lf) / dvec2(-0.42lf, 0.48lf)) => dvec2(0.2380952380952381lf, -2.5lf)
 * (dvec2(-0.42lf, 0.48lf) / dvec2(-0.1lf, -1.2lf)) => dvec2(4.199999999999999lf, -0.4lf)
 * (dvec2(-0.42lf, 0.48lf) / dvec2(-0.42lf, 0.48lf)) => dvec2(1.0lf, 1.0lf)
 */
#version 150
#extension GL_ARB_gpu_shader_fp64 : require

void main()
{
  double[distance((dvec2(-0.1lf, -1.2lf) / dvec2(-0.1lf, -1.2lf)), dvec2(1.0lf, 1.0lf)) <= 1.4142135623730953e-05lf ? 1 : -1] array0;
  double[distance((dvec2(-0.1lf, -1.2lf) / dvec2(-0.42lf, 0.48lf)), dvec2(0.2380952380952381lf, -2.5lf)) <= 2.511312274967737e-05lf ? 1 : -1] array1;
  double[distance((dvec2(-0.42lf, 0.48lf) / dvec2(-0.1lf, -1.2lf)), dvec2(4.199999999999999lf, -0.4lf)) <= 4.219004621945796e-05lf ? 1 : -1] array2;
  double[distance((dvec2(-0.42lf, 0.48lf) / dvec2(-0.42lf, 0.48lf)), dvec2(1.0lf, 1.0lf)) <= 1.4142135623730953e-05lf ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
