# coding: utf-8

"""
InfluxDB OSS API Service.

The InfluxDB v2 API provides a programmatic interface for all interactions with InfluxDB. Access the InfluxDB API using the `/api/v2/` endpoint.   # noqa: E501

OpenAPI spec version: 2.0.0
Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

from influxdb_client.service._base_service import _BaseService


class DashboardsService(_BaseService):
    """NOTE: This class is auto generated by OpenAPI Generator.

    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):  # noqa: E501,D401,D403
        """DashboardsService - a operation defined in OpenAPI."""
        if api_client is None:
            raise ValueError("Invalid value for `api_client`, must be defined.")
        self.api_client = api_client

    def delete_dashboards_id(self, dashboard_id, **kwargs):  # noqa: E501,D401,D403
        """Delete a dashboard.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_dashboards_id(dashboard_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dashboard_id: The ID of the dashboard to update. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_dashboards_id_with_http_info(dashboard_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_dashboards_id_with_http_info(dashboard_id, **kwargs)  # noqa: E501
            return data

    def delete_dashboards_id_with_http_info(self, dashboard_id, **kwargs):  # noqa: E501,D401,D403
        """Delete a dashboard.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_dashboards_id_with_http_info(dashboard_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dashboard_id: The ID of the dashboard to update. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._delete_dashboards_id_prepare(dashboard_id, **kwargs)

        return self.api_client.call_api(
            '/api/v2/dashboards/{dashboardID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def delete_dashboards_id_async(self, dashboard_id, **kwargs):  # noqa: E501,D401,D403
        """Delete a dashboard.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str dashboard_id: The ID of the dashboard to update. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._delete_dashboards_id_prepare(dashboard_id, **kwargs)

        return await self.api_client.call_api(
            '/api/v2/dashboards/{dashboardID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _delete_dashboards_id_prepare(self, dashboard_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['dashboard_id', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('delete_dashboards_id', all_params, local_var_params)
        # verify the required parameter 'dashboard_id' is set
        if ('dashboard_id' not in local_var_params or
                local_var_params['dashboard_id'] is None):
            raise ValueError("Missing the required parameter `dashboard_id` when calling `delete_dashboards_id`")  # noqa: E501

        path_params = {}
        if 'dashboard_id' in local_var_params:
            path_params['dashboardID'] = local_var_params['dashboard_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def delete_dashboards_id_cells_id(self, dashboard_id, cell_id, **kwargs):  # noqa: E501,D401,D403
        """Delete a dashboard cell.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_dashboards_id_cells_id(dashboard_id, cell_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dashboard_id: The ID of the dashboard to delete. (required)
        :param str cell_id: The ID of the cell to delete. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_dashboards_id_cells_id_with_http_info(dashboard_id, cell_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_dashboards_id_cells_id_with_http_info(dashboard_id, cell_id, **kwargs)  # noqa: E501
            return data

    def delete_dashboards_id_cells_id_with_http_info(self, dashboard_id, cell_id, **kwargs):  # noqa: E501,D401,D403
        """Delete a dashboard cell.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_dashboards_id_cells_id_with_http_info(dashboard_id, cell_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dashboard_id: The ID of the dashboard to delete. (required)
        :param str cell_id: The ID of the cell to delete. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._delete_dashboards_id_cells_id_prepare(dashboard_id, cell_id, **kwargs)

        return self.api_client.call_api(
            '/api/v2/dashboards/{dashboardID}/cells/{cellID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def delete_dashboards_id_cells_id_async(self, dashboard_id, cell_id, **kwargs):  # noqa: E501,D401,D403
        """Delete a dashboard cell.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str dashboard_id: The ID of the dashboard to delete. (required)
        :param str cell_id: The ID of the cell to delete. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._delete_dashboards_id_cells_id_prepare(dashboard_id, cell_id, **kwargs)

        return await self.api_client.call_api(
            '/api/v2/dashboards/{dashboardID}/cells/{cellID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _delete_dashboards_id_cells_id_prepare(self, dashboard_id, cell_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['dashboard_id', 'cell_id', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('delete_dashboards_id_cells_id', all_params, local_var_params)
        # verify the required parameter 'dashboard_id' is set
        if ('dashboard_id' not in local_var_params or
                local_var_params['dashboard_id'] is None):
            raise ValueError("Missing the required parameter `dashboard_id` when calling `delete_dashboards_id_cells_id`")  # noqa: E501
        # verify the required parameter 'cell_id' is set
        if ('cell_id' not in local_var_params or
                local_var_params['cell_id'] is None):
            raise ValueError("Missing the required parameter `cell_id` when calling `delete_dashboards_id_cells_id`")  # noqa: E501

        path_params = {}
        if 'dashboard_id' in local_var_params:
            path_params['dashboardID'] = local_var_params['dashboard_id']  # noqa: E501
        if 'cell_id' in local_var_params:
            path_params['cellID'] = local_var_params['cell_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def delete_dashboards_id_labels_id(self, dashboard_id, label_id, **kwargs):  # noqa: E501,D401,D403
        """Delete a label from a dashboard.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_dashboards_id_labels_id(dashboard_id, label_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dashboard_id: The dashboard ID. (required)
        :param str label_id: The ID of the label to delete. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_dashboards_id_labels_id_with_http_info(dashboard_id, label_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_dashboards_id_labels_id_with_http_info(dashboard_id, label_id, **kwargs)  # noqa: E501
            return data

    def delete_dashboards_id_labels_id_with_http_info(self, dashboard_id, label_id, **kwargs):  # noqa: E501,D401,D403
        """Delete a label from a dashboard.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_dashboards_id_labels_id_with_http_info(dashboard_id, label_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dashboard_id: The dashboard ID. (required)
        :param str label_id: The ID of the label to delete. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._delete_dashboards_id_labels_id_prepare(dashboard_id, label_id, **kwargs)

        return self.api_client.call_api(
            '/api/v2/dashboards/{dashboardID}/labels/{labelID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def delete_dashboards_id_labels_id_async(self, dashboard_id, label_id, **kwargs):  # noqa: E501,D401,D403
        """Delete a label from a dashboard.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str dashboard_id: The dashboard ID. (required)
        :param str label_id: The ID of the label to delete. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._delete_dashboards_id_labels_id_prepare(dashboard_id, label_id, **kwargs)

        return await self.api_client.call_api(
            '/api/v2/dashboards/{dashboardID}/labels/{labelID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _delete_dashboards_id_labels_id_prepare(self, dashboard_id, label_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['dashboard_id', 'label_id', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('delete_dashboards_id_labels_id', all_params, local_var_params)
        # verify the required parameter 'dashboard_id' is set
        if ('dashboard_id' not in local_var_params or
                local_var_params['dashboard_id'] is None):
            raise ValueError("Missing the required parameter `dashboard_id` when calling `delete_dashboards_id_labels_id`")  # noqa: E501
        # verify the required parameter 'label_id' is set
        if ('label_id' not in local_var_params or
                local_var_params['label_id'] is None):
            raise ValueError("Missing the required parameter `label_id` when calling `delete_dashboards_id_labels_id`")  # noqa: E501

        path_params = {}
        if 'dashboard_id' in local_var_params:
            path_params['dashboardID'] = local_var_params['dashboard_id']  # noqa: E501
        if 'label_id' in local_var_params:
            path_params['labelID'] = local_var_params['label_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def delete_dashboards_id_members_id(self, user_id, dashboard_id, **kwargs):  # noqa: E501,D401,D403
        """Remove a member from a dashboard.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_dashboards_id_members_id(user_id, dashboard_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The ID of the member to remove. (required)
        :param str dashboard_id: The dashboard ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_dashboards_id_members_id_with_http_info(user_id, dashboard_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_dashboards_id_members_id_with_http_info(user_id, dashboard_id, **kwargs)  # noqa: E501
            return data

    def delete_dashboards_id_members_id_with_http_info(self, user_id, dashboard_id, **kwargs):  # noqa: E501,D401,D403
        """Remove a member from a dashboard.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_dashboards_id_members_id_with_http_info(user_id, dashboard_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The ID of the member to remove. (required)
        :param str dashboard_id: The dashboard ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._delete_dashboards_id_members_id_prepare(user_id, dashboard_id, **kwargs)

        return self.api_client.call_api(
            '/api/v2/dashboards/{dashboardID}/members/{userID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def delete_dashboards_id_members_id_async(self, user_id, dashboard_id, **kwargs):  # noqa: E501,D401,D403
        """Remove a member from a dashboard.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str user_id: The ID of the member to remove. (required)
        :param str dashboard_id: The dashboard ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._delete_dashboards_id_members_id_prepare(user_id, dashboard_id, **kwargs)

        return await self.api_client.call_api(
            '/api/v2/dashboards/{dashboardID}/members/{userID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _delete_dashboards_id_members_id_prepare(self, user_id, dashboard_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['user_id', 'dashboard_id', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('delete_dashboards_id_members_id', all_params, local_var_params)
        # verify the required parameter 'user_id' is set
        if ('user_id' not in local_var_params or
                local_var_params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `delete_dashboards_id_members_id`")  # noqa: E501
        # verify the required parameter 'dashboard_id' is set
        if ('dashboard_id' not in local_var_params or
                local_var_params['dashboard_id'] is None):
            raise ValueError("Missing the required parameter `dashboard_id` when calling `delete_dashboards_id_members_id`")  # noqa: E501

        path_params = {}
        if 'user_id' in local_var_params:
            path_params['userID'] = local_var_params['user_id']  # noqa: E501
        if 'dashboard_id' in local_var_params:
            path_params['dashboardID'] = local_var_params['dashboard_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def delete_dashboards_id_owners_id(self, user_id, dashboard_id, **kwargs):  # noqa: E501,D401,D403
        """Remove an owner from a dashboard.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_dashboards_id_owners_id(user_id, dashboard_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The ID of the owner to remove. (required)
        :param str dashboard_id: The dashboard ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_dashboards_id_owners_id_with_http_info(user_id, dashboard_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_dashboards_id_owners_id_with_http_info(user_id, dashboard_id, **kwargs)  # noqa: E501
            return data

    def delete_dashboards_id_owners_id_with_http_info(self, user_id, dashboard_id, **kwargs):  # noqa: E501,D401,D403
        """Remove an owner from a dashboard.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_dashboards_id_owners_id_with_http_info(user_id, dashboard_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The ID of the owner to remove. (required)
        :param str dashboard_id: The dashboard ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._delete_dashboards_id_owners_id_prepare(user_id, dashboard_id, **kwargs)

        return self.api_client.call_api(
            '/api/v2/dashboards/{dashboardID}/owners/{userID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def delete_dashboards_id_owners_id_async(self, user_id, dashboard_id, **kwargs):  # noqa: E501,D401,D403
        """Remove an owner from a dashboard.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str user_id: The ID of the owner to remove. (required)
        :param str dashboard_id: The dashboard ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._delete_dashboards_id_owners_id_prepare(user_id, dashboard_id, **kwargs)

        return await self.api_client.call_api(
            '/api/v2/dashboards/{dashboardID}/owners/{userID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _delete_dashboards_id_owners_id_prepare(self, user_id, dashboard_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['user_id', 'dashboard_id', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('delete_dashboards_id_owners_id', all_params, local_var_params)
        # verify the required parameter 'user_id' is set
        if ('user_id' not in local_var_params or
                local_var_params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `delete_dashboards_id_owners_id`")  # noqa: E501
        # verify the required parameter 'dashboard_id' is set
        if ('dashboard_id' not in local_var_params or
                local_var_params['dashboard_id'] is None):
            raise ValueError("Missing the required parameter `dashboard_id` when calling `delete_dashboards_id_owners_id`")  # noqa: E501

        path_params = {}
        if 'user_id' in local_var_params:
            path_params['userID'] = local_var_params['user_id']  # noqa: E501
        if 'dashboard_id' in local_var_params:
            path_params['dashboardID'] = local_var_params['dashboard_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def get_dashboards(self, **kwargs):  # noqa: E501,D401,D403
        """List all dashboards.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dashboards(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str zap_trace_span: OpenTracing span context
        :param int offset:
        :param int limit:
        :param bool descending:
        :param str owner: A user identifier. Returns only dashboards where this user has the `owner` role.
        :param str sort_by: The column to sort by.
        :param list[str] id: A list of dashboard identifiers. Returns only the listed dashboards. If both `id` and `owner` are specified, only `id` is used.
        :param str org_id: The identifier of the organization.
        :param str org: The name of the organization.
        :return: Dashboards
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_dashboards_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_dashboards_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_dashboards_with_http_info(self, **kwargs):  # noqa: E501,D401,D403
        """List all dashboards.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dashboards_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str zap_trace_span: OpenTracing span context
        :param int offset:
        :param int limit:
        :param bool descending:
        :param str owner: A user identifier. Returns only dashboards where this user has the `owner` role.
        :param str sort_by: The column to sort by.
        :param list[str] id: A list of dashboard identifiers. Returns only the listed dashboards. If both `id` and `owner` are specified, only `id` is used.
        :param str org_id: The identifier of the organization.
        :param str org: The name of the organization.
        :return: Dashboards
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_dashboards_prepare(**kwargs)

        return self.api_client.call_api(
            '/api/v2/dashboards', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Dashboards',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def get_dashboards_async(self, **kwargs):  # noqa: E501,D401,D403
        """List all dashboards.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str zap_trace_span: OpenTracing span context
        :param int offset:
        :param int limit:
        :param bool descending:
        :param str owner: A user identifier. Returns only dashboards where this user has the `owner` role.
        :param str sort_by: The column to sort by.
        :param list[str] id: A list of dashboard identifiers. Returns only the listed dashboards. If both `id` and `owner` are specified, only `id` is used.
        :param str org_id: The identifier of the organization.
        :param str org: The name of the organization.
        :return: Dashboards
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_dashboards_prepare(**kwargs)

        return await self.api_client.call_api(
            '/api/v2/dashboards', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Dashboards',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _get_dashboards_prepare(self, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['zap_trace_span', 'offset', 'limit', 'descending', 'owner', 'sort_by', 'id', 'org_id', 'org']  # noqa: E501
        self._check_operation_params('get_dashboards', all_params, local_var_params)

        if 'offset' in local_var_params and local_var_params['offset'] < 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `offset` when calling `get_dashboards`, must be a value greater than or equal to `0`")  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] > 100:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_dashboards`, must be a value less than or equal to `100`")  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_dashboards`, must be a value greater than or equal to `1`")  # noqa: E501
        path_params = {}

        query_params = []
        if 'offset' in local_var_params:
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'limit' in local_var_params:
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'descending' in local_var_params:
            query_params.append(('descending', local_var_params['descending']))  # noqa: E501
        if 'owner' in local_var_params:
            query_params.append(('owner', local_var_params['owner']))  # noqa: E501
        if 'sort_by' in local_var_params:
            query_params.append(('sortBy', local_var_params['sort_by']))  # noqa: E501
        if 'id' in local_var_params:
            query_params.append(('id', local_var_params['id']))  # noqa: E501
        if 'org_id' in local_var_params:
            query_params.append(('orgID', local_var_params['org_id']))  # noqa: E501
        if 'org' in local_var_params:
            query_params.append(('org', local_var_params['org']))  # noqa: E501

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def get_dashboards_id(self, dashboard_id, **kwargs):  # noqa: E501,D401,D403
        """Retrieve a dashboard.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dashboards_id(dashboard_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dashboard_id: The ID of the dashboard to update. (required)
        :param str zap_trace_span: OpenTracing span context
        :param str include: If `properties`, includes the cell view properties in the response.
        :return: DashboardWithViewProperties
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_dashboards_id_with_http_info(dashboard_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_dashboards_id_with_http_info(dashboard_id, **kwargs)  # noqa: E501
            return data

    def get_dashboards_id_with_http_info(self, dashboard_id, **kwargs):  # noqa: E501,D401,D403
        """Retrieve a dashboard.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dashboards_id_with_http_info(dashboard_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dashboard_id: The ID of the dashboard to update. (required)
        :param str zap_trace_span: OpenTracing span context
        :param str include: If `properties`, includes the cell view properties in the response.
        :return: DashboardWithViewProperties
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_dashboards_id_prepare(dashboard_id, **kwargs)

        return self.api_client.call_api(
            '/api/v2/dashboards/{dashboardID}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='DashboardWithViewProperties',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def get_dashboards_id_async(self, dashboard_id, **kwargs):  # noqa: E501,D401,D403
        """Retrieve a dashboard.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str dashboard_id: The ID of the dashboard to update. (required)
        :param str zap_trace_span: OpenTracing span context
        :param str include: If `properties`, includes the cell view properties in the response.
        :return: DashboardWithViewProperties
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_dashboards_id_prepare(dashboard_id, **kwargs)

        return await self.api_client.call_api(
            '/api/v2/dashboards/{dashboardID}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='DashboardWithViewProperties',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _get_dashboards_id_prepare(self, dashboard_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['dashboard_id', 'zap_trace_span', 'include']  # noqa: E501
        self._check_operation_params('get_dashboards_id', all_params, local_var_params)
        # verify the required parameter 'dashboard_id' is set
        if ('dashboard_id' not in local_var_params or
                local_var_params['dashboard_id'] is None):
            raise ValueError("Missing the required parameter `dashboard_id` when calling `get_dashboards_id`")  # noqa: E501

        path_params = {}
        if 'dashboard_id' in local_var_params:
            path_params['dashboardID'] = local_var_params['dashboard_id']  # noqa: E501

        query_params = []
        if 'include' in local_var_params:
            query_params.append(('include', local_var_params['include']))  # noqa: E501

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def get_dashboards_id_cells_id_view(self, dashboard_id, cell_id, **kwargs):  # noqa: E501,D401,D403
        """Retrieve the view for a cell.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dashboards_id_cells_id_view(dashboard_id, cell_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dashboard_id: The dashboard ID. (required)
        :param str cell_id: The cell ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: View
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_dashboards_id_cells_id_view_with_http_info(dashboard_id, cell_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_dashboards_id_cells_id_view_with_http_info(dashboard_id, cell_id, **kwargs)  # noqa: E501
            return data

    def get_dashboards_id_cells_id_view_with_http_info(self, dashboard_id, cell_id, **kwargs):  # noqa: E501,D401,D403
        """Retrieve the view for a cell.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dashboards_id_cells_id_view_with_http_info(dashboard_id, cell_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dashboard_id: The dashboard ID. (required)
        :param str cell_id: The cell ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: View
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_dashboards_id_cells_id_view_prepare(dashboard_id, cell_id, **kwargs)

        return self.api_client.call_api(
            '/api/v2/dashboards/{dashboardID}/cells/{cellID}/view', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='View',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def get_dashboards_id_cells_id_view_async(self, dashboard_id, cell_id, **kwargs):  # noqa: E501,D401,D403
        """Retrieve the view for a cell.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str dashboard_id: The dashboard ID. (required)
        :param str cell_id: The cell ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: View
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_dashboards_id_cells_id_view_prepare(dashboard_id, cell_id, **kwargs)

        return await self.api_client.call_api(
            '/api/v2/dashboards/{dashboardID}/cells/{cellID}/view', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='View',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _get_dashboards_id_cells_id_view_prepare(self, dashboard_id, cell_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['dashboard_id', 'cell_id', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('get_dashboards_id_cells_id_view', all_params, local_var_params)
        # verify the required parameter 'dashboard_id' is set
        if ('dashboard_id' not in local_var_params or
                local_var_params['dashboard_id'] is None):
            raise ValueError("Missing the required parameter `dashboard_id` when calling `get_dashboards_id_cells_id_view`")  # noqa: E501
        # verify the required parameter 'cell_id' is set
        if ('cell_id' not in local_var_params or
                local_var_params['cell_id'] is None):
            raise ValueError("Missing the required parameter `cell_id` when calling `get_dashboards_id_cells_id_view`")  # noqa: E501

        path_params = {}
        if 'dashboard_id' in local_var_params:
            path_params['dashboardID'] = local_var_params['dashboard_id']  # noqa: E501
        if 'cell_id' in local_var_params:
            path_params['cellID'] = local_var_params['cell_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def get_dashboards_id_labels(self, dashboard_id, **kwargs):  # noqa: E501,D401,D403
        """List all labels for a dashboard.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dashboards_id_labels(dashboard_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dashboard_id: The dashboard ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: LabelsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_dashboards_id_labels_with_http_info(dashboard_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_dashboards_id_labels_with_http_info(dashboard_id, **kwargs)  # noqa: E501
            return data

    def get_dashboards_id_labels_with_http_info(self, dashboard_id, **kwargs):  # noqa: E501,D401,D403
        """List all labels for a dashboard.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dashboards_id_labels_with_http_info(dashboard_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dashboard_id: The dashboard ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: LabelsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_dashboards_id_labels_prepare(dashboard_id, **kwargs)

        return self.api_client.call_api(
            '/api/v2/dashboards/{dashboardID}/labels', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='LabelsResponse',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def get_dashboards_id_labels_async(self, dashboard_id, **kwargs):  # noqa: E501,D401,D403
        """List all labels for a dashboard.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str dashboard_id: The dashboard ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: LabelsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_dashboards_id_labels_prepare(dashboard_id, **kwargs)

        return await self.api_client.call_api(
            '/api/v2/dashboards/{dashboardID}/labels', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='LabelsResponse',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _get_dashboards_id_labels_prepare(self, dashboard_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['dashboard_id', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('get_dashboards_id_labels', all_params, local_var_params)
        # verify the required parameter 'dashboard_id' is set
        if ('dashboard_id' not in local_var_params or
                local_var_params['dashboard_id'] is None):
            raise ValueError("Missing the required parameter `dashboard_id` when calling `get_dashboards_id_labels`")  # noqa: E501

        path_params = {}
        if 'dashboard_id' in local_var_params:
            path_params['dashboardID'] = local_var_params['dashboard_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def get_dashboards_id_members(self, dashboard_id, **kwargs):  # noqa: E501,D401,D403
        """List all dashboard members.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dashboards_id_members(dashboard_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dashboard_id: The dashboard ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceMembers
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_dashboards_id_members_with_http_info(dashboard_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_dashboards_id_members_with_http_info(dashboard_id, **kwargs)  # noqa: E501
            return data

    def get_dashboards_id_members_with_http_info(self, dashboard_id, **kwargs):  # noqa: E501,D401,D403
        """List all dashboard members.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dashboards_id_members_with_http_info(dashboard_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dashboard_id: The dashboard ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceMembers
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_dashboards_id_members_prepare(dashboard_id, **kwargs)

        return self.api_client.call_api(
            '/api/v2/dashboards/{dashboardID}/members', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='ResourceMembers',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def get_dashboards_id_members_async(self, dashboard_id, **kwargs):  # noqa: E501,D401,D403
        """List all dashboard members.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str dashboard_id: The dashboard ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceMembers
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_dashboards_id_members_prepare(dashboard_id, **kwargs)

        return await self.api_client.call_api(
            '/api/v2/dashboards/{dashboardID}/members', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='ResourceMembers',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _get_dashboards_id_members_prepare(self, dashboard_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['dashboard_id', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('get_dashboards_id_members', all_params, local_var_params)
        # verify the required parameter 'dashboard_id' is set
        if ('dashboard_id' not in local_var_params or
                local_var_params['dashboard_id'] is None):
            raise ValueError("Missing the required parameter `dashboard_id` when calling `get_dashboards_id_members`")  # noqa: E501

        path_params = {}
        if 'dashboard_id' in local_var_params:
            path_params['dashboardID'] = local_var_params['dashboard_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def get_dashboards_id_owners(self, dashboard_id, **kwargs):  # noqa: E501,D401,D403
        """List all dashboard owners.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dashboards_id_owners(dashboard_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dashboard_id: The dashboard ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceOwners
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_dashboards_id_owners_with_http_info(dashboard_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_dashboards_id_owners_with_http_info(dashboard_id, **kwargs)  # noqa: E501
            return data

    def get_dashboards_id_owners_with_http_info(self, dashboard_id, **kwargs):  # noqa: E501,D401,D403
        """List all dashboard owners.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dashboards_id_owners_with_http_info(dashboard_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dashboard_id: The dashboard ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceOwners
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_dashboards_id_owners_prepare(dashboard_id, **kwargs)

        return self.api_client.call_api(
            '/api/v2/dashboards/{dashboardID}/owners', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='ResourceOwners',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def get_dashboards_id_owners_async(self, dashboard_id, **kwargs):  # noqa: E501,D401,D403
        """List all dashboard owners.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str dashboard_id: The dashboard ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceOwners
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_dashboards_id_owners_prepare(dashboard_id, **kwargs)

        return await self.api_client.call_api(
            '/api/v2/dashboards/{dashboardID}/owners', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='ResourceOwners',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _get_dashboards_id_owners_prepare(self, dashboard_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['dashboard_id', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('get_dashboards_id_owners', all_params, local_var_params)
        # verify the required parameter 'dashboard_id' is set
        if ('dashboard_id' not in local_var_params or
                local_var_params['dashboard_id'] is None):
            raise ValueError("Missing the required parameter `dashboard_id` when calling `get_dashboards_id_owners`")  # noqa: E501

        path_params = {}
        if 'dashboard_id' in local_var_params:
            path_params['dashboardID'] = local_var_params['dashboard_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def patch_dashboards_id(self, dashboard_id, **kwargs):  # noqa: E501,D401,D403
        """Update a dashboard.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_dashboards_id(dashboard_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dashboard_id: The ID of the dashboard to update. (required)
        :param str zap_trace_span: OpenTracing span context
        :param PatchDashboardRequest patch_dashboard_request:
        :return: Dashboard
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_dashboards_id_with_http_info(dashboard_id, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_dashboards_id_with_http_info(dashboard_id, **kwargs)  # noqa: E501
            return data

    def patch_dashboards_id_with_http_info(self, dashboard_id, **kwargs):  # noqa: E501,D401,D403
        """Update a dashboard.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_dashboards_id_with_http_info(dashboard_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dashboard_id: The ID of the dashboard to update. (required)
        :param str zap_trace_span: OpenTracing span context
        :param PatchDashboardRequest patch_dashboard_request:
        :return: Dashboard
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._patch_dashboards_id_prepare(dashboard_id, **kwargs)

        return self.api_client.call_api(
            '/api/v2/dashboards/{dashboardID}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Dashboard',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def patch_dashboards_id_async(self, dashboard_id, **kwargs):  # noqa: E501,D401,D403
        """Update a dashboard.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str dashboard_id: The ID of the dashboard to update. (required)
        :param str zap_trace_span: OpenTracing span context
        :param PatchDashboardRequest patch_dashboard_request:
        :return: Dashboard
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._patch_dashboards_id_prepare(dashboard_id, **kwargs)

        return await self.api_client.call_api(
            '/api/v2/dashboards/{dashboardID}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Dashboard',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _patch_dashboards_id_prepare(self, dashboard_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['dashboard_id', 'zap_trace_span', 'patch_dashboard_request']  # noqa: E501
        self._check_operation_params('patch_dashboards_id', all_params, local_var_params)
        # verify the required parameter 'dashboard_id' is set
        if ('dashboard_id' not in local_var_params or
                local_var_params['dashboard_id'] is None):
            raise ValueError("Missing the required parameter `dashboard_id` when calling `patch_dashboards_id`")  # noqa: E501

        path_params = {}
        if 'dashboard_id' in local_var_params:
            path_params['dashboardID'] = local_var_params['dashboard_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        if 'patch_dashboard_request' in local_var_params:
            body_params = local_var_params['patch_dashboard_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def patch_dashboards_id_cells_id(self, dashboard_id, cell_id, cell_update, **kwargs):  # noqa: E501,D401,D403
        """Update the non-positional information related to a cell.

        Updates the non positional information related to a cell. Updates to a single cell's positional data could cause grid conflicts.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_dashboards_id_cells_id(dashboard_id, cell_id, cell_update, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dashboard_id: The ID of the dashboard to update. (required)
        :param str cell_id: The ID of the cell to update. (required)
        :param CellUpdate cell_update: (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Cell
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_dashboards_id_cells_id_with_http_info(dashboard_id, cell_id, cell_update, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_dashboards_id_cells_id_with_http_info(dashboard_id, cell_id, cell_update, **kwargs)  # noqa: E501
            return data

    def patch_dashboards_id_cells_id_with_http_info(self, dashboard_id, cell_id, cell_update, **kwargs):  # noqa: E501,D401,D403
        """Update the non-positional information related to a cell.

        Updates the non positional information related to a cell. Updates to a single cell's positional data could cause grid conflicts.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_dashboards_id_cells_id_with_http_info(dashboard_id, cell_id, cell_update, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dashboard_id: The ID of the dashboard to update. (required)
        :param str cell_id: The ID of the cell to update. (required)
        :param CellUpdate cell_update: (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Cell
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._patch_dashboards_id_cells_id_prepare(dashboard_id, cell_id, cell_update, **kwargs)

        return self.api_client.call_api(
            '/api/v2/dashboards/{dashboardID}/cells/{cellID}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Cell',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def patch_dashboards_id_cells_id_async(self, dashboard_id, cell_id, cell_update, **kwargs):  # noqa: E501,D401,D403
        """Update the non-positional information related to a cell.

        Updates the non positional information related to a cell. Updates to a single cell's positional data could cause grid conflicts.
        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str dashboard_id: The ID of the dashboard to update. (required)
        :param str cell_id: The ID of the cell to update. (required)
        :param CellUpdate cell_update: (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Cell
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._patch_dashboards_id_cells_id_prepare(dashboard_id, cell_id, cell_update, **kwargs)

        return await self.api_client.call_api(
            '/api/v2/dashboards/{dashboardID}/cells/{cellID}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Cell',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _patch_dashboards_id_cells_id_prepare(self, dashboard_id, cell_id, cell_update, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['dashboard_id', 'cell_id', 'cell_update', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('patch_dashboards_id_cells_id', all_params, local_var_params)
        # verify the required parameter 'dashboard_id' is set
        if ('dashboard_id' not in local_var_params or
                local_var_params['dashboard_id'] is None):
            raise ValueError("Missing the required parameter `dashboard_id` when calling `patch_dashboards_id_cells_id`")  # noqa: E501
        # verify the required parameter 'cell_id' is set
        if ('cell_id' not in local_var_params or
                local_var_params['cell_id'] is None):
            raise ValueError("Missing the required parameter `cell_id` when calling `patch_dashboards_id_cells_id`")  # noqa: E501
        # verify the required parameter 'cell_update' is set
        if ('cell_update' not in local_var_params or
                local_var_params['cell_update'] is None):
            raise ValueError("Missing the required parameter `cell_update` when calling `patch_dashboards_id_cells_id`")  # noqa: E501

        path_params = {}
        if 'dashboard_id' in local_var_params:
            path_params['dashboardID'] = local_var_params['dashboard_id']  # noqa: E501
        if 'cell_id' in local_var_params:
            path_params['cellID'] = local_var_params['cell_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        if 'cell_update' in local_var_params:
            body_params = local_var_params['cell_update']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def patch_dashboards_id_cells_id_view(self, dashboard_id, cell_id, view, **kwargs):  # noqa: E501,D401,D403
        """Update the view for a cell.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_dashboards_id_cells_id_view(dashboard_id, cell_id, view, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dashboard_id: The ID of the dashboard to update. (required)
        :param str cell_id: The ID of the cell to update. (required)
        :param View view: (required)
        :param str zap_trace_span: OpenTracing span context
        :return: View
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_dashboards_id_cells_id_view_with_http_info(dashboard_id, cell_id, view, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_dashboards_id_cells_id_view_with_http_info(dashboard_id, cell_id, view, **kwargs)  # noqa: E501
            return data

    def patch_dashboards_id_cells_id_view_with_http_info(self, dashboard_id, cell_id, view, **kwargs):  # noqa: E501,D401,D403
        """Update the view for a cell.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_dashboards_id_cells_id_view_with_http_info(dashboard_id, cell_id, view, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dashboard_id: The ID of the dashboard to update. (required)
        :param str cell_id: The ID of the cell to update. (required)
        :param View view: (required)
        :param str zap_trace_span: OpenTracing span context
        :return: View
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._patch_dashboards_id_cells_id_view_prepare(dashboard_id, cell_id, view, **kwargs)

        return self.api_client.call_api(
            '/api/v2/dashboards/{dashboardID}/cells/{cellID}/view', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='View',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def patch_dashboards_id_cells_id_view_async(self, dashboard_id, cell_id, view, **kwargs):  # noqa: E501,D401,D403
        """Update the view for a cell.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str dashboard_id: The ID of the dashboard to update. (required)
        :param str cell_id: The ID of the cell to update. (required)
        :param View view: (required)
        :param str zap_trace_span: OpenTracing span context
        :return: View
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._patch_dashboards_id_cells_id_view_prepare(dashboard_id, cell_id, view, **kwargs)

        return await self.api_client.call_api(
            '/api/v2/dashboards/{dashboardID}/cells/{cellID}/view', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='View',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _patch_dashboards_id_cells_id_view_prepare(self, dashboard_id, cell_id, view, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['dashboard_id', 'cell_id', 'view', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('patch_dashboards_id_cells_id_view', all_params, local_var_params)
        # verify the required parameter 'dashboard_id' is set
        if ('dashboard_id' not in local_var_params or
                local_var_params['dashboard_id'] is None):
            raise ValueError("Missing the required parameter `dashboard_id` when calling `patch_dashboards_id_cells_id_view`")  # noqa: E501
        # verify the required parameter 'cell_id' is set
        if ('cell_id' not in local_var_params or
                local_var_params['cell_id'] is None):
            raise ValueError("Missing the required parameter `cell_id` when calling `patch_dashboards_id_cells_id_view`")  # noqa: E501
        # verify the required parameter 'view' is set
        if ('view' not in local_var_params or
                local_var_params['view'] is None):
            raise ValueError("Missing the required parameter `view` when calling `patch_dashboards_id_cells_id_view`")  # noqa: E501

        path_params = {}
        if 'dashboard_id' in local_var_params:
            path_params['dashboardID'] = local_var_params['dashboard_id']  # noqa: E501
        if 'cell_id' in local_var_params:
            path_params['cellID'] = local_var_params['cell_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        if 'view' in local_var_params:
            body_params = local_var_params['view']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def post_dashboards(self, create_dashboard_request, **kwargs):  # noqa: E501,D401,D403
        """Create a dashboard.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_dashboards(create_dashboard_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateDashboardRequest create_dashboard_request: Dashboard to create (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Dashboard
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_dashboards_with_http_info(create_dashboard_request, **kwargs)  # noqa: E501
        else:
            (data) = self.post_dashboards_with_http_info(create_dashboard_request, **kwargs)  # noqa: E501
            return data

    def post_dashboards_with_http_info(self, create_dashboard_request, **kwargs):  # noqa: E501,D401,D403
        """Create a dashboard.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_dashboards_with_http_info(create_dashboard_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateDashboardRequest create_dashboard_request: Dashboard to create (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Dashboard
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_dashboards_prepare(create_dashboard_request, **kwargs)

        return self.api_client.call_api(
            '/api/v2/dashboards', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Dashboard',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def post_dashboards_async(self, create_dashboard_request, **kwargs):  # noqa: E501,D401,D403
        """Create a dashboard.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param CreateDashboardRequest create_dashboard_request: Dashboard to create (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Dashboard
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_dashboards_prepare(create_dashboard_request, **kwargs)

        return await self.api_client.call_api(
            '/api/v2/dashboards', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Dashboard',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _post_dashboards_prepare(self, create_dashboard_request, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['create_dashboard_request', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('post_dashboards', all_params, local_var_params)
        # verify the required parameter 'create_dashboard_request' is set
        if ('create_dashboard_request' not in local_var_params or
                local_var_params['create_dashboard_request'] is None):
            raise ValueError("Missing the required parameter `create_dashboard_request` when calling `post_dashboards`")  # noqa: E501

        path_params = {}

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        if 'create_dashboard_request' in local_var_params:
            body_params = local_var_params['create_dashboard_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def post_dashboards_id_cells(self, dashboard_id, create_cell, **kwargs):  # noqa: E501,D401,D403
        """Create a dashboard cell.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_dashboards_id_cells(dashboard_id, create_cell, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dashboard_id: The ID of the dashboard to update. (required)
        :param CreateCell create_cell: Cell that will be added (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Cell
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_dashboards_id_cells_with_http_info(dashboard_id, create_cell, **kwargs)  # noqa: E501
        else:
            (data) = self.post_dashboards_id_cells_with_http_info(dashboard_id, create_cell, **kwargs)  # noqa: E501
            return data

    def post_dashboards_id_cells_with_http_info(self, dashboard_id, create_cell, **kwargs):  # noqa: E501,D401,D403
        """Create a dashboard cell.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_dashboards_id_cells_with_http_info(dashboard_id, create_cell, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dashboard_id: The ID of the dashboard to update. (required)
        :param CreateCell create_cell: Cell that will be added (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Cell
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_dashboards_id_cells_prepare(dashboard_id, create_cell, **kwargs)

        return self.api_client.call_api(
            '/api/v2/dashboards/{dashboardID}/cells', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Cell',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def post_dashboards_id_cells_async(self, dashboard_id, create_cell, **kwargs):  # noqa: E501,D401,D403
        """Create a dashboard cell.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str dashboard_id: The ID of the dashboard to update. (required)
        :param CreateCell create_cell: Cell that will be added (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Cell
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_dashboards_id_cells_prepare(dashboard_id, create_cell, **kwargs)

        return await self.api_client.call_api(
            '/api/v2/dashboards/{dashboardID}/cells', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Cell',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _post_dashboards_id_cells_prepare(self, dashboard_id, create_cell, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['dashboard_id', 'create_cell', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('post_dashboards_id_cells', all_params, local_var_params)
        # verify the required parameter 'dashboard_id' is set
        if ('dashboard_id' not in local_var_params or
                local_var_params['dashboard_id'] is None):
            raise ValueError("Missing the required parameter `dashboard_id` when calling `post_dashboards_id_cells`")  # noqa: E501
        # verify the required parameter 'create_cell' is set
        if ('create_cell' not in local_var_params or
                local_var_params['create_cell'] is None):
            raise ValueError("Missing the required parameter `create_cell` when calling `post_dashboards_id_cells`")  # noqa: E501

        path_params = {}
        if 'dashboard_id' in local_var_params:
            path_params['dashboardID'] = local_var_params['dashboard_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        if 'create_cell' in local_var_params:
            body_params = local_var_params['create_cell']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def post_dashboards_id_labels(self, dashboard_id, label_mapping, **kwargs):  # noqa: E501,D401,D403
        """Add a label to a dashboard.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_dashboards_id_labels(dashboard_id, label_mapping, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dashboard_id: The dashboard ID. (required)
        :param LabelMapping label_mapping: Label to add (required)
        :param str zap_trace_span: OpenTracing span context
        :return: LabelResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_dashboards_id_labels_with_http_info(dashboard_id, label_mapping, **kwargs)  # noqa: E501
        else:
            (data) = self.post_dashboards_id_labels_with_http_info(dashboard_id, label_mapping, **kwargs)  # noqa: E501
            return data

    def post_dashboards_id_labels_with_http_info(self, dashboard_id, label_mapping, **kwargs):  # noqa: E501,D401,D403
        """Add a label to a dashboard.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_dashboards_id_labels_with_http_info(dashboard_id, label_mapping, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dashboard_id: The dashboard ID. (required)
        :param LabelMapping label_mapping: Label to add (required)
        :param str zap_trace_span: OpenTracing span context
        :return: LabelResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_dashboards_id_labels_prepare(dashboard_id, label_mapping, **kwargs)

        return self.api_client.call_api(
            '/api/v2/dashboards/{dashboardID}/labels', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='LabelResponse',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def post_dashboards_id_labels_async(self, dashboard_id, label_mapping, **kwargs):  # noqa: E501,D401,D403
        """Add a label to a dashboard.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str dashboard_id: The dashboard ID. (required)
        :param LabelMapping label_mapping: Label to add (required)
        :param str zap_trace_span: OpenTracing span context
        :return: LabelResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_dashboards_id_labels_prepare(dashboard_id, label_mapping, **kwargs)

        return await self.api_client.call_api(
            '/api/v2/dashboards/{dashboardID}/labels', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='LabelResponse',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _post_dashboards_id_labels_prepare(self, dashboard_id, label_mapping, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['dashboard_id', 'label_mapping', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('post_dashboards_id_labels', all_params, local_var_params)
        # verify the required parameter 'dashboard_id' is set
        if ('dashboard_id' not in local_var_params or
                local_var_params['dashboard_id'] is None):
            raise ValueError("Missing the required parameter `dashboard_id` when calling `post_dashboards_id_labels`")  # noqa: E501
        # verify the required parameter 'label_mapping' is set
        if ('label_mapping' not in local_var_params or
                local_var_params['label_mapping'] is None):
            raise ValueError("Missing the required parameter `label_mapping` when calling `post_dashboards_id_labels`")  # noqa: E501

        path_params = {}
        if 'dashboard_id' in local_var_params:
            path_params['dashboardID'] = local_var_params['dashboard_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        if 'label_mapping' in local_var_params:
            body_params = local_var_params['label_mapping']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def post_dashboards_id_members(self, dashboard_id, add_resource_member_request_body, **kwargs):  # noqa: E501,D401,D403
        """Add a member to a dashboard.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_dashboards_id_members(dashboard_id, add_resource_member_request_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dashboard_id: The dashboard ID. (required)
        :param AddResourceMemberRequestBody add_resource_member_request_body: User to add as member (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceMember
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_dashboards_id_members_with_http_info(dashboard_id, add_resource_member_request_body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_dashboards_id_members_with_http_info(dashboard_id, add_resource_member_request_body, **kwargs)  # noqa: E501
            return data

    def post_dashboards_id_members_with_http_info(self, dashboard_id, add_resource_member_request_body, **kwargs):  # noqa: E501,D401,D403
        """Add a member to a dashboard.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_dashboards_id_members_with_http_info(dashboard_id, add_resource_member_request_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dashboard_id: The dashboard ID. (required)
        :param AddResourceMemberRequestBody add_resource_member_request_body: User to add as member (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceMember
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_dashboards_id_members_prepare(dashboard_id, add_resource_member_request_body, **kwargs)

        return self.api_client.call_api(
            '/api/v2/dashboards/{dashboardID}/members', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='ResourceMember',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def post_dashboards_id_members_async(self, dashboard_id, add_resource_member_request_body, **kwargs):  # noqa: E501,D401,D403
        """Add a member to a dashboard.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str dashboard_id: The dashboard ID. (required)
        :param AddResourceMemberRequestBody add_resource_member_request_body: User to add as member (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceMember
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_dashboards_id_members_prepare(dashboard_id, add_resource_member_request_body, **kwargs)

        return await self.api_client.call_api(
            '/api/v2/dashboards/{dashboardID}/members', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='ResourceMember',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _post_dashboards_id_members_prepare(self, dashboard_id, add_resource_member_request_body, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['dashboard_id', 'add_resource_member_request_body', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('post_dashboards_id_members', all_params, local_var_params)
        # verify the required parameter 'dashboard_id' is set
        if ('dashboard_id' not in local_var_params or
                local_var_params['dashboard_id'] is None):
            raise ValueError("Missing the required parameter `dashboard_id` when calling `post_dashboards_id_members`")  # noqa: E501
        # verify the required parameter 'add_resource_member_request_body' is set
        if ('add_resource_member_request_body' not in local_var_params or
                local_var_params['add_resource_member_request_body'] is None):
            raise ValueError("Missing the required parameter `add_resource_member_request_body` when calling `post_dashboards_id_members`")  # noqa: E501

        path_params = {}
        if 'dashboard_id' in local_var_params:
            path_params['dashboardID'] = local_var_params['dashboard_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        if 'add_resource_member_request_body' in local_var_params:
            body_params = local_var_params['add_resource_member_request_body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def post_dashboards_id_owners(self, dashboard_id, add_resource_member_request_body, **kwargs):  # noqa: E501,D401,D403
        """Add an owner to a dashboard.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_dashboards_id_owners(dashboard_id, add_resource_member_request_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dashboard_id: The dashboard ID. (required)
        :param AddResourceMemberRequestBody add_resource_member_request_body: User to add as owner (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceOwner
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_dashboards_id_owners_with_http_info(dashboard_id, add_resource_member_request_body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_dashboards_id_owners_with_http_info(dashboard_id, add_resource_member_request_body, **kwargs)  # noqa: E501
            return data

    def post_dashboards_id_owners_with_http_info(self, dashboard_id, add_resource_member_request_body, **kwargs):  # noqa: E501,D401,D403
        """Add an owner to a dashboard.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_dashboards_id_owners_with_http_info(dashboard_id, add_resource_member_request_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dashboard_id: The dashboard ID. (required)
        :param AddResourceMemberRequestBody add_resource_member_request_body: User to add as owner (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceOwner
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_dashboards_id_owners_prepare(dashboard_id, add_resource_member_request_body, **kwargs)

        return self.api_client.call_api(
            '/api/v2/dashboards/{dashboardID}/owners', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='ResourceOwner',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def post_dashboards_id_owners_async(self, dashboard_id, add_resource_member_request_body, **kwargs):  # noqa: E501,D401,D403
        """Add an owner to a dashboard.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str dashboard_id: The dashboard ID. (required)
        :param AddResourceMemberRequestBody add_resource_member_request_body: User to add as owner (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceOwner
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_dashboards_id_owners_prepare(dashboard_id, add_resource_member_request_body, **kwargs)

        return await self.api_client.call_api(
            '/api/v2/dashboards/{dashboardID}/owners', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='ResourceOwner',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _post_dashboards_id_owners_prepare(self, dashboard_id, add_resource_member_request_body, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['dashboard_id', 'add_resource_member_request_body', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('post_dashboards_id_owners', all_params, local_var_params)
        # verify the required parameter 'dashboard_id' is set
        if ('dashboard_id' not in local_var_params or
                local_var_params['dashboard_id'] is None):
            raise ValueError("Missing the required parameter `dashboard_id` when calling `post_dashboards_id_owners`")  # noqa: E501
        # verify the required parameter 'add_resource_member_request_body' is set
        if ('add_resource_member_request_body' not in local_var_params or
                local_var_params['add_resource_member_request_body'] is None):
            raise ValueError("Missing the required parameter `add_resource_member_request_body` when calling `post_dashboards_id_owners`")  # noqa: E501

        path_params = {}
        if 'dashboard_id' in local_var_params:
            path_params['dashboardID'] = local_var_params['dashboard_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        if 'add_resource_member_request_body' in local_var_params:
            body_params = local_var_params['add_resource_member_request_body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def put_dashboards_id_cells(self, dashboard_id, cell, **kwargs):  # noqa: E501,D401,D403
        """Replace cells in a dashboard.

        Replaces all cells in a dashboard. This is used primarily to update the positional information of all cells.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_dashboards_id_cells(dashboard_id, cell, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dashboard_id: The ID of the dashboard to update. (required)
        :param list[Cell] cell: (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Dashboard
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.put_dashboards_id_cells_with_http_info(dashboard_id, cell, **kwargs)  # noqa: E501
        else:
            (data) = self.put_dashboards_id_cells_with_http_info(dashboard_id, cell, **kwargs)  # noqa: E501
            return data

    def put_dashboards_id_cells_with_http_info(self, dashboard_id, cell, **kwargs):  # noqa: E501,D401,D403
        """Replace cells in a dashboard.

        Replaces all cells in a dashboard. This is used primarily to update the positional information of all cells.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_dashboards_id_cells_with_http_info(dashboard_id, cell, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dashboard_id: The ID of the dashboard to update. (required)
        :param list[Cell] cell: (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Dashboard
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._put_dashboards_id_cells_prepare(dashboard_id, cell, **kwargs)

        return self.api_client.call_api(
            '/api/v2/dashboards/{dashboardID}/cells', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Dashboard',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def put_dashboards_id_cells_async(self, dashboard_id, cell, **kwargs):  # noqa: E501,D401,D403
        """Replace cells in a dashboard.

        Replaces all cells in a dashboard. This is used primarily to update the positional information of all cells.
        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str dashboard_id: The ID of the dashboard to update. (required)
        :param list[Cell] cell: (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Dashboard
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._put_dashboards_id_cells_prepare(dashboard_id, cell, **kwargs)

        return await self.api_client.call_api(
            '/api/v2/dashboards/{dashboardID}/cells', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Dashboard',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _put_dashboards_id_cells_prepare(self, dashboard_id, cell, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['dashboard_id', 'cell', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('put_dashboards_id_cells', all_params, local_var_params)
        # verify the required parameter 'dashboard_id' is set
        if ('dashboard_id' not in local_var_params or
                local_var_params['dashboard_id'] is None):
            raise ValueError("Missing the required parameter `dashboard_id` when calling `put_dashboards_id_cells`")  # noqa: E501
        # verify the required parameter 'cell' is set
        if ('cell' not in local_var_params or
                local_var_params['cell'] is None):
            raise ValueError("Missing the required parameter `cell` when calling `put_dashboards_id_cells`")  # noqa: E501

        path_params = {}
        if 'dashboard_id' in local_var_params:
            path_params['dashboardID'] = local_var_params['dashboard_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        if 'cell' in local_var_params:
            body_params = local_var_params['cell']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params
