/*
 * This file is part of the Sofia-SIP package
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Pekka Pessi <pekka.pessi@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef HTTP_PROTOS_H
/** Defined when <sofia-sip/http_protos.h> has been included. */
#define HTTP_PROTOS_H

/**@file sofia-sip/http_protos.h
 *
 * Macros for each HTTP header.
 *
 * This file is automatically generated from <http.h> by msg_parser.awk.
 *
 * @author Pekka Pessi <Pekka.Pessi@nokia.com>
 */

#include <sofia-sip/su_config.h>

#ifndef HTTP_HEADER_H
#include <sofia-sip/http_header.h>
#endif
#ifndef HTTP_HCLASSES_H
#include <sofia-sip/http_hclasses.h>
#endif

#define http_header_make(h, c, s) \
  ((http_header_t *)msg_header_make((h), (c), (s)))
#define http_header_vformat(h, c, f, a) \
  ((http_header_t *)msg_header_vformat((h), (c), (f), (a)))

SOFIA_BEGIN_DECLS

/* Declare internal prototypes for request line */

/**@addtogroup http_request*/ /** @{ */

enum {
  /** Hash of request line. @internal*/
  http_request_hash = -1
};

/**Header class for HTTP request line.
 *
 * The header class http_request_class defines how a HTTP
 * request line is parsed and printed.  It also
 * contains methods used by HTTP parser and other functions
 * to manipulate the http_request_t header structure.
 *
 */
SOFIAPUBVAR msg_hclass_t http_request_class[];

#ifndef HTTP_HCLASSES_ONLY

/** Decode (parse) a request line. @internal */
SOFIAPUBFUN msg_parse_f http_request_d;

/** Encode (print) a request line. @internal */
SOFIAPUBFUN msg_print_f http_request_e;

/**Initializer for structure http_request_t.
 *
 * A static http_request_t structure must be initialized
 * with the HTTP_REQUEST_INIT() macro. For instance,
 * @code
 *
 *  http_request_t http_request = HTTP_REQUEST_INIT;
 *
 * @endcode
 * @HI
 */
#define HTTP_REQUEST_INIT() HTTP_HDR_INIT(request)

/**Initialize a structure http_request_t.
 *
 * An http_request_t structure can be initialized with the
 * http_request_init() function/macro. For instance,
 * @code
 *
 *  http_request_t http_request;
 *
 *  http_request_init(&http_request);
 *
 * @endcode
 * @HI
 */
#if SU_HAVE_INLINE
su_inline http_request_t *http_request_init(http_request_t x[1])
{
  return HTTP_HEADER_INIT(x, http_request_class, sizeof(http_request_t));
}
#else
#define http_request_init(x) \
  HTTP_HEADER_INIT(x, http_request_class, sizeof(http_request_t))
#endif

/**Test if header object is instance of http_request_t.
 *
 * The function http_is_request() returns true (nonzero) if
 * the header class is an instance of request line
 * object and false (zero) otherwise.
 *
 * @param header pointer to the header structure to be tested
 *
 * @return
 * The function http_is_xrequest() returns true (nonzero) if
 * the header object is an instance of header request and
 * false (zero) otherwise.
 */
#if SU_HAVE_INLINE
su_inline
int http_is_request(http_header_t const *header)
{
  return header && header->sh_class->hc_hash == http_request_hash;
}
#else
#define http_is_request(h) \
 ((h) && ((msg_common_t *)(h))->h_class->hc_hash == http_request_hash)
#endif

/**Duplicate (deep copy) @c http_request_t.
 *
 * The function http_request_dup() duplicates a header
 * structure @a hdr.  If the header structure @a hdr
 * contains a reference (@c hdr->x_next) to a list of
 * headers, all the headers in the list are duplicated, too.
 *
 * @param home  memory home used to allocate new structure
 * @param hdr   header structure to be duplicated
 *
 * When duplicating, all parameter lists and non-constant
 * strings attached to the header are copied, too.  The
 * function uses given memory @a home to allocate all the
 * memory areas used to copy the header.
 *
 * @par Example
 * @code
 *
 *   request = http_request_dup(home, http->http_request);
 *
 * @endcode
 *
 * @return
 * The function http_request_dup() returns a pointer to the
 * newly duplicated http_request_t header structure, or NULL
 * upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_request_t *http_request_dup(su_home_t *home,
				   http_request_t const *hdr)
     __attribute__((__malloc__));

/**Copy a http_request_t header structure.
 *
 * The function http_request_copy() copies a header structure @a
 * hdr.  If the header structure @a hdr contains a reference (@c
 * hdr->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home
 * to allocate all the memory areas used to copy the header
 * structure @a hdr.
 *
 * @param home    memory home used to allocate new structure
 * @param hdr     pointer to the header structure to be duplicated
 *
 * When copying, only the header structure and parameter lists
 * attached to it are duplicated.  The new header structure
 * retains all the references to the strings within the old @a
 * header, including the encoding of the old header, if present.
 *
 * @par Example
 * @code
 *
 *   request = http_request_copy(home, http->http_request);
 *
 * @endcode
 *
 * @return
 * The function http_request_copy() returns a pointer to
 * newly copied header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_request_t *http_request_copy(su_home_t *home,
				    http_request_t const *hdr)
     __attribute__((__malloc__));

/**Make a header structure http_request_t.
 *
 * The function http_request_make() makes a new
 * http_request_t header structure.  It allocates a new
 * header structure, and decodes the string @a s as the
 * value of the structure.
 *
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 *
 * @note This function is usually implemented as a macro calling
 * http_header_make().
 *
 * @return
 * The function http_request_make() returns a pointer to
 * newly maked http_request_t header structure, or NULL upon
 * an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_request_t *http_request_make(su_home_t *home, char const *s)
     __attribute__((__malloc__));

/**Make a request line from formatting result.
 *
 * The function http_request_format() makes a new
 * request line object using formatting result as its
 * value.  The function first prints the arguments according to
 * the format @a fmt specified.  Then it allocates a new header
 * structure, and uses the formatting result as the header
 * value.
 *
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 *
 * @note This function is usually implemented as a macro calling
 * msg_header_format().
 *
 * @return
 * The function http_request_format() returns a pointer to newly
 * makes header structure, or NULL upon an error.
 *
 * @HIDE
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_request_t *http_request_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__malloc__, __format__ (printf, 2, 3)));


/* Inlined functions */
#if SU_HAVE_INLINE
su_inline
http_request_t *http_request_format(su_home_t *home, char const *fmt, ...)
{
  http_header_t *h;
  va_list ap;

  va_start(ap, fmt);
  h = http_header_vformat(home, http_request_class, fmt, ap);
  va_end(ap);

  return (http_request_t *)h;
}

su_inline
http_request_t *http_request_dup(su_home_t *home, http_request_t const *o)
{
  return (http_request_t *)
    msg_header_dup_as(home, http_request_class, (msg_header_t const *)o);
}

su_inline
http_request_t *http_request_copy(su_home_t *home, http_request_t const *o)
{
  return (http_request_t *)
    msg_header_copy_as(home, http_request_class, (msg_header_t const *)o);
}

su_inline
http_request_t *http_request_make(su_home_t *home, char const *s)
{
  return (http_request_t *)http_header_make(home, http_request_class, s);
}
#endif

#endif /* !define HTTP_HCLASSES_ONLY */

/** @} */


/* Declare internal prototypes for status line */

/**@addtogroup http_status*/ /** @{ */

enum {
  /** Hash of status line. @internal*/
  http_status_hash = -2
};

/**Header class for HTTP status line.
 *
 * The header class http_status_class defines how a HTTP
 * status line is parsed and printed.  It also
 * contains methods used by HTTP parser and other functions
 * to manipulate the http_status_t header structure.
 *
 */
SOFIAPUBVAR msg_hclass_t http_status_class[];

#ifndef HTTP_HCLASSES_ONLY

/** Decode (parse) a status line. @internal */
SOFIAPUBFUN msg_parse_f http_status_d;

/** Encode (print) a status line. @internal */
SOFIAPUBFUN msg_print_f http_status_e;

/**Initializer for structure http_status_t.
 *
 * A static http_status_t structure must be initialized
 * with the HTTP_STATUS_INIT() macro. For instance,
 * @code
 *
 *  http_status_t http_status = HTTP_STATUS_INIT;
 *
 * @endcode
 * @HI
 */
#define HTTP_STATUS_INIT() HTTP_HDR_INIT(status)

/**Initialize a structure http_status_t.
 *
 * An http_status_t structure can be initialized with the
 * http_status_init() function/macro. For instance,
 * @code
 *
 *  http_status_t http_status;
 *
 *  http_status_init(&http_status);
 *
 * @endcode
 * @HI
 */
#if SU_HAVE_INLINE
su_inline http_status_t *http_status_init(http_status_t x[1])
{
  return HTTP_HEADER_INIT(x, http_status_class, sizeof(http_status_t));
}
#else
#define http_status_init(x) \
  HTTP_HEADER_INIT(x, http_status_class, sizeof(http_status_t))
#endif

/**Test if header object is instance of http_status_t.
 *
 * The function http_is_status() returns true (nonzero) if
 * the header class is an instance of status line
 * object and false (zero) otherwise.
 *
 * @param header pointer to the header structure to be tested
 *
 * @return
 * The function http_is_xstatus() returns true (nonzero) if
 * the header object is an instance of header status and
 * false (zero) otherwise.
 */
#if SU_HAVE_INLINE
su_inline
int http_is_status(http_header_t const *header)
{
  return header && header->sh_class->hc_hash == http_status_hash;
}
#else
#define http_is_status(h) \
 ((h) && ((msg_common_t *)(h))->h_class->hc_hash == http_status_hash)
#endif

/**Duplicate (deep copy) @c http_status_t.
 *
 * The function http_status_dup() duplicates a header
 * structure @a hdr.  If the header structure @a hdr
 * contains a reference (@c hdr->x_next) to a list of
 * headers, all the headers in the list are duplicated, too.
 *
 * @param home  memory home used to allocate new structure
 * @param hdr   header structure to be duplicated
 *
 * When duplicating, all parameter lists and non-constant
 * strings attached to the header are copied, too.  The
 * function uses given memory @a home to allocate all the
 * memory areas used to copy the header.
 *
 * @par Example
 * @code
 *
 *   status = http_status_dup(home, http->http_status);
 *
 * @endcode
 *
 * @return
 * The function http_status_dup() returns a pointer to the
 * newly duplicated http_status_t header structure, or NULL
 * upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_status_t *http_status_dup(su_home_t *home,
				   http_status_t const *hdr)
     __attribute__((__malloc__));

/**Copy a http_status_t header structure.
 *
 * The function http_status_copy() copies a header structure @a
 * hdr.  If the header structure @a hdr contains a reference (@c
 * hdr->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home
 * to allocate all the memory areas used to copy the header
 * structure @a hdr.
 *
 * @param home    memory home used to allocate new structure
 * @param hdr     pointer to the header structure to be duplicated
 *
 * When copying, only the header structure and parameter lists
 * attached to it are duplicated.  The new header structure
 * retains all the references to the strings within the old @a
 * header, including the encoding of the old header, if present.
 *
 * @par Example
 * @code
 *
 *   status = http_status_copy(home, http->http_status);
 *
 * @endcode
 *
 * @return
 * The function http_status_copy() returns a pointer to
 * newly copied header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_status_t *http_status_copy(su_home_t *home,
				    http_status_t const *hdr)
     __attribute__((__malloc__));

/**Make a header structure http_status_t.
 *
 * The function http_status_make() makes a new
 * http_status_t header structure.  It allocates a new
 * header structure, and decodes the string @a s as the
 * value of the structure.
 *
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 *
 * @note This function is usually implemented as a macro calling
 * http_header_make().
 *
 * @return
 * The function http_status_make() returns a pointer to
 * newly maked http_status_t header structure, or NULL upon
 * an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_status_t *http_status_make(su_home_t *home, char const *s)
     __attribute__((__malloc__));

/**Make a status line from formatting result.
 *
 * The function http_status_format() makes a new
 * status line object using formatting result as its
 * value.  The function first prints the arguments according to
 * the format @a fmt specified.  Then it allocates a new header
 * structure, and uses the formatting result as the header
 * value.
 *
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 *
 * @note This function is usually implemented as a macro calling
 * msg_header_format().
 *
 * @return
 * The function http_status_format() returns a pointer to newly
 * makes header structure, or NULL upon an error.
 *
 * @HIDE
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_status_t *http_status_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__malloc__, __format__ (printf, 2, 3)));


/* Inlined functions */
#if SU_HAVE_INLINE
su_inline
http_status_t *http_status_format(su_home_t *home, char const *fmt, ...)
{
  http_header_t *h;
  va_list ap;

  va_start(ap, fmt);
  h = http_header_vformat(home, http_status_class, fmt, ap);
  va_end(ap);

  return (http_status_t *)h;
}

su_inline
http_status_t *http_status_dup(su_home_t *home, http_status_t const *o)
{
  return (http_status_t *)
    msg_header_dup_as(home, http_status_class, (msg_header_t const *)o);
}

su_inline
http_status_t *http_status_copy(su_home_t *home, http_status_t const *o)
{
  return (http_status_t *)
    msg_header_copy_as(home, http_status_class, (msg_header_t const *)o);
}

su_inline
http_status_t *http_status_make(su_home_t *home, char const *s)
{
  return (http_status_t *)http_header_make(home, http_status_class, s);
}
#endif

#endif /* !define HTTP_HCLASSES_ONLY */

/** @} */


/* Declare internal prototypes for Accept header */

/**@addtogroup http_accept*/ /** @{ */

enum {
  /** Hash of Accept header. @internal*/
  http_accept_hash = 29344
};

/**Header class for HTTP Accept header.
 *
 * The header class http_accept_class defines how a HTTP
 * Accept header is parsed and printed.  It also
 * contains methods used by HTTP parser and other functions
 * to manipulate the http_accept_t header structure.
 *
 */
SOFIAPUBVAR msg_hclass_t http_accept_class[];

#ifndef HTTP_HCLASSES_ONLY

/** Decode (parse) a Accept header. @internal */
SOFIAPUBFUN msg_parse_f http_accept_d;

/** Encode (print) a Accept header. @internal */
SOFIAPUBFUN msg_print_f http_accept_e;

/**Initializer for structure http_accept_t.
 *
 * A static http_accept_t structure must be initialized
 * with the HTTP_ACCEPT_INIT() macro. For instance,
 * @code
 *
 *  http_accept_t http_accept = HTTP_ACCEPT_INIT;
 *
 * @endcode
 * @HI
 */
#define HTTP_ACCEPT_INIT() HTTP_HDR_INIT(accept)

/**Initialize a structure http_accept_t.
 *
 * An http_accept_t structure can be initialized with the
 * http_accept_init() function/macro. For instance,
 * @code
 *
 *  http_accept_t http_accept;
 *
 *  http_accept_init(&http_accept);
 *
 * @endcode
 * @HI
 */
#if SU_HAVE_INLINE
su_inline http_accept_t *http_accept_init(http_accept_t x[1])
{
  return HTTP_HEADER_INIT(x, http_accept_class, sizeof(http_accept_t));
}
#else
#define http_accept_init(x) \
  HTTP_HEADER_INIT(x, http_accept_class, sizeof(http_accept_t))
#endif

/**Test if header object is instance of http_accept_t.
 *
 * The function http_is_accept() returns true (nonzero) if
 * the header class is an instance of Accept header
 * object and false (zero) otherwise.
 *
 * @param header pointer to the header structure to be tested
 *
 * @return
 * The function http_is_xaccept() returns true (nonzero) if
 * the header object is an instance of header accept and
 * false (zero) otherwise.
 */
#if SU_HAVE_INLINE
su_inline
int http_is_accept(http_header_t const *header)
{
  return header && header->sh_class->hc_hash == http_accept_hash;
}
#else
#define http_is_accept(h) \
 ((h) && ((msg_common_t *)(h))->h_class->hc_hash == http_accept_hash)
#endif

/**Duplicate (deep copy) @c http_accept_t.
 *
 * The function http_accept_dup() duplicates a header
 * structure @a hdr.  If the header structure @a hdr
 * contains a reference (@c hdr->x_next) to a list of
 * headers, all the headers in the list are duplicated, too.
 *
 * @param home  memory home used to allocate new structure
 * @param hdr   header structure to be duplicated
 *
 * When duplicating, all parameter lists and non-constant
 * strings attached to the header are copied, too.  The
 * function uses given memory @a home to allocate all the
 * memory areas used to copy the header.
 *
 * @par Example
 * @code
 *
 *   accept = http_accept_dup(home, http->http_accept);
 *
 * @endcode
 *
 * @return
 * The function http_accept_dup() returns a pointer to the
 * newly duplicated http_accept_t header structure, or NULL
 * upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_accept_t *http_accept_dup(su_home_t *home,
				   http_accept_t const *hdr)
     __attribute__((__malloc__));

/**Copy a http_accept_t header structure.
 *
 * The function http_accept_copy() copies a header structure @a
 * hdr.  If the header structure @a hdr contains a reference (@c
 * hdr->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home
 * to allocate all the memory areas used to copy the header
 * structure @a hdr.
 *
 * @param home    memory home used to allocate new structure
 * @param hdr     pointer to the header structure to be duplicated
 *
 * When copying, only the header structure and parameter lists
 * attached to it are duplicated.  The new header structure
 * retains all the references to the strings within the old @a
 * header, including the encoding of the old header, if present.
 *
 * @par Example
 * @code
 *
 *   accept = http_accept_copy(home, http->http_accept);
 *
 * @endcode
 *
 * @return
 * The function http_accept_copy() returns a pointer to
 * newly copied header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_accept_t *http_accept_copy(su_home_t *home,
				    http_accept_t const *hdr)
     __attribute__((__malloc__));

/**Make a header structure http_accept_t.
 *
 * The function http_accept_make() makes a new
 * http_accept_t header structure.  It allocates a new
 * header structure, and decodes the string @a s as the
 * value of the structure.
 *
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 *
 * @note This function is usually implemented as a macro calling
 * http_header_make().
 *
 * @return
 * The function http_accept_make() returns a pointer to
 * newly maked http_accept_t header structure, or NULL upon
 * an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_accept_t *http_accept_make(su_home_t *home, char const *s)
     __attribute__((__malloc__));

/**Make a Accept header from formatting result.
 *
 * The function http_accept_format() makes a new
 * Accept header object using formatting result as its
 * value.  The function first prints the arguments according to
 * the format @a fmt specified.  Then it allocates a new header
 * structure, and uses the formatting result as the header
 * value.
 *
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 *
 * @note This function is usually implemented as a macro calling
 * msg_header_format().
 *
 * @return
 * The function http_accept_format() returns a pointer to newly
 * makes header structure, or NULL upon an error.
 *
 * @HIDE
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_accept_t *http_accept_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__malloc__, __format__ (printf, 2, 3)));


/* Inlined functions */
#if SU_HAVE_INLINE
su_inline
http_accept_t *http_accept_format(su_home_t *home, char const *fmt, ...)
{
  http_header_t *h;
  va_list ap;

  va_start(ap, fmt);
  h = http_header_vformat(home, http_accept_class, fmt, ap);
  va_end(ap);

  return (http_accept_t *)h;
}

su_inline
http_accept_t *http_accept_dup(su_home_t *home, http_accept_t const *o)
{
  return (http_accept_t *)
    msg_header_dup_as(home, http_accept_class, (msg_header_t const *)o);
}

su_inline
http_accept_t *http_accept_copy(su_home_t *home, http_accept_t const *o)
{
  return (http_accept_t *)
    msg_header_copy_as(home, http_accept_class, (msg_header_t const *)o);
}

su_inline
http_accept_t *http_accept_make(su_home_t *home, char const *s)
{
  return (http_accept_t *)http_header_make(home, http_accept_class, s);
}
#endif

#endif /* !define HTTP_HCLASSES_ONLY */

/** @} */


/* Declare internal prototypes for Accept-Charset header */

/**@addtogroup http_accept_charset*/ /** @{ */

enum {
  /** Hash of Accept-Charset header. @internal*/
  http_accept_charset_hash = 41803
};

/**Header class for HTTP Accept-Charset header.
 *
 * The header class http_accept_charset_class defines how a HTTP
 * Accept-Charset header is parsed and printed.  It also
 * contains methods used by HTTP parser and other functions
 * to manipulate the http_accept_charset_t header structure.
 *
 */
SOFIAPUBVAR msg_hclass_t http_accept_charset_class[];

#ifndef HTTP_HCLASSES_ONLY

/** Decode (parse) a Accept-Charset header. @internal */
SOFIAPUBFUN msg_parse_f http_accept_charset_d;

/** Encode (print) a Accept-Charset header. @internal */
SOFIAPUBFUN msg_print_f http_accept_charset_e;

/**Initializer for structure http_accept_charset_t.
 *
 * A static http_accept_charset_t structure must be initialized
 * with the HTTP_ACCEPT_CHARSET_INIT() macro. For instance,
 * @code
 *
 *  http_accept_charset_t http_accept_charset = HTTP_ACCEPT_CHARSET_INIT;
 *
 * @endcode
 * @HI
 */
#define HTTP_ACCEPT_CHARSET_INIT() HTTP_HDR_INIT(accept_charset)

/**Initialize a structure http_accept_charset_t.
 *
 * An http_accept_charset_t structure can be initialized with the
 * http_accept_charset_init() function/macro. For instance,
 * @code
 *
 *  http_accept_charset_t http_accept_charset;
 *
 *  http_accept_charset_init(&http_accept_charset);
 *
 * @endcode
 * @HI
 */
#if SU_HAVE_INLINE
su_inline http_accept_charset_t *http_accept_charset_init(http_accept_charset_t x[1])
{
  return HTTP_HEADER_INIT(x, http_accept_charset_class, sizeof(http_accept_charset_t));
}
#else
#define http_accept_charset_init(x) \
  HTTP_HEADER_INIT(x, http_accept_charset_class, sizeof(http_accept_charset_t))
#endif

/**Test if header object is instance of http_accept_charset_t.
 *
 * The function http_is_accept_charset() returns true (nonzero) if
 * the header class is an instance of Accept-Charset header
 * object and false (zero) otherwise.
 *
 * @param header pointer to the header structure to be tested
 *
 * @return
 * The function http_is_xaccept_charset() returns true (nonzero) if
 * the header object is an instance of header accept_charset and
 * false (zero) otherwise.
 */
#if SU_HAVE_INLINE
su_inline
int http_is_accept_charset(http_header_t const *header)
{
  return header && header->sh_class->hc_hash == http_accept_charset_hash;
}
#else
#define http_is_accept_charset(h) \
 ((h) && ((msg_common_t *)(h))->h_class->hc_hash == http_accept_charset_hash)
#endif

/**Duplicate (deep copy) @c http_accept_charset_t.
 *
 * The function http_accept_charset_dup() duplicates a header
 * structure @a hdr.  If the header structure @a hdr
 * contains a reference (@c hdr->x_next) to a list of
 * headers, all the headers in the list are duplicated, too.
 *
 * @param home  memory home used to allocate new structure
 * @param hdr   header structure to be duplicated
 *
 * When duplicating, all parameter lists and non-constant
 * strings attached to the header are copied, too.  The
 * function uses given memory @a home to allocate all the
 * memory areas used to copy the header.
 *
 * @par Example
 * @code
 *
 *   accept_charset = http_accept_charset_dup(home, http->http_accept_charset);
 *
 * @endcode
 *
 * @return
 * The function http_accept_charset_dup() returns a pointer to the
 * newly duplicated http_accept_charset_t header structure, or NULL
 * upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_accept_charset_t *http_accept_charset_dup(su_home_t *home,
				   http_accept_charset_t const *hdr)
     __attribute__((__malloc__));

/**Copy a http_accept_charset_t header structure.
 *
 * The function http_accept_charset_copy() copies a header structure @a
 * hdr.  If the header structure @a hdr contains a reference (@c
 * hdr->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home
 * to allocate all the memory areas used to copy the header
 * structure @a hdr.
 *
 * @param home    memory home used to allocate new structure
 * @param hdr     pointer to the header structure to be duplicated
 *
 * When copying, only the header structure and parameter lists
 * attached to it are duplicated.  The new header structure
 * retains all the references to the strings within the old @a
 * header, including the encoding of the old header, if present.
 *
 * @par Example
 * @code
 *
 *   accept_charset = http_accept_charset_copy(home, http->http_accept_charset);
 *
 * @endcode
 *
 * @return
 * The function http_accept_charset_copy() returns a pointer to
 * newly copied header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_accept_charset_t *http_accept_charset_copy(su_home_t *home,
				    http_accept_charset_t const *hdr)
     __attribute__((__malloc__));

/**Make a header structure http_accept_charset_t.
 *
 * The function http_accept_charset_make() makes a new
 * http_accept_charset_t header structure.  It allocates a new
 * header structure, and decodes the string @a s as the
 * value of the structure.
 *
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 *
 * @note This function is usually implemented as a macro calling
 * http_header_make().
 *
 * @return
 * The function http_accept_charset_make() returns a pointer to
 * newly maked http_accept_charset_t header structure, or NULL upon
 * an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_accept_charset_t *http_accept_charset_make(su_home_t *home, char const *s)
     __attribute__((__malloc__));

/**Make a Accept-Charset header from formatting result.
 *
 * The function http_accept_charset_format() makes a new
 * Accept-Charset header object using formatting result as its
 * value.  The function first prints the arguments according to
 * the format @a fmt specified.  Then it allocates a new header
 * structure, and uses the formatting result as the header
 * value.
 *
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 *
 * @note This function is usually implemented as a macro calling
 * msg_header_format().
 *
 * @return
 * The function http_accept_charset_format() returns a pointer to newly
 * makes header structure, or NULL upon an error.
 *
 * @HIDE
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_accept_charset_t *http_accept_charset_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__malloc__, __format__ (printf, 2, 3)));


/* Inlined functions */
#if SU_HAVE_INLINE
su_inline
http_accept_charset_t *http_accept_charset_format(su_home_t *home, char const *fmt, ...)
{
  http_header_t *h;
  va_list ap;

  va_start(ap, fmt);
  h = http_header_vformat(home, http_accept_charset_class, fmt, ap);
  va_end(ap);

  return (http_accept_charset_t *)h;
}

su_inline
http_accept_charset_t *http_accept_charset_dup(su_home_t *home, http_accept_charset_t const *o)
{
  return (http_accept_charset_t *)
    msg_header_dup_as(home, http_accept_charset_class, (msg_header_t const *)o);
}

su_inline
http_accept_charset_t *http_accept_charset_copy(su_home_t *home, http_accept_charset_t const *o)
{
  return (http_accept_charset_t *)
    msg_header_copy_as(home, http_accept_charset_class, (msg_header_t const *)o);
}

su_inline
http_accept_charset_t *http_accept_charset_make(su_home_t *home, char const *s)
{
  return (http_accept_charset_t *)http_header_make(home, http_accept_charset_class, s);
}
#endif

#endif /* !define HTTP_HCLASSES_ONLY */

/** @} */


/* Declare internal prototypes for Accept-Encoding header */

/**@addtogroup http_accept_encoding*/ /** @{ */

enum {
  /** Hash of Accept-Encoding header. @internal*/
  http_accept_encoding_hash = 35932
};

/**Header class for HTTP Accept-Encoding header.
 *
 * The header class http_accept_encoding_class defines how a HTTP
 * Accept-Encoding header is parsed and printed.  It also
 * contains methods used by HTTP parser and other functions
 * to manipulate the http_accept_encoding_t header structure.
 *
 */
SOFIAPUBVAR msg_hclass_t http_accept_encoding_class[];

#ifndef HTTP_HCLASSES_ONLY

/** Decode (parse) a Accept-Encoding header. @internal */
SOFIAPUBFUN msg_parse_f http_accept_encoding_d;

/** Encode (print) a Accept-Encoding header. @internal */
SOFIAPUBFUN msg_print_f http_accept_encoding_e;

/**Initializer for structure http_accept_encoding_t.
 *
 * A static http_accept_encoding_t structure must be initialized
 * with the HTTP_ACCEPT_ENCODING_INIT() macro. For instance,
 * @code
 *
 *  http_accept_encoding_t http_accept_encoding = HTTP_ACCEPT_ENCODING_INIT;
 *
 * @endcode
 * @HI
 */
#define HTTP_ACCEPT_ENCODING_INIT() HTTP_HDR_INIT(accept_encoding)

/**Initialize a structure http_accept_encoding_t.
 *
 * An http_accept_encoding_t structure can be initialized with the
 * http_accept_encoding_init() function/macro. For instance,
 * @code
 *
 *  http_accept_encoding_t http_accept_encoding;
 *
 *  http_accept_encoding_init(&http_accept_encoding);
 *
 * @endcode
 * @HI
 */
#if SU_HAVE_INLINE
su_inline http_accept_encoding_t *http_accept_encoding_init(http_accept_encoding_t x[1])
{
  return HTTP_HEADER_INIT(x, http_accept_encoding_class, sizeof(http_accept_encoding_t));
}
#else
#define http_accept_encoding_init(x) \
  HTTP_HEADER_INIT(x, http_accept_encoding_class, sizeof(http_accept_encoding_t))
#endif

/**Test if header object is instance of http_accept_encoding_t.
 *
 * The function http_is_accept_encoding() returns true (nonzero) if
 * the header class is an instance of Accept-Encoding header
 * object and false (zero) otherwise.
 *
 * @param header pointer to the header structure to be tested
 *
 * @return
 * The function http_is_xaccept_encoding() returns true (nonzero) if
 * the header object is an instance of header accept_encoding and
 * false (zero) otherwise.
 */
#if SU_HAVE_INLINE
su_inline
int http_is_accept_encoding(http_header_t const *header)
{
  return header && header->sh_class->hc_hash == http_accept_encoding_hash;
}
#else
#define http_is_accept_encoding(h) \
 ((h) && ((msg_common_t *)(h))->h_class->hc_hash == http_accept_encoding_hash)
#endif

/**Duplicate (deep copy) @c http_accept_encoding_t.
 *
 * The function http_accept_encoding_dup() duplicates a header
 * structure @a hdr.  If the header structure @a hdr
 * contains a reference (@c hdr->x_next) to a list of
 * headers, all the headers in the list are duplicated, too.
 *
 * @param home  memory home used to allocate new structure
 * @param hdr   header structure to be duplicated
 *
 * When duplicating, all parameter lists and non-constant
 * strings attached to the header are copied, too.  The
 * function uses given memory @a home to allocate all the
 * memory areas used to copy the header.
 *
 * @par Example
 * @code
 *
 *   accept_encoding = http_accept_encoding_dup(home, http->http_accept_encoding);
 *
 * @endcode
 *
 * @return
 * The function http_accept_encoding_dup() returns a pointer to the
 * newly duplicated http_accept_encoding_t header structure, or NULL
 * upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_accept_encoding_t *http_accept_encoding_dup(su_home_t *home,
				   http_accept_encoding_t const *hdr)
     __attribute__((__malloc__));

/**Copy a http_accept_encoding_t header structure.
 *
 * The function http_accept_encoding_copy() copies a header structure @a
 * hdr.  If the header structure @a hdr contains a reference (@c
 * hdr->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home
 * to allocate all the memory areas used to copy the header
 * structure @a hdr.
 *
 * @param home    memory home used to allocate new structure
 * @param hdr     pointer to the header structure to be duplicated
 *
 * When copying, only the header structure and parameter lists
 * attached to it are duplicated.  The new header structure
 * retains all the references to the strings within the old @a
 * header, including the encoding of the old header, if present.
 *
 * @par Example
 * @code
 *
 *   accept_encoding = http_accept_encoding_copy(home, http->http_accept_encoding);
 *
 * @endcode
 *
 * @return
 * The function http_accept_encoding_copy() returns a pointer to
 * newly copied header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_accept_encoding_t *http_accept_encoding_copy(su_home_t *home,
				    http_accept_encoding_t const *hdr)
     __attribute__((__malloc__));

/**Make a header structure http_accept_encoding_t.
 *
 * The function http_accept_encoding_make() makes a new
 * http_accept_encoding_t header structure.  It allocates a new
 * header structure, and decodes the string @a s as the
 * value of the structure.
 *
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 *
 * @note This function is usually implemented as a macro calling
 * http_header_make().
 *
 * @return
 * The function http_accept_encoding_make() returns a pointer to
 * newly maked http_accept_encoding_t header structure, or NULL upon
 * an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_accept_encoding_t *http_accept_encoding_make(su_home_t *home, char const *s)
     __attribute__((__malloc__));

/**Make a Accept-Encoding header from formatting result.
 *
 * The function http_accept_encoding_format() makes a new
 * Accept-Encoding header object using formatting result as its
 * value.  The function first prints the arguments according to
 * the format @a fmt specified.  Then it allocates a new header
 * structure, and uses the formatting result as the header
 * value.
 *
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 *
 * @note This function is usually implemented as a macro calling
 * msg_header_format().
 *
 * @return
 * The function http_accept_encoding_format() returns a pointer to newly
 * makes header structure, or NULL upon an error.
 *
 * @HIDE
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_accept_encoding_t *http_accept_encoding_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__malloc__, __format__ (printf, 2, 3)));


/* Inlined functions */
#if SU_HAVE_INLINE
su_inline
http_accept_encoding_t *http_accept_encoding_format(su_home_t *home, char const *fmt, ...)
{
  http_header_t *h;
  va_list ap;

  va_start(ap, fmt);
  h = http_header_vformat(home, http_accept_encoding_class, fmt, ap);
  va_end(ap);

  return (http_accept_encoding_t *)h;
}

su_inline
http_accept_encoding_t *http_accept_encoding_dup(su_home_t *home, http_accept_encoding_t const *o)
{
  return (http_accept_encoding_t *)
    msg_header_dup_as(home, http_accept_encoding_class, (msg_header_t const *)o);
}

su_inline
http_accept_encoding_t *http_accept_encoding_copy(su_home_t *home, http_accept_encoding_t const *o)
{
  return (http_accept_encoding_t *)
    msg_header_copy_as(home, http_accept_encoding_class, (msg_header_t const *)o);
}

su_inline
http_accept_encoding_t *http_accept_encoding_make(su_home_t *home, char const *s)
{
  return (http_accept_encoding_t *)http_header_make(home, http_accept_encoding_class, s);
}
#endif

#endif /* !define HTTP_HCLASSES_ONLY */

/** @} */


/* Declare internal prototypes for Accept-Language header */

/**@addtogroup http_accept_language*/ /** @{ */

enum {
  /** Hash of Accept-Language header. @internal*/
  http_accept_language_hash = 23797
};

/**Header class for HTTP Accept-Language header.
 *
 * The header class http_accept_language_class defines how a HTTP
 * Accept-Language header is parsed and printed.  It also
 * contains methods used by HTTP parser and other functions
 * to manipulate the http_accept_language_t header structure.
 *
 */
SOFIAPUBVAR msg_hclass_t http_accept_language_class[];

#ifndef HTTP_HCLASSES_ONLY

/** Decode (parse) a Accept-Language header. @internal */
SOFIAPUBFUN msg_parse_f http_accept_language_d;

/** Encode (print) a Accept-Language header. @internal */
SOFIAPUBFUN msg_print_f http_accept_language_e;

/**Initializer for structure http_accept_language_t.
 *
 * A static http_accept_language_t structure must be initialized
 * with the HTTP_ACCEPT_LANGUAGE_INIT() macro. For instance,
 * @code
 *
 *  http_accept_language_t http_accept_language = HTTP_ACCEPT_LANGUAGE_INIT;
 *
 * @endcode
 * @HI
 */
#define HTTP_ACCEPT_LANGUAGE_INIT() HTTP_HDR_INIT(accept_language)

/**Initialize a structure http_accept_language_t.
 *
 * An http_accept_language_t structure can be initialized with the
 * http_accept_language_init() function/macro. For instance,
 * @code
 *
 *  http_accept_language_t http_accept_language;
 *
 *  http_accept_language_init(&http_accept_language);
 *
 * @endcode
 * @HI
 */
#if SU_HAVE_INLINE
su_inline http_accept_language_t *http_accept_language_init(http_accept_language_t x[1])
{
  return HTTP_HEADER_INIT(x, http_accept_language_class, sizeof(http_accept_language_t));
}
#else
#define http_accept_language_init(x) \
  HTTP_HEADER_INIT(x, http_accept_language_class, sizeof(http_accept_language_t))
#endif

/**Test if header object is instance of http_accept_language_t.
 *
 * The function http_is_accept_language() returns true (nonzero) if
 * the header class is an instance of Accept-Language header
 * object and false (zero) otherwise.
 *
 * @param header pointer to the header structure to be tested
 *
 * @return
 * The function http_is_xaccept_language() returns true (nonzero) if
 * the header object is an instance of header accept_language and
 * false (zero) otherwise.
 */
#if SU_HAVE_INLINE
su_inline
int http_is_accept_language(http_header_t const *header)
{
  return header && header->sh_class->hc_hash == http_accept_language_hash;
}
#else
#define http_is_accept_language(h) \
 ((h) && ((msg_common_t *)(h))->h_class->hc_hash == http_accept_language_hash)
#endif

/**Duplicate (deep copy) @c http_accept_language_t.
 *
 * The function http_accept_language_dup() duplicates a header
 * structure @a hdr.  If the header structure @a hdr
 * contains a reference (@c hdr->x_next) to a list of
 * headers, all the headers in the list are duplicated, too.
 *
 * @param home  memory home used to allocate new structure
 * @param hdr   header structure to be duplicated
 *
 * When duplicating, all parameter lists and non-constant
 * strings attached to the header are copied, too.  The
 * function uses given memory @a home to allocate all the
 * memory areas used to copy the header.
 *
 * @par Example
 * @code
 *
 *   accept_language = http_accept_language_dup(home, http->http_accept_language);
 *
 * @endcode
 *
 * @return
 * The function http_accept_language_dup() returns a pointer to the
 * newly duplicated http_accept_language_t header structure, or NULL
 * upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_accept_language_t *http_accept_language_dup(su_home_t *home,
				   http_accept_language_t const *hdr)
     __attribute__((__malloc__));

/**Copy a http_accept_language_t header structure.
 *
 * The function http_accept_language_copy() copies a header structure @a
 * hdr.  If the header structure @a hdr contains a reference (@c
 * hdr->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home
 * to allocate all the memory areas used to copy the header
 * structure @a hdr.
 *
 * @param home    memory home used to allocate new structure
 * @param hdr     pointer to the header structure to be duplicated
 *
 * When copying, only the header structure and parameter lists
 * attached to it are duplicated.  The new header structure
 * retains all the references to the strings within the old @a
 * header, including the encoding of the old header, if present.
 *
 * @par Example
 * @code
 *
 *   accept_language = http_accept_language_copy(home, http->http_accept_language);
 *
 * @endcode
 *
 * @return
 * The function http_accept_language_copy() returns a pointer to
 * newly copied header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_accept_language_t *http_accept_language_copy(su_home_t *home,
				    http_accept_language_t const *hdr)
     __attribute__((__malloc__));

/**Make a header structure http_accept_language_t.
 *
 * The function http_accept_language_make() makes a new
 * http_accept_language_t header structure.  It allocates a new
 * header structure, and decodes the string @a s as the
 * value of the structure.
 *
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 *
 * @note This function is usually implemented as a macro calling
 * http_header_make().
 *
 * @return
 * The function http_accept_language_make() returns a pointer to
 * newly maked http_accept_language_t header structure, or NULL upon
 * an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_accept_language_t *http_accept_language_make(su_home_t *home, char const *s)
     __attribute__((__malloc__));

/**Make a Accept-Language header from formatting result.
 *
 * The function http_accept_language_format() makes a new
 * Accept-Language header object using formatting result as its
 * value.  The function first prints the arguments according to
 * the format @a fmt specified.  Then it allocates a new header
 * structure, and uses the formatting result as the header
 * value.
 *
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 *
 * @note This function is usually implemented as a macro calling
 * msg_header_format().
 *
 * @return
 * The function http_accept_language_format() returns a pointer to newly
 * makes header structure, or NULL upon an error.
 *
 * @HIDE
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_accept_language_t *http_accept_language_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__malloc__, __format__ (printf, 2, 3)));


/* Inlined functions */
#if SU_HAVE_INLINE
su_inline
http_accept_language_t *http_accept_language_format(su_home_t *home, char const *fmt, ...)
{
  http_header_t *h;
  va_list ap;

  va_start(ap, fmt);
  h = http_header_vformat(home, http_accept_language_class, fmt, ap);
  va_end(ap);

  return (http_accept_language_t *)h;
}

su_inline
http_accept_language_t *http_accept_language_dup(su_home_t *home, http_accept_language_t const *o)
{
  return (http_accept_language_t *)
    msg_header_dup_as(home, http_accept_language_class, (msg_header_t const *)o);
}

su_inline
http_accept_language_t *http_accept_language_copy(su_home_t *home, http_accept_language_t const *o)
{
  return (http_accept_language_t *)
    msg_header_copy_as(home, http_accept_language_class, (msg_header_t const *)o);
}

su_inline
http_accept_language_t *http_accept_language_make(su_home_t *home, char const *s)
{
  return (http_accept_language_t *)http_header_make(home, http_accept_language_class, s);
}
#endif

#endif /* !define HTTP_HCLASSES_ONLY */

/** @} */


/* Declare internal prototypes for Accept-Ranges header */

/**@addtogroup http_accept_ranges*/ /** @{ */

enum {
  /** Hash of Accept-Ranges header. @internal*/
  http_accept_ranges_hash = 59733
};

/**Header class for HTTP Accept-Ranges header.
 *
 * The header class http_accept_ranges_class defines how a HTTP
 * Accept-Ranges header is parsed and printed.  It also
 * contains methods used by HTTP parser and other functions
 * to manipulate the http_accept_ranges_t header structure.
 *
 */
SOFIAPUBVAR msg_hclass_t http_accept_ranges_class[];

#ifndef HTTP_HCLASSES_ONLY

/** Decode (parse) a Accept-Ranges header. @internal */
SOFIAPUBFUN msg_parse_f http_accept_ranges_d;

/** Encode (print) a Accept-Ranges header. @internal */
SOFIAPUBFUN msg_print_f http_accept_ranges_e;

/**Initializer for structure http_accept_ranges_t.
 *
 * A static http_accept_ranges_t structure must be initialized
 * with the HTTP_ACCEPT_RANGES_INIT() macro. For instance,
 * @code
 *
 *  http_accept_ranges_t http_accept_ranges = HTTP_ACCEPT_RANGES_INIT;
 *
 * @endcode
 * @HI
 */
#define HTTP_ACCEPT_RANGES_INIT() HTTP_HDR_INIT(accept_ranges)

/**Initialize a structure http_accept_ranges_t.
 *
 * An http_accept_ranges_t structure can be initialized with the
 * http_accept_ranges_init() function/macro. For instance,
 * @code
 *
 *  http_accept_ranges_t http_accept_ranges;
 *
 *  http_accept_ranges_init(&http_accept_ranges);
 *
 * @endcode
 * @HI
 */
#if SU_HAVE_INLINE
su_inline http_accept_ranges_t *http_accept_ranges_init(http_accept_ranges_t x[1])
{
  return HTTP_HEADER_INIT(x, http_accept_ranges_class, sizeof(http_accept_ranges_t));
}
#else
#define http_accept_ranges_init(x) \
  HTTP_HEADER_INIT(x, http_accept_ranges_class, sizeof(http_accept_ranges_t))
#endif

/**Test if header object is instance of http_accept_ranges_t.
 *
 * The function http_is_accept_ranges() returns true (nonzero) if
 * the header class is an instance of Accept-Ranges header
 * object and false (zero) otherwise.
 *
 * @param header pointer to the header structure to be tested
 *
 * @return
 * The function http_is_xaccept_ranges() returns true (nonzero) if
 * the header object is an instance of header accept_ranges and
 * false (zero) otherwise.
 */
#if SU_HAVE_INLINE
su_inline
int http_is_accept_ranges(http_header_t const *header)
{
  return header && header->sh_class->hc_hash == http_accept_ranges_hash;
}
#else
#define http_is_accept_ranges(h) \
 ((h) && ((msg_common_t *)(h))->h_class->hc_hash == http_accept_ranges_hash)
#endif

/**Duplicate (deep copy) @c http_accept_ranges_t.
 *
 * The function http_accept_ranges_dup() duplicates a header
 * structure @a hdr.  If the header structure @a hdr
 * contains a reference (@c hdr->x_next) to a list of
 * headers, all the headers in the list are duplicated, too.
 *
 * @param home  memory home used to allocate new structure
 * @param hdr   header structure to be duplicated
 *
 * When duplicating, all parameter lists and non-constant
 * strings attached to the header are copied, too.  The
 * function uses given memory @a home to allocate all the
 * memory areas used to copy the header.
 *
 * @par Example
 * @code
 *
 *   accept_ranges = http_accept_ranges_dup(home, http->http_accept_ranges);
 *
 * @endcode
 *
 * @return
 * The function http_accept_ranges_dup() returns a pointer to the
 * newly duplicated http_accept_ranges_t header structure, or NULL
 * upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_accept_ranges_t *http_accept_ranges_dup(su_home_t *home,
				   http_accept_ranges_t const *hdr)
     __attribute__((__malloc__));

/**Copy a http_accept_ranges_t header structure.
 *
 * The function http_accept_ranges_copy() copies a header structure @a
 * hdr.  If the header structure @a hdr contains a reference (@c
 * hdr->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home
 * to allocate all the memory areas used to copy the header
 * structure @a hdr.
 *
 * @param home    memory home used to allocate new structure
 * @param hdr     pointer to the header structure to be duplicated
 *
 * When copying, only the header structure and parameter lists
 * attached to it are duplicated.  The new header structure
 * retains all the references to the strings within the old @a
 * header, including the encoding of the old header, if present.
 *
 * @par Example
 * @code
 *
 *   accept_ranges = http_accept_ranges_copy(home, http->http_accept_ranges);
 *
 * @endcode
 *
 * @return
 * The function http_accept_ranges_copy() returns a pointer to
 * newly copied header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_accept_ranges_t *http_accept_ranges_copy(su_home_t *home,
				    http_accept_ranges_t const *hdr)
     __attribute__((__malloc__));

/**Make a header structure http_accept_ranges_t.
 *
 * The function http_accept_ranges_make() makes a new
 * http_accept_ranges_t header structure.  It allocates a new
 * header structure, and decodes the string @a s as the
 * value of the structure.
 *
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 *
 * @note This function is usually implemented as a macro calling
 * http_header_make().
 *
 * @return
 * The function http_accept_ranges_make() returns a pointer to
 * newly maked http_accept_ranges_t header structure, or NULL upon
 * an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_accept_ranges_t *http_accept_ranges_make(su_home_t *home, char const *s)
     __attribute__((__malloc__));

/**Make a Accept-Ranges header from formatting result.
 *
 * The function http_accept_ranges_format() makes a new
 * Accept-Ranges header object using formatting result as its
 * value.  The function first prints the arguments according to
 * the format @a fmt specified.  Then it allocates a new header
 * structure, and uses the formatting result as the header
 * value.
 *
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 *
 * @note This function is usually implemented as a macro calling
 * msg_header_format().
 *
 * @return
 * The function http_accept_ranges_format() returns a pointer to newly
 * makes header structure, or NULL upon an error.
 *
 * @HIDE
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_accept_ranges_t *http_accept_ranges_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__malloc__, __format__ (printf, 2, 3)));


/* Inlined functions */
#if SU_HAVE_INLINE
su_inline
http_accept_ranges_t *http_accept_ranges_format(su_home_t *home, char const *fmt, ...)
{
  http_header_t *h;
  va_list ap;

  va_start(ap, fmt);
  h = http_header_vformat(home, http_accept_ranges_class, fmt, ap);
  va_end(ap);

  return (http_accept_ranges_t *)h;
}

su_inline
http_accept_ranges_t *http_accept_ranges_dup(su_home_t *home, http_accept_ranges_t const *o)
{
  return (http_accept_ranges_t *)
    msg_header_dup_as(home, http_accept_ranges_class, (msg_header_t const *)o);
}

su_inline
http_accept_ranges_t *http_accept_ranges_copy(su_home_t *home, http_accept_ranges_t const *o)
{
  return (http_accept_ranges_t *)
    msg_header_copy_as(home, http_accept_ranges_class, (msg_header_t const *)o);
}

su_inline
http_accept_ranges_t *http_accept_ranges_make(su_home_t *home, char const *s)
{
  return (http_accept_ranges_t *)http_header_make(home, http_accept_ranges_class, s);
}
#endif

#endif /* !define HTTP_HCLASSES_ONLY */

/** @} */


/* Declare internal prototypes for Allow header */

/**@addtogroup http_allow*/ /** @{ */

enum {
  /** Hash of Allow header. @internal*/
  http_allow_hash = 44519
};

/**Header class for HTTP Allow header.
 *
 * The header class http_allow_class defines how a HTTP
 * Allow header is parsed and printed.  It also
 * contains methods used by HTTP parser and other functions
 * to manipulate the http_allow_t header structure.
 *
 */
SOFIAPUBVAR msg_hclass_t http_allow_class[];

#ifndef HTTP_HCLASSES_ONLY

/** Decode (parse) a Allow header. @internal */
SOFIAPUBFUN msg_parse_f http_allow_d;

/** Encode (print) a Allow header. @internal */
SOFIAPUBFUN msg_print_f http_allow_e;

/**Initializer for structure http_allow_t.
 *
 * A static http_allow_t structure must be initialized
 * with the HTTP_ALLOW_INIT() macro. For instance,
 * @code
 *
 *  http_allow_t http_allow = HTTP_ALLOW_INIT;
 *
 * @endcode
 * @HI
 */
#define HTTP_ALLOW_INIT() HTTP_HDR_INIT(allow)

/**Initialize a structure http_allow_t.
 *
 * An http_allow_t structure can be initialized with the
 * http_allow_init() function/macro. For instance,
 * @code
 *
 *  http_allow_t http_allow;
 *
 *  http_allow_init(&http_allow);
 *
 * @endcode
 * @HI
 */
#if SU_HAVE_INLINE
su_inline http_allow_t *http_allow_init(http_allow_t x[1])
{
  return HTTP_HEADER_INIT(x, http_allow_class, sizeof(http_allow_t));
}
#else
#define http_allow_init(x) \
  HTTP_HEADER_INIT(x, http_allow_class, sizeof(http_allow_t))
#endif

/**Test if header object is instance of http_allow_t.
 *
 * The function http_is_allow() returns true (nonzero) if
 * the header class is an instance of Allow header
 * object and false (zero) otherwise.
 *
 * @param header pointer to the header structure to be tested
 *
 * @return
 * The function http_is_xallow() returns true (nonzero) if
 * the header object is an instance of header allow and
 * false (zero) otherwise.
 */
#if SU_HAVE_INLINE
su_inline
int http_is_allow(http_header_t const *header)
{
  return header && header->sh_class->hc_hash == http_allow_hash;
}
#else
#define http_is_allow(h) \
 ((h) && ((msg_common_t *)(h))->h_class->hc_hash == http_allow_hash)
#endif

/**Duplicate (deep copy) @c http_allow_t.
 *
 * The function http_allow_dup() duplicates a header
 * structure @a hdr.  If the header structure @a hdr
 * contains a reference (@c hdr->x_next) to a list of
 * headers, all the headers in the list are duplicated, too.
 *
 * @param home  memory home used to allocate new structure
 * @param hdr   header structure to be duplicated
 *
 * When duplicating, all parameter lists and non-constant
 * strings attached to the header are copied, too.  The
 * function uses given memory @a home to allocate all the
 * memory areas used to copy the header.
 *
 * @par Example
 * @code
 *
 *   allow = http_allow_dup(home, http->http_allow);
 *
 * @endcode
 *
 * @return
 * The function http_allow_dup() returns a pointer to the
 * newly duplicated http_allow_t header structure, or NULL
 * upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_allow_t *http_allow_dup(su_home_t *home,
				   http_allow_t const *hdr)
     __attribute__((__malloc__));

/**Copy a http_allow_t header structure.
 *
 * The function http_allow_copy() copies a header structure @a
 * hdr.  If the header structure @a hdr contains a reference (@c
 * hdr->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home
 * to allocate all the memory areas used to copy the header
 * structure @a hdr.
 *
 * @param home    memory home used to allocate new structure
 * @param hdr     pointer to the header structure to be duplicated
 *
 * When copying, only the header structure and parameter lists
 * attached to it are duplicated.  The new header structure
 * retains all the references to the strings within the old @a
 * header, including the encoding of the old header, if present.
 *
 * @par Example
 * @code
 *
 *   allow = http_allow_copy(home, http->http_allow);
 *
 * @endcode
 *
 * @return
 * The function http_allow_copy() returns a pointer to
 * newly copied header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_allow_t *http_allow_copy(su_home_t *home,
				    http_allow_t const *hdr)
     __attribute__((__malloc__));

/**Make a header structure http_allow_t.
 *
 * The function http_allow_make() makes a new
 * http_allow_t header structure.  It allocates a new
 * header structure, and decodes the string @a s as the
 * value of the structure.
 *
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 *
 * @note This function is usually implemented as a macro calling
 * http_header_make().
 *
 * @return
 * The function http_allow_make() returns a pointer to
 * newly maked http_allow_t header structure, or NULL upon
 * an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_allow_t *http_allow_make(su_home_t *home, char const *s)
     __attribute__((__malloc__));

/**Make a Allow header from formatting result.
 *
 * The function http_allow_format() makes a new
 * Allow header object using formatting result as its
 * value.  The function first prints the arguments according to
 * the format @a fmt specified.  Then it allocates a new header
 * structure, and uses the formatting result as the header
 * value.
 *
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 *
 * @note This function is usually implemented as a macro calling
 * msg_header_format().
 *
 * @return
 * The function http_allow_format() returns a pointer to newly
 * makes header structure, or NULL upon an error.
 *
 * @HIDE
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_allow_t *http_allow_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__malloc__, __format__ (printf, 2, 3)));


/* Inlined functions */
#if SU_HAVE_INLINE
su_inline
http_allow_t *http_allow_format(su_home_t *home, char const *fmt, ...)
{
  http_header_t *h;
  va_list ap;

  va_start(ap, fmt);
  h = http_header_vformat(home, http_allow_class, fmt, ap);
  va_end(ap);

  return (http_allow_t *)h;
}

su_inline
http_allow_t *http_allow_dup(su_home_t *home, http_allow_t const *o)
{
  return (http_allow_t *)
    msg_header_dup_as(home, http_allow_class, (msg_header_t const *)o);
}

su_inline
http_allow_t *http_allow_copy(su_home_t *home, http_allow_t const *o)
{
  return (http_allow_t *)
    msg_header_copy_as(home, http_allow_class, (msg_header_t const *)o);
}

su_inline
http_allow_t *http_allow_make(su_home_t *home, char const *s)
{
  return (http_allow_t *)http_header_make(home, http_allow_class, s);
}
#endif

#endif /* !define HTTP_HCLASSES_ONLY */

/** @} */


/* Declare internal prototypes for Authentication-Info header */

/**@addtogroup http_authentication_info*/ /** @{ */

enum {
  /** Hash of Authentication-Info header. @internal*/
  http_authentication_info_hash = 20849
};

/**Header class for HTTP Authentication-Info header.
 *
 * The header class http_authentication_info_class defines how a HTTP
 * Authentication-Info header is parsed and printed.  It also
 * contains methods used by HTTP parser and other functions
 * to manipulate the http_authentication_info_t header structure.
 *
 */
SOFIAPUBVAR msg_hclass_t http_authentication_info_class[];

#ifndef HTTP_HCLASSES_ONLY

/** Decode (parse) a Authentication-Info header. @internal */
SOFIAPUBFUN msg_parse_f http_authentication_info_d;

/** Encode (print) a Authentication-Info header. @internal */
SOFIAPUBFUN msg_print_f http_authentication_info_e;

/**Initializer for structure http_authentication_info_t.
 *
 * A static http_authentication_info_t structure must be initialized
 * with the HTTP_AUTHENTICATION_INFO_INIT() macro. For instance,
 * @code
 *
 *  http_authentication_info_t http_authentication_info = HTTP_AUTHENTICATION_INFO_INIT;
 *
 * @endcode
 * @HI
 */
#define HTTP_AUTHENTICATION_INFO_INIT() HTTP_HDR_INIT(authentication_info)

/**Initialize a structure http_authentication_info_t.
 *
 * An http_authentication_info_t structure can be initialized with the
 * http_authentication_info_init() function/macro. For instance,
 * @code
 *
 *  http_authentication_info_t http_authentication_info;
 *
 *  http_authentication_info_init(&http_authentication_info);
 *
 * @endcode
 * @HI
 */
#if SU_HAVE_INLINE
su_inline http_authentication_info_t *http_authentication_info_init(http_authentication_info_t x[1])
{
  return HTTP_HEADER_INIT(x, http_authentication_info_class, sizeof(http_authentication_info_t));
}
#else
#define http_authentication_info_init(x) \
  HTTP_HEADER_INIT(x, http_authentication_info_class, sizeof(http_authentication_info_t))
#endif

/**Test if header object is instance of http_authentication_info_t.
 *
 * The function http_is_authentication_info() returns true (nonzero) if
 * the header class is an instance of Authentication-Info header
 * object and false (zero) otherwise.
 *
 * @param header pointer to the header structure to be tested
 *
 * @return
 * The function http_is_xauthentication_info() returns true (nonzero) if
 * the header object is an instance of header authentication_info and
 * false (zero) otherwise.
 */
#if SU_HAVE_INLINE
su_inline
int http_is_authentication_info(http_header_t const *header)
{
  return header && header->sh_class->hc_hash == http_authentication_info_hash;
}
#else
#define http_is_authentication_info(h) \
 ((h) && ((msg_common_t *)(h))->h_class->hc_hash == http_authentication_info_hash)
#endif

/**Duplicate (deep copy) @c http_authentication_info_t.
 *
 * The function http_authentication_info_dup() duplicates a header
 * structure @a hdr.  If the header structure @a hdr
 * contains a reference (@c hdr->x_next) to a list of
 * headers, all the headers in the list are duplicated, too.
 *
 * @param home  memory home used to allocate new structure
 * @param hdr   header structure to be duplicated
 *
 * When duplicating, all parameter lists and non-constant
 * strings attached to the header are copied, too.  The
 * function uses given memory @a home to allocate all the
 * memory areas used to copy the header.
 *
 * @par Example
 * @code
 *
 *   authentication_info = http_authentication_info_dup(home, http->http_authentication_info);
 *
 * @endcode
 *
 * @return
 * The function http_authentication_info_dup() returns a pointer to the
 * newly duplicated http_authentication_info_t header structure, or NULL
 * upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_authentication_info_t *http_authentication_info_dup(su_home_t *home,
				   http_authentication_info_t const *hdr)
     __attribute__((__malloc__));

/**Copy a http_authentication_info_t header structure.
 *
 * The function http_authentication_info_copy() copies a header structure @a
 * hdr.  If the header structure @a hdr contains a reference (@c
 * hdr->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home
 * to allocate all the memory areas used to copy the header
 * structure @a hdr.
 *
 * @param home    memory home used to allocate new structure
 * @param hdr     pointer to the header structure to be duplicated
 *
 * When copying, only the header structure and parameter lists
 * attached to it are duplicated.  The new header structure
 * retains all the references to the strings within the old @a
 * header, including the encoding of the old header, if present.
 *
 * @par Example
 * @code
 *
 *   authentication_info = http_authentication_info_copy(home, http->http_authentication_info);
 *
 * @endcode
 *
 * @return
 * The function http_authentication_info_copy() returns a pointer to
 * newly copied header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_authentication_info_t *http_authentication_info_copy(su_home_t *home,
				    http_authentication_info_t const *hdr)
     __attribute__((__malloc__));

/**Make a header structure http_authentication_info_t.
 *
 * The function http_authentication_info_make() makes a new
 * http_authentication_info_t header structure.  It allocates a new
 * header structure, and decodes the string @a s as the
 * value of the structure.
 *
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 *
 * @note This function is usually implemented as a macro calling
 * http_header_make().
 *
 * @return
 * The function http_authentication_info_make() returns a pointer to
 * newly maked http_authentication_info_t header structure, or NULL upon
 * an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_authentication_info_t *http_authentication_info_make(su_home_t *home, char const *s)
     __attribute__((__malloc__));

/**Make a Authentication-Info header from formatting result.
 *
 * The function http_authentication_info_format() makes a new
 * Authentication-Info header object using formatting result as its
 * value.  The function first prints the arguments according to
 * the format @a fmt specified.  Then it allocates a new header
 * structure, and uses the formatting result as the header
 * value.
 *
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 *
 * @note This function is usually implemented as a macro calling
 * msg_header_format().
 *
 * @return
 * The function http_authentication_info_format() returns a pointer to newly
 * makes header structure, or NULL upon an error.
 *
 * @HIDE
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_authentication_info_t *http_authentication_info_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__malloc__, __format__ (printf, 2, 3)));


/* Inlined functions */
#if SU_HAVE_INLINE
su_inline
http_authentication_info_t *http_authentication_info_format(su_home_t *home, char const *fmt, ...)
{
  http_header_t *h;
  va_list ap;

  va_start(ap, fmt);
  h = http_header_vformat(home, http_authentication_info_class, fmt, ap);
  va_end(ap);

  return (http_authentication_info_t *)h;
}

su_inline
http_authentication_info_t *http_authentication_info_dup(su_home_t *home, http_authentication_info_t const *o)
{
  return (http_authentication_info_t *)
    msg_header_dup_as(home, http_authentication_info_class, (msg_header_t const *)o);
}

su_inline
http_authentication_info_t *http_authentication_info_copy(su_home_t *home, http_authentication_info_t const *o)
{
  return (http_authentication_info_t *)
    msg_header_copy_as(home, http_authentication_info_class, (msg_header_t const *)o);
}

su_inline
http_authentication_info_t *http_authentication_info_make(su_home_t *home, char const *s)
{
  return (http_authentication_info_t *)http_header_make(home, http_authentication_info_class, s);
}
#endif

#endif /* !define HTTP_HCLASSES_ONLY */

/** @} */


/* Declare internal prototypes for Authorization header */

/**@addtogroup http_authorization*/ /** @{ */

enum {
  /** Hash of Authorization header. @internal*/
  http_authorization_hash = 36397
};

/**Header class for HTTP Authorization header.
 *
 * The header class http_authorization_class defines how a HTTP
 * Authorization header is parsed and printed.  It also
 * contains methods used by HTTP parser and other functions
 * to manipulate the http_authorization_t header structure.
 *
 */
SOFIAPUBVAR msg_hclass_t http_authorization_class[];

#ifndef HTTP_HCLASSES_ONLY

/** Decode (parse) a Authorization header. @internal */
SOFIAPUBFUN msg_parse_f http_authorization_d;

/** Encode (print) a Authorization header. @internal */
SOFIAPUBFUN msg_print_f http_authorization_e;

/**Initializer for structure http_authorization_t.
 *
 * A static http_authorization_t structure must be initialized
 * with the HTTP_AUTHORIZATION_INIT() macro. For instance,
 * @code
 *
 *  http_authorization_t http_authorization = HTTP_AUTHORIZATION_INIT;
 *
 * @endcode
 * @HI
 */
#define HTTP_AUTHORIZATION_INIT() HTTP_HDR_INIT(authorization)

/**Initialize a structure http_authorization_t.
 *
 * An http_authorization_t structure can be initialized with the
 * http_authorization_init() function/macro. For instance,
 * @code
 *
 *  http_authorization_t http_authorization;
 *
 *  http_authorization_init(&http_authorization);
 *
 * @endcode
 * @HI
 */
#if SU_HAVE_INLINE
su_inline http_authorization_t *http_authorization_init(http_authorization_t x[1])
{
  return HTTP_HEADER_INIT(x, http_authorization_class, sizeof(http_authorization_t));
}
#else
#define http_authorization_init(x) \
  HTTP_HEADER_INIT(x, http_authorization_class, sizeof(http_authorization_t))
#endif

/**Test if header object is instance of http_authorization_t.
 *
 * The function http_is_authorization() returns true (nonzero) if
 * the header class is an instance of Authorization header
 * object and false (zero) otherwise.
 *
 * @param header pointer to the header structure to be tested
 *
 * @return
 * The function http_is_xauthorization() returns true (nonzero) if
 * the header object is an instance of header authorization and
 * false (zero) otherwise.
 */
#if SU_HAVE_INLINE
su_inline
int http_is_authorization(http_header_t const *header)
{
  return header && header->sh_class->hc_hash == http_authorization_hash;
}
#else
#define http_is_authorization(h) \
 ((h) && ((msg_common_t *)(h))->h_class->hc_hash == http_authorization_hash)
#endif

/**Duplicate (deep copy) @c http_authorization_t.
 *
 * The function http_authorization_dup() duplicates a header
 * structure @a hdr.  If the header structure @a hdr
 * contains a reference (@c hdr->x_next) to a list of
 * headers, all the headers in the list are duplicated, too.
 *
 * @param home  memory home used to allocate new structure
 * @param hdr   header structure to be duplicated
 *
 * When duplicating, all parameter lists and non-constant
 * strings attached to the header are copied, too.  The
 * function uses given memory @a home to allocate all the
 * memory areas used to copy the header.
 *
 * @par Example
 * @code
 *
 *   authorization = http_authorization_dup(home, http->http_authorization);
 *
 * @endcode
 *
 * @return
 * The function http_authorization_dup() returns a pointer to the
 * newly duplicated http_authorization_t header structure, or NULL
 * upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_authorization_t *http_authorization_dup(su_home_t *home,
				   http_authorization_t const *hdr)
     __attribute__((__malloc__));

/**Copy a http_authorization_t header structure.
 *
 * The function http_authorization_copy() copies a header structure @a
 * hdr.  If the header structure @a hdr contains a reference (@c
 * hdr->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home
 * to allocate all the memory areas used to copy the header
 * structure @a hdr.
 *
 * @param home    memory home used to allocate new structure
 * @param hdr     pointer to the header structure to be duplicated
 *
 * When copying, only the header structure and parameter lists
 * attached to it are duplicated.  The new header structure
 * retains all the references to the strings within the old @a
 * header, including the encoding of the old header, if present.
 *
 * @par Example
 * @code
 *
 *   authorization = http_authorization_copy(home, http->http_authorization);
 *
 * @endcode
 *
 * @return
 * The function http_authorization_copy() returns a pointer to
 * newly copied header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_authorization_t *http_authorization_copy(su_home_t *home,
				    http_authorization_t const *hdr)
     __attribute__((__malloc__));

/**Make a header structure http_authorization_t.
 *
 * The function http_authorization_make() makes a new
 * http_authorization_t header structure.  It allocates a new
 * header structure, and decodes the string @a s as the
 * value of the structure.
 *
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 *
 * @note This function is usually implemented as a macro calling
 * http_header_make().
 *
 * @return
 * The function http_authorization_make() returns a pointer to
 * newly maked http_authorization_t header structure, or NULL upon
 * an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_authorization_t *http_authorization_make(su_home_t *home, char const *s)
     __attribute__((__malloc__));

/**Make a Authorization header from formatting result.
 *
 * The function http_authorization_format() makes a new
 * Authorization header object using formatting result as its
 * value.  The function first prints the arguments according to
 * the format @a fmt specified.  Then it allocates a new header
 * structure, and uses the formatting result as the header
 * value.
 *
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 *
 * @note This function is usually implemented as a macro calling
 * msg_header_format().
 *
 * @return
 * The function http_authorization_format() returns a pointer to newly
 * makes header structure, or NULL upon an error.
 *
 * @HIDE
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_authorization_t *http_authorization_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__malloc__, __format__ (printf, 2, 3)));


/* Inlined functions */
#if SU_HAVE_INLINE
su_inline
http_authorization_t *http_authorization_format(su_home_t *home, char const *fmt, ...)
{
  http_header_t *h;
  va_list ap;

  va_start(ap, fmt);
  h = http_header_vformat(home, http_authorization_class, fmt, ap);
  va_end(ap);

  return (http_authorization_t *)h;
}

su_inline
http_authorization_t *http_authorization_dup(su_home_t *home, http_authorization_t const *o)
{
  return (http_authorization_t *)
    msg_header_dup_as(home, http_authorization_class, (msg_header_t const *)o);
}

su_inline
http_authorization_t *http_authorization_copy(su_home_t *home, http_authorization_t const *o)
{
  return (http_authorization_t *)
    msg_header_copy_as(home, http_authorization_class, (msg_header_t const *)o);
}

su_inline
http_authorization_t *http_authorization_make(su_home_t *home, char const *s)
{
  return (http_authorization_t *)http_header_make(home, http_authorization_class, s);
}
#endif

#endif /* !define HTTP_HCLASSES_ONLY */

/** @} */


/* Declare internal prototypes for Age header */

/**@addtogroup http_age*/ /** @{ */

enum {
  /** Hash of Age header. @internal*/
  http_age_hash = 34725
};

/**Header class for HTTP Age header.
 *
 * The header class http_age_class defines how a HTTP
 * Age header is parsed and printed.  It also
 * contains methods used by HTTP parser and other functions
 * to manipulate the http_age_t header structure.
 *
 */
SOFIAPUBVAR msg_hclass_t http_age_class[];

#ifndef HTTP_HCLASSES_ONLY

/** Decode (parse) a Age header. @internal */
SOFIAPUBFUN msg_parse_f http_age_d;

/** Encode (print) a Age header. @internal */
SOFIAPUBFUN msg_print_f http_age_e;

/**Initializer for structure http_age_t.
 *
 * A static http_age_t structure must be initialized
 * with the HTTP_AGE_INIT() macro. For instance,
 * @code
 *
 *  http_age_t http_age = HTTP_AGE_INIT;
 *
 * @endcode
 * @HI
 */
#define HTTP_AGE_INIT() HTTP_HDR_INIT(age)

/**Initialize a structure http_age_t.
 *
 * An http_age_t structure can be initialized with the
 * http_age_init() function/macro. For instance,
 * @code
 *
 *  http_age_t http_age;
 *
 *  http_age_init(&http_age);
 *
 * @endcode
 * @HI
 */
#if SU_HAVE_INLINE
su_inline http_age_t *http_age_init(http_age_t x[1])
{
  return HTTP_HEADER_INIT(x, http_age_class, sizeof(http_age_t));
}
#else
#define http_age_init(x) \
  HTTP_HEADER_INIT(x, http_age_class, sizeof(http_age_t))
#endif

/**Test if header object is instance of http_age_t.
 *
 * The function http_is_age() returns true (nonzero) if
 * the header class is an instance of Age header
 * object and false (zero) otherwise.
 *
 * @param header pointer to the header structure to be tested
 *
 * @return
 * The function http_is_xage() returns true (nonzero) if
 * the header object is an instance of header age and
 * false (zero) otherwise.
 */
#if SU_HAVE_INLINE
su_inline
int http_is_age(http_header_t const *header)
{
  return header && header->sh_class->hc_hash == http_age_hash;
}
#else
#define http_is_age(h) \
 ((h) && ((msg_common_t *)(h))->h_class->hc_hash == http_age_hash)
#endif

/**Duplicate (deep copy) @c http_age_t.
 *
 * The function http_age_dup() duplicates a header
 * structure @a hdr.  If the header structure @a hdr
 * contains a reference (@c hdr->x_next) to a list of
 * headers, all the headers in the list are duplicated, too.
 *
 * @param home  memory home used to allocate new structure
 * @param hdr   header structure to be duplicated
 *
 * When duplicating, all parameter lists and non-constant
 * strings attached to the header are copied, too.  The
 * function uses given memory @a home to allocate all the
 * memory areas used to copy the header.
 *
 * @par Example
 * @code
 *
 *   age = http_age_dup(home, http->http_age);
 *
 * @endcode
 *
 * @return
 * The function http_age_dup() returns a pointer to the
 * newly duplicated http_age_t header structure, or NULL
 * upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_age_t *http_age_dup(su_home_t *home,
				   http_age_t const *hdr)
     __attribute__((__malloc__));

/**Copy a http_age_t header structure.
 *
 * The function http_age_copy() copies a header structure @a
 * hdr.  If the header structure @a hdr contains a reference (@c
 * hdr->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home
 * to allocate all the memory areas used to copy the header
 * structure @a hdr.
 *
 * @param home    memory home used to allocate new structure
 * @param hdr     pointer to the header structure to be duplicated
 *
 * When copying, only the header structure and parameter lists
 * attached to it are duplicated.  The new header structure
 * retains all the references to the strings within the old @a
 * header, including the encoding of the old header, if present.
 *
 * @par Example
 * @code
 *
 *   age = http_age_copy(home, http->http_age);
 *
 * @endcode
 *
 * @return
 * The function http_age_copy() returns a pointer to
 * newly copied header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_age_t *http_age_copy(su_home_t *home,
				    http_age_t const *hdr)
     __attribute__((__malloc__));

/**Make a header structure http_age_t.
 *
 * The function http_age_make() makes a new
 * http_age_t header structure.  It allocates a new
 * header structure, and decodes the string @a s as the
 * value of the structure.
 *
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 *
 * @note This function is usually implemented as a macro calling
 * http_header_make().
 *
 * @return
 * The function http_age_make() returns a pointer to
 * newly maked http_age_t header structure, or NULL upon
 * an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_age_t *http_age_make(su_home_t *home, char const *s)
     __attribute__((__malloc__));

/**Make a Age header from formatting result.
 *
 * The function http_age_format() makes a new
 * Age header object using formatting result as its
 * value.  The function first prints the arguments according to
 * the format @a fmt specified.  Then it allocates a new header
 * structure, and uses the formatting result as the header
 * value.
 *
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 *
 * @note This function is usually implemented as a macro calling
 * msg_header_format().
 *
 * @return
 * The function http_age_format() returns a pointer to newly
 * makes header structure, or NULL upon an error.
 *
 * @HIDE
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_age_t *http_age_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__malloc__, __format__ (printf, 2, 3)));


/* Inlined functions */
#if SU_HAVE_INLINE
su_inline
http_age_t *http_age_format(su_home_t *home, char const *fmt, ...)
{
  http_header_t *h;
  va_list ap;

  va_start(ap, fmt);
  h = http_header_vformat(home, http_age_class, fmt, ap);
  va_end(ap);

  return (http_age_t *)h;
}

su_inline
http_age_t *http_age_dup(su_home_t *home, http_age_t const *o)
{
  return (http_age_t *)
    msg_header_dup_as(home, http_age_class, (msg_header_t const *)o);
}

su_inline
http_age_t *http_age_copy(su_home_t *home, http_age_t const *o)
{
  return (http_age_t *)
    msg_header_copy_as(home, http_age_class, (msg_header_t const *)o);
}

su_inline
http_age_t *http_age_make(su_home_t *home, char const *s)
{
  return (http_age_t *)http_header_make(home, http_age_class, s);
}
#endif

#endif /* !define HTTP_HCLASSES_ONLY */

/** @} */


/* Declare internal prototypes for Cache-Control header */

/**@addtogroup http_cache_control*/ /** @{ */

enum {
  /** Hash of Cache-Control header. @internal*/
  http_cache_control_hash = 48250
};

/**Header class for HTTP Cache-Control header.
 *
 * The header class http_cache_control_class defines how a HTTP
 * Cache-Control header is parsed and printed.  It also
 * contains methods used by HTTP parser and other functions
 * to manipulate the http_cache_control_t header structure.
 *
 */
SOFIAPUBVAR msg_hclass_t http_cache_control_class[];

#ifndef HTTP_HCLASSES_ONLY

/** Decode (parse) a Cache-Control header. @internal */
SOFIAPUBFUN msg_parse_f http_cache_control_d;

/** Encode (print) a Cache-Control header. @internal */
SOFIAPUBFUN msg_print_f http_cache_control_e;

/**Initializer for structure http_cache_control_t.
 *
 * A static http_cache_control_t structure must be initialized
 * with the HTTP_CACHE_CONTROL_INIT() macro. For instance,
 * @code
 *
 *  http_cache_control_t http_cache_control = HTTP_CACHE_CONTROL_INIT;
 *
 * @endcode
 * @HI
 */
#define HTTP_CACHE_CONTROL_INIT() HTTP_HDR_INIT(cache_control)

/**Initialize a structure http_cache_control_t.
 *
 * An http_cache_control_t structure can be initialized with the
 * http_cache_control_init() function/macro. For instance,
 * @code
 *
 *  http_cache_control_t http_cache_control;
 *
 *  http_cache_control_init(&http_cache_control);
 *
 * @endcode
 * @HI
 */
#if SU_HAVE_INLINE
su_inline http_cache_control_t *http_cache_control_init(http_cache_control_t x[1])
{
  return HTTP_HEADER_INIT(x, http_cache_control_class, sizeof(http_cache_control_t));
}
#else
#define http_cache_control_init(x) \
  HTTP_HEADER_INIT(x, http_cache_control_class, sizeof(http_cache_control_t))
#endif

/**Test if header object is instance of http_cache_control_t.
 *
 * The function http_is_cache_control() returns true (nonzero) if
 * the header class is an instance of Cache-Control header
 * object and false (zero) otherwise.
 *
 * @param header pointer to the header structure to be tested
 *
 * @return
 * The function http_is_xcache_control() returns true (nonzero) if
 * the header object is an instance of header cache_control and
 * false (zero) otherwise.
 */
#if SU_HAVE_INLINE
su_inline
int http_is_cache_control(http_header_t const *header)
{
  return header && header->sh_class->hc_hash == http_cache_control_hash;
}
#else
#define http_is_cache_control(h) \
 ((h) && ((msg_common_t *)(h))->h_class->hc_hash == http_cache_control_hash)
#endif

/**Duplicate (deep copy) @c http_cache_control_t.
 *
 * The function http_cache_control_dup() duplicates a header
 * structure @a hdr.  If the header structure @a hdr
 * contains a reference (@c hdr->x_next) to a list of
 * headers, all the headers in the list are duplicated, too.
 *
 * @param home  memory home used to allocate new structure
 * @param hdr   header structure to be duplicated
 *
 * When duplicating, all parameter lists and non-constant
 * strings attached to the header are copied, too.  The
 * function uses given memory @a home to allocate all the
 * memory areas used to copy the header.
 *
 * @par Example
 * @code
 *
 *   cache_control = http_cache_control_dup(home, http->http_cache_control);
 *
 * @endcode
 *
 * @return
 * The function http_cache_control_dup() returns a pointer to the
 * newly duplicated http_cache_control_t header structure, or NULL
 * upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_cache_control_t *http_cache_control_dup(su_home_t *home,
				   http_cache_control_t const *hdr)
     __attribute__((__malloc__));

/**Copy a http_cache_control_t header structure.
 *
 * The function http_cache_control_copy() copies a header structure @a
 * hdr.  If the header structure @a hdr contains a reference (@c
 * hdr->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home
 * to allocate all the memory areas used to copy the header
 * structure @a hdr.
 *
 * @param home    memory home used to allocate new structure
 * @param hdr     pointer to the header structure to be duplicated
 *
 * When copying, only the header structure and parameter lists
 * attached to it are duplicated.  The new header structure
 * retains all the references to the strings within the old @a
 * header, including the encoding of the old header, if present.
 *
 * @par Example
 * @code
 *
 *   cache_control = http_cache_control_copy(home, http->http_cache_control);
 *
 * @endcode
 *
 * @return
 * The function http_cache_control_copy() returns a pointer to
 * newly copied header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_cache_control_t *http_cache_control_copy(su_home_t *home,
				    http_cache_control_t const *hdr)
     __attribute__((__malloc__));

/**Make a header structure http_cache_control_t.
 *
 * The function http_cache_control_make() makes a new
 * http_cache_control_t header structure.  It allocates a new
 * header structure, and decodes the string @a s as the
 * value of the structure.
 *
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 *
 * @note This function is usually implemented as a macro calling
 * http_header_make().
 *
 * @return
 * The function http_cache_control_make() returns a pointer to
 * newly maked http_cache_control_t header structure, or NULL upon
 * an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_cache_control_t *http_cache_control_make(su_home_t *home, char const *s)
     __attribute__((__malloc__));

/**Make a Cache-Control header from formatting result.
 *
 * The function http_cache_control_format() makes a new
 * Cache-Control header object using formatting result as its
 * value.  The function first prints the arguments according to
 * the format @a fmt specified.  Then it allocates a new header
 * structure, and uses the formatting result as the header
 * value.
 *
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 *
 * @note This function is usually implemented as a macro calling
 * msg_header_format().
 *
 * @return
 * The function http_cache_control_format() returns a pointer to newly
 * makes header structure, or NULL upon an error.
 *
 * @HIDE
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_cache_control_t *http_cache_control_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__malloc__, __format__ (printf, 2, 3)));


/* Inlined functions */
#if SU_HAVE_INLINE
su_inline
http_cache_control_t *http_cache_control_format(su_home_t *home, char const *fmt, ...)
{
  http_header_t *h;
  va_list ap;

  va_start(ap, fmt);
  h = http_header_vformat(home, http_cache_control_class, fmt, ap);
  va_end(ap);

  return (http_cache_control_t *)h;
}

su_inline
http_cache_control_t *http_cache_control_dup(su_home_t *home, http_cache_control_t const *o)
{
  return (http_cache_control_t *)
    msg_header_dup_as(home, http_cache_control_class, (msg_header_t const *)o);
}

su_inline
http_cache_control_t *http_cache_control_copy(su_home_t *home, http_cache_control_t const *o)
{
  return (http_cache_control_t *)
    msg_header_copy_as(home, http_cache_control_class, (msg_header_t const *)o);
}

su_inline
http_cache_control_t *http_cache_control_make(su_home_t *home, char const *s)
{
  return (http_cache_control_t *)http_header_make(home, http_cache_control_class, s);
}
#endif

#endif /* !define HTTP_HCLASSES_ONLY */

/** @} */


/* Declare internal prototypes for Connection header */

/**@addtogroup http_connection*/ /** @{ */

enum {
  /** Hash of Connection header. @internal*/
  http_connection_hash = 32700
};

/**Header class for HTTP Connection header.
 *
 * The header class http_connection_class defines how a HTTP
 * Connection header is parsed and printed.  It also
 * contains methods used by HTTP parser and other functions
 * to manipulate the http_connection_t header structure.
 *
 */
SOFIAPUBVAR msg_hclass_t http_connection_class[];

#ifndef HTTP_HCLASSES_ONLY

/** Decode (parse) a Connection header. @internal */
SOFIAPUBFUN msg_parse_f http_connection_d;

/** Encode (print) a Connection header. @internal */
SOFIAPUBFUN msg_print_f http_connection_e;

/**Initializer for structure http_connection_t.
 *
 * A static http_connection_t structure must be initialized
 * with the HTTP_CONNECTION_INIT() macro. For instance,
 * @code
 *
 *  http_connection_t http_connection = HTTP_CONNECTION_INIT;
 *
 * @endcode
 * @HI
 */
#define HTTP_CONNECTION_INIT() HTTP_HDR_INIT(connection)

/**Initialize a structure http_connection_t.
 *
 * An http_connection_t structure can be initialized with the
 * http_connection_init() function/macro. For instance,
 * @code
 *
 *  http_connection_t http_connection;
 *
 *  http_connection_init(&http_connection);
 *
 * @endcode
 * @HI
 */
#if SU_HAVE_INLINE
su_inline http_connection_t *http_connection_init(http_connection_t x[1])
{
  return HTTP_HEADER_INIT(x, http_connection_class, sizeof(http_connection_t));
}
#else
#define http_connection_init(x) \
  HTTP_HEADER_INIT(x, http_connection_class, sizeof(http_connection_t))
#endif

/**Test if header object is instance of http_connection_t.
 *
 * The function http_is_connection() returns true (nonzero) if
 * the header class is an instance of Connection header
 * object and false (zero) otherwise.
 *
 * @param header pointer to the header structure to be tested
 *
 * @return
 * The function http_is_xconnection() returns true (nonzero) if
 * the header object is an instance of header connection and
 * false (zero) otherwise.
 */
#if SU_HAVE_INLINE
su_inline
int http_is_connection(http_header_t const *header)
{
  return header && header->sh_class->hc_hash == http_connection_hash;
}
#else
#define http_is_connection(h) \
 ((h) && ((msg_common_t *)(h))->h_class->hc_hash == http_connection_hash)
#endif

/**Duplicate (deep copy) @c http_connection_t.
 *
 * The function http_connection_dup() duplicates a header
 * structure @a hdr.  If the header structure @a hdr
 * contains a reference (@c hdr->x_next) to a list of
 * headers, all the headers in the list are duplicated, too.
 *
 * @param home  memory home used to allocate new structure
 * @param hdr   header structure to be duplicated
 *
 * When duplicating, all parameter lists and non-constant
 * strings attached to the header are copied, too.  The
 * function uses given memory @a home to allocate all the
 * memory areas used to copy the header.
 *
 * @par Example
 * @code
 *
 *   connection = http_connection_dup(home, http->http_connection);
 *
 * @endcode
 *
 * @return
 * The function http_connection_dup() returns a pointer to the
 * newly duplicated http_connection_t header structure, or NULL
 * upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_connection_t *http_connection_dup(su_home_t *home,
				   http_connection_t const *hdr)
     __attribute__((__malloc__));

/**Copy a http_connection_t header structure.
 *
 * The function http_connection_copy() copies a header structure @a
 * hdr.  If the header structure @a hdr contains a reference (@c
 * hdr->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home
 * to allocate all the memory areas used to copy the header
 * structure @a hdr.
 *
 * @param home    memory home used to allocate new structure
 * @param hdr     pointer to the header structure to be duplicated
 *
 * When copying, only the header structure and parameter lists
 * attached to it are duplicated.  The new header structure
 * retains all the references to the strings within the old @a
 * header, including the encoding of the old header, if present.
 *
 * @par Example
 * @code
 *
 *   connection = http_connection_copy(home, http->http_connection);
 *
 * @endcode
 *
 * @return
 * The function http_connection_copy() returns a pointer to
 * newly copied header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_connection_t *http_connection_copy(su_home_t *home,
				    http_connection_t const *hdr)
     __attribute__((__malloc__));

/**Make a header structure http_connection_t.
 *
 * The function http_connection_make() makes a new
 * http_connection_t header structure.  It allocates a new
 * header structure, and decodes the string @a s as the
 * value of the structure.
 *
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 *
 * @note This function is usually implemented as a macro calling
 * http_header_make().
 *
 * @return
 * The function http_connection_make() returns a pointer to
 * newly maked http_connection_t header structure, or NULL upon
 * an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_connection_t *http_connection_make(su_home_t *home, char const *s)
     __attribute__((__malloc__));

/**Make a Connection header from formatting result.
 *
 * The function http_connection_format() makes a new
 * Connection header object using formatting result as its
 * value.  The function first prints the arguments according to
 * the format @a fmt specified.  Then it allocates a new header
 * structure, and uses the formatting result as the header
 * value.
 *
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 *
 * @note This function is usually implemented as a macro calling
 * msg_header_format().
 *
 * @return
 * The function http_connection_format() returns a pointer to newly
 * makes header structure, or NULL upon an error.
 *
 * @HIDE
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_connection_t *http_connection_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__malloc__, __format__ (printf, 2, 3)));


/* Inlined functions */
#if SU_HAVE_INLINE
su_inline
http_connection_t *http_connection_format(su_home_t *home, char const *fmt, ...)
{
  http_header_t *h;
  va_list ap;

  va_start(ap, fmt);
  h = http_header_vformat(home, http_connection_class, fmt, ap);
  va_end(ap);

  return (http_connection_t *)h;
}

su_inline
http_connection_t *http_connection_dup(su_home_t *home, http_connection_t const *o)
{
  return (http_connection_t *)
    msg_header_dup_as(home, http_connection_class, (msg_header_t const *)o);
}

su_inline
http_connection_t *http_connection_copy(su_home_t *home, http_connection_t const *o)
{
  return (http_connection_t *)
    msg_header_copy_as(home, http_connection_class, (msg_header_t const *)o);
}

su_inline
http_connection_t *http_connection_make(su_home_t *home, char const *s)
{
  return (http_connection_t *)http_header_make(home, http_connection_class, s);
}
#endif

#endif /* !define HTTP_HCLASSES_ONLY */

/** @} */


/* Declare internal prototypes for Date header */

/**@addtogroup http_date*/ /** @{ */

enum {
  /** Hash of Date header. @internal*/
  http_date_hash = 43982
};

/**Header class for HTTP Date header.
 *
 * The header class http_date_class defines how a HTTP
 * Date header is parsed and printed.  It also
 * contains methods used by HTTP parser and other functions
 * to manipulate the http_date_t header structure.
 *
 */
SOFIAPUBVAR msg_hclass_t http_date_class[];

#ifndef HTTP_HCLASSES_ONLY

/** Decode (parse) a Date header. @internal */
SOFIAPUBFUN msg_parse_f http_date_d;

/** Encode (print) a Date header. @internal */
SOFIAPUBFUN msg_print_f http_date_e;

/**Initializer for structure http_date_t.
 *
 * A static http_date_t structure must be initialized
 * with the HTTP_DATE_INIT() macro. For instance,
 * @code
 *
 *  http_date_t http_date = HTTP_DATE_INIT;
 *
 * @endcode
 * @HI
 */
#define HTTP_DATE_INIT() HTTP_HDR_INIT(date)

/**Initialize a structure http_date_t.
 *
 * An http_date_t structure can be initialized with the
 * http_date_init() function/macro. For instance,
 * @code
 *
 *  http_date_t http_date;
 *
 *  http_date_init(&http_date);
 *
 * @endcode
 * @HI
 */
#if SU_HAVE_INLINE
su_inline http_date_t *http_date_init(http_date_t x[1])
{
  return HTTP_HEADER_INIT(x, http_date_class, sizeof(http_date_t));
}
#else
#define http_date_init(x) \
  HTTP_HEADER_INIT(x, http_date_class, sizeof(http_date_t))
#endif

/**Test if header object is instance of http_date_t.
 *
 * The function http_is_date() returns true (nonzero) if
 * the header class is an instance of Date header
 * object and false (zero) otherwise.
 *
 * @param header pointer to the header structure to be tested
 *
 * @return
 * The function http_is_xdate() returns true (nonzero) if
 * the header object is an instance of header date and
 * false (zero) otherwise.
 */
#if SU_HAVE_INLINE
su_inline
int http_is_date(http_header_t const *header)
{
  return header && header->sh_class->hc_hash == http_date_hash;
}
#else
#define http_is_date(h) \
 ((h) && ((msg_common_t *)(h))->h_class->hc_hash == http_date_hash)
#endif

/**Duplicate (deep copy) @c http_date_t.
 *
 * The function http_date_dup() duplicates a header
 * structure @a hdr.  If the header structure @a hdr
 * contains a reference (@c hdr->x_next) to a list of
 * headers, all the headers in the list are duplicated, too.
 *
 * @param home  memory home used to allocate new structure
 * @param hdr   header structure to be duplicated
 *
 * When duplicating, all parameter lists and non-constant
 * strings attached to the header are copied, too.  The
 * function uses given memory @a home to allocate all the
 * memory areas used to copy the header.
 *
 * @par Example
 * @code
 *
 *   date = http_date_dup(home, http->http_date);
 *
 * @endcode
 *
 * @return
 * The function http_date_dup() returns a pointer to the
 * newly duplicated http_date_t header structure, or NULL
 * upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_date_t *http_date_dup(su_home_t *home,
				   http_date_t const *hdr)
     __attribute__((__malloc__));

/**Copy a http_date_t header structure.
 *
 * The function http_date_copy() copies a header structure @a
 * hdr.  If the header structure @a hdr contains a reference (@c
 * hdr->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home
 * to allocate all the memory areas used to copy the header
 * structure @a hdr.
 *
 * @param home    memory home used to allocate new structure
 * @param hdr     pointer to the header structure to be duplicated
 *
 * When copying, only the header structure and parameter lists
 * attached to it are duplicated.  The new header structure
 * retains all the references to the strings within the old @a
 * header, including the encoding of the old header, if present.
 *
 * @par Example
 * @code
 *
 *   date = http_date_copy(home, http->http_date);
 *
 * @endcode
 *
 * @return
 * The function http_date_copy() returns a pointer to
 * newly copied header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_date_t *http_date_copy(su_home_t *home,
				    http_date_t const *hdr)
     __attribute__((__malloc__));

/**Make a header structure http_date_t.
 *
 * The function http_date_make() makes a new
 * http_date_t header structure.  It allocates a new
 * header structure, and decodes the string @a s as the
 * value of the structure.
 *
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 *
 * @note This function is usually implemented as a macro calling
 * http_header_make().
 *
 * @return
 * The function http_date_make() returns a pointer to
 * newly maked http_date_t header structure, or NULL upon
 * an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_date_t *http_date_make(su_home_t *home, char const *s)
     __attribute__((__malloc__));

/**Make a Date header from formatting result.
 *
 * The function http_date_format() makes a new
 * Date header object using formatting result as its
 * value.  The function first prints the arguments according to
 * the format @a fmt specified.  Then it allocates a new header
 * structure, and uses the formatting result as the header
 * value.
 *
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 *
 * @note This function is usually implemented as a macro calling
 * msg_header_format().
 *
 * @return
 * The function http_date_format() returns a pointer to newly
 * makes header structure, or NULL upon an error.
 *
 * @HIDE
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_date_t *http_date_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__malloc__, __format__ (printf, 2, 3)));


/* Inlined functions */
#if SU_HAVE_INLINE
su_inline
http_date_t *http_date_format(su_home_t *home, char const *fmt, ...)
{
  http_header_t *h;
  va_list ap;

  va_start(ap, fmt);
  h = http_header_vformat(home, http_date_class, fmt, ap);
  va_end(ap);

  return (http_date_t *)h;
}

su_inline
http_date_t *http_date_dup(su_home_t *home, http_date_t const *o)
{
  return (http_date_t *)
    msg_header_dup_as(home, http_date_class, (msg_header_t const *)o);
}

su_inline
http_date_t *http_date_copy(su_home_t *home, http_date_t const *o)
{
  return (http_date_t *)
    msg_header_copy_as(home, http_date_class, (msg_header_t const *)o);
}

su_inline
http_date_t *http_date_make(su_home_t *home, char const *s)
{
  return (http_date_t *)http_header_make(home, http_date_class, s);
}
#endif

#endif /* !define HTTP_HCLASSES_ONLY */

/** @} */


/* Declare internal prototypes for ETag header */

/**@addtogroup http_etag*/ /** @{ */

enum {
  /** Hash of ETag header. @internal*/
  http_etag_hash = 1813
};

/**Header class for HTTP ETag header.
 *
 * The header class http_etag_class defines how a HTTP
 * ETag header is parsed and printed.  It also
 * contains methods used by HTTP parser and other functions
 * to manipulate the http_etag_t header structure.
 *
 */
SOFIAPUBVAR msg_hclass_t http_etag_class[];

#ifndef HTTP_HCLASSES_ONLY

/** Decode (parse) a ETag header. @internal */
SOFIAPUBFUN msg_parse_f http_etag_d;

/** Encode (print) a ETag header. @internal */
SOFIAPUBFUN msg_print_f http_etag_e;

/**Initializer for structure http_etag_t.
 *
 * A static http_etag_t structure must be initialized
 * with the HTTP_ETAG_INIT() macro. For instance,
 * @code
 *
 *  http_etag_t http_etag = HTTP_ETAG_INIT;
 *
 * @endcode
 * @HI
 */
#define HTTP_ETAG_INIT() HTTP_HDR_INIT(etag)

/**Initialize a structure http_etag_t.
 *
 * An http_etag_t structure can be initialized with the
 * http_etag_init() function/macro. For instance,
 * @code
 *
 *  http_etag_t http_etag;
 *
 *  http_etag_init(&http_etag);
 *
 * @endcode
 * @HI
 */
#if SU_HAVE_INLINE
su_inline http_etag_t *http_etag_init(http_etag_t x[1])
{
  return HTTP_HEADER_INIT(x, http_etag_class, sizeof(http_etag_t));
}
#else
#define http_etag_init(x) \
  HTTP_HEADER_INIT(x, http_etag_class, sizeof(http_etag_t))
#endif

/**Test if header object is instance of http_etag_t.
 *
 * The function http_is_etag() returns true (nonzero) if
 * the header class is an instance of ETag header
 * object and false (zero) otherwise.
 *
 * @param header pointer to the header structure to be tested
 *
 * @return
 * The function http_is_xetag() returns true (nonzero) if
 * the header object is an instance of header etag and
 * false (zero) otherwise.
 */
#if SU_HAVE_INLINE
su_inline
int http_is_etag(http_header_t const *header)
{
  return header && header->sh_class->hc_hash == http_etag_hash;
}
#else
#define http_is_etag(h) \
 ((h) && ((msg_common_t *)(h))->h_class->hc_hash == http_etag_hash)
#endif

/**Duplicate (deep copy) @c http_etag_t.
 *
 * The function http_etag_dup() duplicates a header
 * structure @a hdr.  If the header structure @a hdr
 * contains a reference (@c hdr->x_next) to a list of
 * headers, all the headers in the list are duplicated, too.
 *
 * @param home  memory home used to allocate new structure
 * @param hdr   header structure to be duplicated
 *
 * When duplicating, all parameter lists and non-constant
 * strings attached to the header are copied, too.  The
 * function uses given memory @a home to allocate all the
 * memory areas used to copy the header.
 *
 * @par Example
 * @code
 *
 *   etag = http_etag_dup(home, http->http_etag);
 *
 * @endcode
 *
 * @return
 * The function http_etag_dup() returns a pointer to the
 * newly duplicated http_etag_t header structure, or NULL
 * upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_etag_t *http_etag_dup(su_home_t *home,
				   http_etag_t const *hdr)
     __attribute__((__malloc__));

/**Copy a http_etag_t header structure.
 *
 * The function http_etag_copy() copies a header structure @a
 * hdr.  If the header structure @a hdr contains a reference (@c
 * hdr->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home
 * to allocate all the memory areas used to copy the header
 * structure @a hdr.
 *
 * @param home    memory home used to allocate new structure
 * @param hdr     pointer to the header structure to be duplicated
 *
 * When copying, only the header structure and parameter lists
 * attached to it are duplicated.  The new header structure
 * retains all the references to the strings within the old @a
 * header, including the encoding of the old header, if present.
 *
 * @par Example
 * @code
 *
 *   etag = http_etag_copy(home, http->http_etag);
 *
 * @endcode
 *
 * @return
 * The function http_etag_copy() returns a pointer to
 * newly copied header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_etag_t *http_etag_copy(su_home_t *home,
				    http_etag_t const *hdr)
     __attribute__((__malloc__));

/**Make a header structure http_etag_t.
 *
 * The function http_etag_make() makes a new
 * http_etag_t header structure.  It allocates a new
 * header structure, and decodes the string @a s as the
 * value of the structure.
 *
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 *
 * @note This function is usually implemented as a macro calling
 * http_header_make().
 *
 * @return
 * The function http_etag_make() returns a pointer to
 * newly maked http_etag_t header structure, or NULL upon
 * an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_etag_t *http_etag_make(su_home_t *home, char const *s)
     __attribute__((__malloc__));

/**Make a ETag header from formatting result.
 *
 * The function http_etag_format() makes a new
 * ETag header object using formatting result as its
 * value.  The function first prints the arguments according to
 * the format @a fmt specified.  Then it allocates a new header
 * structure, and uses the formatting result as the header
 * value.
 *
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 *
 * @note This function is usually implemented as a macro calling
 * msg_header_format().
 *
 * @return
 * The function http_etag_format() returns a pointer to newly
 * makes header structure, or NULL upon an error.
 *
 * @HIDE
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_etag_t *http_etag_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__malloc__, __format__ (printf, 2, 3)));


/* Inlined functions */
#if SU_HAVE_INLINE
su_inline
http_etag_t *http_etag_format(su_home_t *home, char const *fmt, ...)
{
  http_header_t *h;
  va_list ap;

  va_start(ap, fmt);
  h = http_header_vformat(home, http_etag_class, fmt, ap);
  va_end(ap);

  return (http_etag_t *)h;
}

su_inline
http_etag_t *http_etag_dup(su_home_t *home, http_etag_t const *o)
{
  return (http_etag_t *)
    msg_header_dup_as(home, http_etag_class, (msg_header_t const *)o);
}

su_inline
http_etag_t *http_etag_copy(su_home_t *home, http_etag_t const *o)
{
  return (http_etag_t *)
    msg_header_copy_as(home, http_etag_class, (msg_header_t const *)o);
}

su_inline
http_etag_t *http_etag_make(su_home_t *home, char const *s)
{
  return (http_etag_t *)http_header_make(home, http_etag_class, s);
}
#endif

#endif /* !define HTTP_HCLASSES_ONLY */

/** @} */


/* Declare internal prototypes for Expect header */

/**@addtogroup http_expect*/ /** @{ */

enum {
  /** Hash of Expect header. @internal*/
  http_expect_hash = 30389
};

/**Header class for HTTP Expect header.
 *
 * The header class http_expect_class defines how a HTTP
 * Expect header is parsed and printed.  It also
 * contains methods used by HTTP parser and other functions
 * to manipulate the http_expect_t header structure.
 *
 */
SOFIAPUBVAR msg_hclass_t http_expect_class[];

#ifndef HTTP_HCLASSES_ONLY

/** Decode (parse) a Expect header. @internal */
SOFIAPUBFUN msg_parse_f http_expect_d;

/** Encode (print) a Expect header. @internal */
SOFIAPUBFUN msg_print_f http_expect_e;

/**Initializer for structure http_expect_t.
 *
 * A static http_expect_t structure must be initialized
 * with the HTTP_EXPECT_INIT() macro. For instance,
 * @code
 *
 *  http_expect_t http_expect = HTTP_EXPECT_INIT;
 *
 * @endcode
 * @HI
 */
#define HTTP_EXPECT_INIT() HTTP_HDR_INIT(expect)

/**Initialize a structure http_expect_t.
 *
 * An http_expect_t structure can be initialized with the
 * http_expect_init() function/macro. For instance,
 * @code
 *
 *  http_expect_t http_expect;
 *
 *  http_expect_init(&http_expect);
 *
 * @endcode
 * @HI
 */
#if SU_HAVE_INLINE
su_inline http_expect_t *http_expect_init(http_expect_t x[1])
{
  return HTTP_HEADER_INIT(x, http_expect_class, sizeof(http_expect_t));
}
#else
#define http_expect_init(x) \
  HTTP_HEADER_INIT(x, http_expect_class, sizeof(http_expect_t))
#endif

/**Test if header object is instance of http_expect_t.
 *
 * The function http_is_expect() returns true (nonzero) if
 * the header class is an instance of Expect header
 * object and false (zero) otherwise.
 *
 * @param header pointer to the header structure to be tested
 *
 * @return
 * The function http_is_xexpect() returns true (nonzero) if
 * the header object is an instance of header expect and
 * false (zero) otherwise.
 */
#if SU_HAVE_INLINE
su_inline
int http_is_expect(http_header_t const *header)
{
  return header && header->sh_class->hc_hash == http_expect_hash;
}
#else
#define http_is_expect(h) \
 ((h) && ((msg_common_t *)(h))->h_class->hc_hash == http_expect_hash)
#endif

/**Duplicate (deep copy) @c http_expect_t.
 *
 * The function http_expect_dup() duplicates a header
 * structure @a hdr.  If the header structure @a hdr
 * contains a reference (@c hdr->x_next) to a list of
 * headers, all the headers in the list are duplicated, too.
 *
 * @param home  memory home used to allocate new structure
 * @param hdr   header structure to be duplicated
 *
 * When duplicating, all parameter lists and non-constant
 * strings attached to the header are copied, too.  The
 * function uses given memory @a home to allocate all the
 * memory areas used to copy the header.
 *
 * @par Example
 * @code
 *
 *   expect = http_expect_dup(home, http->http_expect);
 *
 * @endcode
 *
 * @return
 * The function http_expect_dup() returns a pointer to the
 * newly duplicated http_expect_t header structure, or NULL
 * upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_expect_t *http_expect_dup(su_home_t *home,
				   http_expect_t const *hdr)
     __attribute__((__malloc__));

/**Copy a http_expect_t header structure.
 *
 * The function http_expect_copy() copies a header structure @a
 * hdr.  If the header structure @a hdr contains a reference (@c
 * hdr->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home
 * to allocate all the memory areas used to copy the header
 * structure @a hdr.
 *
 * @param home    memory home used to allocate new structure
 * @param hdr     pointer to the header structure to be duplicated
 *
 * When copying, only the header structure and parameter lists
 * attached to it are duplicated.  The new header structure
 * retains all the references to the strings within the old @a
 * header, including the encoding of the old header, if present.
 *
 * @par Example
 * @code
 *
 *   expect = http_expect_copy(home, http->http_expect);
 *
 * @endcode
 *
 * @return
 * The function http_expect_copy() returns a pointer to
 * newly copied header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_expect_t *http_expect_copy(su_home_t *home,
				    http_expect_t const *hdr)
     __attribute__((__malloc__));

/**Make a header structure http_expect_t.
 *
 * The function http_expect_make() makes a new
 * http_expect_t header structure.  It allocates a new
 * header structure, and decodes the string @a s as the
 * value of the structure.
 *
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 *
 * @note This function is usually implemented as a macro calling
 * http_header_make().
 *
 * @return
 * The function http_expect_make() returns a pointer to
 * newly maked http_expect_t header structure, or NULL upon
 * an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_expect_t *http_expect_make(su_home_t *home, char const *s)
     __attribute__((__malloc__));

/**Make a Expect header from formatting result.
 *
 * The function http_expect_format() makes a new
 * Expect header object using formatting result as its
 * value.  The function first prints the arguments according to
 * the format @a fmt specified.  Then it allocates a new header
 * structure, and uses the formatting result as the header
 * value.
 *
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 *
 * @note This function is usually implemented as a macro calling
 * msg_header_format().
 *
 * @return
 * The function http_expect_format() returns a pointer to newly
 * makes header structure, or NULL upon an error.
 *
 * @HIDE
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_expect_t *http_expect_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__malloc__, __format__ (printf, 2, 3)));


/* Inlined functions */
#if SU_HAVE_INLINE
su_inline
http_expect_t *http_expect_format(su_home_t *home, char const *fmt, ...)
{
  http_header_t *h;
  va_list ap;

  va_start(ap, fmt);
  h = http_header_vformat(home, http_expect_class, fmt, ap);
  va_end(ap);

  return (http_expect_t *)h;
}

su_inline
http_expect_t *http_expect_dup(su_home_t *home, http_expect_t const *o)
{
  return (http_expect_t *)
    msg_header_dup_as(home, http_expect_class, (msg_header_t const *)o);
}

su_inline
http_expect_t *http_expect_copy(su_home_t *home, http_expect_t const *o)
{
  return (http_expect_t *)
    msg_header_copy_as(home, http_expect_class, (msg_header_t const *)o);
}

su_inline
http_expect_t *http_expect_make(su_home_t *home, char const *s)
{
  return (http_expect_t *)http_header_make(home, http_expect_class, s);
}
#endif

#endif /* !define HTTP_HCLASSES_ONLY */

/** @} */


/* Declare internal prototypes for Expires header */

/**@addtogroup http_expires*/ /** @{ */

enum {
  /** Hash of Expires header. @internal*/
  http_expires_hash = 28680
};

/**Header class for HTTP Expires header.
 *
 * The header class http_expires_class defines how a HTTP
 * Expires header is parsed and printed.  It also
 * contains methods used by HTTP parser and other functions
 * to manipulate the http_expires_t header structure.
 *
 */
SOFIAPUBVAR msg_hclass_t http_expires_class[];

#ifndef HTTP_HCLASSES_ONLY

/** Decode (parse) a Expires header. @internal */
SOFIAPUBFUN msg_parse_f http_expires_d;

/** Encode (print) a Expires header. @internal */
SOFIAPUBFUN msg_print_f http_expires_e;

/**Initializer for structure http_expires_t.
 *
 * A static http_expires_t structure must be initialized
 * with the HTTP_EXPIRES_INIT() macro. For instance,
 * @code
 *
 *  http_expires_t http_expires = HTTP_EXPIRES_INIT;
 *
 * @endcode
 * @HI
 */
#define HTTP_EXPIRES_INIT() HTTP_HDR_INIT(expires)

/**Initialize a structure http_expires_t.
 *
 * An http_expires_t structure can be initialized with the
 * http_expires_init() function/macro. For instance,
 * @code
 *
 *  http_expires_t http_expires;
 *
 *  http_expires_init(&http_expires);
 *
 * @endcode
 * @HI
 */
#if SU_HAVE_INLINE
su_inline http_expires_t *http_expires_init(http_expires_t x[1])
{
  return HTTP_HEADER_INIT(x, http_expires_class, sizeof(http_expires_t));
}
#else
#define http_expires_init(x) \
  HTTP_HEADER_INIT(x, http_expires_class, sizeof(http_expires_t))
#endif

/**Test if header object is instance of http_expires_t.
 *
 * The function http_is_expires() returns true (nonzero) if
 * the header class is an instance of Expires header
 * object and false (zero) otherwise.
 *
 * @param header pointer to the header structure to be tested
 *
 * @return
 * The function http_is_xexpires() returns true (nonzero) if
 * the header object is an instance of header expires and
 * false (zero) otherwise.
 */
#if SU_HAVE_INLINE
su_inline
int http_is_expires(http_header_t const *header)
{
  return header && header->sh_class->hc_hash == http_expires_hash;
}
#else
#define http_is_expires(h) \
 ((h) && ((msg_common_t *)(h))->h_class->hc_hash == http_expires_hash)
#endif

/**Duplicate (deep copy) @c http_expires_t.
 *
 * The function http_expires_dup() duplicates a header
 * structure @a hdr.  If the header structure @a hdr
 * contains a reference (@c hdr->x_next) to a list of
 * headers, all the headers in the list are duplicated, too.
 *
 * @param home  memory home used to allocate new structure
 * @param hdr   header structure to be duplicated
 *
 * When duplicating, all parameter lists and non-constant
 * strings attached to the header are copied, too.  The
 * function uses given memory @a home to allocate all the
 * memory areas used to copy the header.
 *
 * @par Example
 * @code
 *
 *   expires = http_expires_dup(home, http->http_expires);
 *
 * @endcode
 *
 * @return
 * The function http_expires_dup() returns a pointer to the
 * newly duplicated http_expires_t header structure, or NULL
 * upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_expires_t *http_expires_dup(su_home_t *home,
				   http_expires_t const *hdr)
     __attribute__((__malloc__));

/**Copy a http_expires_t header structure.
 *
 * The function http_expires_copy() copies a header structure @a
 * hdr.  If the header structure @a hdr contains a reference (@c
 * hdr->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home
 * to allocate all the memory areas used to copy the header
 * structure @a hdr.
 *
 * @param home    memory home used to allocate new structure
 * @param hdr     pointer to the header structure to be duplicated
 *
 * When copying, only the header structure and parameter lists
 * attached to it are duplicated.  The new header structure
 * retains all the references to the strings within the old @a
 * header, including the encoding of the old header, if present.
 *
 * @par Example
 * @code
 *
 *   expires = http_expires_copy(home, http->http_expires);
 *
 * @endcode
 *
 * @return
 * The function http_expires_copy() returns a pointer to
 * newly copied header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_expires_t *http_expires_copy(su_home_t *home,
				    http_expires_t const *hdr)
     __attribute__((__malloc__));

/**Make a header structure http_expires_t.
 *
 * The function http_expires_make() makes a new
 * http_expires_t header structure.  It allocates a new
 * header structure, and decodes the string @a s as the
 * value of the structure.
 *
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 *
 * @note This function is usually implemented as a macro calling
 * http_header_make().
 *
 * @return
 * The function http_expires_make() returns a pointer to
 * newly maked http_expires_t header structure, or NULL upon
 * an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_expires_t *http_expires_make(su_home_t *home, char const *s)
     __attribute__((__malloc__));

/**Make a Expires header from formatting result.
 *
 * The function http_expires_format() makes a new
 * Expires header object using formatting result as its
 * value.  The function first prints the arguments according to
 * the format @a fmt specified.  Then it allocates a new header
 * structure, and uses the formatting result as the header
 * value.
 *
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 *
 * @note This function is usually implemented as a macro calling
 * msg_header_format().
 *
 * @return
 * The function http_expires_format() returns a pointer to newly
 * makes header structure, or NULL upon an error.
 *
 * @HIDE
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_expires_t *http_expires_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__malloc__, __format__ (printf, 2, 3)));


/* Inlined functions */
#if SU_HAVE_INLINE
su_inline
http_expires_t *http_expires_format(su_home_t *home, char const *fmt, ...)
{
  http_header_t *h;
  va_list ap;

  va_start(ap, fmt);
  h = http_header_vformat(home, http_expires_class, fmt, ap);
  va_end(ap);

  return (http_expires_t *)h;
}

su_inline
http_expires_t *http_expires_dup(su_home_t *home, http_expires_t const *o)
{
  return (http_expires_t *)
    msg_header_dup_as(home, http_expires_class, (msg_header_t const *)o);
}

su_inline
http_expires_t *http_expires_copy(su_home_t *home, http_expires_t const *o)
{
  return (http_expires_t *)
    msg_header_copy_as(home, http_expires_class, (msg_header_t const *)o);
}

su_inline
http_expires_t *http_expires_make(su_home_t *home, char const *s)
{
  return (http_expires_t *)http_header_make(home, http_expires_class, s);
}
#endif

#endif /* !define HTTP_HCLASSES_ONLY */

/** @} */


/* Declare internal prototypes for From header */

/**@addtogroup http_from*/ /** @{ */

enum {
  /** Hash of From header. @internal*/
  http_from_hash = 15368
};

/**Header class for HTTP From header.
 *
 * The header class http_from_class defines how a HTTP
 * From header is parsed and printed.  It also
 * contains methods used by HTTP parser and other functions
 * to manipulate the http_from_t header structure.
 *
 */
SOFIAPUBVAR msg_hclass_t http_from_class[];

#ifndef HTTP_HCLASSES_ONLY

/** Decode (parse) a From header. @internal */
SOFIAPUBFUN msg_parse_f http_from_d;

/** Encode (print) a From header. @internal */
SOFIAPUBFUN msg_print_f http_from_e;

/**Initializer for structure http_from_t.
 *
 * A static http_from_t structure must be initialized
 * with the HTTP_FROM_INIT() macro. For instance,
 * @code
 *
 *  http_from_t http_from = HTTP_FROM_INIT;
 *
 * @endcode
 * @HI
 */
#define HTTP_FROM_INIT() HTTP_HDR_INIT(from)

/**Initialize a structure http_from_t.
 *
 * An http_from_t structure can be initialized with the
 * http_from_init() function/macro. For instance,
 * @code
 *
 *  http_from_t http_from;
 *
 *  http_from_init(&http_from);
 *
 * @endcode
 * @HI
 */
#if SU_HAVE_INLINE
su_inline http_from_t *http_from_init(http_from_t x[1])
{
  return HTTP_HEADER_INIT(x, http_from_class, sizeof(http_from_t));
}
#else
#define http_from_init(x) \
  HTTP_HEADER_INIT(x, http_from_class, sizeof(http_from_t))
#endif

/**Test if header object is instance of http_from_t.
 *
 * The function http_is_from() returns true (nonzero) if
 * the header class is an instance of From header
 * object and false (zero) otherwise.
 *
 * @param header pointer to the header structure to be tested
 *
 * @return
 * The function http_is_xfrom() returns true (nonzero) if
 * the header object is an instance of header from and
 * false (zero) otherwise.
 */
#if SU_HAVE_INLINE
su_inline
int http_is_from(http_header_t const *header)
{
  return header && header->sh_class->hc_hash == http_from_hash;
}
#else
#define http_is_from(h) \
 ((h) && ((msg_common_t *)(h))->h_class->hc_hash == http_from_hash)
#endif

/**Duplicate (deep copy) @c http_from_t.
 *
 * The function http_from_dup() duplicates a header
 * structure @a hdr.  If the header structure @a hdr
 * contains a reference (@c hdr->x_next) to a list of
 * headers, all the headers in the list are duplicated, too.
 *
 * @param home  memory home used to allocate new structure
 * @param hdr   header structure to be duplicated
 *
 * When duplicating, all parameter lists and non-constant
 * strings attached to the header are copied, too.  The
 * function uses given memory @a home to allocate all the
 * memory areas used to copy the header.
 *
 * @par Example
 * @code
 *
 *   from = http_from_dup(home, http->http_from);
 *
 * @endcode
 *
 * @return
 * The function http_from_dup() returns a pointer to the
 * newly duplicated http_from_t header structure, or NULL
 * upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_from_t *http_from_dup(su_home_t *home,
				   http_from_t const *hdr)
     __attribute__((__malloc__));

/**Copy a http_from_t header structure.
 *
 * The function http_from_copy() copies a header structure @a
 * hdr.  If the header structure @a hdr contains a reference (@c
 * hdr->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home
 * to allocate all the memory areas used to copy the header
 * structure @a hdr.
 *
 * @param home    memory home used to allocate new structure
 * @param hdr     pointer to the header structure to be duplicated
 *
 * When copying, only the header structure and parameter lists
 * attached to it are duplicated.  The new header structure
 * retains all the references to the strings within the old @a
 * header, including the encoding of the old header, if present.
 *
 * @par Example
 * @code
 *
 *   from = http_from_copy(home, http->http_from);
 *
 * @endcode
 *
 * @return
 * The function http_from_copy() returns a pointer to
 * newly copied header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_from_t *http_from_copy(su_home_t *home,
				    http_from_t const *hdr)
     __attribute__((__malloc__));

/**Make a header structure http_from_t.
 *
 * The function http_from_make() makes a new
 * http_from_t header structure.  It allocates a new
 * header structure, and decodes the string @a s as the
 * value of the structure.
 *
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 *
 * @note This function is usually implemented as a macro calling
 * http_header_make().
 *
 * @return
 * The function http_from_make() returns a pointer to
 * newly maked http_from_t header structure, or NULL upon
 * an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_from_t *http_from_make(su_home_t *home, char const *s)
     __attribute__((__malloc__));

/**Make a From header from formatting result.
 *
 * The function http_from_format() makes a new
 * From header object using formatting result as its
 * value.  The function first prints the arguments according to
 * the format @a fmt specified.  Then it allocates a new header
 * structure, and uses the formatting result as the header
 * value.
 *
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 *
 * @note This function is usually implemented as a macro calling
 * msg_header_format().
 *
 * @return
 * The function http_from_format() returns a pointer to newly
 * makes header structure, or NULL upon an error.
 *
 * @HIDE
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_from_t *http_from_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__malloc__, __format__ (printf, 2, 3)));


/* Inlined functions */
#if SU_HAVE_INLINE
su_inline
http_from_t *http_from_format(su_home_t *home, char const *fmt, ...)
{
  http_header_t *h;
  va_list ap;

  va_start(ap, fmt);
  h = http_header_vformat(home, http_from_class, fmt, ap);
  va_end(ap);

  return (http_from_t *)h;
}

su_inline
http_from_t *http_from_dup(su_home_t *home, http_from_t const *o)
{
  return (http_from_t *)
    msg_header_dup_as(home, http_from_class, (msg_header_t const *)o);
}

su_inline
http_from_t *http_from_copy(su_home_t *home, http_from_t const *o)
{
  return (http_from_t *)
    msg_header_copy_as(home, http_from_class, (msg_header_t const *)o);
}

su_inline
http_from_t *http_from_make(su_home_t *home, char const *s)
{
  return (http_from_t *)http_header_make(home, http_from_class, s);
}
#endif

#endif /* !define HTTP_HCLASSES_ONLY */

/** @} */


/* Declare internal prototypes for Host header */

/**@addtogroup http_host*/ /** @{ */

enum {
  /** Hash of Host header. @internal*/
  http_host_hash = 33850
};

/**Header class for HTTP Host header.
 *
 * The header class http_host_class defines how a HTTP
 * Host header is parsed and printed.  It also
 * contains methods used by HTTP parser and other functions
 * to manipulate the http_host_t header structure.
 *
 */
SOFIAPUBVAR msg_hclass_t http_host_class[];

#ifndef HTTP_HCLASSES_ONLY

/** Decode (parse) a Host header. @internal */
SOFIAPUBFUN msg_parse_f http_host_d;

/** Encode (print) a Host header. @internal */
SOFIAPUBFUN msg_print_f http_host_e;

/**Initializer for structure http_host_t.
 *
 * A static http_host_t structure must be initialized
 * with the HTTP_HOST_INIT() macro. For instance,
 * @code
 *
 *  http_host_t http_host = HTTP_HOST_INIT;
 *
 * @endcode
 * @HI
 */
#define HTTP_HOST_INIT() HTTP_HDR_INIT(host)

/**Initialize a structure http_host_t.
 *
 * An http_host_t structure can be initialized with the
 * http_host_init() function/macro. For instance,
 * @code
 *
 *  http_host_t http_host;
 *
 *  http_host_init(&http_host);
 *
 * @endcode
 * @HI
 */
#if SU_HAVE_INLINE
su_inline http_host_t *http_host_init(http_host_t x[1])
{
  return HTTP_HEADER_INIT(x, http_host_class, sizeof(http_host_t));
}
#else
#define http_host_init(x) \
  HTTP_HEADER_INIT(x, http_host_class, sizeof(http_host_t))
#endif

/**Test if header object is instance of http_host_t.
 *
 * The function http_is_host() returns true (nonzero) if
 * the header class is an instance of Host header
 * object and false (zero) otherwise.
 *
 * @param header pointer to the header structure to be tested
 *
 * @return
 * The function http_is_xhost() returns true (nonzero) if
 * the header object is an instance of header host and
 * false (zero) otherwise.
 */
#if SU_HAVE_INLINE
su_inline
int http_is_host(http_header_t const *header)
{
  return header && header->sh_class->hc_hash == http_host_hash;
}
#else
#define http_is_host(h) \
 ((h) && ((msg_common_t *)(h))->h_class->hc_hash == http_host_hash)
#endif

/**Duplicate (deep copy) @c http_host_t.
 *
 * The function http_host_dup() duplicates a header
 * structure @a hdr.  If the header structure @a hdr
 * contains a reference (@c hdr->x_next) to a list of
 * headers, all the headers in the list are duplicated, too.
 *
 * @param home  memory home used to allocate new structure
 * @param hdr   header structure to be duplicated
 *
 * When duplicating, all parameter lists and non-constant
 * strings attached to the header are copied, too.  The
 * function uses given memory @a home to allocate all the
 * memory areas used to copy the header.
 *
 * @par Example
 * @code
 *
 *   host = http_host_dup(home, http->http_host);
 *
 * @endcode
 *
 * @return
 * The function http_host_dup() returns a pointer to the
 * newly duplicated http_host_t header structure, or NULL
 * upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_host_t *http_host_dup(su_home_t *home,
				   http_host_t const *hdr)
     __attribute__((__malloc__));

/**Copy a http_host_t header structure.
 *
 * The function http_host_copy() copies a header structure @a
 * hdr.  If the header structure @a hdr contains a reference (@c
 * hdr->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home
 * to allocate all the memory areas used to copy the header
 * structure @a hdr.
 *
 * @param home    memory home used to allocate new structure
 * @param hdr     pointer to the header structure to be duplicated
 *
 * When copying, only the header structure and parameter lists
 * attached to it are duplicated.  The new header structure
 * retains all the references to the strings within the old @a
 * header, including the encoding of the old header, if present.
 *
 * @par Example
 * @code
 *
 *   host = http_host_copy(home, http->http_host);
 *
 * @endcode
 *
 * @return
 * The function http_host_copy() returns a pointer to
 * newly copied header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_host_t *http_host_copy(su_home_t *home,
				    http_host_t const *hdr)
     __attribute__((__malloc__));

/**Make a header structure http_host_t.
 *
 * The function http_host_make() makes a new
 * http_host_t header structure.  It allocates a new
 * header structure, and decodes the string @a s as the
 * value of the structure.
 *
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 *
 * @note This function is usually implemented as a macro calling
 * http_header_make().
 *
 * @return
 * The function http_host_make() returns a pointer to
 * newly maked http_host_t header structure, or NULL upon
 * an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_host_t *http_host_make(su_home_t *home, char const *s)
     __attribute__((__malloc__));

/**Make a Host header from formatting result.
 *
 * The function http_host_format() makes a new
 * Host header object using formatting result as its
 * value.  The function first prints the arguments according to
 * the format @a fmt specified.  Then it allocates a new header
 * structure, and uses the formatting result as the header
 * value.
 *
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 *
 * @note This function is usually implemented as a macro calling
 * msg_header_format().
 *
 * @return
 * The function http_host_format() returns a pointer to newly
 * makes header structure, or NULL upon an error.
 *
 * @HIDE
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_host_t *http_host_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__malloc__, __format__ (printf, 2, 3)));


/* Inlined functions */
#if SU_HAVE_INLINE
su_inline
http_host_t *http_host_format(su_home_t *home, char const *fmt, ...)
{
  http_header_t *h;
  va_list ap;

  va_start(ap, fmt);
  h = http_header_vformat(home, http_host_class, fmt, ap);
  va_end(ap);

  return (http_host_t *)h;
}

su_inline
http_host_t *http_host_dup(su_home_t *home, http_host_t const *o)
{
  return (http_host_t *)
    msg_header_dup_as(home, http_host_class, (msg_header_t const *)o);
}

su_inline
http_host_t *http_host_copy(su_home_t *home, http_host_t const *o)
{
  return (http_host_t *)
    msg_header_copy_as(home, http_host_class, (msg_header_t const *)o);
}

su_inline
http_host_t *http_host_make(su_home_t *home, char const *s)
{
  return (http_host_t *)http_header_make(home, http_host_class, s);
}
#endif

#endif /* !define HTTP_HCLASSES_ONLY */

/** @} */


/* Declare internal prototypes for If-Match header */

/**@addtogroup http_if_match*/ /** @{ */

enum {
  /** Hash of If-Match header. @internal*/
  http_if_match_hash = 805
};

/**Header class for HTTP If-Match header.
 *
 * The header class http_if_match_class defines how a HTTP
 * If-Match header is parsed and printed.  It also
 * contains methods used by HTTP parser and other functions
 * to manipulate the http_if_match_t header structure.
 *
 */
SOFIAPUBVAR msg_hclass_t http_if_match_class[];

#ifndef HTTP_HCLASSES_ONLY

/** Decode (parse) a If-Match header. @internal */
SOFIAPUBFUN msg_parse_f http_if_match_d;

/** Encode (print) a If-Match header. @internal */
SOFIAPUBFUN msg_print_f http_if_match_e;

/**Initializer for structure http_if_match_t.
 *
 * A static http_if_match_t structure must be initialized
 * with the HTTP_IF_MATCH_INIT() macro. For instance,
 * @code
 *
 *  http_if_match_t http_if_match = HTTP_IF_MATCH_INIT;
 *
 * @endcode
 * @HI
 */
#define HTTP_IF_MATCH_INIT() HTTP_HDR_INIT(if_match)

/**Initialize a structure http_if_match_t.
 *
 * An http_if_match_t structure can be initialized with the
 * http_if_match_init() function/macro. For instance,
 * @code
 *
 *  http_if_match_t http_if_match;
 *
 *  http_if_match_init(&http_if_match);
 *
 * @endcode
 * @HI
 */
#if SU_HAVE_INLINE
su_inline http_if_match_t *http_if_match_init(http_if_match_t x[1])
{
  return HTTP_HEADER_INIT(x, http_if_match_class, sizeof(http_if_match_t));
}
#else
#define http_if_match_init(x) \
  HTTP_HEADER_INIT(x, http_if_match_class, sizeof(http_if_match_t))
#endif

/**Test if header object is instance of http_if_match_t.
 *
 * The function http_is_if_match() returns true (nonzero) if
 * the header class is an instance of If-Match header
 * object and false (zero) otherwise.
 *
 * @param header pointer to the header structure to be tested
 *
 * @return
 * The function http_is_xif_match() returns true (nonzero) if
 * the header object is an instance of header if_match and
 * false (zero) otherwise.
 */
#if SU_HAVE_INLINE
su_inline
int http_is_if_match(http_header_t const *header)
{
  return header && header->sh_class->hc_hash == http_if_match_hash;
}
#else
#define http_is_if_match(h) \
 ((h) && ((msg_common_t *)(h))->h_class->hc_hash == http_if_match_hash)
#endif

/**Duplicate (deep copy) @c http_if_match_t.
 *
 * The function http_if_match_dup() duplicates a header
 * structure @a hdr.  If the header structure @a hdr
 * contains a reference (@c hdr->x_next) to a list of
 * headers, all the headers in the list are duplicated, too.
 *
 * @param home  memory home used to allocate new structure
 * @param hdr   header structure to be duplicated
 *
 * When duplicating, all parameter lists and non-constant
 * strings attached to the header are copied, too.  The
 * function uses given memory @a home to allocate all the
 * memory areas used to copy the header.
 *
 * @par Example
 * @code
 *
 *   if_match = http_if_match_dup(home, http->http_if_match);
 *
 * @endcode
 *
 * @return
 * The function http_if_match_dup() returns a pointer to the
 * newly duplicated http_if_match_t header structure, or NULL
 * upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_if_match_t *http_if_match_dup(su_home_t *home,
				   http_if_match_t const *hdr)
     __attribute__((__malloc__));

/**Copy a http_if_match_t header structure.
 *
 * The function http_if_match_copy() copies a header structure @a
 * hdr.  If the header structure @a hdr contains a reference (@c
 * hdr->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home
 * to allocate all the memory areas used to copy the header
 * structure @a hdr.
 *
 * @param home    memory home used to allocate new structure
 * @param hdr     pointer to the header structure to be duplicated
 *
 * When copying, only the header structure and parameter lists
 * attached to it are duplicated.  The new header structure
 * retains all the references to the strings within the old @a
 * header, including the encoding of the old header, if present.
 *
 * @par Example
 * @code
 *
 *   if_match = http_if_match_copy(home, http->http_if_match);
 *
 * @endcode
 *
 * @return
 * The function http_if_match_copy() returns a pointer to
 * newly copied header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_if_match_t *http_if_match_copy(su_home_t *home,
				    http_if_match_t const *hdr)
     __attribute__((__malloc__));

/**Make a header structure http_if_match_t.
 *
 * The function http_if_match_make() makes a new
 * http_if_match_t header structure.  It allocates a new
 * header structure, and decodes the string @a s as the
 * value of the structure.
 *
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 *
 * @note This function is usually implemented as a macro calling
 * http_header_make().
 *
 * @return
 * The function http_if_match_make() returns a pointer to
 * newly maked http_if_match_t header structure, or NULL upon
 * an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_if_match_t *http_if_match_make(su_home_t *home, char const *s)
     __attribute__((__malloc__));

/**Make a If-Match header from formatting result.
 *
 * The function http_if_match_format() makes a new
 * If-Match header object using formatting result as its
 * value.  The function first prints the arguments according to
 * the format @a fmt specified.  Then it allocates a new header
 * structure, and uses the formatting result as the header
 * value.
 *
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 *
 * @note This function is usually implemented as a macro calling
 * msg_header_format().
 *
 * @return
 * The function http_if_match_format() returns a pointer to newly
 * makes header structure, or NULL upon an error.
 *
 * @HIDE
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_if_match_t *http_if_match_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__malloc__, __format__ (printf, 2, 3)));


/* Inlined functions */
#if SU_HAVE_INLINE
su_inline
http_if_match_t *http_if_match_format(su_home_t *home, char const *fmt, ...)
{
  http_header_t *h;
  va_list ap;

  va_start(ap, fmt);
  h = http_header_vformat(home, http_if_match_class, fmt, ap);
  va_end(ap);

  return (http_if_match_t *)h;
}

su_inline
http_if_match_t *http_if_match_dup(su_home_t *home, http_if_match_t const *o)
{
  return (http_if_match_t *)
    msg_header_dup_as(home, http_if_match_class, (msg_header_t const *)o);
}

su_inline
http_if_match_t *http_if_match_copy(su_home_t *home, http_if_match_t const *o)
{
  return (http_if_match_t *)
    msg_header_copy_as(home, http_if_match_class, (msg_header_t const *)o);
}

su_inline
http_if_match_t *http_if_match_make(su_home_t *home, char const *s)
{
  return (http_if_match_t *)http_header_make(home, http_if_match_class, s);
}
#endif

#endif /* !define HTTP_HCLASSES_ONLY */

/** @} */


/* Declare internal prototypes for If-Modified-Since header */

/**@addtogroup http_if_modified_since*/ /** @{ */

enum {
  /** Hash of If-Modified-Since header. @internal*/
  http_if_modified_since_hash = 4424
};

/**Header class for HTTP If-Modified-Since header.
 *
 * The header class http_if_modified_since_class defines how a HTTP
 * If-Modified-Since header is parsed and printed.  It also
 * contains methods used by HTTP parser and other functions
 * to manipulate the http_if_modified_since_t header structure.
 *
 */
SOFIAPUBVAR msg_hclass_t http_if_modified_since_class[];

#ifndef HTTP_HCLASSES_ONLY

/** Decode (parse) a If-Modified-Since header. @internal */
SOFIAPUBFUN msg_parse_f http_if_modified_since_d;

/** Encode (print) a If-Modified-Since header. @internal */
SOFIAPUBFUN msg_print_f http_if_modified_since_e;

/**Initializer for structure http_if_modified_since_t.
 *
 * A static http_if_modified_since_t structure must be initialized
 * with the HTTP_IF_MODIFIED_SINCE_INIT() macro. For instance,
 * @code
 *
 *  http_if_modified_since_t http_if_modified_since = HTTP_IF_MODIFIED_SINCE_INIT;
 *
 * @endcode
 * @HI
 */
#define HTTP_IF_MODIFIED_SINCE_INIT() HTTP_HDR_INIT(if_modified_since)

/**Initialize a structure http_if_modified_since_t.
 *
 * An http_if_modified_since_t structure can be initialized with the
 * http_if_modified_since_init() function/macro. For instance,
 * @code
 *
 *  http_if_modified_since_t http_if_modified_since;
 *
 *  http_if_modified_since_init(&http_if_modified_since);
 *
 * @endcode
 * @HI
 */
#if SU_HAVE_INLINE
su_inline http_if_modified_since_t *http_if_modified_since_init(http_if_modified_since_t x[1])
{
  return HTTP_HEADER_INIT(x, http_if_modified_since_class, sizeof(http_if_modified_since_t));
}
#else
#define http_if_modified_since_init(x) \
  HTTP_HEADER_INIT(x, http_if_modified_since_class, sizeof(http_if_modified_since_t))
#endif

/**Test if header object is instance of http_if_modified_since_t.
 *
 * The function http_is_if_modified_since() returns true (nonzero) if
 * the header class is an instance of If-Modified-Since header
 * object and false (zero) otherwise.
 *
 * @param header pointer to the header structure to be tested
 *
 * @return
 * The function http_is_xif_modified_since() returns true (nonzero) if
 * the header object is an instance of header if_modified_since and
 * false (zero) otherwise.
 */
#if SU_HAVE_INLINE
su_inline
int http_is_if_modified_since(http_header_t const *header)
{
  return header && header->sh_class->hc_hash == http_if_modified_since_hash;
}
#else
#define http_is_if_modified_since(h) \
 ((h) && ((msg_common_t *)(h))->h_class->hc_hash == http_if_modified_since_hash)
#endif

/**Duplicate (deep copy) @c http_if_modified_since_t.
 *
 * The function http_if_modified_since_dup() duplicates a header
 * structure @a hdr.  If the header structure @a hdr
 * contains a reference (@c hdr->x_next) to a list of
 * headers, all the headers in the list are duplicated, too.
 *
 * @param home  memory home used to allocate new structure
 * @param hdr   header structure to be duplicated
 *
 * When duplicating, all parameter lists and non-constant
 * strings attached to the header are copied, too.  The
 * function uses given memory @a home to allocate all the
 * memory areas used to copy the header.
 *
 * @par Example
 * @code
 *
 *   if_modified_since = http_if_modified_since_dup(home, http->http_if_modified_since);
 *
 * @endcode
 *
 * @return
 * The function http_if_modified_since_dup() returns a pointer to the
 * newly duplicated http_if_modified_since_t header structure, or NULL
 * upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_if_modified_since_t *http_if_modified_since_dup(su_home_t *home,
				   http_if_modified_since_t const *hdr)
     __attribute__((__malloc__));

/**Copy a http_if_modified_since_t header structure.
 *
 * The function http_if_modified_since_copy() copies a header structure @a
 * hdr.  If the header structure @a hdr contains a reference (@c
 * hdr->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home
 * to allocate all the memory areas used to copy the header
 * structure @a hdr.
 *
 * @param home    memory home used to allocate new structure
 * @param hdr     pointer to the header structure to be duplicated
 *
 * When copying, only the header structure and parameter lists
 * attached to it are duplicated.  The new header structure
 * retains all the references to the strings within the old @a
 * header, including the encoding of the old header, if present.
 *
 * @par Example
 * @code
 *
 *   if_modified_since = http_if_modified_since_copy(home, http->http_if_modified_since);
 *
 * @endcode
 *
 * @return
 * The function http_if_modified_since_copy() returns a pointer to
 * newly copied header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_if_modified_since_t *http_if_modified_since_copy(su_home_t *home,
				    http_if_modified_since_t const *hdr)
     __attribute__((__malloc__));

/**Make a header structure http_if_modified_since_t.
 *
 * The function http_if_modified_since_make() makes a new
 * http_if_modified_since_t header structure.  It allocates a new
 * header structure, and decodes the string @a s as the
 * value of the structure.
 *
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 *
 * @note This function is usually implemented as a macro calling
 * http_header_make().
 *
 * @return
 * The function http_if_modified_since_make() returns a pointer to
 * newly maked http_if_modified_since_t header structure, or NULL upon
 * an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_if_modified_since_t *http_if_modified_since_make(su_home_t *home, char const *s)
     __attribute__((__malloc__));

/**Make a If-Modified-Since header from formatting result.
 *
 * The function http_if_modified_since_format() makes a new
 * If-Modified-Since header object using formatting result as its
 * value.  The function first prints the arguments according to
 * the format @a fmt specified.  Then it allocates a new header
 * structure, and uses the formatting result as the header
 * value.
 *
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 *
 * @note This function is usually implemented as a macro calling
 * msg_header_format().
 *
 * @return
 * The function http_if_modified_since_format() returns a pointer to newly
 * makes header structure, or NULL upon an error.
 *
 * @HIDE
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_if_modified_since_t *http_if_modified_since_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__malloc__, __format__ (printf, 2, 3)));


/* Inlined functions */
#if SU_HAVE_INLINE
su_inline
http_if_modified_since_t *http_if_modified_since_format(su_home_t *home, char const *fmt, ...)
{
  http_header_t *h;
  va_list ap;

  va_start(ap, fmt);
  h = http_header_vformat(home, http_if_modified_since_class, fmt, ap);
  va_end(ap);

  return (http_if_modified_since_t *)h;
}

su_inline
http_if_modified_since_t *http_if_modified_since_dup(su_home_t *home, http_if_modified_since_t const *o)
{
  return (http_if_modified_since_t *)
    msg_header_dup_as(home, http_if_modified_since_class, (msg_header_t const *)o);
}

su_inline
http_if_modified_since_t *http_if_modified_since_copy(su_home_t *home, http_if_modified_since_t const *o)
{
  return (http_if_modified_since_t *)
    msg_header_copy_as(home, http_if_modified_since_class, (msg_header_t const *)o);
}

su_inline
http_if_modified_since_t *http_if_modified_since_make(su_home_t *home, char const *s)
{
  return (http_if_modified_since_t *)http_header_make(home, http_if_modified_since_class, s);
}
#endif

#endif /* !define HTTP_HCLASSES_ONLY */

/** @} */


/* Declare internal prototypes for If-None-Match header */

/**@addtogroup http_if_none_match*/ /** @{ */

enum {
  /** Hash of If-None-Match header. @internal*/
  http_if_none_match_hash = 64610
};

/**Header class for HTTP If-None-Match header.
 *
 * The header class http_if_none_match_class defines how a HTTP
 * If-None-Match header is parsed and printed.  It also
 * contains methods used by HTTP parser and other functions
 * to manipulate the http_if_none_match_t header structure.
 *
 */
SOFIAPUBVAR msg_hclass_t http_if_none_match_class[];

#ifndef HTTP_HCLASSES_ONLY

/** Decode (parse) a If-None-Match header. @internal */
SOFIAPUBFUN msg_parse_f http_if_none_match_d;

/** Encode (print) a If-None-Match header. @internal */
SOFIAPUBFUN msg_print_f http_if_none_match_e;

/**Initializer for structure http_if_none_match_t.
 *
 * A static http_if_none_match_t structure must be initialized
 * with the HTTP_IF_NONE_MATCH_INIT() macro. For instance,
 * @code
 *
 *  http_if_none_match_t http_if_none_match = HTTP_IF_NONE_MATCH_INIT;
 *
 * @endcode
 * @HI
 */
#define HTTP_IF_NONE_MATCH_INIT() HTTP_HDR_INIT(if_none_match)

/**Initialize a structure http_if_none_match_t.
 *
 * An http_if_none_match_t structure can be initialized with the
 * http_if_none_match_init() function/macro. For instance,
 * @code
 *
 *  http_if_none_match_t http_if_none_match;
 *
 *  http_if_none_match_init(&http_if_none_match);
 *
 * @endcode
 * @HI
 */
#if SU_HAVE_INLINE
su_inline http_if_none_match_t *http_if_none_match_init(http_if_none_match_t x[1])
{
  return HTTP_HEADER_INIT(x, http_if_none_match_class, sizeof(http_if_none_match_t));
}
#else
#define http_if_none_match_init(x) \
  HTTP_HEADER_INIT(x, http_if_none_match_class, sizeof(http_if_none_match_t))
#endif

/**Test if header object is instance of http_if_none_match_t.
 *
 * The function http_is_if_none_match() returns true (nonzero) if
 * the header class is an instance of If-None-Match header
 * object and false (zero) otherwise.
 *
 * @param header pointer to the header structure to be tested
 *
 * @return
 * The function http_is_xif_none_match() returns true (nonzero) if
 * the header object is an instance of header if_none_match and
 * false (zero) otherwise.
 */
#if SU_HAVE_INLINE
su_inline
int http_is_if_none_match(http_header_t const *header)
{
  return header && header->sh_class->hc_hash == http_if_none_match_hash;
}
#else
#define http_is_if_none_match(h) \
 ((h) && ((msg_common_t *)(h))->h_class->hc_hash == http_if_none_match_hash)
#endif

/**Duplicate (deep copy) @c http_if_none_match_t.
 *
 * The function http_if_none_match_dup() duplicates a header
 * structure @a hdr.  If the header structure @a hdr
 * contains a reference (@c hdr->x_next) to a list of
 * headers, all the headers in the list are duplicated, too.
 *
 * @param home  memory home used to allocate new structure
 * @param hdr   header structure to be duplicated
 *
 * When duplicating, all parameter lists and non-constant
 * strings attached to the header are copied, too.  The
 * function uses given memory @a home to allocate all the
 * memory areas used to copy the header.
 *
 * @par Example
 * @code
 *
 *   if_none_match = http_if_none_match_dup(home, http->http_if_none_match);
 *
 * @endcode
 *
 * @return
 * The function http_if_none_match_dup() returns a pointer to the
 * newly duplicated http_if_none_match_t header structure, or NULL
 * upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_if_none_match_t *http_if_none_match_dup(su_home_t *home,
				   http_if_none_match_t const *hdr)
     __attribute__((__malloc__));

/**Copy a http_if_none_match_t header structure.
 *
 * The function http_if_none_match_copy() copies a header structure @a
 * hdr.  If the header structure @a hdr contains a reference (@c
 * hdr->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home
 * to allocate all the memory areas used to copy the header
 * structure @a hdr.
 *
 * @param home    memory home used to allocate new structure
 * @param hdr     pointer to the header structure to be duplicated
 *
 * When copying, only the header structure and parameter lists
 * attached to it are duplicated.  The new header structure
 * retains all the references to the strings within the old @a
 * header, including the encoding of the old header, if present.
 *
 * @par Example
 * @code
 *
 *   if_none_match = http_if_none_match_copy(home, http->http_if_none_match);
 *
 * @endcode
 *
 * @return
 * The function http_if_none_match_copy() returns a pointer to
 * newly copied header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_if_none_match_t *http_if_none_match_copy(su_home_t *home,
				    http_if_none_match_t const *hdr)
     __attribute__((__malloc__));

/**Make a header structure http_if_none_match_t.
 *
 * The function http_if_none_match_make() makes a new
 * http_if_none_match_t header structure.  It allocates a new
 * header structure, and decodes the string @a s as the
 * value of the structure.
 *
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 *
 * @note This function is usually implemented as a macro calling
 * http_header_make().
 *
 * @return
 * The function http_if_none_match_make() returns a pointer to
 * newly maked http_if_none_match_t header structure, or NULL upon
 * an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_if_none_match_t *http_if_none_match_make(su_home_t *home, char const *s)
     __attribute__((__malloc__));

/**Make a If-None-Match header from formatting result.
 *
 * The function http_if_none_match_format() makes a new
 * If-None-Match header object using formatting result as its
 * value.  The function first prints the arguments according to
 * the format @a fmt specified.  Then it allocates a new header
 * structure, and uses the formatting result as the header
 * value.
 *
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 *
 * @note This function is usually implemented as a macro calling
 * msg_header_format().
 *
 * @return
 * The function http_if_none_match_format() returns a pointer to newly
 * makes header structure, or NULL upon an error.
 *
 * @HIDE
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_if_none_match_t *http_if_none_match_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__malloc__, __format__ (printf, 2, 3)));


/* Inlined functions */
#if SU_HAVE_INLINE
su_inline
http_if_none_match_t *http_if_none_match_format(su_home_t *home, char const *fmt, ...)
{
  http_header_t *h;
  va_list ap;

  va_start(ap, fmt);
  h = http_header_vformat(home, http_if_none_match_class, fmt, ap);
  va_end(ap);

  return (http_if_none_match_t *)h;
}

su_inline
http_if_none_match_t *http_if_none_match_dup(su_home_t *home, http_if_none_match_t const *o)
{
  return (http_if_none_match_t *)
    msg_header_dup_as(home, http_if_none_match_class, (msg_header_t const *)o);
}

su_inline
http_if_none_match_t *http_if_none_match_copy(su_home_t *home, http_if_none_match_t const *o)
{
  return (http_if_none_match_t *)
    msg_header_copy_as(home, http_if_none_match_class, (msg_header_t const *)o);
}

su_inline
http_if_none_match_t *http_if_none_match_make(su_home_t *home, char const *s)
{
  return (http_if_none_match_t *)http_header_make(home, http_if_none_match_class, s);
}
#endif

#endif /* !define HTTP_HCLASSES_ONLY */

/** @} */


/* Declare internal prototypes for If-Range header */

/**@addtogroup http_if_range*/ /** @{ */

enum {
  /** Hash of If-Range header. @internal*/
  http_if_range_hash = 40469
};

/**Header class for HTTP If-Range header.
 *
 * The header class http_if_range_class defines how a HTTP
 * If-Range header is parsed and printed.  It also
 * contains methods used by HTTP parser and other functions
 * to manipulate the http_if_range_t header structure.
 *
 */
SOFIAPUBVAR msg_hclass_t http_if_range_class[];

#ifndef HTTP_HCLASSES_ONLY

/** Decode (parse) a If-Range header. @internal */
SOFIAPUBFUN msg_parse_f http_if_range_d;

/** Encode (print) a If-Range header. @internal */
SOFIAPUBFUN msg_print_f http_if_range_e;

/**Initializer for structure http_if_range_t.
 *
 * A static http_if_range_t structure must be initialized
 * with the HTTP_IF_RANGE_INIT() macro. For instance,
 * @code
 *
 *  http_if_range_t http_if_range = HTTP_IF_RANGE_INIT;
 *
 * @endcode
 * @HI
 */
#define HTTP_IF_RANGE_INIT() HTTP_HDR_INIT(if_range)

/**Initialize a structure http_if_range_t.
 *
 * An http_if_range_t structure can be initialized with the
 * http_if_range_init() function/macro. For instance,
 * @code
 *
 *  http_if_range_t http_if_range;
 *
 *  http_if_range_init(&http_if_range);
 *
 * @endcode
 * @HI
 */
#if SU_HAVE_INLINE
su_inline http_if_range_t *http_if_range_init(http_if_range_t x[1])
{
  return HTTP_HEADER_INIT(x, http_if_range_class, sizeof(http_if_range_t));
}
#else
#define http_if_range_init(x) \
  HTTP_HEADER_INIT(x, http_if_range_class, sizeof(http_if_range_t))
#endif

/**Test if header object is instance of http_if_range_t.
 *
 * The function http_is_if_range() returns true (nonzero) if
 * the header class is an instance of If-Range header
 * object and false (zero) otherwise.
 *
 * @param header pointer to the header structure to be tested
 *
 * @return
 * The function http_is_xif_range() returns true (nonzero) if
 * the header object is an instance of header if_range and
 * false (zero) otherwise.
 */
#if SU_HAVE_INLINE
su_inline
int http_is_if_range(http_header_t const *header)
{
  return header && header->sh_class->hc_hash == http_if_range_hash;
}
#else
#define http_is_if_range(h) \
 ((h) && ((msg_common_t *)(h))->h_class->hc_hash == http_if_range_hash)
#endif

/**Duplicate (deep copy) @c http_if_range_t.
 *
 * The function http_if_range_dup() duplicates a header
 * structure @a hdr.  If the header structure @a hdr
 * contains a reference (@c hdr->x_next) to a list of
 * headers, all the headers in the list are duplicated, too.
 *
 * @param home  memory home used to allocate new structure
 * @param hdr   header structure to be duplicated
 *
 * When duplicating, all parameter lists and non-constant
 * strings attached to the header are copied, too.  The
 * function uses given memory @a home to allocate all the
 * memory areas used to copy the header.
 *
 * @par Example
 * @code
 *
 *   if_range = http_if_range_dup(home, http->http_if_range);
 *
 * @endcode
 *
 * @return
 * The function http_if_range_dup() returns a pointer to the
 * newly duplicated http_if_range_t header structure, or NULL
 * upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_if_range_t *http_if_range_dup(su_home_t *home,
				   http_if_range_t const *hdr)
     __attribute__((__malloc__));

/**Copy a http_if_range_t header structure.
 *
 * The function http_if_range_copy() copies a header structure @a
 * hdr.  If the header structure @a hdr contains a reference (@c
 * hdr->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home
 * to allocate all the memory areas used to copy the header
 * structure @a hdr.
 *
 * @param home    memory home used to allocate new structure
 * @param hdr     pointer to the header structure to be duplicated
 *
 * When copying, only the header structure and parameter lists
 * attached to it are duplicated.  The new header structure
 * retains all the references to the strings within the old @a
 * header, including the encoding of the old header, if present.
 *
 * @par Example
 * @code
 *
 *   if_range = http_if_range_copy(home, http->http_if_range);
 *
 * @endcode
 *
 * @return
 * The function http_if_range_copy() returns a pointer to
 * newly copied header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_if_range_t *http_if_range_copy(su_home_t *home,
				    http_if_range_t const *hdr)
     __attribute__((__malloc__));

/**Make a header structure http_if_range_t.
 *
 * The function http_if_range_make() makes a new
 * http_if_range_t header structure.  It allocates a new
 * header structure, and decodes the string @a s as the
 * value of the structure.
 *
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 *
 * @note This function is usually implemented as a macro calling
 * http_header_make().
 *
 * @return
 * The function http_if_range_make() returns a pointer to
 * newly maked http_if_range_t header structure, or NULL upon
 * an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_if_range_t *http_if_range_make(su_home_t *home, char const *s)
     __attribute__((__malloc__));

/**Make a If-Range header from formatting result.
 *
 * The function http_if_range_format() makes a new
 * If-Range header object using formatting result as its
 * value.  The function first prints the arguments according to
 * the format @a fmt specified.  Then it allocates a new header
 * structure, and uses the formatting result as the header
 * value.
 *
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 *
 * @note This function is usually implemented as a macro calling
 * msg_header_format().
 *
 * @return
 * The function http_if_range_format() returns a pointer to newly
 * makes header structure, or NULL upon an error.
 *
 * @HIDE
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_if_range_t *http_if_range_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__malloc__, __format__ (printf, 2, 3)));


/* Inlined functions */
#if SU_HAVE_INLINE
su_inline
http_if_range_t *http_if_range_format(su_home_t *home, char const *fmt, ...)
{
  http_header_t *h;
  va_list ap;

  va_start(ap, fmt);
  h = http_header_vformat(home, http_if_range_class, fmt, ap);
  va_end(ap);

  return (http_if_range_t *)h;
}

su_inline
http_if_range_t *http_if_range_dup(su_home_t *home, http_if_range_t const *o)
{
  return (http_if_range_t *)
    msg_header_dup_as(home, http_if_range_class, (msg_header_t const *)o);
}

su_inline
http_if_range_t *http_if_range_copy(su_home_t *home, http_if_range_t const *o)
{
  return (http_if_range_t *)
    msg_header_copy_as(home, http_if_range_class, (msg_header_t const *)o);
}

su_inline
http_if_range_t *http_if_range_make(su_home_t *home, char const *s)
{
  return (http_if_range_t *)http_header_make(home, http_if_range_class, s);
}
#endif

#endif /* !define HTTP_HCLASSES_ONLY */

/** @} */


/* Declare internal prototypes for If-Unmodified-Since header */

/**@addtogroup http_if_unmodified_since*/ /** @{ */

enum {
  /** Hash of If-Unmodified-Since header. @internal*/
  http_if_unmodified_since_hash = 2675
};

/**Header class for HTTP If-Unmodified-Since header.
 *
 * The header class http_if_unmodified_since_class defines how a HTTP
 * If-Unmodified-Since header is parsed and printed.  It also
 * contains methods used by HTTP parser and other functions
 * to manipulate the http_if_unmodified_since_t header structure.
 *
 */
SOFIAPUBVAR msg_hclass_t http_if_unmodified_since_class[];

#ifndef HTTP_HCLASSES_ONLY

/** Decode (parse) a If-Unmodified-Since header. @internal */
SOFIAPUBFUN msg_parse_f http_if_unmodified_since_d;

/** Encode (print) a If-Unmodified-Since header. @internal */
SOFIAPUBFUN msg_print_f http_if_unmodified_since_e;

/**Initializer for structure http_if_unmodified_since_t.
 *
 * A static http_if_unmodified_since_t structure must be initialized
 * with the HTTP_IF_UNMODIFIED_SINCE_INIT() macro. For instance,
 * @code
 *
 *  http_if_unmodified_since_t http_if_unmodified_since = HTTP_IF_UNMODIFIED_SINCE_INIT;
 *
 * @endcode
 * @HI
 */
#define HTTP_IF_UNMODIFIED_SINCE_INIT() HTTP_HDR_INIT(if_unmodified_since)

/**Initialize a structure http_if_unmodified_since_t.
 *
 * An http_if_unmodified_since_t structure can be initialized with the
 * http_if_unmodified_since_init() function/macro. For instance,
 * @code
 *
 *  http_if_unmodified_since_t http_if_unmodified_since;
 *
 *  http_if_unmodified_since_init(&http_if_unmodified_since);
 *
 * @endcode
 * @HI
 */
#if SU_HAVE_INLINE
su_inline http_if_unmodified_since_t *http_if_unmodified_since_init(http_if_unmodified_since_t x[1])
{
  return HTTP_HEADER_INIT(x, http_if_unmodified_since_class, sizeof(http_if_unmodified_since_t));
}
#else
#define http_if_unmodified_since_init(x) \
  HTTP_HEADER_INIT(x, http_if_unmodified_since_class, sizeof(http_if_unmodified_since_t))
#endif

/**Test if header object is instance of http_if_unmodified_since_t.
 *
 * The function http_is_if_unmodified_since() returns true (nonzero) if
 * the header class is an instance of If-Unmodified-Since header
 * object and false (zero) otherwise.
 *
 * @param header pointer to the header structure to be tested
 *
 * @return
 * The function http_is_xif_unmodified_since() returns true (nonzero) if
 * the header object is an instance of header if_unmodified_since and
 * false (zero) otherwise.
 */
#if SU_HAVE_INLINE
su_inline
int http_is_if_unmodified_since(http_header_t const *header)
{
  return header && header->sh_class->hc_hash == http_if_unmodified_since_hash;
}
#else
#define http_is_if_unmodified_since(h) \
 ((h) && ((msg_common_t *)(h))->h_class->hc_hash == http_if_unmodified_since_hash)
#endif

/**Duplicate (deep copy) @c http_if_unmodified_since_t.
 *
 * The function http_if_unmodified_since_dup() duplicates a header
 * structure @a hdr.  If the header structure @a hdr
 * contains a reference (@c hdr->x_next) to a list of
 * headers, all the headers in the list are duplicated, too.
 *
 * @param home  memory home used to allocate new structure
 * @param hdr   header structure to be duplicated
 *
 * When duplicating, all parameter lists and non-constant
 * strings attached to the header are copied, too.  The
 * function uses given memory @a home to allocate all the
 * memory areas used to copy the header.
 *
 * @par Example
 * @code
 *
 *   if_unmodified_since = http_if_unmodified_since_dup(home, http->http_if_unmodified_since);
 *
 * @endcode
 *
 * @return
 * The function http_if_unmodified_since_dup() returns a pointer to the
 * newly duplicated http_if_unmodified_since_t header structure, or NULL
 * upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_if_unmodified_since_t *http_if_unmodified_since_dup(su_home_t *home,
				   http_if_unmodified_since_t const *hdr)
     __attribute__((__malloc__));

/**Copy a http_if_unmodified_since_t header structure.
 *
 * The function http_if_unmodified_since_copy() copies a header structure @a
 * hdr.  If the header structure @a hdr contains a reference (@c
 * hdr->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home
 * to allocate all the memory areas used to copy the header
 * structure @a hdr.
 *
 * @param home    memory home used to allocate new structure
 * @param hdr     pointer to the header structure to be duplicated
 *
 * When copying, only the header structure and parameter lists
 * attached to it are duplicated.  The new header structure
 * retains all the references to the strings within the old @a
 * header, including the encoding of the old header, if present.
 *
 * @par Example
 * @code
 *
 *   if_unmodified_since = http_if_unmodified_since_copy(home, http->http_if_unmodified_since);
 *
 * @endcode
 *
 * @return
 * The function http_if_unmodified_since_copy() returns a pointer to
 * newly copied header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_if_unmodified_since_t *http_if_unmodified_since_copy(su_home_t *home,
				    http_if_unmodified_since_t const *hdr)
     __attribute__((__malloc__));

/**Make a header structure http_if_unmodified_since_t.
 *
 * The function http_if_unmodified_since_make() makes a new
 * http_if_unmodified_since_t header structure.  It allocates a new
 * header structure, and decodes the string @a s as the
 * value of the structure.
 *
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 *
 * @note This function is usually implemented as a macro calling
 * http_header_make().
 *
 * @return
 * The function http_if_unmodified_since_make() returns a pointer to
 * newly maked http_if_unmodified_since_t header structure, or NULL upon
 * an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_if_unmodified_since_t *http_if_unmodified_since_make(su_home_t *home, char const *s)
     __attribute__((__malloc__));

/**Make a If-Unmodified-Since header from formatting result.
 *
 * The function http_if_unmodified_since_format() makes a new
 * If-Unmodified-Since header object using formatting result as its
 * value.  The function first prints the arguments according to
 * the format @a fmt specified.  Then it allocates a new header
 * structure, and uses the formatting result as the header
 * value.
 *
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 *
 * @note This function is usually implemented as a macro calling
 * msg_header_format().
 *
 * @return
 * The function http_if_unmodified_since_format() returns a pointer to newly
 * makes header structure, or NULL upon an error.
 *
 * @HIDE
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_if_unmodified_since_t *http_if_unmodified_since_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__malloc__, __format__ (printf, 2, 3)));


/* Inlined functions */
#if SU_HAVE_INLINE
su_inline
http_if_unmodified_since_t *http_if_unmodified_since_format(su_home_t *home, char const *fmt, ...)
{
  http_header_t *h;
  va_list ap;

  va_start(ap, fmt);
  h = http_header_vformat(home, http_if_unmodified_since_class, fmt, ap);
  va_end(ap);

  return (http_if_unmodified_since_t *)h;
}

su_inline
http_if_unmodified_since_t *http_if_unmodified_since_dup(su_home_t *home, http_if_unmodified_since_t const *o)
{
  return (http_if_unmodified_since_t *)
    msg_header_dup_as(home, http_if_unmodified_since_class, (msg_header_t const *)o);
}

su_inline
http_if_unmodified_since_t *http_if_unmodified_since_copy(su_home_t *home, http_if_unmodified_since_t const *o)
{
  return (http_if_unmodified_since_t *)
    msg_header_copy_as(home, http_if_unmodified_since_class, (msg_header_t const *)o);
}

su_inline
http_if_unmodified_since_t *http_if_unmodified_since_make(su_home_t *home, char const *s)
{
  return (http_if_unmodified_since_t *)http_header_make(home, http_if_unmodified_since_class, s);
}
#endif

#endif /* !define HTTP_HCLASSES_ONLY */

/** @} */


/* Declare internal prototypes for Last-Modified header */

/**@addtogroup http_last_modified*/ /** @{ */

enum {
  /** Hash of Last-Modified header. @internal*/
  http_last_modified_hash = 19958
};

/**Header class for HTTP Last-Modified header.
 *
 * The header class http_last_modified_class defines how a HTTP
 * Last-Modified header is parsed and printed.  It also
 * contains methods used by HTTP parser and other functions
 * to manipulate the http_last_modified_t header structure.
 *
 */
SOFIAPUBVAR msg_hclass_t http_last_modified_class[];

#ifndef HTTP_HCLASSES_ONLY

/** Decode (parse) a Last-Modified header. @internal */
SOFIAPUBFUN msg_parse_f http_last_modified_d;

/** Encode (print) a Last-Modified header. @internal */
SOFIAPUBFUN msg_print_f http_last_modified_e;

/**Initializer for structure http_last_modified_t.
 *
 * A static http_last_modified_t structure must be initialized
 * with the HTTP_LAST_MODIFIED_INIT() macro. For instance,
 * @code
 *
 *  http_last_modified_t http_last_modified = HTTP_LAST_MODIFIED_INIT;
 *
 * @endcode
 * @HI
 */
#define HTTP_LAST_MODIFIED_INIT() HTTP_HDR_INIT(last_modified)

/**Initialize a structure http_last_modified_t.
 *
 * An http_last_modified_t structure can be initialized with the
 * http_last_modified_init() function/macro. For instance,
 * @code
 *
 *  http_last_modified_t http_last_modified;
 *
 *  http_last_modified_init(&http_last_modified);
 *
 * @endcode
 * @HI
 */
#if SU_HAVE_INLINE
su_inline http_last_modified_t *http_last_modified_init(http_last_modified_t x[1])
{
  return HTTP_HEADER_INIT(x, http_last_modified_class, sizeof(http_last_modified_t));
}
#else
#define http_last_modified_init(x) \
  HTTP_HEADER_INIT(x, http_last_modified_class, sizeof(http_last_modified_t))
#endif

/**Test if header object is instance of http_last_modified_t.
 *
 * The function http_is_last_modified() returns true (nonzero) if
 * the header class is an instance of Last-Modified header
 * object and false (zero) otherwise.
 *
 * @param header pointer to the header structure to be tested
 *
 * @return
 * The function http_is_xlast_modified() returns true (nonzero) if
 * the header object is an instance of header last_modified and
 * false (zero) otherwise.
 */
#if SU_HAVE_INLINE
su_inline
int http_is_last_modified(http_header_t const *header)
{
  return header && header->sh_class->hc_hash == http_last_modified_hash;
}
#else
#define http_is_last_modified(h) \
 ((h) && ((msg_common_t *)(h))->h_class->hc_hash == http_last_modified_hash)
#endif

/**Duplicate (deep copy) @c http_last_modified_t.
 *
 * The function http_last_modified_dup() duplicates a header
 * structure @a hdr.  If the header structure @a hdr
 * contains a reference (@c hdr->x_next) to a list of
 * headers, all the headers in the list are duplicated, too.
 *
 * @param home  memory home used to allocate new structure
 * @param hdr   header structure to be duplicated
 *
 * When duplicating, all parameter lists and non-constant
 * strings attached to the header are copied, too.  The
 * function uses given memory @a home to allocate all the
 * memory areas used to copy the header.
 *
 * @par Example
 * @code
 *
 *   last_modified = http_last_modified_dup(home, http->http_last_modified);
 *
 * @endcode
 *
 * @return
 * The function http_last_modified_dup() returns a pointer to the
 * newly duplicated http_last_modified_t header structure, or NULL
 * upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_last_modified_t *http_last_modified_dup(su_home_t *home,
				   http_last_modified_t const *hdr)
     __attribute__((__malloc__));

/**Copy a http_last_modified_t header structure.
 *
 * The function http_last_modified_copy() copies a header structure @a
 * hdr.  If the header structure @a hdr contains a reference (@c
 * hdr->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home
 * to allocate all the memory areas used to copy the header
 * structure @a hdr.
 *
 * @param home    memory home used to allocate new structure
 * @param hdr     pointer to the header structure to be duplicated
 *
 * When copying, only the header structure and parameter lists
 * attached to it are duplicated.  The new header structure
 * retains all the references to the strings within the old @a
 * header, including the encoding of the old header, if present.
 *
 * @par Example
 * @code
 *
 *   last_modified = http_last_modified_copy(home, http->http_last_modified);
 *
 * @endcode
 *
 * @return
 * The function http_last_modified_copy() returns a pointer to
 * newly copied header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_last_modified_t *http_last_modified_copy(su_home_t *home,
				    http_last_modified_t const *hdr)
     __attribute__((__malloc__));

/**Make a header structure http_last_modified_t.
 *
 * The function http_last_modified_make() makes a new
 * http_last_modified_t header structure.  It allocates a new
 * header structure, and decodes the string @a s as the
 * value of the structure.
 *
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 *
 * @note This function is usually implemented as a macro calling
 * http_header_make().
 *
 * @return
 * The function http_last_modified_make() returns a pointer to
 * newly maked http_last_modified_t header structure, or NULL upon
 * an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_last_modified_t *http_last_modified_make(su_home_t *home, char const *s)
     __attribute__((__malloc__));

/**Make a Last-Modified header from formatting result.
 *
 * The function http_last_modified_format() makes a new
 * Last-Modified header object using formatting result as its
 * value.  The function first prints the arguments according to
 * the format @a fmt specified.  Then it allocates a new header
 * structure, and uses the formatting result as the header
 * value.
 *
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 *
 * @note This function is usually implemented as a macro calling
 * msg_header_format().
 *
 * @return
 * The function http_last_modified_format() returns a pointer to newly
 * makes header structure, or NULL upon an error.
 *
 * @HIDE
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_last_modified_t *http_last_modified_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__malloc__, __format__ (printf, 2, 3)));


/* Inlined functions */
#if SU_HAVE_INLINE
su_inline
http_last_modified_t *http_last_modified_format(su_home_t *home, char const *fmt, ...)
{
  http_header_t *h;
  va_list ap;

  va_start(ap, fmt);
  h = http_header_vformat(home, http_last_modified_class, fmt, ap);
  va_end(ap);

  return (http_last_modified_t *)h;
}

su_inline
http_last_modified_t *http_last_modified_dup(su_home_t *home, http_last_modified_t const *o)
{
  return (http_last_modified_t *)
    msg_header_dup_as(home, http_last_modified_class, (msg_header_t const *)o);
}

su_inline
http_last_modified_t *http_last_modified_copy(su_home_t *home, http_last_modified_t const *o)
{
  return (http_last_modified_t *)
    msg_header_copy_as(home, http_last_modified_class, (msg_header_t const *)o);
}

su_inline
http_last_modified_t *http_last_modified_make(su_home_t *home, char const *s)
{
  return (http_last_modified_t *)http_header_make(home, http_last_modified_class, s);
}
#endif

#endif /* !define HTTP_HCLASSES_ONLY */

/** @} */


/* Declare internal prototypes for Location header */

/**@addtogroup http_location*/ /** @{ */

enum {
  /** Hash of Location header. @internal*/
  http_location_hash = 60949
};

/**Header class for HTTP Location header.
 *
 * The header class http_location_class defines how a HTTP
 * Location header is parsed and printed.  It also
 * contains methods used by HTTP parser and other functions
 * to manipulate the http_location_t header structure.
 *
 */
SOFIAPUBVAR msg_hclass_t http_location_class[];

#ifndef HTTP_HCLASSES_ONLY

/** Decode (parse) a Location header. @internal */
SOFIAPUBFUN msg_parse_f http_location_d;

/** Encode (print) a Location header. @internal */
SOFIAPUBFUN msg_print_f http_location_e;

/**Initializer for structure http_location_t.
 *
 * A static http_location_t structure must be initialized
 * with the HTTP_LOCATION_INIT() macro. For instance,
 * @code
 *
 *  http_location_t http_location = HTTP_LOCATION_INIT;
 *
 * @endcode
 * @HI
 */
#define HTTP_LOCATION_INIT() HTTP_HDR_INIT(location)

/**Initialize a structure http_location_t.
 *
 * An http_location_t structure can be initialized with the
 * http_location_init() function/macro. For instance,
 * @code
 *
 *  http_location_t http_location;
 *
 *  http_location_init(&http_location);
 *
 * @endcode
 * @HI
 */
#if SU_HAVE_INLINE
su_inline http_location_t *http_location_init(http_location_t x[1])
{
  return HTTP_HEADER_INIT(x, http_location_class, sizeof(http_location_t));
}
#else
#define http_location_init(x) \
  HTTP_HEADER_INIT(x, http_location_class, sizeof(http_location_t))
#endif

/**Test if header object is instance of http_location_t.
 *
 * The function http_is_location() returns true (nonzero) if
 * the header class is an instance of Location header
 * object and false (zero) otherwise.
 *
 * @param header pointer to the header structure to be tested
 *
 * @return
 * The function http_is_xlocation() returns true (nonzero) if
 * the header object is an instance of header location and
 * false (zero) otherwise.
 */
#if SU_HAVE_INLINE
su_inline
int http_is_location(http_header_t const *header)
{
  return header && header->sh_class->hc_hash == http_location_hash;
}
#else
#define http_is_location(h) \
 ((h) && ((msg_common_t *)(h))->h_class->hc_hash == http_location_hash)
#endif

/**Duplicate (deep copy) @c http_location_t.
 *
 * The function http_location_dup() duplicates a header
 * structure @a hdr.  If the header structure @a hdr
 * contains a reference (@c hdr->x_next) to a list of
 * headers, all the headers in the list are duplicated, too.
 *
 * @param home  memory home used to allocate new structure
 * @param hdr   header structure to be duplicated
 *
 * When duplicating, all parameter lists and non-constant
 * strings attached to the header are copied, too.  The
 * function uses given memory @a home to allocate all the
 * memory areas used to copy the header.
 *
 * @par Example
 * @code
 *
 *   location = http_location_dup(home, http->http_location);
 *
 * @endcode
 *
 * @return
 * The function http_location_dup() returns a pointer to the
 * newly duplicated http_location_t header structure, or NULL
 * upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_location_t *http_location_dup(su_home_t *home,
				   http_location_t const *hdr)
     __attribute__((__malloc__));

/**Copy a http_location_t header structure.
 *
 * The function http_location_copy() copies a header structure @a
 * hdr.  If the header structure @a hdr contains a reference (@c
 * hdr->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home
 * to allocate all the memory areas used to copy the header
 * structure @a hdr.
 *
 * @param home    memory home used to allocate new structure
 * @param hdr     pointer to the header structure to be duplicated
 *
 * When copying, only the header structure and parameter lists
 * attached to it are duplicated.  The new header structure
 * retains all the references to the strings within the old @a
 * header, including the encoding of the old header, if present.
 *
 * @par Example
 * @code
 *
 *   location = http_location_copy(home, http->http_location);
 *
 * @endcode
 *
 * @return
 * The function http_location_copy() returns a pointer to
 * newly copied header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_location_t *http_location_copy(su_home_t *home,
				    http_location_t const *hdr)
     __attribute__((__malloc__));

/**Make a header structure http_location_t.
 *
 * The function http_location_make() makes a new
 * http_location_t header structure.  It allocates a new
 * header structure, and decodes the string @a s as the
 * value of the structure.
 *
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 *
 * @note This function is usually implemented as a macro calling
 * http_header_make().
 *
 * @return
 * The function http_location_make() returns a pointer to
 * newly maked http_location_t header structure, or NULL upon
 * an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_location_t *http_location_make(su_home_t *home, char const *s)
     __attribute__((__malloc__));

/**Make a Location header from formatting result.
 *
 * The function http_location_format() makes a new
 * Location header object using formatting result as its
 * value.  The function first prints the arguments according to
 * the format @a fmt specified.  Then it allocates a new header
 * structure, and uses the formatting result as the header
 * value.
 *
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 *
 * @note This function is usually implemented as a macro calling
 * msg_header_format().
 *
 * @return
 * The function http_location_format() returns a pointer to newly
 * makes header structure, or NULL upon an error.
 *
 * @HIDE
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_location_t *http_location_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__malloc__, __format__ (printf, 2, 3)));


/* Inlined functions */
#if SU_HAVE_INLINE
su_inline
http_location_t *http_location_format(su_home_t *home, char const *fmt, ...)
{
  http_header_t *h;
  va_list ap;

  va_start(ap, fmt);
  h = http_header_vformat(home, http_location_class, fmt, ap);
  va_end(ap);

  return (http_location_t *)h;
}

su_inline
http_location_t *http_location_dup(su_home_t *home, http_location_t const *o)
{
  return (http_location_t *)
    msg_header_dup_as(home, http_location_class, (msg_header_t const *)o);
}

su_inline
http_location_t *http_location_copy(su_home_t *home, http_location_t const *o)
{
  return (http_location_t *)
    msg_header_copy_as(home, http_location_class, (msg_header_t const *)o);
}

su_inline
http_location_t *http_location_make(su_home_t *home, char const *s)
{
  return (http_location_t *)http_header_make(home, http_location_class, s);
}
#endif

#endif /* !define HTTP_HCLASSES_ONLY */

/** @} */


/* Declare internal prototypes for Max-Forwards header */

/**@addtogroup http_max_forwards*/ /** @{ */

enum {
  /** Hash of Max-Forwards header. @internal*/
  http_max_forwards_hash = 27231
};

/**Header class for HTTP Max-Forwards header.
 *
 * The header class http_max_forwards_class defines how a HTTP
 * Max-Forwards header is parsed and printed.  It also
 * contains methods used by HTTP parser and other functions
 * to manipulate the http_max_forwards_t header structure.
 *
 */
SOFIAPUBVAR msg_hclass_t http_max_forwards_class[];

#ifndef HTTP_HCLASSES_ONLY

/** Decode (parse) a Max-Forwards header. @internal */
SOFIAPUBFUN msg_parse_f http_max_forwards_d;

/** Encode (print) a Max-Forwards header. @internal */
SOFIAPUBFUN msg_print_f http_max_forwards_e;

/**Initializer for structure http_max_forwards_t.
 *
 * A static http_max_forwards_t structure must be initialized
 * with the HTTP_MAX_FORWARDS_INIT() macro. For instance,
 * @code
 *
 *  http_max_forwards_t http_max_forwards = HTTP_MAX_FORWARDS_INIT;
 *
 * @endcode
 * @HI
 */
#define HTTP_MAX_FORWARDS_INIT() HTTP_HDR_INIT(max_forwards)

/**Initialize a structure http_max_forwards_t.
 *
 * An http_max_forwards_t structure can be initialized with the
 * http_max_forwards_init() function/macro. For instance,
 * @code
 *
 *  http_max_forwards_t http_max_forwards;
 *
 *  http_max_forwards_init(&http_max_forwards);
 *
 * @endcode
 * @HI
 */
#if SU_HAVE_INLINE
su_inline http_max_forwards_t *http_max_forwards_init(http_max_forwards_t x[1])
{
  return HTTP_HEADER_INIT(x, http_max_forwards_class, sizeof(http_max_forwards_t));
}
#else
#define http_max_forwards_init(x) \
  HTTP_HEADER_INIT(x, http_max_forwards_class, sizeof(http_max_forwards_t))
#endif

/**Test if header object is instance of http_max_forwards_t.
 *
 * The function http_is_max_forwards() returns true (nonzero) if
 * the header class is an instance of Max-Forwards header
 * object and false (zero) otherwise.
 *
 * @param header pointer to the header structure to be tested
 *
 * @return
 * The function http_is_xmax_forwards() returns true (nonzero) if
 * the header object is an instance of header max_forwards and
 * false (zero) otherwise.
 */
#if SU_HAVE_INLINE
su_inline
int http_is_max_forwards(http_header_t const *header)
{
  return header && header->sh_class->hc_hash == http_max_forwards_hash;
}
#else
#define http_is_max_forwards(h) \
 ((h) && ((msg_common_t *)(h))->h_class->hc_hash == http_max_forwards_hash)
#endif

/**Duplicate (deep copy) @c http_max_forwards_t.
 *
 * The function http_max_forwards_dup() duplicates a header
 * structure @a hdr.  If the header structure @a hdr
 * contains a reference (@c hdr->x_next) to a list of
 * headers, all the headers in the list are duplicated, too.
 *
 * @param home  memory home used to allocate new structure
 * @param hdr   header structure to be duplicated
 *
 * When duplicating, all parameter lists and non-constant
 * strings attached to the header are copied, too.  The
 * function uses given memory @a home to allocate all the
 * memory areas used to copy the header.
 *
 * @par Example
 * @code
 *
 *   max_forwards = http_max_forwards_dup(home, http->http_max_forwards);
 *
 * @endcode
 *
 * @return
 * The function http_max_forwards_dup() returns a pointer to the
 * newly duplicated http_max_forwards_t header structure, or NULL
 * upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_max_forwards_t *http_max_forwards_dup(su_home_t *home,
				   http_max_forwards_t const *hdr)
     __attribute__((__malloc__));

/**Copy a http_max_forwards_t header structure.
 *
 * The function http_max_forwards_copy() copies a header structure @a
 * hdr.  If the header structure @a hdr contains a reference (@c
 * hdr->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home
 * to allocate all the memory areas used to copy the header
 * structure @a hdr.
 *
 * @param home    memory home used to allocate new structure
 * @param hdr     pointer to the header structure to be duplicated
 *
 * When copying, only the header structure and parameter lists
 * attached to it are duplicated.  The new header structure
 * retains all the references to the strings within the old @a
 * header, including the encoding of the old header, if present.
 *
 * @par Example
 * @code
 *
 *   max_forwards = http_max_forwards_copy(home, http->http_max_forwards);
 *
 * @endcode
 *
 * @return
 * The function http_max_forwards_copy() returns a pointer to
 * newly copied header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_max_forwards_t *http_max_forwards_copy(su_home_t *home,
				    http_max_forwards_t const *hdr)
     __attribute__((__malloc__));

/**Make a header structure http_max_forwards_t.
 *
 * The function http_max_forwards_make() makes a new
 * http_max_forwards_t header structure.  It allocates a new
 * header structure, and decodes the string @a s as the
 * value of the structure.
 *
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 *
 * @note This function is usually implemented as a macro calling
 * http_header_make().
 *
 * @return
 * The function http_max_forwards_make() returns a pointer to
 * newly maked http_max_forwards_t header structure, or NULL upon
 * an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_max_forwards_t *http_max_forwards_make(su_home_t *home, char const *s)
     __attribute__((__malloc__));

/**Make a Max-Forwards header from formatting result.
 *
 * The function http_max_forwards_format() makes a new
 * Max-Forwards header object using formatting result as its
 * value.  The function first prints the arguments according to
 * the format @a fmt specified.  Then it allocates a new header
 * structure, and uses the formatting result as the header
 * value.
 *
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 *
 * @note This function is usually implemented as a macro calling
 * msg_header_format().
 *
 * @return
 * The function http_max_forwards_format() returns a pointer to newly
 * makes header structure, or NULL upon an error.
 *
 * @HIDE
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_max_forwards_t *http_max_forwards_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__malloc__, __format__ (printf, 2, 3)));


/* Inlined functions */
#if SU_HAVE_INLINE
su_inline
http_max_forwards_t *http_max_forwards_format(su_home_t *home, char const *fmt, ...)
{
  http_header_t *h;
  va_list ap;

  va_start(ap, fmt);
  h = http_header_vformat(home, http_max_forwards_class, fmt, ap);
  va_end(ap);

  return (http_max_forwards_t *)h;
}

su_inline
http_max_forwards_t *http_max_forwards_dup(su_home_t *home, http_max_forwards_t const *o)
{
  return (http_max_forwards_t *)
    msg_header_dup_as(home, http_max_forwards_class, (msg_header_t const *)o);
}

su_inline
http_max_forwards_t *http_max_forwards_copy(su_home_t *home, http_max_forwards_t const *o)
{
  return (http_max_forwards_t *)
    msg_header_copy_as(home, http_max_forwards_class, (msg_header_t const *)o);
}

su_inline
http_max_forwards_t *http_max_forwards_make(su_home_t *home, char const *s)
{
  return (http_max_forwards_t *)http_header_make(home, http_max_forwards_class, s);
}
#endif

#endif /* !define HTTP_HCLASSES_ONLY */

/** @} */


/* Declare internal prototypes for Pragma header */

/**@addtogroup http_pragma*/ /** @{ */

enum {
  /** Hash of Pragma header. @internal*/
  http_pragma_hash = 49776
};

/**Header class for HTTP Pragma header.
 *
 * The header class http_pragma_class defines how a HTTP
 * Pragma header is parsed and printed.  It also
 * contains methods used by HTTP parser and other functions
 * to manipulate the http_pragma_t header structure.
 *
 */
SOFIAPUBVAR msg_hclass_t http_pragma_class[];

#ifndef HTTP_HCLASSES_ONLY

/** Decode (parse) a Pragma header. @internal */
SOFIAPUBFUN msg_parse_f http_pragma_d;

/** Encode (print) a Pragma header. @internal */
SOFIAPUBFUN msg_print_f http_pragma_e;

/**Initializer for structure http_pragma_t.
 *
 * A static http_pragma_t structure must be initialized
 * with the HTTP_PRAGMA_INIT() macro. For instance,
 * @code
 *
 *  http_pragma_t http_pragma = HTTP_PRAGMA_INIT;
 *
 * @endcode
 * @HI
 */
#define HTTP_PRAGMA_INIT() HTTP_HDR_INIT(pragma)

/**Initialize a structure http_pragma_t.
 *
 * An http_pragma_t structure can be initialized with the
 * http_pragma_init() function/macro. For instance,
 * @code
 *
 *  http_pragma_t http_pragma;
 *
 *  http_pragma_init(&http_pragma);
 *
 * @endcode
 * @HI
 */
#if SU_HAVE_INLINE
su_inline http_pragma_t *http_pragma_init(http_pragma_t x[1])
{
  return HTTP_HEADER_INIT(x, http_pragma_class, sizeof(http_pragma_t));
}
#else
#define http_pragma_init(x) \
  HTTP_HEADER_INIT(x, http_pragma_class, sizeof(http_pragma_t))
#endif

/**Test if header object is instance of http_pragma_t.
 *
 * The function http_is_pragma() returns true (nonzero) if
 * the header class is an instance of Pragma header
 * object and false (zero) otherwise.
 *
 * @param header pointer to the header structure to be tested
 *
 * @return
 * The function http_is_xpragma() returns true (nonzero) if
 * the header object is an instance of header pragma and
 * false (zero) otherwise.
 */
#if SU_HAVE_INLINE
su_inline
int http_is_pragma(http_header_t const *header)
{
  return header && header->sh_class->hc_hash == http_pragma_hash;
}
#else
#define http_is_pragma(h) \
 ((h) && ((msg_common_t *)(h))->h_class->hc_hash == http_pragma_hash)
#endif

/**Duplicate (deep copy) @c http_pragma_t.
 *
 * The function http_pragma_dup() duplicates a header
 * structure @a hdr.  If the header structure @a hdr
 * contains a reference (@c hdr->x_next) to a list of
 * headers, all the headers in the list are duplicated, too.
 *
 * @param home  memory home used to allocate new structure
 * @param hdr   header structure to be duplicated
 *
 * When duplicating, all parameter lists and non-constant
 * strings attached to the header are copied, too.  The
 * function uses given memory @a home to allocate all the
 * memory areas used to copy the header.
 *
 * @par Example
 * @code
 *
 *   pragma = http_pragma_dup(home, http->http_pragma);
 *
 * @endcode
 *
 * @return
 * The function http_pragma_dup() returns a pointer to the
 * newly duplicated http_pragma_t header structure, or NULL
 * upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_pragma_t *http_pragma_dup(su_home_t *home,
				   http_pragma_t const *hdr)
     __attribute__((__malloc__));

/**Copy a http_pragma_t header structure.
 *
 * The function http_pragma_copy() copies a header structure @a
 * hdr.  If the header structure @a hdr contains a reference (@c
 * hdr->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home
 * to allocate all the memory areas used to copy the header
 * structure @a hdr.
 *
 * @param home    memory home used to allocate new structure
 * @param hdr     pointer to the header structure to be duplicated
 *
 * When copying, only the header structure and parameter lists
 * attached to it are duplicated.  The new header structure
 * retains all the references to the strings within the old @a
 * header, including the encoding of the old header, if present.
 *
 * @par Example
 * @code
 *
 *   pragma = http_pragma_copy(home, http->http_pragma);
 *
 * @endcode
 *
 * @return
 * The function http_pragma_copy() returns a pointer to
 * newly copied header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_pragma_t *http_pragma_copy(su_home_t *home,
				    http_pragma_t const *hdr)
     __attribute__((__malloc__));

/**Make a header structure http_pragma_t.
 *
 * The function http_pragma_make() makes a new
 * http_pragma_t header structure.  It allocates a new
 * header structure, and decodes the string @a s as the
 * value of the structure.
 *
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 *
 * @note This function is usually implemented as a macro calling
 * http_header_make().
 *
 * @return
 * The function http_pragma_make() returns a pointer to
 * newly maked http_pragma_t header structure, or NULL upon
 * an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_pragma_t *http_pragma_make(su_home_t *home, char const *s)
     __attribute__((__malloc__));

/**Make a Pragma header from formatting result.
 *
 * The function http_pragma_format() makes a new
 * Pragma header object using formatting result as its
 * value.  The function first prints the arguments according to
 * the format @a fmt specified.  Then it allocates a new header
 * structure, and uses the formatting result as the header
 * value.
 *
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 *
 * @note This function is usually implemented as a macro calling
 * msg_header_format().
 *
 * @return
 * The function http_pragma_format() returns a pointer to newly
 * makes header structure, or NULL upon an error.
 *
 * @HIDE
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_pragma_t *http_pragma_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__malloc__, __format__ (printf, 2, 3)));


/* Inlined functions */
#if SU_HAVE_INLINE
su_inline
http_pragma_t *http_pragma_format(su_home_t *home, char const *fmt, ...)
{
  http_header_t *h;
  va_list ap;

  va_start(ap, fmt);
  h = http_header_vformat(home, http_pragma_class, fmt, ap);
  va_end(ap);

  return (http_pragma_t *)h;
}

su_inline
http_pragma_t *http_pragma_dup(su_home_t *home, http_pragma_t const *o)
{
  return (http_pragma_t *)
    msg_header_dup_as(home, http_pragma_class, (msg_header_t const *)o);
}

su_inline
http_pragma_t *http_pragma_copy(su_home_t *home, http_pragma_t const *o)
{
  return (http_pragma_t *)
    msg_header_copy_as(home, http_pragma_class, (msg_header_t const *)o);
}

su_inline
http_pragma_t *http_pragma_make(su_home_t *home, char const *s)
{
  return (http_pragma_t *)http_header_make(home, http_pragma_class, s);
}
#endif

#endif /* !define HTTP_HCLASSES_ONLY */

/** @} */


/* Declare internal prototypes for Proxy-Authenticate header */

/**@addtogroup http_proxy_authenticate*/ /** @{ */

enum {
  /** Hash of Proxy-Authenticate header. @internal*/
  http_proxy_authenticate_hash = 57658
};

/**Header class for HTTP Proxy-Authenticate header.
 *
 * The header class http_proxy_authenticate_class defines how a HTTP
 * Proxy-Authenticate header is parsed and printed.  It also
 * contains methods used by HTTP parser and other functions
 * to manipulate the http_proxy_authenticate_t header structure.
 *
 */
SOFIAPUBVAR msg_hclass_t http_proxy_authenticate_class[];

#ifndef HTTP_HCLASSES_ONLY

/** Decode (parse) a Proxy-Authenticate header. @internal */
SOFIAPUBFUN msg_parse_f http_proxy_authenticate_d;

/** Encode (print) a Proxy-Authenticate header. @internal */
SOFIAPUBFUN msg_print_f http_proxy_authenticate_e;

/**Initializer for structure http_proxy_authenticate_t.
 *
 * A static http_proxy_authenticate_t structure must be initialized
 * with the HTTP_PROXY_AUTHENTICATE_INIT() macro. For instance,
 * @code
 *
 *  http_proxy_authenticate_t http_proxy_authenticate = HTTP_PROXY_AUTHENTICATE_INIT;
 *
 * @endcode
 * @HI
 */
#define HTTP_PROXY_AUTHENTICATE_INIT() HTTP_HDR_INIT(proxy_authenticate)

/**Initialize a structure http_proxy_authenticate_t.
 *
 * An http_proxy_authenticate_t structure can be initialized with the
 * http_proxy_authenticate_init() function/macro. For instance,
 * @code
 *
 *  http_proxy_authenticate_t http_proxy_authenticate;
 *
 *  http_proxy_authenticate_init(&http_proxy_authenticate);
 *
 * @endcode
 * @HI
 */
#if SU_HAVE_INLINE
su_inline http_proxy_authenticate_t *http_proxy_authenticate_init(http_proxy_authenticate_t x[1])
{
  return HTTP_HEADER_INIT(x, http_proxy_authenticate_class, sizeof(http_proxy_authenticate_t));
}
#else
#define http_proxy_authenticate_init(x) \
  HTTP_HEADER_INIT(x, http_proxy_authenticate_class, sizeof(http_proxy_authenticate_t))
#endif

/**Test if header object is instance of http_proxy_authenticate_t.
 *
 * The function http_is_proxy_authenticate() returns true (nonzero) if
 * the header class is an instance of Proxy-Authenticate header
 * object and false (zero) otherwise.
 *
 * @param header pointer to the header structure to be tested
 *
 * @return
 * The function http_is_xproxy_authenticate() returns true (nonzero) if
 * the header object is an instance of header proxy_authenticate and
 * false (zero) otherwise.
 */
#if SU_HAVE_INLINE
su_inline
int http_is_proxy_authenticate(http_header_t const *header)
{
  return header && header->sh_class->hc_hash == http_proxy_authenticate_hash;
}
#else
#define http_is_proxy_authenticate(h) \
 ((h) && ((msg_common_t *)(h))->h_class->hc_hash == http_proxy_authenticate_hash)
#endif

/**Duplicate (deep copy) @c http_proxy_authenticate_t.
 *
 * The function http_proxy_authenticate_dup() duplicates a header
 * structure @a hdr.  If the header structure @a hdr
 * contains a reference (@c hdr->x_next) to a list of
 * headers, all the headers in the list are duplicated, too.
 *
 * @param home  memory home used to allocate new structure
 * @param hdr   header structure to be duplicated
 *
 * When duplicating, all parameter lists and non-constant
 * strings attached to the header are copied, too.  The
 * function uses given memory @a home to allocate all the
 * memory areas used to copy the header.
 *
 * @par Example
 * @code
 *
 *   proxy_authenticate = http_proxy_authenticate_dup(home, http->http_proxy_authenticate);
 *
 * @endcode
 *
 * @return
 * The function http_proxy_authenticate_dup() returns a pointer to the
 * newly duplicated http_proxy_authenticate_t header structure, or NULL
 * upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_proxy_authenticate_t *http_proxy_authenticate_dup(su_home_t *home,
				   http_proxy_authenticate_t const *hdr)
     __attribute__((__malloc__));

/**Copy a http_proxy_authenticate_t header structure.
 *
 * The function http_proxy_authenticate_copy() copies a header structure @a
 * hdr.  If the header structure @a hdr contains a reference (@c
 * hdr->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home
 * to allocate all the memory areas used to copy the header
 * structure @a hdr.
 *
 * @param home    memory home used to allocate new structure
 * @param hdr     pointer to the header structure to be duplicated
 *
 * When copying, only the header structure and parameter lists
 * attached to it are duplicated.  The new header structure
 * retains all the references to the strings within the old @a
 * header, including the encoding of the old header, if present.
 *
 * @par Example
 * @code
 *
 *   proxy_authenticate = http_proxy_authenticate_copy(home, http->http_proxy_authenticate);
 *
 * @endcode
 *
 * @return
 * The function http_proxy_authenticate_copy() returns a pointer to
 * newly copied header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_proxy_authenticate_t *http_proxy_authenticate_copy(su_home_t *home,
				    http_proxy_authenticate_t const *hdr)
     __attribute__((__malloc__));

/**Make a header structure http_proxy_authenticate_t.
 *
 * The function http_proxy_authenticate_make() makes a new
 * http_proxy_authenticate_t header structure.  It allocates a new
 * header structure, and decodes the string @a s as the
 * value of the structure.
 *
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 *
 * @note This function is usually implemented as a macro calling
 * http_header_make().
 *
 * @return
 * The function http_proxy_authenticate_make() returns a pointer to
 * newly maked http_proxy_authenticate_t header structure, or NULL upon
 * an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_proxy_authenticate_t *http_proxy_authenticate_make(su_home_t *home, char const *s)
     __attribute__((__malloc__));

/**Make a Proxy-Authenticate header from formatting result.
 *
 * The function http_proxy_authenticate_format() makes a new
 * Proxy-Authenticate header object using formatting result as its
 * value.  The function first prints the arguments according to
 * the format @a fmt specified.  Then it allocates a new header
 * structure, and uses the formatting result as the header
 * value.
 *
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 *
 * @note This function is usually implemented as a macro calling
 * msg_header_format().
 *
 * @return
 * The function http_proxy_authenticate_format() returns a pointer to newly
 * makes header structure, or NULL upon an error.
 *
 * @HIDE
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_proxy_authenticate_t *http_proxy_authenticate_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__malloc__, __format__ (printf, 2, 3)));


/* Inlined functions */
#if SU_HAVE_INLINE
su_inline
http_proxy_authenticate_t *http_proxy_authenticate_format(su_home_t *home, char const *fmt, ...)
{
  http_header_t *h;
  va_list ap;

  va_start(ap, fmt);
  h = http_header_vformat(home, http_proxy_authenticate_class, fmt, ap);
  va_end(ap);

  return (http_proxy_authenticate_t *)h;
}

su_inline
http_proxy_authenticate_t *http_proxy_authenticate_dup(su_home_t *home, http_proxy_authenticate_t const *o)
{
  return (http_proxy_authenticate_t *)
    msg_header_dup_as(home, http_proxy_authenticate_class, (msg_header_t const *)o);
}

su_inline
http_proxy_authenticate_t *http_proxy_authenticate_copy(su_home_t *home, http_proxy_authenticate_t const *o)
{
  return (http_proxy_authenticate_t *)
    msg_header_copy_as(home, http_proxy_authenticate_class, (msg_header_t const *)o);
}

su_inline
http_proxy_authenticate_t *http_proxy_authenticate_make(su_home_t *home, char const *s)
{
  return (http_proxy_authenticate_t *)http_header_make(home, http_proxy_authenticate_class, s);
}
#endif

#endif /* !define HTTP_HCLASSES_ONLY */

/** @} */


/* Declare internal prototypes for Proxy-Authorization header */

/**@addtogroup http_proxy_authorization*/ /** @{ */

enum {
  /** Hash of Proxy-Authorization header. @internal*/
  http_proxy_authorization_hash = 21244
};

/**Header class for HTTP Proxy-Authorization header.
 *
 * The header class http_proxy_authorization_class defines how a HTTP
 * Proxy-Authorization header is parsed and printed.  It also
 * contains methods used by HTTP parser and other functions
 * to manipulate the http_proxy_authorization_t header structure.
 *
 */
SOFIAPUBVAR msg_hclass_t http_proxy_authorization_class[];

#ifndef HTTP_HCLASSES_ONLY

/** Decode (parse) a Proxy-Authorization header. @internal */
SOFIAPUBFUN msg_parse_f http_proxy_authorization_d;

/** Encode (print) a Proxy-Authorization header. @internal */
SOFIAPUBFUN msg_print_f http_proxy_authorization_e;

/**Initializer for structure http_proxy_authorization_t.
 *
 * A static http_proxy_authorization_t structure must be initialized
 * with the HTTP_PROXY_AUTHORIZATION_INIT() macro. For instance,
 * @code
 *
 *  http_proxy_authorization_t http_proxy_authorization = HTTP_PROXY_AUTHORIZATION_INIT;
 *
 * @endcode
 * @HI
 */
#define HTTP_PROXY_AUTHORIZATION_INIT() HTTP_HDR_INIT(proxy_authorization)

/**Initialize a structure http_proxy_authorization_t.
 *
 * An http_proxy_authorization_t structure can be initialized with the
 * http_proxy_authorization_init() function/macro. For instance,
 * @code
 *
 *  http_proxy_authorization_t http_proxy_authorization;
 *
 *  http_proxy_authorization_init(&http_proxy_authorization);
 *
 * @endcode
 * @HI
 */
#if SU_HAVE_INLINE
su_inline http_proxy_authorization_t *http_proxy_authorization_init(http_proxy_authorization_t x[1])
{
  return HTTP_HEADER_INIT(x, http_proxy_authorization_class, sizeof(http_proxy_authorization_t));
}
#else
#define http_proxy_authorization_init(x) \
  HTTP_HEADER_INIT(x, http_proxy_authorization_class, sizeof(http_proxy_authorization_t))
#endif

/**Test if header object is instance of http_proxy_authorization_t.
 *
 * The function http_is_proxy_authorization() returns true (nonzero) if
 * the header class is an instance of Proxy-Authorization header
 * object and false (zero) otherwise.
 *
 * @param header pointer to the header structure to be tested
 *
 * @return
 * The function http_is_xproxy_authorization() returns true (nonzero) if
 * the header object is an instance of header proxy_authorization and
 * false (zero) otherwise.
 */
#if SU_HAVE_INLINE
su_inline
int http_is_proxy_authorization(http_header_t const *header)
{
  return header && header->sh_class->hc_hash == http_proxy_authorization_hash;
}
#else
#define http_is_proxy_authorization(h) \
 ((h) && ((msg_common_t *)(h))->h_class->hc_hash == http_proxy_authorization_hash)
#endif

/**Duplicate (deep copy) @c http_proxy_authorization_t.
 *
 * The function http_proxy_authorization_dup() duplicates a header
 * structure @a hdr.  If the header structure @a hdr
 * contains a reference (@c hdr->x_next) to a list of
 * headers, all the headers in the list are duplicated, too.
 *
 * @param home  memory home used to allocate new structure
 * @param hdr   header structure to be duplicated
 *
 * When duplicating, all parameter lists and non-constant
 * strings attached to the header are copied, too.  The
 * function uses given memory @a home to allocate all the
 * memory areas used to copy the header.
 *
 * @par Example
 * @code
 *
 *   proxy_authorization = http_proxy_authorization_dup(home, http->http_proxy_authorization);
 *
 * @endcode
 *
 * @return
 * The function http_proxy_authorization_dup() returns a pointer to the
 * newly duplicated http_proxy_authorization_t header structure, or NULL
 * upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_proxy_authorization_t *http_proxy_authorization_dup(su_home_t *home,
				   http_proxy_authorization_t const *hdr)
     __attribute__((__malloc__));

/**Copy a http_proxy_authorization_t header structure.
 *
 * The function http_proxy_authorization_copy() copies a header structure @a
 * hdr.  If the header structure @a hdr contains a reference (@c
 * hdr->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home
 * to allocate all the memory areas used to copy the header
 * structure @a hdr.
 *
 * @param home    memory home used to allocate new structure
 * @param hdr     pointer to the header structure to be duplicated
 *
 * When copying, only the header structure and parameter lists
 * attached to it are duplicated.  The new header structure
 * retains all the references to the strings within the old @a
 * header, including the encoding of the old header, if present.
 *
 * @par Example
 * @code
 *
 *   proxy_authorization = http_proxy_authorization_copy(home, http->http_proxy_authorization);
 *
 * @endcode
 *
 * @return
 * The function http_proxy_authorization_copy() returns a pointer to
 * newly copied header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_proxy_authorization_t *http_proxy_authorization_copy(su_home_t *home,
				    http_proxy_authorization_t const *hdr)
     __attribute__((__malloc__));

/**Make a header structure http_proxy_authorization_t.
 *
 * The function http_proxy_authorization_make() makes a new
 * http_proxy_authorization_t header structure.  It allocates a new
 * header structure, and decodes the string @a s as the
 * value of the structure.
 *
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 *
 * @note This function is usually implemented as a macro calling
 * http_header_make().
 *
 * @return
 * The function http_proxy_authorization_make() returns a pointer to
 * newly maked http_proxy_authorization_t header structure, or NULL upon
 * an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_proxy_authorization_t *http_proxy_authorization_make(su_home_t *home, char const *s)
     __attribute__((__malloc__));

/**Make a Proxy-Authorization header from formatting result.
 *
 * The function http_proxy_authorization_format() makes a new
 * Proxy-Authorization header object using formatting result as its
 * value.  The function first prints the arguments according to
 * the format @a fmt specified.  Then it allocates a new header
 * structure, and uses the formatting result as the header
 * value.
 *
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 *
 * @note This function is usually implemented as a macro calling
 * msg_header_format().
 *
 * @return
 * The function http_proxy_authorization_format() returns a pointer to newly
 * makes header structure, or NULL upon an error.
 *
 * @HIDE
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_proxy_authorization_t *http_proxy_authorization_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__malloc__, __format__ (printf, 2, 3)));


/* Inlined functions */
#if SU_HAVE_INLINE
su_inline
http_proxy_authorization_t *http_proxy_authorization_format(su_home_t *home, char const *fmt, ...)
{
  http_header_t *h;
  va_list ap;

  va_start(ap, fmt);
  h = http_header_vformat(home, http_proxy_authorization_class, fmt, ap);
  va_end(ap);

  return (http_proxy_authorization_t *)h;
}

su_inline
http_proxy_authorization_t *http_proxy_authorization_dup(su_home_t *home, http_proxy_authorization_t const *o)
{
  return (http_proxy_authorization_t *)
    msg_header_dup_as(home, http_proxy_authorization_class, (msg_header_t const *)o);
}

su_inline
http_proxy_authorization_t *http_proxy_authorization_copy(su_home_t *home, http_proxy_authorization_t const *o)
{
  return (http_proxy_authorization_t *)
    msg_header_copy_as(home, http_proxy_authorization_class, (msg_header_t const *)o);
}

su_inline
http_proxy_authorization_t *http_proxy_authorization_make(su_home_t *home, char const *s)
{
  return (http_proxy_authorization_t *)http_header_make(home, http_proxy_authorization_class, s);
}
#endif

#endif /* !define HTTP_HCLASSES_ONLY */

/** @} */


/* Declare internal prototypes for Range header */

/**@addtogroup http_range*/ /** @{ */

enum {
  /** Hash of Range header. @internal*/
  http_range_hash = 20297
};

/**Header class for HTTP Range header.
 *
 * The header class http_range_class defines how a HTTP
 * Range header is parsed and printed.  It also
 * contains methods used by HTTP parser and other functions
 * to manipulate the http_range_t header structure.
 *
 */
SOFIAPUBVAR msg_hclass_t http_range_class[];

#ifndef HTTP_HCLASSES_ONLY

/** Decode (parse) a Range header. @internal */
SOFIAPUBFUN msg_parse_f http_range_d;

/** Encode (print) a Range header. @internal */
SOFIAPUBFUN msg_print_f http_range_e;

/**Initializer for structure http_range_t.
 *
 * A static http_range_t structure must be initialized
 * with the HTTP_RANGE_INIT() macro. For instance,
 * @code
 *
 *  http_range_t http_range = HTTP_RANGE_INIT;
 *
 * @endcode
 * @HI
 */
#define HTTP_RANGE_INIT() HTTP_HDR_INIT(range)

/**Initialize a structure http_range_t.
 *
 * An http_range_t structure can be initialized with the
 * http_range_init() function/macro. For instance,
 * @code
 *
 *  http_range_t http_range;
 *
 *  http_range_init(&http_range);
 *
 * @endcode
 * @HI
 */
#if SU_HAVE_INLINE
su_inline http_range_t *http_range_init(http_range_t x[1])
{
  return HTTP_HEADER_INIT(x, http_range_class, sizeof(http_range_t));
}
#else
#define http_range_init(x) \
  HTTP_HEADER_INIT(x, http_range_class, sizeof(http_range_t))
#endif

/**Test if header object is instance of http_range_t.
 *
 * The function http_is_range() returns true (nonzero) if
 * the header class is an instance of Range header
 * object and false (zero) otherwise.
 *
 * @param header pointer to the header structure to be tested
 *
 * @return
 * The function http_is_xrange() returns true (nonzero) if
 * the header object is an instance of header range and
 * false (zero) otherwise.
 */
#if SU_HAVE_INLINE
su_inline
int http_is_range(http_header_t const *header)
{
  return header && header->sh_class->hc_hash == http_range_hash;
}
#else
#define http_is_range(h) \
 ((h) && ((msg_common_t *)(h))->h_class->hc_hash == http_range_hash)
#endif

/**Duplicate (deep copy) @c http_range_t.
 *
 * The function http_range_dup() duplicates a header
 * structure @a hdr.  If the header structure @a hdr
 * contains a reference (@c hdr->x_next) to a list of
 * headers, all the headers in the list are duplicated, too.
 *
 * @param home  memory home used to allocate new structure
 * @param hdr   header structure to be duplicated
 *
 * When duplicating, all parameter lists and non-constant
 * strings attached to the header are copied, too.  The
 * function uses given memory @a home to allocate all the
 * memory areas used to copy the header.
 *
 * @par Example
 * @code
 *
 *   range = http_range_dup(home, http->http_range);
 *
 * @endcode
 *
 * @return
 * The function http_range_dup() returns a pointer to the
 * newly duplicated http_range_t header structure, or NULL
 * upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_range_t *http_range_dup(su_home_t *home,
				   http_range_t const *hdr)
     __attribute__((__malloc__));

/**Copy a http_range_t header structure.
 *
 * The function http_range_copy() copies a header structure @a
 * hdr.  If the header structure @a hdr contains a reference (@c
 * hdr->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home
 * to allocate all the memory areas used to copy the header
 * structure @a hdr.
 *
 * @param home    memory home used to allocate new structure
 * @param hdr     pointer to the header structure to be duplicated
 *
 * When copying, only the header structure and parameter lists
 * attached to it are duplicated.  The new header structure
 * retains all the references to the strings within the old @a
 * header, including the encoding of the old header, if present.
 *
 * @par Example
 * @code
 *
 *   range = http_range_copy(home, http->http_range);
 *
 * @endcode
 *
 * @return
 * The function http_range_copy() returns a pointer to
 * newly copied header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_range_t *http_range_copy(su_home_t *home,
				    http_range_t const *hdr)
     __attribute__((__malloc__));

/**Make a header structure http_range_t.
 *
 * The function http_range_make() makes a new
 * http_range_t header structure.  It allocates a new
 * header structure, and decodes the string @a s as the
 * value of the structure.
 *
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 *
 * @note This function is usually implemented as a macro calling
 * http_header_make().
 *
 * @return
 * The function http_range_make() returns a pointer to
 * newly maked http_range_t header structure, or NULL upon
 * an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_range_t *http_range_make(su_home_t *home, char const *s)
     __attribute__((__malloc__));

/**Make a Range header from formatting result.
 *
 * The function http_range_format() makes a new
 * Range header object using formatting result as its
 * value.  The function first prints the arguments according to
 * the format @a fmt specified.  Then it allocates a new header
 * structure, and uses the formatting result as the header
 * value.
 *
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 *
 * @note This function is usually implemented as a macro calling
 * msg_header_format().
 *
 * @return
 * The function http_range_format() returns a pointer to newly
 * makes header structure, or NULL upon an error.
 *
 * @HIDE
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_range_t *http_range_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__malloc__, __format__ (printf, 2, 3)));


/* Inlined functions */
#if SU_HAVE_INLINE
su_inline
http_range_t *http_range_format(su_home_t *home, char const *fmt, ...)
{
  http_header_t *h;
  va_list ap;

  va_start(ap, fmt);
  h = http_header_vformat(home, http_range_class, fmt, ap);
  va_end(ap);

  return (http_range_t *)h;
}

su_inline
http_range_t *http_range_dup(su_home_t *home, http_range_t const *o)
{
  return (http_range_t *)
    msg_header_dup_as(home, http_range_class, (msg_header_t const *)o);
}

su_inline
http_range_t *http_range_copy(su_home_t *home, http_range_t const *o)
{
  return (http_range_t *)
    msg_header_copy_as(home, http_range_class, (msg_header_t const *)o);
}

su_inline
http_range_t *http_range_make(su_home_t *home, char const *s)
{
  return (http_range_t *)http_header_make(home, http_range_class, s);
}
#endif

#endif /* !define HTTP_HCLASSES_ONLY */

/** @} */


/* Declare internal prototypes for Referer header */

/**@addtogroup http_referer*/ /** @{ */

enum {
  /** Hash of Referer header. @internal*/
  http_referer_hash = 64523
};

/**Header class for HTTP Referer header.
 *
 * The header class http_referer_class defines how a HTTP
 * Referer header is parsed and printed.  It also
 * contains methods used by HTTP parser and other functions
 * to manipulate the http_referer_t header structure.
 *
 */
SOFIAPUBVAR msg_hclass_t http_referer_class[];

#ifndef HTTP_HCLASSES_ONLY

/** Decode (parse) a Referer header. @internal */
SOFIAPUBFUN msg_parse_f http_referer_d;

/** Encode (print) a Referer header. @internal */
SOFIAPUBFUN msg_print_f http_referer_e;

/**Initializer for structure http_referer_t.
 *
 * A static http_referer_t structure must be initialized
 * with the HTTP_REFERER_INIT() macro. For instance,
 * @code
 *
 *  http_referer_t http_referer = HTTP_REFERER_INIT;
 *
 * @endcode
 * @HI
 */
#define HTTP_REFERER_INIT() HTTP_HDR_INIT(referer)

/**Initialize a structure http_referer_t.
 *
 * An http_referer_t structure can be initialized with the
 * http_referer_init() function/macro. For instance,
 * @code
 *
 *  http_referer_t http_referer;
 *
 *  http_referer_init(&http_referer);
 *
 * @endcode
 * @HI
 */
#if SU_HAVE_INLINE
su_inline http_referer_t *http_referer_init(http_referer_t x[1])
{
  return HTTP_HEADER_INIT(x, http_referer_class, sizeof(http_referer_t));
}
#else
#define http_referer_init(x) \
  HTTP_HEADER_INIT(x, http_referer_class, sizeof(http_referer_t))
#endif

/**Test if header object is instance of http_referer_t.
 *
 * The function http_is_referer() returns true (nonzero) if
 * the header class is an instance of Referer header
 * object and false (zero) otherwise.
 *
 * @param header pointer to the header structure to be tested
 *
 * @return
 * The function http_is_xreferer() returns true (nonzero) if
 * the header object is an instance of header referer and
 * false (zero) otherwise.
 */
#if SU_HAVE_INLINE
su_inline
int http_is_referer(http_header_t const *header)
{
  return header && header->sh_class->hc_hash == http_referer_hash;
}
#else
#define http_is_referer(h) \
 ((h) && ((msg_common_t *)(h))->h_class->hc_hash == http_referer_hash)
#endif

/**Duplicate (deep copy) @c http_referer_t.
 *
 * The function http_referer_dup() duplicates a header
 * structure @a hdr.  If the header structure @a hdr
 * contains a reference (@c hdr->x_next) to a list of
 * headers, all the headers in the list are duplicated, too.
 *
 * @param home  memory home used to allocate new structure
 * @param hdr   header structure to be duplicated
 *
 * When duplicating, all parameter lists and non-constant
 * strings attached to the header are copied, too.  The
 * function uses given memory @a home to allocate all the
 * memory areas used to copy the header.
 *
 * @par Example
 * @code
 *
 *   referer = http_referer_dup(home, http->http_referer);
 *
 * @endcode
 *
 * @return
 * The function http_referer_dup() returns a pointer to the
 * newly duplicated http_referer_t header structure, or NULL
 * upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_referer_t *http_referer_dup(su_home_t *home,
				   http_referer_t const *hdr)
     __attribute__((__malloc__));

/**Copy a http_referer_t header structure.
 *
 * The function http_referer_copy() copies a header structure @a
 * hdr.  If the header structure @a hdr contains a reference (@c
 * hdr->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home
 * to allocate all the memory areas used to copy the header
 * structure @a hdr.
 *
 * @param home    memory home used to allocate new structure
 * @param hdr     pointer to the header structure to be duplicated
 *
 * When copying, only the header structure and parameter lists
 * attached to it are duplicated.  The new header structure
 * retains all the references to the strings within the old @a
 * header, including the encoding of the old header, if present.
 *
 * @par Example
 * @code
 *
 *   referer = http_referer_copy(home, http->http_referer);
 *
 * @endcode
 *
 * @return
 * The function http_referer_copy() returns a pointer to
 * newly copied header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_referer_t *http_referer_copy(su_home_t *home,
				    http_referer_t const *hdr)
     __attribute__((__malloc__));

/**Make a header structure http_referer_t.
 *
 * The function http_referer_make() makes a new
 * http_referer_t header structure.  It allocates a new
 * header structure, and decodes the string @a s as the
 * value of the structure.
 *
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 *
 * @note This function is usually implemented as a macro calling
 * http_header_make().
 *
 * @return
 * The function http_referer_make() returns a pointer to
 * newly maked http_referer_t header structure, or NULL upon
 * an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_referer_t *http_referer_make(su_home_t *home, char const *s)
     __attribute__((__malloc__));

/**Make a Referer header from formatting result.
 *
 * The function http_referer_format() makes a new
 * Referer header object using formatting result as its
 * value.  The function first prints the arguments according to
 * the format @a fmt specified.  Then it allocates a new header
 * structure, and uses the formatting result as the header
 * value.
 *
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 *
 * @note This function is usually implemented as a macro calling
 * msg_header_format().
 *
 * @return
 * The function http_referer_format() returns a pointer to newly
 * makes header structure, or NULL upon an error.
 *
 * @HIDE
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_referer_t *http_referer_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__malloc__, __format__ (printf, 2, 3)));


/* Inlined functions */
#if SU_HAVE_INLINE
su_inline
http_referer_t *http_referer_format(su_home_t *home, char const *fmt, ...)
{
  http_header_t *h;
  va_list ap;

  va_start(ap, fmt);
  h = http_header_vformat(home, http_referer_class, fmt, ap);
  va_end(ap);

  return (http_referer_t *)h;
}

su_inline
http_referer_t *http_referer_dup(su_home_t *home, http_referer_t const *o)
{
  return (http_referer_t *)
    msg_header_dup_as(home, http_referer_class, (msg_header_t const *)o);
}

su_inline
http_referer_t *http_referer_copy(su_home_t *home, http_referer_t const *o)
{
  return (http_referer_t *)
    msg_header_copy_as(home, http_referer_class, (msg_header_t const *)o);
}

su_inline
http_referer_t *http_referer_make(su_home_t *home, char const *s)
{
  return (http_referer_t *)http_header_make(home, http_referer_class, s);
}
#endif

#endif /* !define HTTP_HCLASSES_ONLY */

/** @} */


/* Declare internal prototypes for Retry-After header */

/**@addtogroup http_retry_after*/ /** @{ */

enum {
  /** Hash of Retry-After header. @internal*/
  http_retry_after_hash = 30349
};

/**Header class for HTTP Retry-After header.
 *
 * The header class http_retry_after_class defines how a HTTP
 * Retry-After header is parsed and printed.  It also
 * contains methods used by HTTP parser and other functions
 * to manipulate the http_retry_after_t header structure.
 *
 */
SOFIAPUBVAR msg_hclass_t http_retry_after_class[];

#ifndef HTTP_HCLASSES_ONLY

/** Decode (parse) a Retry-After header. @internal */
SOFIAPUBFUN msg_parse_f http_retry_after_d;

/** Encode (print) a Retry-After header. @internal */
SOFIAPUBFUN msg_print_f http_retry_after_e;

/**Initializer for structure http_retry_after_t.
 *
 * A static http_retry_after_t structure must be initialized
 * with the HTTP_RETRY_AFTER_INIT() macro. For instance,
 * @code
 *
 *  http_retry_after_t http_retry_after = HTTP_RETRY_AFTER_INIT;
 *
 * @endcode
 * @HI
 */
#define HTTP_RETRY_AFTER_INIT() HTTP_HDR_INIT(retry_after)

/**Initialize a structure http_retry_after_t.
 *
 * An http_retry_after_t structure can be initialized with the
 * http_retry_after_init() function/macro. For instance,
 * @code
 *
 *  http_retry_after_t http_retry_after;
 *
 *  http_retry_after_init(&http_retry_after);
 *
 * @endcode
 * @HI
 */
#if SU_HAVE_INLINE
su_inline http_retry_after_t *http_retry_after_init(http_retry_after_t x[1])
{
  return HTTP_HEADER_INIT(x, http_retry_after_class, sizeof(http_retry_after_t));
}
#else
#define http_retry_after_init(x) \
  HTTP_HEADER_INIT(x, http_retry_after_class, sizeof(http_retry_after_t))
#endif

/**Test if header object is instance of http_retry_after_t.
 *
 * The function http_is_retry_after() returns true (nonzero) if
 * the header class is an instance of Retry-After header
 * object and false (zero) otherwise.
 *
 * @param header pointer to the header structure to be tested
 *
 * @return
 * The function http_is_xretry_after() returns true (nonzero) if
 * the header object is an instance of header retry_after and
 * false (zero) otherwise.
 */
#if SU_HAVE_INLINE
su_inline
int http_is_retry_after(http_header_t const *header)
{
  return header && header->sh_class->hc_hash == http_retry_after_hash;
}
#else
#define http_is_retry_after(h) \
 ((h) && ((msg_common_t *)(h))->h_class->hc_hash == http_retry_after_hash)
#endif

/**Duplicate (deep copy) @c http_retry_after_t.
 *
 * The function http_retry_after_dup() duplicates a header
 * structure @a hdr.  If the header structure @a hdr
 * contains a reference (@c hdr->x_next) to a list of
 * headers, all the headers in the list are duplicated, too.
 *
 * @param home  memory home used to allocate new structure
 * @param hdr   header structure to be duplicated
 *
 * When duplicating, all parameter lists and non-constant
 * strings attached to the header are copied, too.  The
 * function uses given memory @a home to allocate all the
 * memory areas used to copy the header.
 *
 * @par Example
 * @code
 *
 *   retry_after = http_retry_after_dup(home, http->http_retry_after);
 *
 * @endcode
 *
 * @return
 * The function http_retry_after_dup() returns a pointer to the
 * newly duplicated http_retry_after_t header structure, or NULL
 * upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_retry_after_t *http_retry_after_dup(su_home_t *home,
				   http_retry_after_t const *hdr)
     __attribute__((__malloc__));

/**Copy a http_retry_after_t header structure.
 *
 * The function http_retry_after_copy() copies a header structure @a
 * hdr.  If the header structure @a hdr contains a reference (@c
 * hdr->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home
 * to allocate all the memory areas used to copy the header
 * structure @a hdr.
 *
 * @param home    memory home used to allocate new structure
 * @param hdr     pointer to the header structure to be duplicated
 *
 * When copying, only the header structure and parameter lists
 * attached to it are duplicated.  The new header structure
 * retains all the references to the strings within the old @a
 * header, including the encoding of the old header, if present.
 *
 * @par Example
 * @code
 *
 *   retry_after = http_retry_after_copy(home, http->http_retry_after);
 *
 * @endcode
 *
 * @return
 * The function http_retry_after_copy() returns a pointer to
 * newly copied header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_retry_after_t *http_retry_after_copy(su_home_t *home,
				    http_retry_after_t const *hdr)
     __attribute__((__malloc__));

/**Make a header structure http_retry_after_t.
 *
 * The function http_retry_after_make() makes a new
 * http_retry_after_t header structure.  It allocates a new
 * header structure, and decodes the string @a s as the
 * value of the structure.
 *
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 *
 * @note This function is usually implemented as a macro calling
 * http_header_make().
 *
 * @return
 * The function http_retry_after_make() returns a pointer to
 * newly maked http_retry_after_t header structure, or NULL upon
 * an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_retry_after_t *http_retry_after_make(su_home_t *home, char const *s)
     __attribute__((__malloc__));

/**Make a Retry-After header from formatting result.
 *
 * The function http_retry_after_format() makes a new
 * Retry-After header object using formatting result as its
 * value.  The function first prints the arguments according to
 * the format @a fmt specified.  Then it allocates a new header
 * structure, and uses the formatting result as the header
 * value.
 *
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 *
 * @note This function is usually implemented as a macro calling
 * msg_header_format().
 *
 * @return
 * The function http_retry_after_format() returns a pointer to newly
 * makes header structure, or NULL upon an error.
 *
 * @HIDE
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_retry_after_t *http_retry_after_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__malloc__, __format__ (printf, 2, 3)));


/* Inlined functions */
#if SU_HAVE_INLINE
su_inline
http_retry_after_t *http_retry_after_format(su_home_t *home, char const *fmt, ...)
{
  http_header_t *h;
  va_list ap;

  va_start(ap, fmt);
  h = http_header_vformat(home, http_retry_after_class, fmt, ap);
  va_end(ap);

  return (http_retry_after_t *)h;
}

su_inline
http_retry_after_t *http_retry_after_dup(su_home_t *home, http_retry_after_t const *o)
{
  return (http_retry_after_t *)
    msg_header_dup_as(home, http_retry_after_class, (msg_header_t const *)o);
}

su_inline
http_retry_after_t *http_retry_after_copy(su_home_t *home, http_retry_after_t const *o)
{
  return (http_retry_after_t *)
    msg_header_copy_as(home, http_retry_after_class, (msg_header_t const *)o);
}

su_inline
http_retry_after_t *http_retry_after_make(su_home_t *home, char const *s)
{
  return (http_retry_after_t *)http_header_make(home, http_retry_after_class, s);
}
#endif

#endif /* !define HTTP_HCLASSES_ONLY */

/** @} */


/* Declare internal prototypes for Server header */

/**@addtogroup http_server*/ /** @{ */

enum {
  /** Hash of Server header. @internal*/
  http_server_hash = 31323
};

/**Header class for HTTP Server header.
 *
 * The header class http_server_class defines how a HTTP
 * Server header is parsed and printed.  It also
 * contains methods used by HTTP parser and other functions
 * to manipulate the http_server_t header structure.
 *
 */
SOFIAPUBVAR msg_hclass_t http_server_class[];

#ifndef HTTP_HCLASSES_ONLY

/** Decode (parse) a Server header. @internal */
SOFIAPUBFUN msg_parse_f http_server_d;

/** Encode (print) a Server header. @internal */
SOFIAPUBFUN msg_print_f http_server_e;

/**Initializer for structure http_server_t.
 *
 * A static http_server_t structure must be initialized
 * with the HTTP_SERVER_INIT() macro. For instance,
 * @code
 *
 *  http_server_t http_server = HTTP_SERVER_INIT;
 *
 * @endcode
 * @HI
 */
#define HTTP_SERVER_INIT() HTTP_HDR_INIT(server)

/**Initialize a structure http_server_t.
 *
 * An http_server_t structure can be initialized with the
 * http_server_init() function/macro. For instance,
 * @code
 *
 *  http_server_t http_server;
 *
 *  http_server_init(&http_server);
 *
 * @endcode
 * @HI
 */
#if SU_HAVE_INLINE
su_inline http_server_t *http_server_init(http_server_t x[1])
{
  return HTTP_HEADER_INIT(x, http_server_class, sizeof(http_server_t));
}
#else
#define http_server_init(x) \
  HTTP_HEADER_INIT(x, http_server_class, sizeof(http_server_t))
#endif

/**Test if header object is instance of http_server_t.
 *
 * The function http_is_server() returns true (nonzero) if
 * the header class is an instance of Server header
 * object and false (zero) otherwise.
 *
 * @param header pointer to the header structure to be tested
 *
 * @return
 * The function http_is_xserver() returns true (nonzero) if
 * the header object is an instance of header server and
 * false (zero) otherwise.
 */
#if SU_HAVE_INLINE
su_inline
int http_is_server(http_header_t const *header)
{
  return header && header->sh_class->hc_hash == http_server_hash;
}
#else
#define http_is_server(h) \
 ((h) && ((msg_common_t *)(h))->h_class->hc_hash == http_server_hash)
#endif

/**Duplicate (deep copy) @c http_server_t.
 *
 * The function http_server_dup() duplicates a header
 * structure @a hdr.  If the header structure @a hdr
 * contains a reference (@c hdr->x_next) to a list of
 * headers, all the headers in the list are duplicated, too.
 *
 * @param home  memory home used to allocate new structure
 * @param hdr   header structure to be duplicated
 *
 * When duplicating, all parameter lists and non-constant
 * strings attached to the header are copied, too.  The
 * function uses given memory @a home to allocate all the
 * memory areas used to copy the header.
 *
 * @par Example
 * @code
 *
 *   server = http_server_dup(home, http->http_server);
 *
 * @endcode
 *
 * @return
 * The function http_server_dup() returns a pointer to the
 * newly duplicated http_server_t header structure, or NULL
 * upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_server_t *http_server_dup(su_home_t *home,
				   http_server_t const *hdr)
     __attribute__((__malloc__));

/**Copy a http_server_t header structure.
 *
 * The function http_server_copy() copies a header structure @a
 * hdr.  If the header structure @a hdr contains a reference (@c
 * hdr->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home
 * to allocate all the memory areas used to copy the header
 * structure @a hdr.
 *
 * @param home    memory home used to allocate new structure
 * @param hdr     pointer to the header structure to be duplicated
 *
 * When copying, only the header structure and parameter lists
 * attached to it are duplicated.  The new header structure
 * retains all the references to the strings within the old @a
 * header, including the encoding of the old header, if present.
 *
 * @par Example
 * @code
 *
 *   server = http_server_copy(home, http->http_server);
 *
 * @endcode
 *
 * @return
 * The function http_server_copy() returns a pointer to
 * newly copied header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_server_t *http_server_copy(su_home_t *home,
				    http_server_t const *hdr)
     __attribute__((__malloc__));

/**Make a header structure http_server_t.
 *
 * The function http_server_make() makes a new
 * http_server_t header structure.  It allocates a new
 * header structure, and decodes the string @a s as the
 * value of the structure.
 *
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 *
 * @note This function is usually implemented as a macro calling
 * http_header_make().
 *
 * @return
 * The function http_server_make() returns a pointer to
 * newly maked http_server_t header structure, or NULL upon
 * an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_server_t *http_server_make(su_home_t *home, char const *s)
     __attribute__((__malloc__));

/**Make a Server header from formatting result.
 *
 * The function http_server_format() makes a new
 * Server header object using formatting result as its
 * value.  The function first prints the arguments according to
 * the format @a fmt specified.  Then it allocates a new header
 * structure, and uses the formatting result as the header
 * value.
 *
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 *
 * @note This function is usually implemented as a macro calling
 * msg_header_format().
 *
 * @return
 * The function http_server_format() returns a pointer to newly
 * makes header structure, or NULL upon an error.
 *
 * @HIDE
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_server_t *http_server_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__malloc__, __format__ (printf, 2, 3)));


/* Inlined functions */
#if SU_HAVE_INLINE
su_inline
http_server_t *http_server_format(su_home_t *home, char const *fmt, ...)
{
  http_header_t *h;
  va_list ap;

  va_start(ap, fmt);
  h = http_header_vformat(home, http_server_class, fmt, ap);
  va_end(ap);

  return (http_server_t *)h;
}

su_inline
http_server_t *http_server_dup(su_home_t *home, http_server_t const *o)
{
  return (http_server_t *)
    msg_header_dup_as(home, http_server_class, (msg_header_t const *)o);
}

su_inline
http_server_t *http_server_copy(su_home_t *home, http_server_t const *o)
{
  return (http_server_t *)
    msg_header_copy_as(home, http_server_class, (msg_header_t const *)o);
}

su_inline
http_server_t *http_server_make(su_home_t *home, char const *s)
{
  return (http_server_t *)http_header_make(home, http_server_class, s);
}
#endif

#endif /* !define HTTP_HCLASSES_ONLY */

/** @} */


/* Declare internal prototypes for TE header */

/**@addtogroup http_te*/ /** @{ */

enum {
  /** Hash of TE header. @internal*/
  http_te_hash = 5165
};

/**Header class for HTTP TE header.
 *
 * The header class http_te_class defines how a HTTP
 * TE header is parsed and printed.  It also
 * contains methods used by HTTP parser and other functions
 * to manipulate the http_te_t header structure.
 *
 */
SOFIAPUBVAR msg_hclass_t http_te_class[];

#ifndef HTTP_HCLASSES_ONLY

/** Decode (parse) a TE header. @internal */
SOFIAPUBFUN msg_parse_f http_te_d;

/** Encode (print) a TE header. @internal */
SOFIAPUBFUN msg_print_f http_te_e;

/**Initializer for structure http_te_t.
 *
 * A static http_te_t structure must be initialized
 * with the HTTP_TE_INIT() macro. For instance,
 * @code
 *
 *  http_te_t http_te = HTTP_TE_INIT;
 *
 * @endcode
 * @HI
 */
#define HTTP_TE_INIT() HTTP_HDR_INIT(te)

/**Initialize a structure http_te_t.
 *
 * An http_te_t structure can be initialized with the
 * http_te_init() function/macro. For instance,
 * @code
 *
 *  http_te_t http_te;
 *
 *  http_te_init(&http_te);
 *
 * @endcode
 * @HI
 */
#if SU_HAVE_INLINE
su_inline http_te_t *http_te_init(http_te_t x[1])
{
  return HTTP_HEADER_INIT(x, http_te_class, sizeof(http_te_t));
}
#else
#define http_te_init(x) \
  HTTP_HEADER_INIT(x, http_te_class, sizeof(http_te_t))
#endif

/**Test if header object is instance of http_te_t.
 *
 * The function http_is_te() returns true (nonzero) if
 * the header class is an instance of TE header
 * object and false (zero) otherwise.
 *
 * @param header pointer to the header structure to be tested
 *
 * @return
 * The function http_is_xte() returns true (nonzero) if
 * the header object is an instance of header te and
 * false (zero) otherwise.
 */
#if SU_HAVE_INLINE
su_inline
int http_is_te(http_header_t const *header)
{
  return header && header->sh_class->hc_hash == http_te_hash;
}
#else
#define http_is_te(h) \
 ((h) && ((msg_common_t *)(h))->h_class->hc_hash == http_te_hash)
#endif

/**Duplicate (deep copy) @c http_te_t.
 *
 * The function http_te_dup() duplicates a header
 * structure @a hdr.  If the header structure @a hdr
 * contains a reference (@c hdr->x_next) to a list of
 * headers, all the headers in the list are duplicated, too.
 *
 * @param home  memory home used to allocate new structure
 * @param hdr   header structure to be duplicated
 *
 * When duplicating, all parameter lists and non-constant
 * strings attached to the header are copied, too.  The
 * function uses given memory @a home to allocate all the
 * memory areas used to copy the header.
 *
 * @par Example
 * @code
 *
 *   te = http_te_dup(home, http->http_te);
 *
 * @endcode
 *
 * @return
 * The function http_te_dup() returns a pointer to the
 * newly duplicated http_te_t header structure, or NULL
 * upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_te_t *http_te_dup(su_home_t *home,
				   http_te_t const *hdr)
     __attribute__((__malloc__));

/**Copy a http_te_t header structure.
 *
 * The function http_te_copy() copies a header structure @a
 * hdr.  If the header structure @a hdr contains a reference (@c
 * hdr->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home
 * to allocate all the memory areas used to copy the header
 * structure @a hdr.
 *
 * @param home    memory home used to allocate new structure
 * @param hdr     pointer to the header structure to be duplicated
 *
 * When copying, only the header structure and parameter lists
 * attached to it are duplicated.  The new header structure
 * retains all the references to the strings within the old @a
 * header, including the encoding of the old header, if present.
 *
 * @par Example
 * @code
 *
 *   te = http_te_copy(home, http->http_te);
 *
 * @endcode
 *
 * @return
 * The function http_te_copy() returns a pointer to
 * newly copied header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_te_t *http_te_copy(su_home_t *home,
				    http_te_t const *hdr)
     __attribute__((__malloc__));

/**Make a header structure http_te_t.
 *
 * The function http_te_make() makes a new
 * http_te_t header structure.  It allocates a new
 * header structure, and decodes the string @a s as the
 * value of the structure.
 *
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 *
 * @note This function is usually implemented as a macro calling
 * http_header_make().
 *
 * @return
 * The function http_te_make() returns a pointer to
 * newly maked http_te_t header structure, or NULL upon
 * an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_te_t *http_te_make(su_home_t *home, char const *s)
     __attribute__((__malloc__));

/**Make a TE header from formatting result.
 *
 * The function http_te_format() makes a new
 * TE header object using formatting result as its
 * value.  The function first prints the arguments according to
 * the format @a fmt specified.  Then it allocates a new header
 * structure, and uses the formatting result as the header
 * value.
 *
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 *
 * @note This function is usually implemented as a macro calling
 * msg_header_format().
 *
 * @return
 * The function http_te_format() returns a pointer to newly
 * makes header structure, or NULL upon an error.
 *
 * @HIDE
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_te_t *http_te_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__malloc__, __format__ (printf, 2, 3)));


/* Inlined functions */
#if SU_HAVE_INLINE
su_inline
http_te_t *http_te_format(su_home_t *home, char const *fmt, ...)
{
  http_header_t *h;
  va_list ap;

  va_start(ap, fmt);
  h = http_header_vformat(home, http_te_class, fmt, ap);
  va_end(ap);

  return (http_te_t *)h;
}

su_inline
http_te_t *http_te_dup(su_home_t *home, http_te_t const *o)
{
  return (http_te_t *)
    msg_header_dup_as(home, http_te_class, (msg_header_t const *)o);
}

su_inline
http_te_t *http_te_copy(su_home_t *home, http_te_t const *o)
{
  return (http_te_t *)
    msg_header_copy_as(home, http_te_class, (msg_header_t const *)o);
}

su_inline
http_te_t *http_te_make(su_home_t *home, char const *s)
{
  return (http_te_t *)http_header_make(home, http_te_class, s);
}
#endif

#endif /* !define HTTP_HCLASSES_ONLY */

/** @} */


/* Declare internal prototypes for Trailer header */

/**@addtogroup http_trailer*/ /** @{ */

enum {
  /** Hash of Trailer header. @internal*/
  http_trailer_hash = 11015
};

/**Header class for HTTP Trailer header.
 *
 * The header class http_trailer_class defines how a HTTP
 * Trailer header is parsed and printed.  It also
 * contains methods used by HTTP parser and other functions
 * to manipulate the http_trailer_t header structure.
 *
 */
SOFIAPUBVAR msg_hclass_t http_trailer_class[];

#ifndef HTTP_HCLASSES_ONLY

/** Decode (parse) a Trailer header. @internal */
SOFIAPUBFUN msg_parse_f http_trailer_d;

/** Encode (print) a Trailer header. @internal */
SOFIAPUBFUN msg_print_f http_trailer_e;

/**Initializer for structure http_trailer_t.
 *
 * A static http_trailer_t structure must be initialized
 * with the HTTP_TRAILER_INIT() macro. For instance,
 * @code
 *
 *  http_trailer_t http_trailer = HTTP_TRAILER_INIT;
 *
 * @endcode
 * @HI
 */
#define HTTP_TRAILER_INIT() HTTP_HDR_INIT(trailer)

/**Initialize a structure http_trailer_t.
 *
 * An http_trailer_t structure can be initialized with the
 * http_trailer_init() function/macro. For instance,
 * @code
 *
 *  http_trailer_t http_trailer;
 *
 *  http_trailer_init(&http_trailer);
 *
 * @endcode
 * @HI
 */
#if SU_HAVE_INLINE
su_inline http_trailer_t *http_trailer_init(http_trailer_t x[1])
{
  return HTTP_HEADER_INIT(x, http_trailer_class, sizeof(http_trailer_t));
}
#else
#define http_trailer_init(x) \
  HTTP_HEADER_INIT(x, http_trailer_class, sizeof(http_trailer_t))
#endif

/**Test if header object is instance of http_trailer_t.
 *
 * The function http_is_trailer() returns true (nonzero) if
 * the header class is an instance of Trailer header
 * object and false (zero) otherwise.
 *
 * @param header pointer to the header structure to be tested
 *
 * @return
 * The function http_is_xtrailer() returns true (nonzero) if
 * the header object is an instance of header trailer and
 * false (zero) otherwise.
 */
#if SU_HAVE_INLINE
su_inline
int http_is_trailer(http_header_t const *header)
{
  return header && header->sh_class->hc_hash == http_trailer_hash;
}
#else
#define http_is_trailer(h) \
 ((h) && ((msg_common_t *)(h))->h_class->hc_hash == http_trailer_hash)
#endif

/**Duplicate (deep copy) @c http_trailer_t.
 *
 * The function http_trailer_dup() duplicates a header
 * structure @a hdr.  If the header structure @a hdr
 * contains a reference (@c hdr->x_next) to a list of
 * headers, all the headers in the list are duplicated, too.
 *
 * @param home  memory home used to allocate new structure
 * @param hdr   header structure to be duplicated
 *
 * When duplicating, all parameter lists and non-constant
 * strings attached to the header are copied, too.  The
 * function uses given memory @a home to allocate all the
 * memory areas used to copy the header.
 *
 * @par Example
 * @code
 *
 *   trailer = http_trailer_dup(home, http->http_trailer);
 *
 * @endcode
 *
 * @return
 * The function http_trailer_dup() returns a pointer to the
 * newly duplicated http_trailer_t header structure, or NULL
 * upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_trailer_t *http_trailer_dup(su_home_t *home,
				   http_trailer_t const *hdr)
     __attribute__((__malloc__));

/**Copy a http_trailer_t header structure.
 *
 * The function http_trailer_copy() copies a header structure @a
 * hdr.  If the header structure @a hdr contains a reference (@c
 * hdr->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home
 * to allocate all the memory areas used to copy the header
 * structure @a hdr.
 *
 * @param home    memory home used to allocate new structure
 * @param hdr     pointer to the header structure to be duplicated
 *
 * When copying, only the header structure and parameter lists
 * attached to it are duplicated.  The new header structure
 * retains all the references to the strings within the old @a
 * header, including the encoding of the old header, if present.
 *
 * @par Example
 * @code
 *
 *   trailer = http_trailer_copy(home, http->http_trailer);
 *
 * @endcode
 *
 * @return
 * The function http_trailer_copy() returns a pointer to
 * newly copied header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_trailer_t *http_trailer_copy(su_home_t *home,
				    http_trailer_t const *hdr)
     __attribute__((__malloc__));

/**Make a header structure http_trailer_t.
 *
 * The function http_trailer_make() makes a new
 * http_trailer_t header structure.  It allocates a new
 * header structure, and decodes the string @a s as the
 * value of the structure.
 *
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 *
 * @note This function is usually implemented as a macro calling
 * http_header_make().
 *
 * @return
 * The function http_trailer_make() returns a pointer to
 * newly maked http_trailer_t header structure, or NULL upon
 * an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_trailer_t *http_trailer_make(su_home_t *home, char const *s)
     __attribute__((__malloc__));

/**Make a Trailer header from formatting result.
 *
 * The function http_trailer_format() makes a new
 * Trailer header object using formatting result as its
 * value.  The function first prints the arguments according to
 * the format @a fmt specified.  Then it allocates a new header
 * structure, and uses the formatting result as the header
 * value.
 *
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 *
 * @note This function is usually implemented as a macro calling
 * msg_header_format().
 *
 * @return
 * The function http_trailer_format() returns a pointer to newly
 * makes header structure, or NULL upon an error.
 *
 * @HIDE
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_trailer_t *http_trailer_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__malloc__, __format__ (printf, 2, 3)));


/* Inlined functions */
#if SU_HAVE_INLINE
su_inline
http_trailer_t *http_trailer_format(su_home_t *home, char const *fmt, ...)
{
  http_header_t *h;
  va_list ap;

  va_start(ap, fmt);
  h = http_header_vformat(home, http_trailer_class, fmt, ap);
  va_end(ap);

  return (http_trailer_t *)h;
}

su_inline
http_trailer_t *http_trailer_dup(su_home_t *home, http_trailer_t const *o)
{
  return (http_trailer_t *)
    msg_header_dup_as(home, http_trailer_class, (msg_header_t const *)o);
}

su_inline
http_trailer_t *http_trailer_copy(su_home_t *home, http_trailer_t const *o)
{
  return (http_trailer_t *)
    msg_header_copy_as(home, http_trailer_class, (msg_header_t const *)o);
}

su_inline
http_trailer_t *http_trailer_make(su_home_t *home, char const *s)
{
  return (http_trailer_t *)http_header_make(home, http_trailer_class, s);
}
#endif

#endif /* !define HTTP_HCLASSES_ONLY */

/** @} */


/* Declare internal prototypes for Transfer-Encoding header */

/**@addtogroup http_transfer_encoding*/ /** @{ */

enum {
  /** Hash of Transfer-Encoding header. @internal*/
  http_transfer_encoding_hash = 25509
};

/**Header class for HTTP Transfer-Encoding header.
 *
 * The header class http_transfer_encoding_class defines how a HTTP
 * Transfer-Encoding header is parsed and printed.  It also
 * contains methods used by HTTP parser and other functions
 * to manipulate the http_transfer_encoding_t header structure.
 *
 */
SOFIAPUBVAR msg_hclass_t http_transfer_encoding_class[];

#ifndef HTTP_HCLASSES_ONLY

/** Decode (parse) a Transfer-Encoding header. @internal */
SOFIAPUBFUN msg_parse_f http_transfer_encoding_d;

/** Encode (print) a Transfer-Encoding header. @internal */
SOFIAPUBFUN msg_print_f http_transfer_encoding_e;

/**Initializer for structure http_transfer_encoding_t.
 *
 * A static http_transfer_encoding_t structure must be initialized
 * with the HTTP_TRANSFER_ENCODING_INIT() macro. For instance,
 * @code
 *
 *  http_transfer_encoding_t http_transfer_encoding = HTTP_TRANSFER_ENCODING_INIT;
 *
 * @endcode
 * @HI
 */
#define HTTP_TRANSFER_ENCODING_INIT() HTTP_HDR_INIT(transfer_encoding)

/**Initialize a structure http_transfer_encoding_t.
 *
 * An http_transfer_encoding_t structure can be initialized with the
 * http_transfer_encoding_init() function/macro. For instance,
 * @code
 *
 *  http_transfer_encoding_t http_transfer_encoding;
 *
 *  http_transfer_encoding_init(&http_transfer_encoding);
 *
 * @endcode
 * @HI
 */
#if SU_HAVE_INLINE
su_inline http_transfer_encoding_t *http_transfer_encoding_init(http_transfer_encoding_t x[1])
{
  return HTTP_HEADER_INIT(x, http_transfer_encoding_class, sizeof(http_transfer_encoding_t));
}
#else
#define http_transfer_encoding_init(x) \
  HTTP_HEADER_INIT(x, http_transfer_encoding_class, sizeof(http_transfer_encoding_t))
#endif

/**Test if header object is instance of http_transfer_encoding_t.
 *
 * The function http_is_transfer_encoding() returns true (nonzero) if
 * the header class is an instance of Transfer-Encoding header
 * object and false (zero) otherwise.
 *
 * @param header pointer to the header structure to be tested
 *
 * @return
 * The function http_is_xtransfer_encoding() returns true (nonzero) if
 * the header object is an instance of header transfer_encoding and
 * false (zero) otherwise.
 */
#if SU_HAVE_INLINE
su_inline
int http_is_transfer_encoding(http_header_t const *header)
{
  return header && header->sh_class->hc_hash == http_transfer_encoding_hash;
}
#else
#define http_is_transfer_encoding(h) \
 ((h) && ((msg_common_t *)(h))->h_class->hc_hash == http_transfer_encoding_hash)
#endif

/**Duplicate (deep copy) @c http_transfer_encoding_t.
 *
 * The function http_transfer_encoding_dup() duplicates a header
 * structure @a hdr.  If the header structure @a hdr
 * contains a reference (@c hdr->x_next) to a list of
 * headers, all the headers in the list are duplicated, too.
 *
 * @param home  memory home used to allocate new structure
 * @param hdr   header structure to be duplicated
 *
 * When duplicating, all parameter lists and non-constant
 * strings attached to the header are copied, too.  The
 * function uses given memory @a home to allocate all the
 * memory areas used to copy the header.
 *
 * @par Example
 * @code
 *
 *   transfer_encoding = http_transfer_encoding_dup(home, http->http_transfer_encoding);
 *
 * @endcode
 *
 * @return
 * The function http_transfer_encoding_dup() returns a pointer to the
 * newly duplicated http_transfer_encoding_t header structure, or NULL
 * upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_transfer_encoding_t *http_transfer_encoding_dup(su_home_t *home,
				   http_transfer_encoding_t const *hdr)
     __attribute__((__malloc__));

/**Copy a http_transfer_encoding_t header structure.
 *
 * The function http_transfer_encoding_copy() copies a header structure @a
 * hdr.  If the header structure @a hdr contains a reference (@c
 * hdr->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home
 * to allocate all the memory areas used to copy the header
 * structure @a hdr.
 *
 * @param home    memory home used to allocate new structure
 * @param hdr     pointer to the header structure to be duplicated
 *
 * When copying, only the header structure and parameter lists
 * attached to it are duplicated.  The new header structure
 * retains all the references to the strings within the old @a
 * header, including the encoding of the old header, if present.
 *
 * @par Example
 * @code
 *
 *   transfer_encoding = http_transfer_encoding_copy(home, http->http_transfer_encoding);
 *
 * @endcode
 *
 * @return
 * The function http_transfer_encoding_copy() returns a pointer to
 * newly copied header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_transfer_encoding_t *http_transfer_encoding_copy(su_home_t *home,
				    http_transfer_encoding_t const *hdr)
     __attribute__((__malloc__));

/**Make a header structure http_transfer_encoding_t.
 *
 * The function http_transfer_encoding_make() makes a new
 * http_transfer_encoding_t header structure.  It allocates a new
 * header structure, and decodes the string @a s as the
 * value of the structure.
 *
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 *
 * @note This function is usually implemented as a macro calling
 * http_header_make().
 *
 * @return
 * The function http_transfer_encoding_make() returns a pointer to
 * newly maked http_transfer_encoding_t header structure, or NULL upon
 * an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_transfer_encoding_t *http_transfer_encoding_make(su_home_t *home, char const *s)
     __attribute__((__malloc__));

/**Make a Transfer-Encoding header from formatting result.
 *
 * The function http_transfer_encoding_format() makes a new
 * Transfer-Encoding header object using formatting result as its
 * value.  The function first prints the arguments according to
 * the format @a fmt specified.  Then it allocates a new header
 * structure, and uses the formatting result as the header
 * value.
 *
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 *
 * @note This function is usually implemented as a macro calling
 * msg_header_format().
 *
 * @return
 * The function http_transfer_encoding_format() returns a pointer to newly
 * makes header structure, or NULL upon an error.
 *
 * @HIDE
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_transfer_encoding_t *http_transfer_encoding_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__malloc__, __format__ (printf, 2, 3)));


/* Inlined functions */
#if SU_HAVE_INLINE
su_inline
http_transfer_encoding_t *http_transfer_encoding_format(su_home_t *home, char const *fmt, ...)
{
  http_header_t *h;
  va_list ap;

  va_start(ap, fmt);
  h = http_header_vformat(home, http_transfer_encoding_class, fmt, ap);
  va_end(ap);

  return (http_transfer_encoding_t *)h;
}

su_inline
http_transfer_encoding_t *http_transfer_encoding_dup(su_home_t *home, http_transfer_encoding_t const *o)
{
  return (http_transfer_encoding_t *)
    msg_header_dup_as(home, http_transfer_encoding_class, (msg_header_t const *)o);
}

su_inline
http_transfer_encoding_t *http_transfer_encoding_copy(su_home_t *home, http_transfer_encoding_t const *o)
{
  return (http_transfer_encoding_t *)
    msg_header_copy_as(home, http_transfer_encoding_class, (msg_header_t const *)o);
}

su_inline
http_transfer_encoding_t *http_transfer_encoding_make(su_home_t *home, char const *s)
{
  return (http_transfer_encoding_t *)http_header_make(home, http_transfer_encoding_class, s);
}
#endif

#endif /* !define HTTP_HCLASSES_ONLY */

/** @} */


/* Declare internal prototypes for Upgrade header */

/**@addtogroup http_upgrade*/ /** @{ */

enum {
  /** Hash of Upgrade header. @internal*/
  http_upgrade_hash = 16256
};

/**Header class for HTTP Upgrade header.
 *
 * The header class http_upgrade_class defines how a HTTP
 * Upgrade header is parsed and printed.  It also
 * contains methods used by HTTP parser and other functions
 * to manipulate the http_upgrade_t header structure.
 *
 */
SOFIAPUBVAR msg_hclass_t http_upgrade_class[];

#ifndef HTTP_HCLASSES_ONLY

/** Decode (parse) a Upgrade header. @internal */
SOFIAPUBFUN msg_parse_f http_upgrade_d;

/** Encode (print) a Upgrade header. @internal */
SOFIAPUBFUN msg_print_f http_upgrade_e;

/**Initializer for structure http_upgrade_t.
 *
 * A static http_upgrade_t structure must be initialized
 * with the HTTP_UPGRADE_INIT() macro. For instance,
 * @code
 *
 *  http_upgrade_t http_upgrade = HTTP_UPGRADE_INIT;
 *
 * @endcode
 * @HI
 */
#define HTTP_UPGRADE_INIT() HTTP_HDR_INIT(upgrade)

/**Initialize a structure http_upgrade_t.
 *
 * An http_upgrade_t structure can be initialized with the
 * http_upgrade_init() function/macro. For instance,
 * @code
 *
 *  http_upgrade_t http_upgrade;
 *
 *  http_upgrade_init(&http_upgrade);
 *
 * @endcode
 * @HI
 */
#if SU_HAVE_INLINE
su_inline http_upgrade_t *http_upgrade_init(http_upgrade_t x[1])
{
  return HTTP_HEADER_INIT(x, http_upgrade_class, sizeof(http_upgrade_t));
}
#else
#define http_upgrade_init(x) \
  HTTP_HEADER_INIT(x, http_upgrade_class, sizeof(http_upgrade_t))
#endif

/**Test if header object is instance of http_upgrade_t.
 *
 * The function http_is_upgrade() returns true (nonzero) if
 * the header class is an instance of Upgrade header
 * object and false (zero) otherwise.
 *
 * @param header pointer to the header structure to be tested
 *
 * @return
 * The function http_is_xupgrade() returns true (nonzero) if
 * the header object is an instance of header upgrade and
 * false (zero) otherwise.
 */
#if SU_HAVE_INLINE
su_inline
int http_is_upgrade(http_header_t const *header)
{
  return header && header->sh_class->hc_hash == http_upgrade_hash;
}
#else
#define http_is_upgrade(h) \
 ((h) && ((msg_common_t *)(h))->h_class->hc_hash == http_upgrade_hash)
#endif

/**Duplicate (deep copy) @c http_upgrade_t.
 *
 * The function http_upgrade_dup() duplicates a header
 * structure @a hdr.  If the header structure @a hdr
 * contains a reference (@c hdr->x_next) to a list of
 * headers, all the headers in the list are duplicated, too.
 *
 * @param home  memory home used to allocate new structure
 * @param hdr   header structure to be duplicated
 *
 * When duplicating, all parameter lists and non-constant
 * strings attached to the header are copied, too.  The
 * function uses given memory @a home to allocate all the
 * memory areas used to copy the header.
 *
 * @par Example
 * @code
 *
 *   upgrade = http_upgrade_dup(home, http->http_upgrade);
 *
 * @endcode
 *
 * @return
 * The function http_upgrade_dup() returns a pointer to the
 * newly duplicated http_upgrade_t header structure, or NULL
 * upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_upgrade_t *http_upgrade_dup(su_home_t *home,
				   http_upgrade_t const *hdr)
     __attribute__((__malloc__));

/**Copy a http_upgrade_t header structure.
 *
 * The function http_upgrade_copy() copies a header structure @a
 * hdr.  If the header structure @a hdr contains a reference (@c
 * hdr->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home
 * to allocate all the memory areas used to copy the header
 * structure @a hdr.
 *
 * @param home    memory home used to allocate new structure
 * @param hdr     pointer to the header structure to be duplicated
 *
 * When copying, only the header structure and parameter lists
 * attached to it are duplicated.  The new header structure
 * retains all the references to the strings within the old @a
 * header, including the encoding of the old header, if present.
 *
 * @par Example
 * @code
 *
 *   upgrade = http_upgrade_copy(home, http->http_upgrade);
 *
 * @endcode
 *
 * @return
 * The function http_upgrade_copy() returns a pointer to
 * newly copied header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_upgrade_t *http_upgrade_copy(su_home_t *home,
				    http_upgrade_t const *hdr)
     __attribute__((__malloc__));

/**Make a header structure http_upgrade_t.
 *
 * The function http_upgrade_make() makes a new
 * http_upgrade_t header structure.  It allocates a new
 * header structure, and decodes the string @a s as the
 * value of the structure.
 *
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 *
 * @note This function is usually implemented as a macro calling
 * http_header_make().
 *
 * @return
 * The function http_upgrade_make() returns a pointer to
 * newly maked http_upgrade_t header structure, or NULL upon
 * an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_upgrade_t *http_upgrade_make(su_home_t *home, char const *s)
     __attribute__((__malloc__));

/**Make a Upgrade header from formatting result.
 *
 * The function http_upgrade_format() makes a new
 * Upgrade header object using formatting result as its
 * value.  The function first prints the arguments according to
 * the format @a fmt specified.  Then it allocates a new header
 * structure, and uses the formatting result as the header
 * value.
 *
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 *
 * @note This function is usually implemented as a macro calling
 * msg_header_format().
 *
 * @return
 * The function http_upgrade_format() returns a pointer to newly
 * makes header structure, or NULL upon an error.
 *
 * @HIDE
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_upgrade_t *http_upgrade_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__malloc__, __format__ (printf, 2, 3)));


/* Inlined functions */
#if SU_HAVE_INLINE
su_inline
http_upgrade_t *http_upgrade_format(su_home_t *home, char const *fmt, ...)
{
  http_header_t *h;
  va_list ap;

  va_start(ap, fmt);
  h = http_header_vformat(home, http_upgrade_class, fmt, ap);
  va_end(ap);

  return (http_upgrade_t *)h;
}

su_inline
http_upgrade_t *http_upgrade_dup(su_home_t *home, http_upgrade_t const *o)
{
  return (http_upgrade_t *)
    msg_header_dup_as(home, http_upgrade_class, (msg_header_t const *)o);
}

su_inline
http_upgrade_t *http_upgrade_copy(su_home_t *home, http_upgrade_t const *o)
{
  return (http_upgrade_t *)
    msg_header_copy_as(home, http_upgrade_class, (msg_header_t const *)o);
}

su_inline
http_upgrade_t *http_upgrade_make(su_home_t *home, char const *s)
{
  return (http_upgrade_t *)http_header_make(home, http_upgrade_class, s);
}
#endif

#endif /* !define HTTP_HCLASSES_ONLY */

/** @} */


/* Declare internal prototypes for User-Agent header */

/**@addtogroup http_user_agent*/ /** @{ */

enum {
  /** Hash of User-Agent header. @internal*/
  http_user_agent_hash = 40911
};

/**Header class for HTTP User-Agent header.
 *
 * The header class http_user_agent_class defines how a HTTP
 * User-Agent header is parsed and printed.  It also
 * contains methods used by HTTP parser and other functions
 * to manipulate the http_user_agent_t header structure.
 *
 */
SOFIAPUBVAR msg_hclass_t http_user_agent_class[];

#ifndef HTTP_HCLASSES_ONLY

/** Decode (parse) a User-Agent header. @internal */
SOFIAPUBFUN msg_parse_f http_user_agent_d;

/** Encode (print) a User-Agent header. @internal */
SOFIAPUBFUN msg_print_f http_user_agent_e;

/**Initializer for structure http_user_agent_t.
 *
 * A static http_user_agent_t structure must be initialized
 * with the HTTP_USER_AGENT_INIT() macro. For instance,
 * @code
 *
 *  http_user_agent_t http_user_agent = HTTP_USER_AGENT_INIT;
 *
 * @endcode
 * @HI
 */
#define HTTP_USER_AGENT_INIT() HTTP_HDR_INIT(user_agent)

/**Initialize a structure http_user_agent_t.
 *
 * An http_user_agent_t structure can be initialized with the
 * http_user_agent_init() function/macro. For instance,
 * @code
 *
 *  http_user_agent_t http_user_agent;
 *
 *  http_user_agent_init(&http_user_agent);
 *
 * @endcode
 * @HI
 */
#if SU_HAVE_INLINE
su_inline http_user_agent_t *http_user_agent_init(http_user_agent_t x[1])
{
  return HTTP_HEADER_INIT(x, http_user_agent_class, sizeof(http_user_agent_t));
}
#else
#define http_user_agent_init(x) \
  HTTP_HEADER_INIT(x, http_user_agent_class, sizeof(http_user_agent_t))
#endif

/**Test if header object is instance of http_user_agent_t.
 *
 * The function http_is_user_agent() returns true (nonzero) if
 * the header class is an instance of User-Agent header
 * object and false (zero) otherwise.
 *
 * @param header pointer to the header structure to be tested
 *
 * @return
 * The function http_is_xuser_agent() returns true (nonzero) if
 * the header object is an instance of header user_agent and
 * false (zero) otherwise.
 */
#if SU_HAVE_INLINE
su_inline
int http_is_user_agent(http_header_t const *header)
{
  return header && header->sh_class->hc_hash == http_user_agent_hash;
}
#else
#define http_is_user_agent(h) \
 ((h) && ((msg_common_t *)(h))->h_class->hc_hash == http_user_agent_hash)
#endif

/**Duplicate (deep copy) @c http_user_agent_t.
 *
 * The function http_user_agent_dup() duplicates a header
 * structure @a hdr.  If the header structure @a hdr
 * contains a reference (@c hdr->x_next) to a list of
 * headers, all the headers in the list are duplicated, too.
 *
 * @param home  memory home used to allocate new structure
 * @param hdr   header structure to be duplicated
 *
 * When duplicating, all parameter lists and non-constant
 * strings attached to the header are copied, too.  The
 * function uses given memory @a home to allocate all the
 * memory areas used to copy the header.
 *
 * @par Example
 * @code
 *
 *   user_agent = http_user_agent_dup(home, http->http_user_agent);
 *
 * @endcode
 *
 * @return
 * The function http_user_agent_dup() returns a pointer to the
 * newly duplicated http_user_agent_t header structure, or NULL
 * upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_user_agent_t *http_user_agent_dup(su_home_t *home,
				   http_user_agent_t const *hdr)
     __attribute__((__malloc__));

/**Copy a http_user_agent_t header structure.
 *
 * The function http_user_agent_copy() copies a header structure @a
 * hdr.  If the header structure @a hdr contains a reference (@c
 * hdr->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home
 * to allocate all the memory areas used to copy the header
 * structure @a hdr.
 *
 * @param home    memory home used to allocate new structure
 * @param hdr     pointer to the header structure to be duplicated
 *
 * When copying, only the header structure and parameter lists
 * attached to it are duplicated.  The new header structure
 * retains all the references to the strings within the old @a
 * header, including the encoding of the old header, if present.
 *
 * @par Example
 * @code
 *
 *   user_agent = http_user_agent_copy(home, http->http_user_agent);
 *
 * @endcode
 *
 * @return
 * The function http_user_agent_copy() returns a pointer to
 * newly copied header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_user_agent_t *http_user_agent_copy(su_home_t *home,
				    http_user_agent_t const *hdr)
     __attribute__((__malloc__));

/**Make a header structure http_user_agent_t.
 *
 * The function http_user_agent_make() makes a new
 * http_user_agent_t header structure.  It allocates a new
 * header structure, and decodes the string @a s as the
 * value of the structure.
 *
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 *
 * @note This function is usually implemented as a macro calling
 * http_header_make().
 *
 * @return
 * The function http_user_agent_make() returns a pointer to
 * newly maked http_user_agent_t header structure, or NULL upon
 * an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_user_agent_t *http_user_agent_make(su_home_t *home, char const *s)
     __attribute__((__malloc__));

/**Make a User-Agent header from formatting result.
 *
 * The function http_user_agent_format() makes a new
 * User-Agent header object using formatting result as its
 * value.  The function first prints the arguments according to
 * the format @a fmt specified.  Then it allocates a new header
 * structure, and uses the formatting result as the header
 * value.
 *
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 *
 * @note This function is usually implemented as a macro calling
 * msg_header_format().
 *
 * @return
 * The function http_user_agent_format() returns a pointer to newly
 * makes header structure, or NULL upon an error.
 *
 * @HIDE
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_user_agent_t *http_user_agent_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__malloc__, __format__ (printf, 2, 3)));


/* Inlined functions */
#if SU_HAVE_INLINE
su_inline
http_user_agent_t *http_user_agent_format(su_home_t *home, char const *fmt, ...)
{
  http_header_t *h;
  va_list ap;

  va_start(ap, fmt);
  h = http_header_vformat(home, http_user_agent_class, fmt, ap);
  va_end(ap);

  return (http_user_agent_t *)h;
}

su_inline
http_user_agent_t *http_user_agent_dup(su_home_t *home, http_user_agent_t const *o)
{
  return (http_user_agent_t *)
    msg_header_dup_as(home, http_user_agent_class, (msg_header_t const *)o);
}

su_inline
http_user_agent_t *http_user_agent_copy(su_home_t *home, http_user_agent_t const *o)
{
  return (http_user_agent_t *)
    msg_header_copy_as(home, http_user_agent_class, (msg_header_t const *)o);
}

su_inline
http_user_agent_t *http_user_agent_make(su_home_t *home, char const *s)
{
  return (http_user_agent_t *)http_header_make(home, http_user_agent_class, s);
}
#endif

#endif /* !define HTTP_HCLASSES_ONLY */

/** @} */


/* Declare internal prototypes for Vary header */

/**@addtogroup http_vary*/ /** @{ */

enum {
  /** Hash of Vary header. @internal*/
  http_vary_hash = 57074
};

/**Header class for HTTP Vary header.
 *
 * The header class http_vary_class defines how a HTTP
 * Vary header is parsed and printed.  It also
 * contains methods used by HTTP parser and other functions
 * to manipulate the http_vary_t header structure.
 *
 */
SOFIAPUBVAR msg_hclass_t http_vary_class[];

#ifndef HTTP_HCLASSES_ONLY

/** Decode (parse) a Vary header. @internal */
SOFIAPUBFUN msg_parse_f http_vary_d;

/** Encode (print) a Vary header. @internal */
SOFIAPUBFUN msg_print_f http_vary_e;

/**Initializer for structure http_vary_t.
 *
 * A static http_vary_t structure must be initialized
 * with the HTTP_VARY_INIT() macro. For instance,
 * @code
 *
 *  http_vary_t http_vary = HTTP_VARY_INIT;
 *
 * @endcode
 * @HI
 */
#define HTTP_VARY_INIT() HTTP_HDR_INIT(vary)

/**Initialize a structure http_vary_t.
 *
 * An http_vary_t structure can be initialized with the
 * http_vary_init() function/macro. For instance,
 * @code
 *
 *  http_vary_t http_vary;
 *
 *  http_vary_init(&http_vary);
 *
 * @endcode
 * @HI
 */
#if SU_HAVE_INLINE
su_inline http_vary_t *http_vary_init(http_vary_t x[1])
{
  return HTTP_HEADER_INIT(x, http_vary_class, sizeof(http_vary_t));
}
#else
#define http_vary_init(x) \
  HTTP_HEADER_INIT(x, http_vary_class, sizeof(http_vary_t))
#endif

/**Test if header object is instance of http_vary_t.
 *
 * The function http_is_vary() returns true (nonzero) if
 * the header class is an instance of Vary header
 * object and false (zero) otherwise.
 *
 * @param header pointer to the header structure to be tested
 *
 * @return
 * The function http_is_xvary() returns true (nonzero) if
 * the header object is an instance of header vary and
 * false (zero) otherwise.
 */
#if SU_HAVE_INLINE
su_inline
int http_is_vary(http_header_t const *header)
{
  return header && header->sh_class->hc_hash == http_vary_hash;
}
#else
#define http_is_vary(h) \
 ((h) && ((msg_common_t *)(h))->h_class->hc_hash == http_vary_hash)
#endif

/**Duplicate (deep copy) @c http_vary_t.
 *
 * The function http_vary_dup() duplicates a header
 * structure @a hdr.  If the header structure @a hdr
 * contains a reference (@c hdr->x_next) to a list of
 * headers, all the headers in the list are duplicated, too.
 *
 * @param home  memory home used to allocate new structure
 * @param hdr   header structure to be duplicated
 *
 * When duplicating, all parameter lists and non-constant
 * strings attached to the header are copied, too.  The
 * function uses given memory @a home to allocate all the
 * memory areas used to copy the header.
 *
 * @par Example
 * @code
 *
 *   vary = http_vary_dup(home, http->http_vary);
 *
 * @endcode
 *
 * @return
 * The function http_vary_dup() returns a pointer to the
 * newly duplicated http_vary_t header structure, or NULL
 * upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_vary_t *http_vary_dup(su_home_t *home,
				   http_vary_t const *hdr)
     __attribute__((__malloc__));

/**Copy a http_vary_t header structure.
 *
 * The function http_vary_copy() copies a header structure @a
 * hdr.  If the header structure @a hdr contains a reference (@c
 * hdr->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home
 * to allocate all the memory areas used to copy the header
 * structure @a hdr.
 *
 * @param home    memory home used to allocate new structure
 * @param hdr     pointer to the header structure to be duplicated
 *
 * When copying, only the header structure and parameter lists
 * attached to it are duplicated.  The new header structure
 * retains all the references to the strings within the old @a
 * header, including the encoding of the old header, if present.
 *
 * @par Example
 * @code
 *
 *   vary = http_vary_copy(home, http->http_vary);
 *
 * @endcode
 *
 * @return
 * The function http_vary_copy() returns a pointer to
 * newly copied header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_vary_t *http_vary_copy(su_home_t *home,
				    http_vary_t const *hdr)
     __attribute__((__malloc__));

/**Make a header structure http_vary_t.
 *
 * The function http_vary_make() makes a new
 * http_vary_t header structure.  It allocates a new
 * header structure, and decodes the string @a s as the
 * value of the structure.
 *
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 *
 * @note This function is usually implemented as a macro calling
 * http_header_make().
 *
 * @return
 * The function http_vary_make() returns a pointer to
 * newly maked http_vary_t header structure, or NULL upon
 * an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_vary_t *http_vary_make(su_home_t *home, char const *s)
     __attribute__((__malloc__));

/**Make a Vary header from formatting result.
 *
 * The function http_vary_format() makes a new
 * Vary header object using formatting result as its
 * value.  The function first prints the arguments according to
 * the format @a fmt specified.  Then it allocates a new header
 * structure, and uses the formatting result as the header
 * value.
 *
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 *
 * @note This function is usually implemented as a macro calling
 * msg_header_format().
 *
 * @return
 * The function http_vary_format() returns a pointer to newly
 * makes header structure, or NULL upon an error.
 *
 * @HIDE
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_vary_t *http_vary_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__malloc__, __format__ (printf, 2, 3)));


/* Inlined functions */
#if SU_HAVE_INLINE
su_inline
http_vary_t *http_vary_format(su_home_t *home, char const *fmt, ...)
{
  http_header_t *h;
  va_list ap;

  va_start(ap, fmt);
  h = http_header_vformat(home, http_vary_class, fmt, ap);
  va_end(ap);

  return (http_vary_t *)h;
}

su_inline
http_vary_t *http_vary_dup(su_home_t *home, http_vary_t const *o)
{
  return (http_vary_t *)
    msg_header_dup_as(home, http_vary_class, (msg_header_t const *)o);
}

su_inline
http_vary_t *http_vary_copy(su_home_t *home, http_vary_t const *o)
{
  return (http_vary_t *)
    msg_header_copy_as(home, http_vary_class, (msg_header_t const *)o);
}

su_inline
http_vary_t *http_vary_make(su_home_t *home, char const *s)
{
  return (http_vary_t *)http_header_make(home, http_vary_class, s);
}
#endif

#endif /* !define HTTP_HCLASSES_ONLY */

/** @} */


/* Declare internal prototypes for Via header */

/**@addtogroup http_via*/ /** @{ */

enum {
  /** Hash of Via header. @internal*/
  http_via_hash = 46244
};

/**Header class for HTTP Via header.
 *
 * The header class http_via_class defines how a HTTP
 * Via header is parsed and printed.  It also
 * contains methods used by HTTP parser and other functions
 * to manipulate the http_via_t header structure.
 *
 */
SOFIAPUBVAR msg_hclass_t http_via_class[];

#ifndef HTTP_HCLASSES_ONLY

/** Decode (parse) a Via header. @internal */
SOFIAPUBFUN msg_parse_f http_via_d;

/** Encode (print) a Via header. @internal */
SOFIAPUBFUN msg_print_f http_via_e;

/**Initializer for structure http_via_t.
 *
 * A static http_via_t structure must be initialized
 * with the HTTP_VIA_INIT() macro. For instance,
 * @code
 *
 *  http_via_t http_via = HTTP_VIA_INIT;
 *
 * @endcode
 * @HI
 */
#define HTTP_VIA_INIT() HTTP_HDR_INIT(via)

/**Initialize a structure http_via_t.
 *
 * An http_via_t structure can be initialized with the
 * http_via_init() function/macro. For instance,
 * @code
 *
 *  http_via_t http_via;
 *
 *  http_via_init(&http_via);
 *
 * @endcode
 * @HI
 */
#if SU_HAVE_INLINE
su_inline http_via_t *http_via_init(http_via_t x[1])
{
  return HTTP_HEADER_INIT(x, http_via_class, sizeof(http_via_t));
}
#else
#define http_via_init(x) \
  HTTP_HEADER_INIT(x, http_via_class, sizeof(http_via_t))
#endif

/**Test if header object is instance of http_via_t.
 *
 * The function http_is_via() returns true (nonzero) if
 * the header class is an instance of Via header
 * object and false (zero) otherwise.
 *
 * @param header pointer to the header structure to be tested
 *
 * @return
 * The function http_is_xvia() returns true (nonzero) if
 * the header object is an instance of header via and
 * false (zero) otherwise.
 */
#if SU_HAVE_INLINE
su_inline
int http_is_via(http_header_t const *header)
{
  return header && header->sh_class->hc_hash == http_via_hash;
}
#else
#define http_is_via(h) \
 ((h) && ((msg_common_t *)(h))->h_class->hc_hash == http_via_hash)
#endif

/**Duplicate (deep copy) @c http_via_t.
 *
 * The function http_via_dup() duplicates a header
 * structure @a hdr.  If the header structure @a hdr
 * contains a reference (@c hdr->x_next) to a list of
 * headers, all the headers in the list are duplicated, too.
 *
 * @param home  memory home used to allocate new structure
 * @param hdr   header structure to be duplicated
 *
 * When duplicating, all parameter lists and non-constant
 * strings attached to the header are copied, too.  The
 * function uses given memory @a home to allocate all the
 * memory areas used to copy the header.
 *
 * @par Example
 * @code
 *
 *   via = http_via_dup(home, http->http_via);
 *
 * @endcode
 *
 * @return
 * The function http_via_dup() returns a pointer to the
 * newly duplicated http_via_t header structure, or NULL
 * upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_via_t *http_via_dup(su_home_t *home,
				   http_via_t const *hdr)
     __attribute__((__malloc__));

/**Copy a http_via_t header structure.
 *
 * The function http_via_copy() copies a header structure @a
 * hdr.  If the header structure @a hdr contains a reference (@c
 * hdr->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home
 * to allocate all the memory areas used to copy the header
 * structure @a hdr.
 *
 * @param home    memory home used to allocate new structure
 * @param hdr     pointer to the header structure to be duplicated
 *
 * When copying, only the header structure and parameter lists
 * attached to it are duplicated.  The new header structure
 * retains all the references to the strings within the old @a
 * header, including the encoding of the old header, if present.
 *
 * @par Example
 * @code
 *
 *   via = http_via_copy(home, http->http_via);
 *
 * @endcode
 *
 * @return
 * The function http_via_copy() returns a pointer to
 * newly copied header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_via_t *http_via_copy(su_home_t *home,
				    http_via_t const *hdr)
     __attribute__((__malloc__));

/**Make a header structure http_via_t.
 *
 * The function http_via_make() makes a new
 * http_via_t header structure.  It allocates a new
 * header structure, and decodes the string @a s as the
 * value of the structure.
 *
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 *
 * @note This function is usually implemented as a macro calling
 * http_header_make().
 *
 * @return
 * The function http_via_make() returns a pointer to
 * newly maked http_via_t header structure, or NULL upon
 * an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_via_t *http_via_make(su_home_t *home, char const *s)
     __attribute__((__malloc__));

/**Make a Via header from formatting result.
 *
 * The function http_via_format() makes a new
 * Via header object using formatting result as its
 * value.  The function first prints the arguments according to
 * the format @a fmt specified.  Then it allocates a new header
 * structure, and uses the formatting result as the header
 * value.
 *
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 *
 * @note This function is usually implemented as a macro calling
 * msg_header_format().
 *
 * @return
 * The function http_via_format() returns a pointer to newly
 * makes header structure, or NULL upon an error.
 *
 * @HIDE
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_via_t *http_via_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__malloc__, __format__ (printf, 2, 3)));


/* Inlined functions */
#if SU_HAVE_INLINE
su_inline
http_via_t *http_via_format(su_home_t *home, char const *fmt, ...)
{
  http_header_t *h;
  va_list ap;

  va_start(ap, fmt);
  h = http_header_vformat(home, http_via_class, fmt, ap);
  va_end(ap);

  return (http_via_t *)h;
}

su_inline
http_via_t *http_via_dup(su_home_t *home, http_via_t const *o)
{
  return (http_via_t *)
    msg_header_dup_as(home, http_via_class, (msg_header_t const *)o);
}

su_inline
http_via_t *http_via_copy(su_home_t *home, http_via_t const *o)
{
  return (http_via_t *)
    msg_header_copy_as(home, http_via_class, (msg_header_t const *)o);
}

su_inline
http_via_t *http_via_make(su_home_t *home, char const *s)
{
  return (http_via_t *)http_header_make(home, http_via_class, s);
}
#endif

#endif /* !define HTTP_HCLASSES_ONLY */

/** @} */


/* Declare internal prototypes for Warning header */

/**@addtogroup http_warning*/ /** @{ */

enum {
  /** Hash of Warning header. @internal*/
  http_warning_hash = 4130
};

/**Header class for HTTP Warning header.
 *
 * The header class http_warning_class defines how a HTTP
 * Warning header is parsed and printed.  It also
 * contains methods used by HTTP parser and other functions
 * to manipulate the http_warning_t header structure.
 *
 */
SOFIAPUBVAR msg_hclass_t http_warning_class[];

#ifndef HTTP_HCLASSES_ONLY

/** Decode (parse) a Warning header. @internal */
SOFIAPUBFUN msg_parse_f http_warning_d;

/** Encode (print) a Warning header. @internal */
SOFIAPUBFUN msg_print_f http_warning_e;

/**Initializer for structure http_warning_t.
 *
 * A static http_warning_t structure must be initialized
 * with the HTTP_WARNING_INIT() macro. For instance,
 * @code
 *
 *  http_warning_t http_warning = HTTP_WARNING_INIT;
 *
 * @endcode
 * @HI
 */
#define HTTP_WARNING_INIT() HTTP_HDR_INIT(warning)

/**Initialize a structure http_warning_t.
 *
 * An http_warning_t structure can be initialized with the
 * http_warning_init() function/macro. For instance,
 * @code
 *
 *  http_warning_t http_warning;
 *
 *  http_warning_init(&http_warning);
 *
 * @endcode
 * @HI
 */
#if SU_HAVE_INLINE
su_inline http_warning_t *http_warning_init(http_warning_t x[1])
{
  return HTTP_HEADER_INIT(x, http_warning_class, sizeof(http_warning_t));
}
#else
#define http_warning_init(x) \
  HTTP_HEADER_INIT(x, http_warning_class, sizeof(http_warning_t))
#endif

/**Test if header object is instance of http_warning_t.
 *
 * The function http_is_warning() returns true (nonzero) if
 * the header class is an instance of Warning header
 * object and false (zero) otherwise.
 *
 * @param header pointer to the header structure to be tested
 *
 * @return
 * The function http_is_xwarning() returns true (nonzero) if
 * the header object is an instance of header warning and
 * false (zero) otherwise.
 */
#if SU_HAVE_INLINE
su_inline
int http_is_warning(http_header_t const *header)
{
  return header && header->sh_class->hc_hash == http_warning_hash;
}
#else
#define http_is_warning(h) \
 ((h) && ((msg_common_t *)(h))->h_class->hc_hash == http_warning_hash)
#endif

/**Duplicate (deep copy) @c http_warning_t.
 *
 * The function http_warning_dup() duplicates a header
 * structure @a hdr.  If the header structure @a hdr
 * contains a reference (@c hdr->x_next) to a list of
 * headers, all the headers in the list are duplicated, too.
 *
 * @param home  memory home used to allocate new structure
 * @param hdr   header structure to be duplicated
 *
 * When duplicating, all parameter lists and non-constant
 * strings attached to the header are copied, too.  The
 * function uses given memory @a home to allocate all the
 * memory areas used to copy the header.
 *
 * @par Example
 * @code
 *
 *   warning = http_warning_dup(home, http->http_warning);
 *
 * @endcode
 *
 * @return
 * The function http_warning_dup() returns a pointer to the
 * newly duplicated http_warning_t header structure, or NULL
 * upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_warning_t *http_warning_dup(su_home_t *home,
				   http_warning_t const *hdr)
     __attribute__((__malloc__));

/**Copy a http_warning_t header structure.
 *
 * The function http_warning_copy() copies a header structure @a
 * hdr.  If the header structure @a hdr contains a reference (@c
 * hdr->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home
 * to allocate all the memory areas used to copy the header
 * structure @a hdr.
 *
 * @param home    memory home used to allocate new structure
 * @param hdr     pointer to the header structure to be duplicated
 *
 * When copying, only the header structure and parameter lists
 * attached to it are duplicated.  The new header structure
 * retains all the references to the strings within the old @a
 * header, including the encoding of the old header, if present.
 *
 * @par Example
 * @code
 *
 *   warning = http_warning_copy(home, http->http_warning);
 *
 * @endcode
 *
 * @return
 * The function http_warning_copy() returns a pointer to
 * newly copied header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_warning_t *http_warning_copy(su_home_t *home,
				    http_warning_t const *hdr)
     __attribute__((__malloc__));

/**Make a header structure http_warning_t.
 *
 * The function http_warning_make() makes a new
 * http_warning_t header structure.  It allocates a new
 * header structure, and decodes the string @a s as the
 * value of the structure.
 *
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 *
 * @note This function is usually implemented as a macro calling
 * http_header_make().
 *
 * @return
 * The function http_warning_make() returns a pointer to
 * newly maked http_warning_t header structure, or NULL upon
 * an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_warning_t *http_warning_make(su_home_t *home, char const *s)
     __attribute__((__malloc__));

/**Make a Warning header from formatting result.
 *
 * The function http_warning_format() makes a new
 * Warning header object using formatting result as its
 * value.  The function first prints the arguments according to
 * the format @a fmt specified.  Then it allocates a new header
 * structure, and uses the formatting result as the header
 * value.
 *
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 *
 * @note This function is usually implemented as a macro calling
 * msg_header_format().
 *
 * @return
 * The function http_warning_format() returns a pointer to newly
 * makes header structure, or NULL upon an error.
 *
 * @HIDE
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_warning_t *http_warning_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__malloc__, __format__ (printf, 2, 3)));


/* Inlined functions */
#if SU_HAVE_INLINE
su_inline
http_warning_t *http_warning_format(su_home_t *home, char const *fmt, ...)
{
  http_header_t *h;
  va_list ap;

  va_start(ap, fmt);
  h = http_header_vformat(home, http_warning_class, fmt, ap);
  va_end(ap);

  return (http_warning_t *)h;
}

su_inline
http_warning_t *http_warning_dup(su_home_t *home, http_warning_t const *o)
{
  return (http_warning_t *)
    msg_header_dup_as(home, http_warning_class, (msg_header_t const *)o);
}

su_inline
http_warning_t *http_warning_copy(su_home_t *home, http_warning_t const *o)
{
  return (http_warning_t *)
    msg_header_copy_as(home, http_warning_class, (msg_header_t const *)o);
}

su_inline
http_warning_t *http_warning_make(su_home_t *home, char const *s)
{
  return (http_warning_t *)http_header_make(home, http_warning_class, s);
}
#endif

#endif /* !define HTTP_HCLASSES_ONLY */

/** @} */


/* Declare internal prototypes for WWW-Authenticate header */

/**@addtogroup http_www_authenticate*/ /** @{ */

enum {
  /** Hash of WWW-Authenticate header. @internal*/
  http_www_authenticate_hash = 16217
};

/**Header class for HTTP WWW-Authenticate header.
 *
 * The header class http_www_authenticate_class defines how a HTTP
 * WWW-Authenticate header is parsed and printed.  It also
 * contains methods used by HTTP parser and other functions
 * to manipulate the http_www_authenticate_t header structure.
 *
 */
SOFIAPUBVAR msg_hclass_t http_www_authenticate_class[];

#ifndef HTTP_HCLASSES_ONLY

/** Decode (parse) a WWW-Authenticate header. @internal */
SOFIAPUBFUN msg_parse_f http_www_authenticate_d;

/** Encode (print) a WWW-Authenticate header. @internal */
SOFIAPUBFUN msg_print_f http_www_authenticate_e;

/**Initializer for structure http_www_authenticate_t.
 *
 * A static http_www_authenticate_t structure must be initialized
 * with the HTTP_WWW_AUTHENTICATE_INIT() macro. For instance,
 * @code
 *
 *  http_www_authenticate_t http_www_authenticate = HTTP_WWW_AUTHENTICATE_INIT;
 *
 * @endcode
 * @HI
 */
#define HTTP_WWW_AUTHENTICATE_INIT() HTTP_HDR_INIT(www_authenticate)

/**Initialize a structure http_www_authenticate_t.
 *
 * An http_www_authenticate_t structure can be initialized with the
 * http_www_authenticate_init() function/macro. For instance,
 * @code
 *
 *  http_www_authenticate_t http_www_authenticate;
 *
 *  http_www_authenticate_init(&http_www_authenticate);
 *
 * @endcode
 * @HI
 */
#if SU_HAVE_INLINE
su_inline http_www_authenticate_t *http_www_authenticate_init(http_www_authenticate_t x[1])
{
  return HTTP_HEADER_INIT(x, http_www_authenticate_class, sizeof(http_www_authenticate_t));
}
#else
#define http_www_authenticate_init(x) \
  HTTP_HEADER_INIT(x, http_www_authenticate_class, sizeof(http_www_authenticate_t))
#endif

/**Test if header object is instance of http_www_authenticate_t.
 *
 * The function http_is_www_authenticate() returns true (nonzero) if
 * the header class is an instance of WWW-Authenticate header
 * object and false (zero) otherwise.
 *
 * @param header pointer to the header structure to be tested
 *
 * @return
 * The function http_is_xwww_authenticate() returns true (nonzero) if
 * the header object is an instance of header www_authenticate and
 * false (zero) otherwise.
 */
#if SU_HAVE_INLINE
su_inline
int http_is_www_authenticate(http_header_t const *header)
{
  return header && header->sh_class->hc_hash == http_www_authenticate_hash;
}
#else
#define http_is_www_authenticate(h) \
 ((h) && ((msg_common_t *)(h))->h_class->hc_hash == http_www_authenticate_hash)
#endif

/**Duplicate (deep copy) @c http_www_authenticate_t.
 *
 * The function http_www_authenticate_dup() duplicates a header
 * structure @a hdr.  If the header structure @a hdr
 * contains a reference (@c hdr->x_next) to a list of
 * headers, all the headers in the list are duplicated, too.
 *
 * @param home  memory home used to allocate new structure
 * @param hdr   header structure to be duplicated
 *
 * When duplicating, all parameter lists and non-constant
 * strings attached to the header are copied, too.  The
 * function uses given memory @a home to allocate all the
 * memory areas used to copy the header.
 *
 * @par Example
 * @code
 *
 *   www_authenticate = http_www_authenticate_dup(home, http->http_www_authenticate);
 *
 * @endcode
 *
 * @return
 * The function http_www_authenticate_dup() returns a pointer to the
 * newly duplicated http_www_authenticate_t header structure, or NULL
 * upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_www_authenticate_t *http_www_authenticate_dup(su_home_t *home,
				   http_www_authenticate_t const *hdr)
     __attribute__((__malloc__));

/**Copy a http_www_authenticate_t header structure.
 *
 * The function http_www_authenticate_copy() copies a header structure @a
 * hdr.  If the header structure @a hdr contains a reference (@c
 * hdr->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home
 * to allocate all the memory areas used to copy the header
 * structure @a hdr.
 *
 * @param home    memory home used to allocate new structure
 * @param hdr     pointer to the header structure to be duplicated
 *
 * When copying, only the header structure and parameter lists
 * attached to it are duplicated.  The new header structure
 * retains all the references to the strings within the old @a
 * header, including the encoding of the old header, if present.
 *
 * @par Example
 * @code
 *
 *   www_authenticate = http_www_authenticate_copy(home, http->http_www_authenticate);
 *
 * @endcode
 *
 * @return
 * The function http_www_authenticate_copy() returns a pointer to
 * newly copied header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_www_authenticate_t *http_www_authenticate_copy(su_home_t *home,
				    http_www_authenticate_t const *hdr)
     __attribute__((__malloc__));

/**Make a header structure http_www_authenticate_t.
 *
 * The function http_www_authenticate_make() makes a new
 * http_www_authenticate_t header structure.  It allocates a new
 * header structure, and decodes the string @a s as the
 * value of the structure.
 *
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 *
 * @note This function is usually implemented as a macro calling
 * http_header_make().
 *
 * @return
 * The function http_www_authenticate_make() returns a pointer to
 * newly maked http_www_authenticate_t header structure, or NULL upon
 * an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_www_authenticate_t *http_www_authenticate_make(su_home_t *home, char const *s)
     __attribute__((__malloc__));

/**Make a WWW-Authenticate header from formatting result.
 *
 * The function http_www_authenticate_format() makes a new
 * WWW-Authenticate header object using formatting result as its
 * value.  The function first prints the arguments according to
 * the format @a fmt specified.  Then it allocates a new header
 * structure, and uses the formatting result as the header
 * value.
 *
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 *
 * @note This function is usually implemented as a macro calling
 * msg_header_format().
 *
 * @return
 * The function http_www_authenticate_format() returns a pointer to newly
 * makes header structure, or NULL upon an error.
 *
 * @HIDE
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_www_authenticate_t *http_www_authenticate_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__malloc__, __format__ (printf, 2, 3)));


/* Inlined functions */
#if SU_HAVE_INLINE
su_inline
http_www_authenticate_t *http_www_authenticate_format(su_home_t *home, char const *fmt, ...)
{
  http_header_t *h;
  va_list ap;

  va_start(ap, fmt);
  h = http_header_vformat(home, http_www_authenticate_class, fmt, ap);
  va_end(ap);

  return (http_www_authenticate_t *)h;
}

su_inline
http_www_authenticate_t *http_www_authenticate_dup(su_home_t *home, http_www_authenticate_t const *o)
{
  return (http_www_authenticate_t *)
    msg_header_dup_as(home, http_www_authenticate_class, (msg_header_t const *)o);
}

su_inline
http_www_authenticate_t *http_www_authenticate_copy(su_home_t *home, http_www_authenticate_t const *o)
{
  return (http_www_authenticate_t *)
    msg_header_copy_as(home, http_www_authenticate_class, (msg_header_t const *)o);
}

su_inline
http_www_authenticate_t *http_www_authenticate_make(su_home_t *home, char const *s)
{
  return (http_www_authenticate_t *)http_header_make(home, http_www_authenticate_class, s);
}
#endif

#endif /* !define HTTP_HCLASSES_ONLY */

/** @} */


/* Declare internal prototypes for Proxy-Connection header */

/**@addtogroup http_proxy_connection*/ /** @{ */

enum {
  /** Hash of Proxy-Connection header. @internal*/
  http_proxy_connection_hash = 60183
};

/**Header class for HTTP Proxy-Connection header.
 *
 * The header class http_proxy_connection_class defines how a HTTP
 * Proxy-Connection header is parsed and printed.  It also
 * contains methods used by HTTP parser and other functions
 * to manipulate the http_proxy_connection_t header structure.
 *
 */
SOFIAPUBVAR msg_hclass_t http_proxy_connection_class[];

#ifndef HTTP_HCLASSES_ONLY

/** Decode (parse) a Proxy-Connection header. @internal */
SOFIAPUBFUN msg_parse_f http_proxy_connection_d;

/** Encode (print) a Proxy-Connection header. @internal */
SOFIAPUBFUN msg_print_f http_proxy_connection_e;

/**Initializer for structure http_proxy_connection_t.
 *
 * A static http_proxy_connection_t structure must be initialized
 * with the HTTP_PROXY_CONNECTION_INIT() macro. For instance,
 * @code
 *
 *  http_proxy_connection_t http_proxy_connection = HTTP_PROXY_CONNECTION_INIT;
 *
 * @endcode
 * @HI
 */
#define HTTP_PROXY_CONNECTION_INIT() HTTP_HDR_INIT(proxy_connection)

/**Initialize a structure http_proxy_connection_t.
 *
 * An http_proxy_connection_t structure can be initialized with the
 * http_proxy_connection_init() function/macro. For instance,
 * @code
 *
 *  http_proxy_connection_t http_proxy_connection;
 *
 *  http_proxy_connection_init(&http_proxy_connection);
 *
 * @endcode
 * @HI
 */
#if SU_HAVE_INLINE
su_inline http_proxy_connection_t *http_proxy_connection_init(http_proxy_connection_t x[1])
{
  return HTTP_HEADER_INIT(x, http_proxy_connection_class, sizeof(http_proxy_connection_t));
}
#else
#define http_proxy_connection_init(x) \
  HTTP_HEADER_INIT(x, http_proxy_connection_class, sizeof(http_proxy_connection_t))
#endif

/**Test if header object is instance of http_proxy_connection_t.
 *
 * The function http_is_proxy_connection() returns true (nonzero) if
 * the header class is an instance of Proxy-Connection header
 * object and false (zero) otherwise.
 *
 * @param header pointer to the header structure to be tested
 *
 * @return
 * The function http_is_xproxy_connection() returns true (nonzero) if
 * the header object is an instance of header proxy_connection and
 * false (zero) otherwise.
 */
#if SU_HAVE_INLINE
su_inline
int http_is_proxy_connection(http_header_t const *header)
{
  return header && header->sh_class->hc_hash == http_proxy_connection_hash;
}
#else
#define http_is_proxy_connection(h) \
 ((h) && ((msg_common_t *)(h))->h_class->hc_hash == http_proxy_connection_hash)
#endif

/**Duplicate (deep copy) @c http_proxy_connection_t.
 *
 * The function http_proxy_connection_dup() duplicates a header
 * structure @a hdr.  If the header structure @a hdr
 * contains a reference (@c hdr->x_next) to a list of
 * headers, all the headers in the list are duplicated, too.
 *
 * @param home  memory home used to allocate new structure
 * @param hdr   header structure to be duplicated
 *
 * When duplicating, all parameter lists and non-constant
 * strings attached to the header are copied, too.  The
 * function uses given memory @a home to allocate all the
 * memory areas used to copy the header.
 *
 * @par Example
 * @code
 *
 *   proxy_connection = http_proxy_connection_dup(home, http->http_proxy_connection);
 *
 * @endcode
 *
 * @return
 * The function http_proxy_connection_dup() returns a pointer to the
 * newly duplicated http_proxy_connection_t header structure, or NULL
 * upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_proxy_connection_t *http_proxy_connection_dup(su_home_t *home,
				   http_proxy_connection_t const *hdr)
     __attribute__((__malloc__));

/**Copy a http_proxy_connection_t header structure.
 *
 * The function http_proxy_connection_copy() copies a header structure @a
 * hdr.  If the header structure @a hdr contains a reference (@c
 * hdr->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home
 * to allocate all the memory areas used to copy the header
 * structure @a hdr.
 *
 * @param home    memory home used to allocate new structure
 * @param hdr     pointer to the header structure to be duplicated
 *
 * When copying, only the header structure and parameter lists
 * attached to it are duplicated.  The new header structure
 * retains all the references to the strings within the old @a
 * header, including the encoding of the old header, if present.
 *
 * @par Example
 * @code
 *
 *   proxy_connection = http_proxy_connection_copy(home, http->http_proxy_connection);
 *
 * @endcode
 *
 * @return
 * The function http_proxy_connection_copy() returns a pointer to
 * newly copied header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_proxy_connection_t *http_proxy_connection_copy(su_home_t *home,
				    http_proxy_connection_t const *hdr)
     __attribute__((__malloc__));

/**Make a header structure http_proxy_connection_t.
 *
 * The function http_proxy_connection_make() makes a new
 * http_proxy_connection_t header structure.  It allocates a new
 * header structure, and decodes the string @a s as the
 * value of the structure.
 *
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 *
 * @note This function is usually implemented as a macro calling
 * http_header_make().
 *
 * @return
 * The function http_proxy_connection_make() returns a pointer to
 * newly maked http_proxy_connection_t header structure, or NULL upon
 * an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_proxy_connection_t *http_proxy_connection_make(su_home_t *home, char const *s)
     __attribute__((__malloc__));

/**Make a Proxy-Connection header from formatting result.
 *
 * The function http_proxy_connection_format() makes a new
 * Proxy-Connection header object using formatting result as its
 * value.  The function first prints the arguments according to
 * the format @a fmt specified.  Then it allocates a new header
 * structure, and uses the formatting result as the header
 * value.
 *
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 *
 * @note This function is usually implemented as a macro calling
 * msg_header_format().
 *
 * @return
 * The function http_proxy_connection_format() returns a pointer to newly
 * makes header structure, or NULL upon an error.
 *
 * @HIDE
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_proxy_connection_t *http_proxy_connection_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__malloc__, __format__ (printf, 2, 3)));


/* Inlined functions */
#if SU_HAVE_INLINE
su_inline
http_proxy_connection_t *http_proxy_connection_format(su_home_t *home, char const *fmt, ...)
{
  http_header_t *h;
  va_list ap;

  va_start(ap, fmt);
  h = http_header_vformat(home, http_proxy_connection_class, fmt, ap);
  va_end(ap);

  return (http_proxy_connection_t *)h;
}

su_inline
http_proxy_connection_t *http_proxy_connection_dup(su_home_t *home, http_proxy_connection_t const *o)
{
  return (http_proxy_connection_t *)
    msg_header_dup_as(home, http_proxy_connection_class, (msg_header_t const *)o);
}

su_inline
http_proxy_connection_t *http_proxy_connection_copy(su_home_t *home, http_proxy_connection_t const *o)
{
  return (http_proxy_connection_t *)
    msg_header_copy_as(home, http_proxy_connection_class, (msg_header_t const *)o);
}

su_inline
http_proxy_connection_t *http_proxy_connection_make(su_home_t *home, char const *s)
{
  return (http_proxy_connection_t *)http_header_make(home, http_proxy_connection_class, s);
}
#endif

#endif /* !define HTTP_HCLASSES_ONLY */

/** @} */


/* Declare internal prototypes for Set-Cookie header */

/**@addtogroup http_set_cookie*/ /** @{ */

enum {
  /** Hash of Set-Cookie header. @internal*/
  http_set_cookie_hash = 57887
};

/**Header class for HTTP Set-Cookie header.
 *
 * The header class http_set_cookie_class defines how a HTTP
 * Set-Cookie header is parsed and printed.  It also
 * contains methods used by HTTP parser and other functions
 * to manipulate the http_set_cookie_t header structure.
 *
 */
SOFIAPUBVAR msg_hclass_t http_set_cookie_class[];

#ifndef HTTP_HCLASSES_ONLY

/** Decode (parse) a Set-Cookie header. @internal */
SOFIAPUBFUN msg_parse_f http_set_cookie_d;

/** Encode (print) a Set-Cookie header. @internal */
SOFIAPUBFUN msg_print_f http_set_cookie_e;

/**Initializer for structure http_set_cookie_t.
 *
 * A static http_set_cookie_t structure must be initialized
 * with the HTTP_SET_COOKIE_INIT() macro. For instance,
 * @code
 *
 *  http_set_cookie_t http_set_cookie = HTTP_SET_COOKIE_INIT;
 *
 * @endcode
 * @HI
 */
#define HTTP_SET_COOKIE_INIT() HTTP_HDR_INIT(set_cookie)

/**Initialize a structure http_set_cookie_t.
 *
 * An http_set_cookie_t structure can be initialized with the
 * http_set_cookie_init() function/macro. For instance,
 * @code
 *
 *  http_set_cookie_t http_set_cookie;
 *
 *  http_set_cookie_init(&http_set_cookie);
 *
 * @endcode
 * @HI
 */
#if SU_HAVE_INLINE
su_inline http_set_cookie_t *http_set_cookie_init(http_set_cookie_t x[1])
{
  return HTTP_HEADER_INIT(x, http_set_cookie_class, sizeof(http_set_cookie_t));
}
#else
#define http_set_cookie_init(x) \
  HTTP_HEADER_INIT(x, http_set_cookie_class, sizeof(http_set_cookie_t))
#endif

/**Test if header object is instance of http_set_cookie_t.
 *
 * The function http_is_set_cookie() returns true (nonzero) if
 * the header class is an instance of Set-Cookie header
 * object and false (zero) otherwise.
 *
 * @param header pointer to the header structure to be tested
 *
 * @return
 * The function http_is_xset_cookie() returns true (nonzero) if
 * the header object is an instance of header set_cookie and
 * false (zero) otherwise.
 */
#if SU_HAVE_INLINE
su_inline
int http_is_set_cookie(http_header_t const *header)
{
  return header && header->sh_class->hc_hash == http_set_cookie_hash;
}
#else
#define http_is_set_cookie(h) \
 ((h) && ((msg_common_t *)(h))->h_class->hc_hash == http_set_cookie_hash)
#endif

/**Duplicate (deep copy) @c http_set_cookie_t.
 *
 * The function http_set_cookie_dup() duplicates a header
 * structure @a hdr.  If the header structure @a hdr
 * contains a reference (@c hdr->x_next) to a list of
 * headers, all the headers in the list are duplicated, too.
 *
 * @param home  memory home used to allocate new structure
 * @param hdr   header structure to be duplicated
 *
 * When duplicating, all parameter lists and non-constant
 * strings attached to the header are copied, too.  The
 * function uses given memory @a home to allocate all the
 * memory areas used to copy the header.
 *
 * @par Example
 * @code
 *
 *   set_cookie = http_set_cookie_dup(home, http->http_set_cookie);
 *
 * @endcode
 *
 * @return
 * The function http_set_cookie_dup() returns a pointer to the
 * newly duplicated http_set_cookie_t header structure, or NULL
 * upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_set_cookie_t *http_set_cookie_dup(su_home_t *home,
				   http_set_cookie_t const *hdr)
     __attribute__((__malloc__));

/**Copy a http_set_cookie_t header structure.
 *
 * The function http_set_cookie_copy() copies a header structure @a
 * hdr.  If the header structure @a hdr contains a reference (@c
 * hdr->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home
 * to allocate all the memory areas used to copy the header
 * structure @a hdr.
 *
 * @param home    memory home used to allocate new structure
 * @param hdr     pointer to the header structure to be duplicated
 *
 * When copying, only the header structure and parameter lists
 * attached to it are duplicated.  The new header structure
 * retains all the references to the strings within the old @a
 * header, including the encoding of the old header, if present.
 *
 * @par Example
 * @code
 *
 *   set_cookie = http_set_cookie_copy(home, http->http_set_cookie);
 *
 * @endcode
 *
 * @return
 * The function http_set_cookie_copy() returns a pointer to
 * newly copied header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_set_cookie_t *http_set_cookie_copy(su_home_t *home,
				    http_set_cookie_t const *hdr)
     __attribute__((__malloc__));

/**Make a header structure http_set_cookie_t.
 *
 * The function http_set_cookie_make() makes a new
 * http_set_cookie_t header structure.  It allocates a new
 * header structure, and decodes the string @a s as the
 * value of the structure.
 *
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 *
 * @note This function is usually implemented as a macro calling
 * http_header_make().
 *
 * @return
 * The function http_set_cookie_make() returns a pointer to
 * newly maked http_set_cookie_t header structure, or NULL upon
 * an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_set_cookie_t *http_set_cookie_make(su_home_t *home, char const *s)
     __attribute__((__malloc__));

/**Make a Set-Cookie header from formatting result.
 *
 * The function http_set_cookie_format() makes a new
 * Set-Cookie header object using formatting result as its
 * value.  The function first prints the arguments according to
 * the format @a fmt specified.  Then it allocates a new header
 * structure, and uses the formatting result as the header
 * value.
 *
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 *
 * @note This function is usually implemented as a macro calling
 * msg_header_format().
 *
 * @return
 * The function http_set_cookie_format() returns a pointer to newly
 * makes header structure, or NULL upon an error.
 *
 * @HIDE
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_set_cookie_t *http_set_cookie_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__malloc__, __format__ (printf, 2, 3)));


/* Inlined functions */
#if SU_HAVE_INLINE
su_inline
http_set_cookie_t *http_set_cookie_format(su_home_t *home, char const *fmt, ...)
{
  http_header_t *h;
  va_list ap;

  va_start(ap, fmt);
  h = http_header_vformat(home, http_set_cookie_class, fmt, ap);
  va_end(ap);

  return (http_set_cookie_t *)h;
}

su_inline
http_set_cookie_t *http_set_cookie_dup(su_home_t *home, http_set_cookie_t const *o)
{
  return (http_set_cookie_t *)
    msg_header_dup_as(home, http_set_cookie_class, (msg_header_t const *)o);
}

su_inline
http_set_cookie_t *http_set_cookie_copy(su_home_t *home, http_set_cookie_t const *o)
{
  return (http_set_cookie_t *)
    msg_header_copy_as(home, http_set_cookie_class, (msg_header_t const *)o);
}

su_inline
http_set_cookie_t *http_set_cookie_make(su_home_t *home, char const *s)
{
  return (http_set_cookie_t *)http_header_make(home, http_set_cookie_class, s);
}
#endif

#endif /* !define HTTP_HCLASSES_ONLY */

/** @} */


/* Declare internal prototypes for Cookie header */

/**@addtogroup http_cookie*/ /** @{ */

enum {
  /** Hash of Cookie header. @internal*/
  http_cookie_hash = 78
};

/**Header class for HTTP Cookie header.
 *
 * The header class http_cookie_class defines how a HTTP
 * Cookie header is parsed and printed.  It also
 * contains methods used by HTTP parser and other functions
 * to manipulate the http_cookie_t header structure.
 *
 */
SOFIAPUBVAR msg_hclass_t http_cookie_class[];

#ifndef HTTP_HCLASSES_ONLY

/** Decode (parse) a Cookie header. @internal */
SOFIAPUBFUN msg_parse_f http_cookie_d;

/** Encode (print) a Cookie header. @internal */
SOFIAPUBFUN msg_print_f http_cookie_e;

/**Initializer for structure http_cookie_t.
 *
 * A static http_cookie_t structure must be initialized
 * with the HTTP_COOKIE_INIT() macro. For instance,
 * @code
 *
 *  http_cookie_t http_cookie = HTTP_COOKIE_INIT;
 *
 * @endcode
 * @HI
 */
#define HTTP_COOKIE_INIT() HTTP_HDR_INIT(cookie)

/**Initialize a structure http_cookie_t.
 *
 * An http_cookie_t structure can be initialized with the
 * http_cookie_init() function/macro. For instance,
 * @code
 *
 *  http_cookie_t http_cookie;
 *
 *  http_cookie_init(&http_cookie);
 *
 * @endcode
 * @HI
 */
#if SU_HAVE_INLINE
su_inline http_cookie_t *http_cookie_init(http_cookie_t x[1])
{
  return HTTP_HEADER_INIT(x, http_cookie_class, sizeof(http_cookie_t));
}
#else
#define http_cookie_init(x) \
  HTTP_HEADER_INIT(x, http_cookie_class, sizeof(http_cookie_t))
#endif

/**Test if header object is instance of http_cookie_t.
 *
 * The function http_is_cookie() returns true (nonzero) if
 * the header class is an instance of Cookie header
 * object and false (zero) otherwise.
 *
 * @param header pointer to the header structure to be tested
 *
 * @return
 * The function http_is_xcookie() returns true (nonzero) if
 * the header object is an instance of header cookie and
 * false (zero) otherwise.
 */
#if SU_HAVE_INLINE
su_inline
int http_is_cookie(http_header_t const *header)
{
  return header && header->sh_class->hc_hash == http_cookie_hash;
}
#else
#define http_is_cookie(h) \
 ((h) && ((msg_common_t *)(h))->h_class->hc_hash == http_cookie_hash)
#endif

/**Duplicate (deep copy) @c http_cookie_t.
 *
 * The function http_cookie_dup() duplicates a header
 * structure @a hdr.  If the header structure @a hdr
 * contains a reference (@c hdr->x_next) to a list of
 * headers, all the headers in the list are duplicated, too.
 *
 * @param home  memory home used to allocate new structure
 * @param hdr   header structure to be duplicated
 *
 * When duplicating, all parameter lists and non-constant
 * strings attached to the header are copied, too.  The
 * function uses given memory @a home to allocate all the
 * memory areas used to copy the header.
 *
 * @par Example
 * @code
 *
 *   cookie = http_cookie_dup(home, http->http_cookie);
 *
 * @endcode
 *
 * @return
 * The function http_cookie_dup() returns a pointer to the
 * newly duplicated http_cookie_t header structure, or NULL
 * upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_cookie_t *http_cookie_dup(su_home_t *home,
				   http_cookie_t const *hdr)
     __attribute__((__malloc__));

/**Copy a http_cookie_t header structure.
 *
 * The function http_cookie_copy() copies a header structure @a
 * hdr.  If the header structure @a hdr contains a reference (@c
 * hdr->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home
 * to allocate all the memory areas used to copy the header
 * structure @a hdr.
 *
 * @param home    memory home used to allocate new structure
 * @param hdr     pointer to the header structure to be duplicated
 *
 * When copying, only the header structure and parameter lists
 * attached to it are duplicated.  The new header structure
 * retains all the references to the strings within the old @a
 * header, including the encoding of the old header, if present.
 *
 * @par Example
 * @code
 *
 *   cookie = http_cookie_copy(home, http->http_cookie);
 *
 * @endcode
 *
 * @return
 * The function http_cookie_copy() returns a pointer to
 * newly copied header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_cookie_t *http_cookie_copy(su_home_t *home,
				    http_cookie_t const *hdr)
     __attribute__((__malloc__));

/**Make a header structure http_cookie_t.
 *
 * The function http_cookie_make() makes a new
 * http_cookie_t header structure.  It allocates a new
 * header structure, and decodes the string @a s as the
 * value of the structure.
 *
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 *
 * @note This function is usually implemented as a macro calling
 * http_header_make().
 *
 * @return
 * The function http_cookie_make() returns a pointer to
 * newly maked http_cookie_t header structure, or NULL upon
 * an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_cookie_t *http_cookie_make(su_home_t *home, char const *s)
     __attribute__((__malloc__));

/**Make a Cookie header from formatting result.
 *
 * The function http_cookie_format() makes a new
 * Cookie header object using formatting result as its
 * value.  The function first prints the arguments according to
 * the format @a fmt specified.  Then it allocates a new header
 * structure, and uses the formatting result as the header
 * value.
 *
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 *
 * @note This function is usually implemented as a macro calling
 * msg_header_format().
 *
 * @return
 * The function http_cookie_format() returns a pointer to newly
 * makes header structure, or NULL upon an error.
 *
 * @HIDE
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_cookie_t *http_cookie_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__malloc__, __format__ (printf, 2, 3)));


/* Inlined functions */
#if SU_HAVE_INLINE
su_inline
http_cookie_t *http_cookie_format(su_home_t *home, char const *fmt, ...)
{
  http_header_t *h;
  va_list ap;

  va_start(ap, fmt);
  h = http_header_vformat(home, http_cookie_class, fmt, ap);
  va_end(ap);

  return (http_cookie_t *)h;
}

su_inline
http_cookie_t *http_cookie_dup(su_home_t *home, http_cookie_t const *o)
{
  return (http_cookie_t *)
    msg_header_dup_as(home, http_cookie_class, (msg_header_t const *)o);
}

su_inline
http_cookie_t *http_cookie_copy(su_home_t *home, http_cookie_t const *o)
{
  return (http_cookie_t *)
    msg_header_copy_as(home, http_cookie_class, (msg_header_t const *)o);
}

su_inline
http_cookie_t *http_cookie_make(su_home_t *home, char const *s)
{
  return (http_cookie_t *)http_header_make(home, http_cookie_class, s);
}
#endif

#endif /* !define HTTP_HCLASSES_ONLY */

/** @} */


/* Declare internal prototypes for MIME-Version header */

/**@addtogroup http_mime_version*/ /** @{ */

enum {
  /** Hash of MIME-Version header. @internal*/
  http_mime_version_hash = 49047
};

/**Header class for HTTP MIME-Version header.
 *
 * The header class http_mime_version_class defines how a HTTP
 * MIME-Version header is parsed and printed.  It also
 * contains methods used by HTTP parser and other functions
 * to manipulate the http_mime_version_t header structure.
 *
 */
SOFIAPUBVAR msg_hclass_t http_mime_version_class[];

#ifndef HTTP_HCLASSES_ONLY

/** Decode (parse) a MIME-Version header. @internal */
SOFIAPUBFUN msg_parse_f http_mime_version_d;

/** Encode (print) a MIME-Version header. @internal */
SOFIAPUBFUN msg_print_f http_mime_version_e;

/**Initializer for structure http_mime_version_t.
 *
 * A static http_mime_version_t structure must be initialized
 * with the HTTP_MIME_VERSION_INIT() macro. For instance,
 * @code
 *
 *  http_mime_version_t http_mime_version = HTTP_MIME_VERSION_INIT;
 *
 * @endcode
 * @HI
 */
#define HTTP_MIME_VERSION_INIT() HTTP_HDR_INIT(mime_version)

/**Initialize a structure http_mime_version_t.
 *
 * An http_mime_version_t structure can be initialized with the
 * http_mime_version_init() function/macro. For instance,
 * @code
 *
 *  http_mime_version_t http_mime_version;
 *
 *  http_mime_version_init(&http_mime_version);
 *
 * @endcode
 * @HI
 */
#if SU_HAVE_INLINE
su_inline http_mime_version_t *http_mime_version_init(http_mime_version_t x[1])
{
  return HTTP_HEADER_INIT(x, http_mime_version_class, sizeof(http_mime_version_t));
}
#else
#define http_mime_version_init(x) \
  HTTP_HEADER_INIT(x, http_mime_version_class, sizeof(http_mime_version_t))
#endif

/**Test if header object is instance of http_mime_version_t.
 *
 * The function http_is_mime_version() returns true (nonzero) if
 * the header class is an instance of MIME-Version header
 * object and false (zero) otherwise.
 *
 * @param header pointer to the header structure to be tested
 *
 * @return
 * The function http_is_xmime_version() returns true (nonzero) if
 * the header object is an instance of header mime_version and
 * false (zero) otherwise.
 */
#if SU_HAVE_INLINE
su_inline
int http_is_mime_version(http_header_t const *header)
{
  return header && header->sh_class->hc_hash == http_mime_version_hash;
}
#else
#define http_is_mime_version(h) \
 ((h) && ((msg_common_t *)(h))->h_class->hc_hash == http_mime_version_hash)
#endif

/**Duplicate (deep copy) @c http_mime_version_t.
 *
 * The function http_mime_version_dup() duplicates a header
 * structure @a hdr.  If the header structure @a hdr
 * contains a reference (@c hdr->x_next) to a list of
 * headers, all the headers in the list are duplicated, too.
 *
 * @param home  memory home used to allocate new structure
 * @param hdr   header structure to be duplicated
 *
 * When duplicating, all parameter lists and non-constant
 * strings attached to the header are copied, too.  The
 * function uses given memory @a home to allocate all the
 * memory areas used to copy the header.
 *
 * @par Example
 * @code
 *
 *   mime_version = http_mime_version_dup(home, http->http_mime_version);
 *
 * @endcode
 *
 * @return
 * The function http_mime_version_dup() returns a pointer to the
 * newly duplicated http_mime_version_t header structure, or NULL
 * upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_mime_version_t *http_mime_version_dup(su_home_t *home,
				   http_mime_version_t const *hdr)
     __attribute__((__malloc__));

/**Copy a http_mime_version_t header structure.
 *
 * The function http_mime_version_copy() copies a header structure @a
 * hdr.  If the header structure @a hdr contains a reference (@c
 * hdr->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home
 * to allocate all the memory areas used to copy the header
 * structure @a hdr.
 *
 * @param home    memory home used to allocate new structure
 * @param hdr     pointer to the header structure to be duplicated
 *
 * When copying, only the header structure and parameter lists
 * attached to it are duplicated.  The new header structure
 * retains all the references to the strings within the old @a
 * header, including the encoding of the old header, if present.
 *
 * @par Example
 * @code
 *
 *   mime_version = http_mime_version_copy(home, http->http_mime_version);
 *
 * @endcode
 *
 * @return
 * The function http_mime_version_copy() returns a pointer to
 * newly copied header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_mime_version_t *http_mime_version_copy(su_home_t *home,
				    http_mime_version_t const *hdr)
     __attribute__((__malloc__));

/**Make a header structure http_mime_version_t.
 *
 * The function http_mime_version_make() makes a new
 * http_mime_version_t header structure.  It allocates a new
 * header structure, and decodes the string @a s as the
 * value of the structure.
 *
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 *
 * @note This function is usually implemented as a macro calling
 * http_header_make().
 *
 * @return
 * The function http_mime_version_make() returns a pointer to
 * newly maked http_mime_version_t header structure, or NULL upon
 * an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_mime_version_t *http_mime_version_make(su_home_t *home, char const *s)
     __attribute__((__malloc__));

/**Make a MIME-Version header from formatting result.
 *
 * The function http_mime_version_format() makes a new
 * MIME-Version header object using formatting result as its
 * value.  The function first prints the arguments according to
 * the format @a fmt specified.  Then it allocates a new header
 * structure, and uses the formatting result as the header
 * value.
 *
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 *
 * @note This function is usually implemented as a macro calling
 * msg_header_format().
 *
 * @return
 * The function http_mime_version_format() returns a pointer to newly
 * makes header structure, or NULL upon an error.
 *
 * @HIDE
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_mime_version_t *http_mime_version_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__malloc__, __format__ (printf, 2, 3)));


/* Inlined functions */
#if SU_HAVE_INLINE
su_inline
http_mime_version_t *http_mime_version_format(su_home_t *home, char const *fmt, ...)
{
  http_header_t *h;
  va_list ap;

  va_start(ap, fmt);
  h = http_header_vformat(home, http_mime_version_class, fmt, ap);
  va_end(ap);

  return (http_mime_version_t *)h;
}

su_inline
http_mime_version_t *http_mime_version_dup(su_home_t *home, http_mime_version_t const *o)
{
  return (http_mime_version_t *)
    msg_header_dup_as(home, http_mime_version_class, (msg_header_t const *)o);
}

su_inline
http_mime_version_t *http_mime_version_copy(su_home_t *home, http_mime_version_t const *o)
{
  return (http_mime_version_t *)
    msg_header_copy_as(home, http_mime_version_class, (msg_header_t const *)o);
}

su_inline
http_mime_version_t *http_mime_version_make(su_home_t *home, char const *s)
{
  return (http_mime_version_t *)http_header_make(home, http_mime_version_class, s);
}
#endif

#endif /* !define HTTP_HCLASSES_ONLY */

/** @} */


/* Declare internal prototypes for Content-Encoding header */

/**@addtogroup http_content_encoding*/ /** @{ */

enum {
  /** Hash of Content-Encoding header. @internal*/
  http_content_encoding_hash = 8707
};

/**Header class for HTTP Content-Encoding header.
 *
 * The header class http_content_encoding_class defines how a HTTP
 * Content-Encoding header is parsed and printed.  It also
 * contains methods used by HTTP parser and other functions
 * to manipulate the http_content_encoding_t header structure.
 *
 */
SOFIAPUBVAR msg_hclass_t http_content_encoding_class[];

#ifndef HTTP_HCLASSES_ONLY

/** Decode (parse) a Content-Encoding header. @internal */
SOFIAPUBFUN msg_parse_f http_content_encoding_d;

/** Encode (print) a Content-Encoding header. @internal */
SOFIAPUBFUN msg_print_f http_content_encoding_e;

/**Initializer for structure http_content_encoding_t.
 *
 * A static http_content_encoding_t structure must be initialized
 * with the HTTP_CONTENT_ENCODING_INIT() macro. For instance,
 * @code
 *
 *  http_content_encoding_t http_content_encoding = HTTP_CONTENT_ENCODING_INIT;
 *
 * @endcode
 * @HI
 */
#define HTTP_CONTENT_ENCODING_INIT() HTTP_HDR_INIT(content_encoding)

/**Initialize a structure http_content_encoding_t.
 *
 * An http_content_encoding_t structure can be initialized with the
 * http_content_encoding_init() function/macro. For instance,
 * @code
 *
 *  http_content_encoding_t http_content_encoding;
 *
 *  http_content_encoding_init(&http_content_encoding);
 *
 * @endcode
 * @HI
 */
#if SU_HAVE_INLINE
su_inline http_content_encoding_t *http_content_encoding_init(http_content_encoding_t x[1])
{
  return HTTP_HEADER_INIT(x, http_content_encoding_class, sizeof(http_content_encoding_t));
}
#else
#define http_content_encoding_init(x) \
  HTTP_HEADER_INIT(x, http_content_encoding_class, sizeof(http_content_encoding_t))
#endif

/**Test if header object is instance of http_content_encoding_t.
 *
 * The function http_is_content_encoding() returns true (nonzero) if
 * the header class is an instance of Content-Encoding header
 * object and false (zero) otherwise.
 *
 * @param header pointer to the header structure to be tested
 *
 * @return
 * The function http_is_xcontent_encoding() returns true (nonzero) if
 * the header object is an instance of header content_encoding and
 * false (zero) otherwise.
 */
#if SU_HAVE_INLINE
su_inline
int http_is_content_encoding(http_header_t const *header)
{
  return header && header->sh_class->hc_hash == http_content_encoding_hash;
}
#else
#define http_is_content_encoding(h) \
 ((h) && ((msg_common_t *)(h))->h_class->hc_hash == http_content_encoding_hash)
#endif

/**Duplicate (deep copy) @c http_content_encoding_t.
 *
 * The function http_content_encoding_dup() duplicates a header
 * structure @a hdr.  If the header structure @a hdr
 * contains a reference (@c hdr->x_next) to a list of
 * headers, all the headers in the list are duplicated, too.
 *
 * @param home  memory home used to allocate new structure
 * @param hdr   header structure to be duplicated
 *
 * When duplicating, all parameter lists and non-constant
 * strings attached to the header are copied, too.  The
 * function uses given memory @a home to allocate all the
 * memory areas used to copy the header.
 *
 * @par Example
 * @code
 *
 *   content_encoding = http_content_encoding_dup(home, http->http_content_encoding);
 *
 * @endcode
 *
 * @return
 * The function http_content_encoding_dup() returns a pointer to the
 * newly duplicated http_content_encoding_t header structure, or NULL
 * upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_content_encoding_t *http_content_encoding_dup(su_home_t *home,
				   http_content_encoding_t const *hdr)
     __attribute__((__malloc__));

/**Copy a http_content_encoding_t header structure.
 *
 * The function http_content_encoding_copy() copies a header structure @a
 * hdr.  If the header structure @a hdr contains a reference (@c
 * hdr->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home
 * to allocate all the memory areas used to copy the header
 * structure @a hdr.
 *
 * @param home    memory home used to allocate new structure
 * @param hdr     pointer to the header structure to be duplicated
 *
 * When copying, only the header structure and parameter lists
 * attached to it are duplicated.  The new header structure
 * retains all the references to the strings within the old @a
 * header, including the encoding of the old header, if present.
 *
 * @par Example
 * @code
 *
 *   content_encoding = http_content_encoding_copy(home, http->http_content_encoding);
 *
 * @endcode
 *
 * @return
 * The function http_content_encoding_copy() returns a pointer to
 * newly copied header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_content_encoding_t *http_content_encoding_copy(su_home_t *home,
				    http_content_encoding_t const *hdr)
     __attribute__((__malloc__));

/**Make a header structure http_content_encoding_t.
 *
 * The function http_content_encoding_make() makes a new
 * http_content_encoding_t header structure.  It allocates a new
 * header structure, and decodes the string @a s as the
 * value of the structure.
 *
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 *
 * @note This function is usually implemented as a macro calling
 * http_header_make().
 *
 * @return
 * The function http_content_encoding_make() returns a pointer to
 * newly maked http_content_encoding_t header structure, or NULL upon
 * an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_content_encoding_t *http_content_encoding_make(su_home_t *home, char const *s)
     __attribute__((__malloc__));

/**Make a Content-Encoding header from formatting result.
 *
 * The function http_content_encoding_format() makes a new
 * Content-Encoding header object using formatting result as its
 * value.  The function first prints the arguments according to
 * the format @a fmt specified.  Then it allocates a new header
 * structure, and uses the formatting result as the header
 * value.
 *
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 *
 * @note This function is usually implemented as a macro calling
 * msg_header_format().
 *
 * @return
 * The function http_content_encoding_format() returns a pointer to newly
 * makes header structure, or NULL upon an error.
 *
 * @HIDE
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_content_encoding_t *http_content_encoding_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__malloc__, __format__ (printf, 2, 3)));


/* Inlined functions */
#if SU_HAVE_INLINE
su_inline
http_content_encoding_t *http_content_encoding_format(su_home_t *home, char const *fmt, ...)
{
  http_header_t *h;
  va_list ap;

  va_start(ap, fmt);
  h = http_header_vformat(home, http_content_encoding_class, fmt, ap);
  va_end(ap);

  return (http_content_encoding_t *)h;
}

su_inline
http_content_encoding_t *http_content_encoding_dup(su_home_t *home, http_content_encoding_t const *o)
{
  return (http_content_encoding_t *)
    msg_header_dup_as(home, http_content_encoding_class, (msg_header_t const *)o);
}

su_inline
http_content_encoding_t *http_content_encoding_copy(su_home_t *home, http_content_encoding_t const *o)
{
  return (http_content_encoding_t *)
    msg_header_copy_as(home, http_content_encoding_class, (msg_header_t const *)o);
}

su_inline
http_content_encoding_t *http_content_encoding_make(su_home_t *home, char const *s)
{
  return (http_content_encoding_t *)http_header_make(home, http_content_encoding_class, s);
}
#endif

#endif /* !define HTTP_HCLASSES_ONLY */

/** @} */


/* Declare internal prototypes for Content-Language header */

/**@addtogroup http_content_language*/ /** @{ */

enum {
  /** Hash of Content-Language header. @internal*/
  http_content_language_hash = 62108
};

/**Header class for HTTP Content-Language header.
 *
 * The header class http_content_language_class defines how a HTTP
 * Content-Language header is parsed and printed.  It also
 * contains methods used by HTTP parser and other functions
 * to manipulate the http_content_language_t header structure.
 *
 */
SOFIAPUBVAR msg_hclass_t http_content_language_class[];

#ifndef HTTP_HCLASSES_ONLY

/** Decode (parse) a Content-Language header. @internal */
SOFIAPUBFUN msg_parse_f http_content_language_d;

/** Encode (print) a Content-Language header. @internal */
SOFIAPUBFUN msg_print_f http_content_language_e;

/**Initializer for structure http_content_language_t.
 *
 * A static http_content_language_t structure must be initialized
 * with the HTTP_CONTENT_LANGUAGE_INIT() macro. For instance,
 * @code
 *
 *  http_content_language_t http_content_language = HTTP_CONTENT_LANGUAGE_INIT;
 *
 * @endcode
 * @HI
 */
#define HTTP_CONTENT_LANGUAGE_INIT() HTTP_HDR_INIT(content_language)

/**Initialize a structure http_content_language_t.
 *
 * An http_content_language_t structure can be initialized with the
 * http_content_language_init() function/macro. For instance,
 * @code
 *
 *  http_content_language_t http_content_language;
 *
 *  http_content_language_init(&http_content_language);
 *
 * @endcode
 * @HI
 */
#if SU_HAVE_INLINE
su_inline http_content_language_t *http_content_language_init(http_content_language_t x[1])
{
  return HTTP_HEADER_INIT(x, http_content_language_class, sizeof(http_content_language_t));
}
#else
#define http_content_language_init(x) \
  HTTP_HEADER_INIT(x, http_content_language_class, sizeof(http_content_language_t))
#endif

/**Test if header object is instance of http_content_language_t.
 *
 * The function http_is_content_language() returns true (nonzero) if
 * the header class is an instance of Content-Language header
 * object and false (zero) otherwise.
 *
 * @param header pointer to the header structure to be tested
 *
 * @return
 * The function http_is_xcontent_language() returns true (nonzero) if
 * the header object is an instance of header content_language and
 * false (zero) otherwise.
 */
#if SU_HAVE_INLINE
su_inline
int http_is_content_language(http_header_t const *header)
{
  return header && header->sh_class->hc_hash == http_content_language_hash;
}
#else
#define http_is_content_language(h) \
 ((h) && ((msg_common_t *)(h))->h_class->hc_hash == http_content_language_hash)
#endif

/**Duplicate (deep copy) @c http_content_language_t.
 *
 * The function http_content_language_dup() duplicates a header
 * structure @a hdr.  If the header structure @a hdr
 * contains a reference (@c hdr->x_next) to a list of
 * headers, all the headers in the list are duplicated, too.
 *
 * @param home  memory home used to allocate new structure
 * @param hdr   header structure to be duplicated
 *
 * When duplicating, all parameter lists and non-constant
 * strings attached to the header are copied, too.  The
 * function uses given memory @a home to allocate all the
 * memory areas used to copy the header.
 *
 * @par Example
 * @code
 *
 *   content_language = http_content_language_dup(home, http->http_content_language);
 *
 * @endcode
 *
 * @return
 * The function http_content_language_dup() returns a pointer to the
 * newly duplicated http_content_language_t header structure, or NULL
 * upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_content_language_t *http_content_language_dup(su_home_t *home,
				   http_content_language_t const *hdr)
     __attribute__((__malloc__));

/**Copy a http_content_language_t header structure.
 *
 * The function http_content_language_copy() copies a header structure @a
 * hdr.  If the header structure @a hdr contains a reference (@c
 * hdr->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home
 * to allocate all the memory areas used to copy the header
 * structure @a hdr.
 *
 * @param home    memory home used to allocate new structure
 * @param hdr     pointer to the header structure to be duplicated
 *
 * When copying, only the header structure and parameter lists
 * attached to it are duplicated.  The new header structure
 * retains all the references to the strings within the old @a
 * header, including the encoding of the old header, if present.
 *
 * @par Example
 * @code
 *
 *   content_language = http_content_language_copy(home, http->http_content_language);
 *
 * @endcode
 *
 * @return
 * The function http_content_language_copy() returns a pointer to
 * newly copied header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_content_language_t *http_content_language_copy(su_home_t *home,
				    http_content_language_t const *hdr)
     __attribute__((__malloc__));

/**Make a header structure http_content_language_t.
 *
 * The function http_content_language_make() makes a new
 * http_content_language_t header structure.  It allocates a new
 * header structure, and decodes the string @a s as the
 * value of the structure.
 *
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 *
 * @note This function is usually implemented as a macro calling
 * http_header_make().
 *
 * @return
 * The function http_content_language_make() returns a pointer to
 * newly maked http_content_language_t header structure, or NULL upon
 * an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_content_language_t *http_content_language_make(su_home_t *home, char const *s)
     __attribute__((__malloc__));

/**Make a Content-Language header from formatting result.
 *
 * The function http_content_language_format() makes a new
 * Content-Language header object using formatting result as its
 * value.  The function first prints the arguments according to
 * the format @a fmt specified.  Then it allocates a new header
 * structure, and uses the formatting result as the header
 * value.
 *
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 *
 * @note This function is usually implemented as a macro calling
 * msg_header_format().
 *
 * @return
 * The function http_content_language_format() returns a pointer to newly
 * makes header structure, or NULL upon an error.
 *
 * @HIDE
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_content_language_t *http_content_language_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__malloc__, __format__ (printf, 2, 3)));


/* Inlined functions */
#if SU_HAVE_INLINE
su_inline
http_content_language_t *http_content_language_format(su_home_t *home, char const *fmt, ...)
{
  http_header_t *h;
  va_list ap;

  va_start(ap, fmt);
  h = http_header_vformat(home, http_content_language_class, fmt, ap);
  va_end(ap);

  return (http_content_language_t *)h;
}

su_inline
http_content_language_t *http_content_language_dup(su_home_t *home, http_content_language_t const *o)
{
  return (http_content_language_t *)
    msg_header_dup_as(home, http_content_language_class, (msg_header_t const *)o);
}

su_inline
http_content_language_t *http_content_language_copy(su_home_t *home, http_content_language_t const *o)
{
  return (http_content_language_t *)
    msg_header_copy_as(home, http_content_language_class, (msg_header_t const *)o);
}

su_inline
http_content_language_t *http_content_language_make(su_home_t *home, char const *s)
{
  return (http_content_language_t *)http_header_make(home, http_content_language_class, s);
}
#endif

#endif /* !define HTTP_HCLASSES_ONLY */

/** @} */


/* Declare internal prototypes for Content-Length header */

/**@addtogroup http_content_length*/ /** @{ */

enum {
  /** Hash of Content-Length header. @internal*/
  http_content_length_hash = 8402
};

/**Header class for HTTP Content-Length header.
 *
 * The header class http_content_length_class defines how a HTTP
 * Content-Length header is parsed and printed.  It also
 * contains methods used by HTTP parser and other functions
 * to manipulate the http_content_length_t header structure.
 *
 */
SOFIAPUBVAR msg_hclass_t http_content_length_class[];

#ifndef HTTP_HCLASSES_ONLY

/** Decode (parse) a Content-Length header. @internal */
SOFIAPUBFUN msg_parse_f http_content_length_d;

/** Encode (print) a Content-Length header. @internal */
SOFIAPUBFUN msg_print_f http_content_length_e;

/**Initializer for structure http_content_length_t.
 *
 * A static http_content_length_t structure must be initialized
 * with the HTTP_CONTENT_LENGTH_INIT() macro. For instance,
 * @code
 *
 *  http_content_length_t http_content_length = HTTP_CONTENT_LENGTH_INIT;
 *
 * @endcode
 * @HI
 */
#define HTTP_CONTENT_LENGTH_INIT() HTTP_HDR_INIT(content_length)

/**Initialize a structure http_content_length_t.
 *
 * An http_content_length_t structure can be initialized with the
 * http_content_length_init() function/macro. For instance,
 * @code
 *
 *  http_content_length_t http_content_length;
 *
 *  http_content_length_init(&http_content_length);
 *
 * @endcode
 * @HI
 */
#if SU_HAVE_INLINE
su_inline http_content_length_t *http_content_length_init(http_content_length_t x[1])
{
  return HTTP_HEADER_INIT(x, http_content_length_class, sizeof(http_content_length_t));
}
#else
#define http_content_length_init(x) \
  HTTP_HEADER_INIT(x, http_content_length_class, sizeof(http_content_length_t))
#endif

/**Test if header object is instance of http_content_length_t.
 *
 * The function http_is_content_length() returns true (nonzero) if
 * the header class is an instance of Content-Length header
 * object and false (zero) otherwise.
 *
 * @param header pointer to the header structure to be tested
 *
 * @return
 * The function http_is_xcontent_length() returns true (nonzero) if
 * the header object is an instance of header content_length and
 * false (zero) otherwise.
 */
#if SU_HAVE_INLINE
su_inline
int http_is_content_length(http_header_t const *header)
{
  return header && header->sh_class->hc_hash == http_content_length_hash;
}
#else
#define http_is_content_length(h) \
 ((h) && ((msg_common_t *)(h))->h_class->hc_hash == http_content_length_hash)
#endif

/**Duplicate (deep copy) @c http_content_length_t.
 *
 * The function http_content_length_dup() duplicates a header
 * structure @a hdr.  If the header structure @a hdr
 * contains a reference (@c hdr->x_next) to a list of
 * headers, all the headers in the list are duplicated, too.
 *
 * @param home  memory home used to allocate new structure
 * @param hdr   header structure to be duplicated
 *
 * When duplicating, all parameter lists and non-constant
 * strings attached to the header are copied, too.  The
 * function uses given memory @a home to allocate all the
 * memory areas used to copy the header.
 *
 * @par Example
 * @code
 *
 *   content_length = http_content_length_dup(home, http->http_content_length);
 *
 * @endcode
 *
 * @return
 * The function http_content_length_dup() returns a pointer to the
 * newly duplicated http_content_length_t header structure, or NULL
 * upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_content_length_t *http_content_length_dup(su_home_t *home,
				   http_content_length_t const *hdr)
     __attribute__((__malloc__));

/**Copy a http_content_length_t header structure.
 *
 * The function http_content_length_copy() copies a header structure @a
 * hdr.  If the header structure @a hdr contains a reference (@c
 * hdr->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home
 * to allocate all the memory areas used to copy the header
 * structure @a hdr.
 *
 * @param home    memory home used to allocate new structure
 * @param hdr     pointer to the header structure to be duplicated
 *
 * When copying, only the header structure and parameter lists
 * attached to it are duplicated.  The new header structure
 * retains all the references to the strings within the old @a
 * header, including the encoding of the old header, if present.
 *
 * @par Example
 * @code
 *
 *   content_length = http_content_length_copy(home, http->http_content_length);
 *
 * @endcode
 *
 * @return
 * The function http_content_length_copy() returns a pointer to
 * newly copied header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_content_length_t *http_content_length_copy(su_home_t *home,
				    http_content_length_t const *hdr)
     __attribute__((__malloc__));

/**Make a header structure http_content_length_t.
 *
 * The function http_content_length_make() makes a new
 * http_content_length_t header structure.  It allocates a new
 * header structure, and decodes the string @a s as the
 * value of the structure.
 *
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 *
 * @note This function is usually implemented as a macro calling
 * http_header_make().
 *
 * @return
 * The function http_content_length_make() returns a pointer to
 * newly maked http_content_length_t header structure, or NULL upon
 * an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_content_length_t *http_content_length_make(su_home_t *home, char const *s)
     __attribute__((__malloc__));

/**Make a Content-Length header from formatting result.
 *
 * The function http_content_length_format() makes a new
 * Content-Length header object using formatting result as its
 * value.  The function first prints the arguments according to
 * the format @a fmt specified.  Then it allocates a new header
 * structure, and uses the formatting result as the header
 * value.
 *
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 *
 * @note This function is usually implemented as a macro calling
 * msg_header_format().
 *
 * @return
 * The function http_content_length_format() returns a pointer to newly
 * makes header structure, or NULL upon an error.
 *
 * @HIDE
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_content_length_t *http_content_length_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__malloc__, __format__ (printf, 2, 3)));


/* Inlined functions */
#if SU_HAVE_INLINE
su_inline
http_content_length_t *http_content_length_format(su_home_t *home, char const *fmt, ...)
{
  http_header_t *h;
  va_list ap;

  va_start(ap, fmt);
  h = http_header_vformat(home, http_content_length_class, fmt, ap);
  va_end(ap);

  return (http_content_length_t *)h;
}

su_inline
http_content_length_t *http_content_length_dup(su_home_t *home, http_content_length_t const *o)
{
  return (http_content_length_t *)
    msg_header_dup_as(home, http_content_length_class, (msg_header_t const *)o);
}

su_inline
http_content_length_t *http_content_length_copy(su_home_t *home, http_content_length_t const *o)
{
  return (http_content_length_t *)
    msg_header_copy_as(home, http_content_length_class, (msg_header_t const *)o);
}

su_inline
http_content_length_t *http_content_length_make(su_home_t *home, char const *s)
{
  return (http_content_length_t *)http_header_make(home, http_content_length_class, s);
}
#endif

#endif /* !define HTTP_HCLASSES_ONLY */

/** @} */


/* Declare internal prototypes for Content-Location header */

/**@addtogroup http_content_location*/ /** @{ */

enum {
  /** Hash of Content-Location header. @internal*/
  http_content_location_hash = 3453
};

/**Header class for HTTP Content-Location header.
 *
 * The header class http_content_location_class defines how a HTTP
 * Content-Location header is parsed and printed.  It also
 * contains methods used by HTTP parser and other functions
 * to manipulate the http_content_location_t header structure.
 *
 */
SOFIAPUBVAR msg_hclass_t http_content_location_class[];

#ifndef HTTP_HCLASSES_ONLY

/** Decode (parse) a Content-Location header. @internal */
SOFIAPUBFUN msg_parse_f http_content_location_d;

/** Encode (print) a Content-Location header. @internal */
SOFIAPUBFUN msg_print_f http_content_location_e;

/**Initializer for structure http_content_location_t.
 *
 * A static http_content_location_t structure must be initialized
 * with the HTTP_CONTENT_LOCATION_INIT() macro. For instance,
 * @code
 *
 *  http_content_location_t http_content_location = HTTP_CONTENT_LOCATION_INIT;
 *
 * @endcode
 * @HI
 */
#define HTTP_CONTENT_LOCATION_INIT() HTTP_HDR_INIT(content_location)

/**Initialize a structure http_content_location_t.
 *
 * An http_content_location_t structure can be initialized with the
 * http_content_location_init() function/macro. For instance,
 * @code
 *
 *  http_content_location_t http_content_location;
 *
 *  http_content_location_init(&http_content_location);
 *
 * @endcode
 * @HI
 */
#if SU_HAVE_INLINE
su_inline http_content_location_t *http_content_location_init(http_content_location_t x[1])
{
  return HTTP_HEADER_INIT(x, http_content_location_class, sizeof(http_content_location_t));
}
#else
#define http_content_location_init(x) \
  HTTP_HEADER_INIT(x, http_content_location_class, sizeof(http_content_location_t))
#endif

/**Test if header object is instance of http_content_location_t.
 *
 * The function http_is_content_location() returns true (nonzero) if
 * the header class is an instance of Content-Location header
 * object and false (zero) otherwise.
 *
 * @param header pointer to the header structure to be tested
 *
 * @return
 * The function http_is_xcontent_location() returns true (nonzero) if
 * the header object is an instance of header content_location and
 * false (zero) otherwise.
 */
#if SU_HAVE_INLINE
su_inline
int http_is_content_location(http_header_t const *header)
{
  return header && header->sh_class->hc_hash == http_content_location_hash;
}
#else
#define http_is_content_location(h) \
 ((h) && ((msg_common_t *)(h))->h_class->hc_hash == http_content_location_hash)
#endif

/**Duplicate (deep copy) @c http_content_location_t.
 *
 * The function http_content_location_dup() duplicates a header
 * structure @a hdr.  If the header structure @a hdr
 * contains a reference (@c hdr->x_next) to a list of
 * headers, all the headers in the list are duplicated, too.
 *
 * @param home  memory home used to allocate new structure
 * @param hdr   header structure to be duplicated
 *
 * When duplicating, all parameter lists and non-constant
 * strings attached to the header are copied, too.  The
 * function uses given memory @a home to allocate all the
 * memory areas used to copy the header.
 *
 * @par Example
 * @code
 *
 *   content_location = http_content_location_dup(home, http->http_content_location);
 *
 * @endcode
 *
 * @return
 * The function http_content_location_dup() returns a pointer to the
 * newly duplicated http_content_location_t header structure, or NULL
 * upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_content_location_t *http_content_location_dup(su_home_t *home,
				   http_content_location_t const *hdr)
     __attribute__((__malloc__));

/**Copy a http_content_location_t header structure.
 *
 * The function http_content_location_copy() copies a header structure @a
 * hdr.  If the header structure @a hdr contains a reference (@c
 * hdr->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home
 * to allocate all the memory areas used to copy the header
 * structure @a hdr.
 *
 * @param home    memory home used to allocate new structure
 * @param hdr     pointer to the header structure to be duplicated
 *
 * When copying, only the header structure and parameter lists
 * attached to it are duplicated.  The new header structure
 * retains all the references to the strings within the old @a
 * header, including the encoding of the old header, if present.
 *
 * @par Example
 * @code
 *
 *   content_location = http_content_location_copy(home, http->http_content_location);
 *
 * @endcode
 *
 * @return
 * The function http_content_location_copy() returns a pointer to
 * newly copied header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_content_location_t *http_content_location_copy(su_home_t *home,
				    http_content_location_t const *hdr)
     __attribute__((__malloc__));

/**Make a header structure http_content_location_t.
 *
 * The function http_content_location_make() makes a new
 * http_content_location_t header structure.  It allocates a new
 * header structure, and decodes the string @a s as the
 * value of the structure.
 *
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 *
 * @note This function is usually implemented as a macro calling
 * http_header_make().
 *
 * @return
 * The function http_content_location_make() returns a pointer to
 * newly maked http_content_location_t header structure, or NULL upon
 * an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_content_location_t *http_content_location_make(su_home_t *home, char const *s)
     __attribute__((__malloc__));

/**Make a Content-Location header from formatting result.
 *
 * The function http_content_location_format() makes a new
 * Content-Location header object using formatting result as its
 * value.  The function first prints the arguments according to
 * the format @a fmt specified.  Then it allocates a new header
 * structure, and uses the formatting result as the header
 * value.
 *
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 *
 * @note This function is usually implemented as a macro calling
 * msg_header_format().
 *
 * @return
 * The function http_content_location_format() returns a pointer to newly
 * makes header structure, or NULL upon an error.
 *
 * @HIDE
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_content_location_t *http_content_location_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__malloc__, __format__ (printf, 2, 3)));


/* Inlined functions */
#if SU_HAVE_INLINE
su_inline
http_content_location_t *http_content_location_format(su_home_t *home, char const *fmt, ...)
{
  http_header_t *h;
  va_list ap;

  va_start(ap, fmt);
  h = http_header_vformat(home, http_content_location_class, fmt, ap);
  va_end(ap);

  return (http_content_location_t *)h;
}

su_inline
http_content_location_t *http_content_location_dup(su_home_t *home, http_content_location_t const *o)
{
  return (http_content_location_t *)
    msg_header_dup_as(home, http_content_location_class, (msg_header_t const *)o);
}

su_inline
http_content_location_t *http_content_location_copy(su_home_t *home, http_content_location_t const *o)
{
  return (http_content_location_t *)
    msg_header_copy_as(home, http_content_location_class, (msg_header_t const *)o);
}

su_inline
http_content_location_t *http_content_location_make(su_home_t *home, char const *s)
{
  return (http_content_location_t *)http_header_make(home, http_content_location_class, s);
}
#endif

#endif /* !define HTTP_HCLASSES_ONLY */

/** @} */


/* Declare internal prototypes for Content-MD5 header */

/**@addtogroup http_content_md5*/ /** @{ */

enum {
  /** Hash of Content-MD5 header. @internal*/
  http_content_md5_hash = 60494
};

/**Header class for HTTP Content-MD5 header.
 *
 * The header class http_content_md5_class defines how a HTTP
 * Content-MD5 header is parsed and printed.  It also
 * contains methods used by HTTP parser and other functions
 * to manipulate the http_content_md5_t header structure.
 *
 */
SOFIAPUBVAR msg_hclass_t http_content_md5_class[];

#ifndef HTTP_HCLASSES_ONLY

/** Decode (parse) a Content-MD5 header. @internal */
SOFIAPUBFUN msg_parse_f http_content_md5_d;

/** Encode (print) a Content-MD5 header. @internal */
SOFIAPUBFUN msg_print_f http_content_md5_e;

/**Initializer for structure http_content_md5_t.
 *
 * A static http_content_md5_t structure must be initialized
 * with the HTTP_CONTENT_MD5_INIT() macro. For instance,
 * @code
 *
 *  http_content_md5_t http_content_md5 = HTTP_CONTENT_MD5_INIT;
 *
 * @endcode
 * @HI
 */
#define HTTP_CONTENT_MD5_INIT() HTTP_HDR_INIT(content_md5)

/**Initialize a structure http_content_md5_t.
 *
 * An http_content_md5_t structure can be initialized with the
 * http_content_md5_init() function/macro. For instance,
 * @code
 *
 *  http_content_md5_t http_content_md5;
 *
 *  http_content_md5_init(&http_content_md5);
 *
 * @endcode
 * @HI
 */
#if SU_HAVE_INLINE
su_inline http_content_md5_t *http_content_md5_init(http_content_md5_t x[1])
{
  return HTTP_HEADER_INIT(x, http_content_md5_class, sizeof(http_content_md5_t));
}
#else
#define http_content_md5_init(x) \
  HTTP_HEADER_INIT(x, http_content_md5_class, sizeof(http_content_md5_t))
#endif

/**Test if header object is instance of http_content_md5_t.
 *
 * The function http_is_content_md5() returns true (nonzero) if
 * the header class is an instance of Content-MD5 header
 * object and false (zero) otherwise.
 *
 * @param header pointer to the header structure to be tested
 *
 * @return
 * The function http_is_xcontent_md5() returns true (nonzero) if
 * the header object is an instance of header content_md5 and
 * false (zero) otherwise.
 */
#if SU_HAVE_INLINE
su_inline
int http_is_content_md5(http_header_t const *header)
{
  return header && header->sh_class->hc_hash == http_content_md5_hash;
}
#else
#define http_is_content_md5(h) \
 ((h) && ((msg_common_t *)(h))->h_class->hc_hash == http_content_md5_hash)
#endif

/**Duplicate (deep copy) @c http_content_md5_t.
 *
 * The function http_content_md5_dup() duplicates a header
 * structure @a hdr.  If the header structure @a hdr
 * contains a reference (@c hdr->x_next) to a list of
 * headers, all the headers in the list are duplicated, too.
 *
 * @param home  memory home used to allocate new structure
 * @param hdr   header structure to be duplicated
 *
 * When duplicating, all parameter lists and non-constant
 * strings attached to the header are copied, too.  The
 * function uses given memory @a home to allocate all the
 * memory areas used to copy the header.
 *
 * @par Example
 * @code
 *
 *   content_md5 = http_content_md5_dup(home, http->http_content_md5);
 *
 * @endcode
 *
 * @return
 * The function http_content_md5_dup() returns a pointer to the
 * newly duplicated http_content_md5_t header structure, or NULL
 * upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_content_md5_t *http_content_md5_dup(su_home_t *home,
				   http_content_md5_t const *hdr)
     __attribute__((__malloc__));

/**Copy a http_content_md5_t header structure.
 *
 * The function http_content_md5_copy() copies a header structure @a
 * hdr.  If the header structure @a hdr contains a reference (@c
 * hdr->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home
 * to allocate all the memory areas used to copy the header
 * structure @a hdr.
 *
 * @param home    memory home used to allocate new structure
 * @param hdr     pointer to the header structure to be duplicated
 *
 * When copying, only the header structure and parameter lists
 * attached to it are duplicated.  The new header structure
 * retains all the references to the strings within the old @a
 * header, including the encoding of the old header, if present.
 *
 * @par Example
 * @code
 *
 *   content_md5 = http_content_md5_copy(home, http->http_content_md5);
 *
 * @endcode
 *
 * @return
 * The function http_content_md5_copy() returns a pointer to
 * newly copied header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_content_md5_t *http_content_md5_copy(su_home_t *home,
				    http_content_md5_t const *hdr)
     __attribute__((__malloc__));

/**Make a header structure http_content_md5_t.
 *
 * The function http_content_md5_make() makes a new
 * http_content_md5_t header structure.  It allocates a new
 * header structure, and decodes the string @a s as the
 * value of the structure.
 *
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 *
 * @note This function is usually implemented as a macro calling
 * http_header_make().
 *
 * @return
 * The function http_content_md5_make() returns a pointer to
 * newly maked http_content_md5_t header structure, or NULL upon
 * an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_content_md5_t *http_content_md5_make(su_home_t *home, char const *s)
     __attribute__((__malloc__));

/**Make a Content-MD5 header from formatting result.
 *
 * The function http_content_md5_format() makes a new
 * Content-MD5 header object using formatting result as its
 * value.  The function first prints the arguments according to
 * the format @a fmt specified.  Then it allocates a new header
 * structure, and uses the formatting result as the header
 * value.
 *
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 *
 * @note This function is usually implemented as a macro calling
 * msg_header_format().
 *
 * @return
 * The function http_content_md5_format() returns a pointer to newly
 * makes header structure, or NULL upon an error.
 *
 * @HIDE
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_content_md5_t *http_content_md5_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__malloc__, __format__ (printf, 2, 3)));


/* Inlined functions */
#if SU_HAVE_INLINE
su_inline
http_content_md5_t *http_content_md5_format(su_home_t *home, char const *fmt, ...)
{
  http_header_t *h;
  va_list ap;

  va_start(ap, fmt);
  h = http_header_vformat(home, http_content_md5_class, fmt, ap);
  va_end(ap);

  return (http_content_md5_t *)h;
}

su_inline
http_content_md5_t *http_content_md5_dup(su_home_t *home, http_content_md5_t const *o)
{
  return (http_content_md5_t *)
    msg_header_dup_as(home, http_content_md5_class, (msg_header_t const *)o);
}

su_inline
http_content_md5_t *http_content_md5_copy(su_home_t *home, http_content_md5_t const *o)
{
  return (http_content_md5_t *)
    msg_header_copy_as(home, http_content_md5_class, (msg_header_t const *)o);
}

su_inline
http_content_md5_t *http_content_md5_make(su_home_t *home, char const *s)
{
  return (http_content_md5_t *)http_header_make(home, http_content_md5_class, s);
}
#endif

#endif /* !define HTTP_HCLASSES_ONLY */

/** @} */


/* Declare internal prototypes for Content-Range header */

/**@addtogroup http_content_range*/ /** @{ */

enum {
  /** Hash of Content-Range header. @internal*/
  http_content_range_hash = 64465
};

/**Header class for HTTP Content-Range header.
 *
 * The header class http_content_range_class defines how a HTTP
 * Content-Range header is parsed and printed.  It also
 * contains methods used by HTTP parser and other functions
 * to manipulate the http_content_range_t header structure.
 *
 */
SOFIAPUBVAR msg_hclass_t http_content_range_class[];

#ifndef HTTP_HCLASSES_ONLY

/** Decode (parse) a Content-Range header. @internal */
SOFIAPUBFUN msg_parse_f http_content_range_d;

/** Encode (print) a Content-Range header. @internal */
SOFIAPUBFUN msg_print_f http_content_range_e;

/**Initializer for structure http_content_range_t.
 *
 * A static http_content_range_t structure must be initialized
 * with the HTTP_CONTENT_RANGE_INIT() macro. For instance,
 * @code
 *
 *  http_content_range_t http_content_range = HTTP_CONTENT_RANGE_INIT;
 *
 * @endcode
 * @HI
 */
#define HTTP_CONTENT_RANGE_INIT() HTTP_HDR_INIT(content_range)

/**Initialize a structure http_content_range_t.
 *
 * An http_content_range_t structure can be initialized with the
 * http_content_range_init() function/macro. For instance,
 * @code
 *
 *  http_content_range_t http_content_range;
 *
 *  http_content_range_init(&http_content_range);
 *
 * @endcode
 * @HI
 */
#if SU_HAVE_INLINE
su_inline http_content_range_t *http_content_range_init(http_content_range_t x[1])
{
  return HTTP_HEADER_INIT(x, http_content_range_class, sizeof(http_content_range_t));
}
#else
#define http_content_range_init(x) \
  HTTP_HEADER_INIT(x, http_content_range_class, sizeof(http_content_range_t))
#endif

/**Test if header object is instance of http_content_range_t.
 *
 * The function http_is_content_range() returns true (nonzero) if
 * the header class is an instance of Content-Range header
 * object and false (zero) otherwise.
 *
 * @param header pointer to the header structure to be tested
 *
 * @return
 * The function http_is_xcontent_range() returns true (nonzero) if
 * the header object is an instance of header content_range and
 * false (zero) otherwise.
 */
#if SU_HAVE_INLINE
su_inline
int http_is_content_range(http_header_t const *header)
{
  return header && header->sh_class->hc_hash == http_content_range_hash;
}
#else
#define http_is_content_range(h) \
 ((h) && ((msg_common_t *)(h))->h_class->hc_hash == http_content_range_hash)
#endif

/**Duplicate (deep copy) @c http_content_range_t.
 *
 * The function http_content_range_dup() duplicates a header
 * structure @a hdr.  If the header structure @a hdr
 * contains a reference (@c hdr->x_next) to a list of
 * headers, all the headers in the list are duplicated, too.
 *
 * @param home  memory home used to allocate new structure
 * @param hdr   header structure to be duplicated
 *
 * When duplicating, all parameter lists and non-constant
 * strings attached to the header are copied, too.  The
 * function uses given memory @a home to allocate all the
 * memory areas used to copy the header.
 *
 * @par Example
 * @code
 *
 *   content_range = http_content_range_dup(home, http->http_content_range);
 *
 * @endcode
 *
 * @return
 * The function http_content_range_dup() returns a pointer to the
 * newly duplicated http_content_range_t header structure, or NULL
 * upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_content_range_t *http_content_range_dup(su_home_t *home,
				   http_content_range_t const *hdr)
     __attribute__((__malloc__));

/**Copy a http_content_range_t header structure.
 *
 * The function http_content_range_copy() copies a header structure @a
 * hdr.  If the header structure @a hdr contains a reference (@c
 * hdr->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home
 * to allocate all the memory areas used to copy the header
 * structure @a hdr.
 *
 * @param home    memory home used to allocate new structure
 * @param hdr     pointer to the header structure to be duplicated
 *
 * When copying, only the header structure and parameter lists
 * attached to it are duplicated.  The new header structure
 * retains all the references to the strings within the old @a
 * header, including the encoding of the old header, if present.
 *
 * @par Example
 * @code
 *
 *   content_range = http_content_range_copy(home, http->http_content_range);
 *
 * @endcode
 *
 * @return
 * The function http_content_range_copy() returns a pointer to
 * newly copied header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_content_range_t *http_content_range_copy(su_home_t *home,
				    http_content_range_t const *hdr)
     __attribute__((__malloc__));

/**Make a header structure http_content_range_t.
 *
 * The function http_content_range_make() makes a new
 * http_content_range_t header structure.  It allocates a new
 * header structure, and decodes the string @a s as the
 * value of the structure.
 *
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 *
 * @note This function is usually implemented as a macro calling
 * http_header_make().
 *
 * @return
 * The function http_content_range_make() returns a pointer to
 * newly maked http_content_range_t header structure, or NULL upon
 * an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_content_range_t *http_content_range_make(su_home_t *home, char const *s)
     __attribute__((__malloc__));

/**Make a Content-Range header from formatting result.
 *
 * The function http_content_range_format() makes a new
 * Content-Range header object using formatting result as its
 * value.  The function first prints the arguments according to
 * the format @a fmt specified.  Then it allocates a new header
 * structure, and uses the formatting result as the header
 * value.
 *
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 *
 * @note This function is usually implemented as a macro calling
 * msg_header_format().
 *
 * @return
 * The function http_content_range_format() returns a pointer to newly
 * makes header structure, or NULL upon an error.
 *
 * @HIDE
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_content_range_t *http_content_range_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__malloc__, __format__ (printf, 2, 3)));


/* Inlined functions */
#if SU_HAVE_INLINE
su_inline
http_content_range_t *http_content_range_format(su_home_t *home, char const *fmt, ...)
{
  http_header_t *h;
  va_list ap;

  va_start(ap, fmt);
  h = http_header_vformat(home, http_content_range_class, fmt, ap);
  va_end(ap);

  return (http_content_range_t *)h;
}

su_inline
http_content_range_t *http_content_range_dup(su_home_t *home, http_content_range_t const *o)
{
  return (http_content_range_t *)
    msg_header_dup_as(home, http_content_range_class, (msg_header_t const *)o);
}

su_inline
http_content_range_t *http_content_range_copy(su_home_t *home, http_content_range_t const *o)
{
  return (http_content_range_t *)
    msg_header_copy_as(home, http_content_range_class, (msg_header_t const *)o);
}

su_inline
http_content_range_t *http_content_range_make(su_home_t *home, char const *s)
{
  return (http_content_range_t *)http_header_make(home, http_content_range_class, s);
}
#endif

#endif /* !define HTTP_HCLASSES_ONLY */

/** @} */


/* Declare internal prototypes for Content-Type header */

/**@addtogroup http_content_type*/ /** @{ */

enum {
  /** Hash of Content-Type header. @internal*/
  http_content_type_hash = 51226
};

/**Header class for HTTP Content-Type header.
 *
 * The header class http_content_type_class defines how a HTTP
 * Content-Type header is parsed and printed.  It also
 * contains methods used by HTTP parser and other functions
 * to manipulate the http_content_type_t header structure.
 *
 */
SOFIAPUBVAR msg_hclass_t http_content_type_class[];

#ifndef HTTP_HCLASSES_ONLY

/** Decode (parse) a Content-Type header. @internal */
SOFIAPUBFUN msg_parse_f http_content_type_d;

/** Encode (print) a Content-Type header. @internal */
SOFIAPUBFUN msg_print_f http_content_type_e;

/**Initializer for structure http_content_type_t.
 *
 * A static http_content_type_t structure must be initialized
 * with the HTTP_CONTENT_TYPE_INIT() macro. For instance,
 * @code
 *
 *  http_content_type_t http_content_type = HTTP_CONTENT_TYPE_INIT;
 *
 * @endcode
 * @HI
 */
#define HTTP_CONTENT_TYPE_INIT() HTTP_HDR_INIT(content_type)

/**Initialize a structure http_content_type_t.
 *
 * An http_content_type_t structure can be initialized with the
 * http_content_type_init() function/macro. For instance,
 * @code
 *
 *  http_content_type_t http_content_type;
 *
 *  http_content_type_init(&http_content_type);
 *
 * @endcode
 * @HI
 */
#if SU_HAVE_INLINE
su_inline http_content_type_t *http_content_type_init(http_content_type_t x[1])
{
  return HTTP_HEADER_INIT(x, http_content_type_class, sizeof(http_content_type_t));
}
#else
#define http_content_type_init(x) \
  HTTP_HEADER_INIT(x, http_content_type_class, sizeof(http_content_type_t))
#endif

/**Test if header object is instance of http_content_type_t.
 *
 * The function http_is_content_type() returns true (nonzero) if
 * the header class is an instance of Content-Type header
 * object and false (zero) otherwise.
 *
 * @param header pointer to the header structure to be tested
 *
 * @return
 * The function http_is_xcontent_type() returns true (nonzero) if
 * the header object is an instance of header content_type and
 * false (zero) otherwise.
 */
#if SU_HAVE_INLINE
su_inline
int http_is_content_type(http_header_t const *header)
{
  return header && header->sh_class->hc_hash == http_content_type_hash;
}
#else
#define http_is_content_type(h) \
 ((h) && ((msg_common_t *)(h))->h_class->hc_hash == http_content_type_hash)
#endif

/**Duplicate (deep copy) @c http_content_type_t.
 *
 * The function http_content_type_dup() duplicates a header
 * structure @a hdr.  If the header structure @a hdr
 * contains a reference (@c hdr->x_next) to a list of
 * headers, all the headers in the list are duplicated, too.
 *
 * @param home  memory home used to allocate new structure
 * @param hdr   header structure to be duplicated
 *
 * When duplicating, all parameter lists and non-constant
 * strings attached to the header are copied, too.  The
 * function uses given memory @a home to allocate all the
 * memory areas used to copy the header.
 *
 * @par Example
 * @code
 *
 *   content_type = http_content_type_dup(home, http->http_content_type);
 *
 * @endcode
 *
 * @return
 * The function http_content_type_dup() returns a pointer to the
 * newly duplicated http_content_type_t header structure, or NULL
 * upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_content_type_t *http_content_type_dup(su_home_t *home,
				   http_content_type_t const *hdr)
     __attribute__((__malloc__));

/**Copy a http_content_type_t header structure.
 *
 * The function http_content_type_copy() copies a header structure @a
 * hdr.  If the header structure @a hdr contains a reference (@c
 * hdr->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home
 * to allocate all the memory areas used to copy the header
 * structure @a hdr.
 *
 * @param home    memory home used to allocate new structure
 * @param hdr     pointer to the header structure to be duplicated
 *
 * When copying, only the header structure and parameter lists
 * attached to it are duplicated.  The new header structure
 * retains all the references to the strings within the old @a
 * header, including the encoding of the old header, if present.
 *
 * @par Example
 * @code
 *
 *   content_type = http_content_type_copy(home, http->http_content_type);
 *
 * @endcode
 *
 * @return
 * The function http_content_type_copy() returns a pointer to
 * newly copied header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_content_type_t *http_content_type_copy(su_home_t *home,
				    http_content_type_t const *hdr)
     __attribute__((__malloc__));

/**Make a header structure http_content_type_t.
 *
 * The function http_content_type_make() makes a new
 * http_content_type_t header structure.  It allocates a new
 * header structure, and decodes the string @a s as the
 * value of the structure.
 *
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 *
 * @note This function is usually implemented as a macro calling
 * http_header_make().
 *
 * @return
 * The function http_content_type_make() returns a pointer to
 * newly maked http_content_type_t header structure, or NULL upon
 * an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_content_type_t *http_content_type_make(su_home_t *home, char const *s)
     __attribute__((__malloc__));

/**Make a Content-Type header from formatting result.
 *
 * The function http_content_type_format() makes a new
 * Content-Type header object using formatting result as its
 * value.  The function first prints the arguments according to
 * the format @a fmt specified.  Then it allocates a new header
 * structure, and uses the formatting result as the header
 * value.
 *
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 *
 * @note This function is usually implemented as a macro calling
 * msg_header_format().
 *
 * @return
 * The function http_content_type_format() returns a pointer to newly
 * makes header structure, or NULL upon an error.
 *
 * @HIDE
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_content_type_t *http_content_type_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__malloc__, __format__ (printf, 2, 3)));


/* Inlined functions */
#if SU_HAVE_INLINE
su_inline
http_content_type_t *http_content_type_format(su_home_t *home, char const *fmt, ...)
{
  http_header_t *h;
  va_list ap;

  va_start(ap, fmt);
  h = http_header_vformat(home, http_content_type_class, fmt, ap);
  va_end(ap);

  return (http_content_type_t *)h;
}

su_inline
http_content_type_t *http_content_type_dup(su_home_t *home, http_content_type_t const *o)
{
  return (http_content_type_t *)
    msg_header_dup_as(home, http_content_type_class, (msg_header_t const *)o);
}

su_inline
http_content_type_t *http_content_type_copy(su_home_t *home, http_content_type_t const *o)
{
  return (http_content_type_t *)
    msg_header_copy_as(home, http_content_type_class, (msg_header_t const *)o);
}

su_inline
http_content_type_t *http_content_type_make(su_home_t *home, char const *s)
{
  return (http_content_type_t *)http_header_make(home, http_content_type_class, s);
}
#endif

#endif /* !define HTTP_HCLASSES_ONLY */

/** @} */


/* Declare internal prototypes for unknown headers */

/**@addtogroup http_unknown*/ /** @{ */

enum {
  /** Hash of unknown headers. @internal*/
  http_unknown_hash = -3
};

/**Header class for HTTP unknown headers.
 *
 * The header class http_unknown_class defines how a HTTP
 * unknown headers is parsed and printed.  It also
 * contains methods used by HTTP parser and other functions
 * to manipulate the http_unknown_t header structure.
 *
 */
SOFIAPUBVAR msg_hclass_t http_unknown_class[];

#ifndef HTTP_HCLASSES_ONLY

/** Decode (parse) a unknown headers. @internal */
SOFIAPUBFUN msg_parse_f http_unknown_d;

/** Encode (print) a unknown headers. @internal */
SOFIAPUBFUN msg_print_f http_unknown_e;

/**Initializer for structure http_unknown_t.
 *
 * A static http_unknown_t structure must be initialized
 * with the HTTP_UNKNOWN_INIT() macro. For instance,
 * @code
 *
 *  http_unknown_t http_unknown = HTTP_UNKNOWN_INIT;
 *
 * @endcode
 * @HI
 */
#define HTTP_UNKNOWN_INIT() HTTP_HDR_INIT(unknown)

/**Initialize a structure http_unknown_t.
 *
 * An http_unknown_t structure can be initialized with the
 * http_unknown_init() function/macro. For instance,
 * @code
 *
 *  http_unknown_t http_unknown;
 *
 *  http_unknown_init(&http_unknown);
 *
 * @endcode
 * @HI
 */
#if SU_HAVE_INLINE
su_inline http_unknown_t *http_unknown_init(http_unknown_t x[1])
{
  return HTTP_HEADER_INIT(x, http_unknown_class, sizeof(http_unknown_t));
}
#else
#define http_unknown_init(x) \
  HTTP_HEADER_INIT(x, http_unknown_class, sizeof(http_unknown_t))
#endif

/**Test if header object is instance of http_unknown_t.
 *
 * The function http_is_unknown() returns true (nonzero) if
 * the header class is an instance of unknown headers
 * object and false (zero) otherwise.
 *
 * @param header pointer to the header structure to be tested
 *
 * @return
 * The function http_is_xunknown() returns true (nonzero) if
 * the header object is an instance of header unknown and
 * false (zero) otherwise.
 */
#if SU_HAVE_INLINE
su_inline
int http_is_unknown(http_header_t const *header)
{
  return header && header->sh_class->hc_hash == http_unknown_hash;
}
#else
#define http_is_unknown(h) \
 ((h) && ((msg_common_t *)(h))->h_class->hc_hash == http_unknown_hash)
#endif

/**Duplicate (deep copy) @c http_unknown_t.
 *
 * The function http_unknown_dup() duplicates a header
 * structure @a hdr.  If the header structure @a hdr
 * contains a reference (@c hdr->x_next) to a list of
 * headers, all the headers in the list are duplicated, too.
 *
 * @param home  memory home used to allocate new structure
 * @param hdr   header structure to be duplicated
 *
 * When duplicating, all parameter lists and non-constant
 * strings attached to the header are copied, too.  The
 * function uses given memory @a home to allocate all the
 * memory areas used to copy the header.
 *
 * @par Example
 * @code
 *
 *   unknown = http_unknown_dup(home, http->http_unknown);
 *
 * @endcode
 *
 * @return
 * The function http_unknown_dup() returns a pointer to the
 * newly duplicated http_unknown_t header structure, or NULL
 * upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_unknown_t *http_unknown_dup(su_home_t *home,
				   http_unknown_t const *hdr)
     __attribute__((__malloc__));

/**Copy a http_unknown_t header structure.
 *
 * The function http_unknown_copy() copies a header structure @a
 * hdr.  If the header structure @a hdr contains a reference (@c
 * hdr->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home
 * to allocate all the memory areas used to copy the header
 * structure @a hdr.
 *
 * @param home    memory home used to allocate new structure
 * @param hdr     pointer to the header structure to be duplicated
 *
 * When copying, only the header structure and parameter lists
 * attached to it are duplicated.  The new header structure
 * retains all the references to the strings within the old @a
 * header, including the encoding of the old header, if present.
 *
 * @par Example
 * @code
 *
 *   unknown = http_unknown_copy(home, http->http_unknown);
 *
 * @endcode
 *
 * @return
 * The function http_unknown_copy() returns a pointer to
 * newly copied header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_unknown_t *http_unknown_copy(su_home_t *home,
				    http_unknown_t const *hdr)
     __attribute__((__malloc__));

/**Make a header structure http_unknown_t.
 *
 * The function http_unknown_make() makes a new
 * http_unknown_t header structure.  It allocates a new
 * header structure, and decodes the string @a s as the
 * value of the structure.
 *
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 *
 * @note This function is usually implemented as a macro calling
 * http_header_make().
 *
 * @return
 * The function http_unknown_make() returns a pointer to
 * newly maked http_unknown_t header structure, or NULL upon
 * an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_unknown_t *http_unknown_make(su_home_t *home, char const *s)
     __attribute__((__malloc__));

/**Make a unknown headers from formatting result.
 *
 * The function http_unknown_format() makes a new
 * unknown headers object using formatting result as its
 * value.  The function first prints the arguments according to
 * the format @a fmt specified.  Then it allocates a new header
 * structure, and uses the formatting result as the header
 * value.
 *
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 *
 * @note This function is usually implemented as a macro calling
 * msg_header_format().
 *
 * @return
 * The function http_unknown_format() returns a pointer to newly
 * makes header structure, or NULL upon an error.
 *
 * @HIDE
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_unknown_t *http_unknown_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__malloc__, __format__ (printf, 2, 3)));


/* Inlined functions */
#if SU_HAVE_INLINE
su_inline
http_unknown_t *http_unknown_format(su_home_t *home, char const *fmt, ...)
{
  http_header_t *h;
  va_list ap;

  va_start(ap, fmt);
  h = http_header_vformat(home, http_unknown_class, fmt, ap);
  va_end(ap);

  return (http_unknown_t *)h;
}

su_inline
http_unknown_t *http_unknown_dup(su_home_t *home, http_unknown_t const *o)
{
  return (http_unknown_t *)
    msg_header_dup_as(home, http_unknown_class, (msg_header_t const *)o);
}

su_inline
http_unknown_t *http_unknown_copy(su_home_t *home, http_unknown_t const *o)
{
  return (http_unknown_t *)
    msg_header_copy_as(home, http_unknown_class, (msg_header_t const *)o);
}

su_inline
http_unknown_t *http_unknown_make(su_home_t *home, char const *s)
{
  return (http_unknown_t *)http_header_make(home, http_unknown_class, s);
}
#endif

#endif /* !define HTTP_HCLASSES_ONLY */

/** @} */


/* Declare internal prototypes for erroneous headers */

/**@addtogroup http_error*/ /** @{ */

enum {
  /** Hash of erroneous headers. @internal*/
  http_error_hash = -4
};

/**Header class for HTTP erroneous headers.
 *
 * The header class http_error_class defines how a HTTP
 * erroneous headers is parsed and printed.  It also
 * contains methods used by HTTP parser and other functions
 * to manipulate the http_error_t header structure.
 *
 */
SOFIAPUBVAR msg_hclass_t http_error_class[];

#ifndef HTTP_HCLASSES_ONLY

/** Decode (parse) a erroneous headers. @internal */
SOFIAPUBFUN msg_parse_f http_error_d;

/** Encode (print) a erroneous headers. @internal */
SOFIAPUBFUN msg_print_f http_error_e;

/**Initializer for structure http_error_t.
 *
 * A static http_error_t structure must be initialized
 * with the HTTP_ERROR_INIT() macro. For instance,
 * @code
 *
 *  http_error_t http_error = HTTP_ERROR_INIT;
 *
 * @endcode
 * @HI
 */
#define HTTP_ERROR_INIT() HTTP_HDR_INIT(error)

/**Initialize a structure http_error_t.
 *
 * An http_error_t structure can be initialized with the
 * http_error_init() function/macro. For instance,
 * @code
 *
 *  http_error_t http_error;
 *
 *  http_error_init(&http_error);
 *
 * @endcode
 * @HI
 */
#if SU_HAVE_INLINE
su_inline http_error_t *http_error_init(http_error_t x[1])
{
  return HTTP_HEADER_INIT(x, http_error_class, sizeof(http_error_t));
}
#else
#define http_error_init(x) \
  HTTP_HEADER_INIT(x, http_error_class, sizeof(http_error_t))
#endif

/**Test if header object is instance of http_error_t.
 *
 * The function http_is_error() returns true (nonzero) if
 * the header class is an instance of erroneous headers
 * object and false (zero) otherwise.
 *
 * @param header pointer to the header structure to be tested
 *
 * @return
 * The function http_is_xerror() returns true (nonzero) if
 * the header object is an instance of header error and
 * false (zero) otherwise.
 */
#if SU_HAVE_INLINE
su_inline
int http_is_error(http_header_t const *header)
{
  return header && header->sh_class->hc_hash == http_error_hash;
}
#else
#define http_is_error(h) \
 ((h) && ((msg_common_t *)(h))->h_class->hc_hash == http_error_hash)
#endif

/**Duplicate (deep copy) @c http_error_t.
 *
 * The function http_error_dup() duplicates a header
 * structure @a hdr.  If the header structure @a hdr
 * contains a reference (@c hdr->x_next) to a list of
 * headers, all the headers in the list are duplicated, too.
 *
 * @param home  memory home used to allocate new structure
 * @param hdr   header structure to be duplicated
 *
 * When duplicating, all parameter lists and non-constant
 * strings attached to the header are copied, too.  The
 * function uses given memory @a home to allocate all the
 * memory areas used to copy the header.
 *
 * @par Example
 * @code
 *
 *   error = http_error_dup(home, http->http_error);
 *
 * @endcode
 *
 * @return
 * The function http_error_dup() returns a pointer to the
 * newly duplicated http_error_t header structure, or NULL
 * upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_error_t *http_error_dup(su_home_t *home,
				   http_error_t const *hdr)
     __attribute__((__malloc__));

/**Copy a http_error_t header structure.
 *
 * The function http_error_copy() copies a header structure @a
 * hdr.  If the header structure @a hdr contains a reference (@c
 * hdr->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home
 * to allocate all the memory areas used to copy the header
 * structure @a hdr.
 *
 * @param home    memory home used to allocate new structure
 * @param hdr     pointer to the header structure to be duplicated
 *
 * When copying, only the header structure and parameter lists
 * attached to it are duplicated.  The new header structure
 * retains all the references to the strings within the old @a
 * header, including the encoding of the old header, if present.
 *
 * @par Example
 * @code
 *
 *   error = http_error_copy(home, http->http_error);
 *
 * @endcode
 *
 * @return
 * The function http_error_copy() returns a pointer to
 * newly copied header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_error_t *http_error_copy(su_home_t *home,
				    http_error_t const *hdr)
     __attribute__((__malloc__));

/**Make a header structure http_error_t.
 *
 * The function http_error_make() makes a new
 * http_error_t header structure.  It allocates a new
 * header structure, and decodes the string @a s as the
 * value of the structure.
 *
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 *
 * @note This function is usually implemented as a macro calling
 * http_header_make().
 *
 * @return
 * The function http_error_make() returns a pointer to
 * newly maked http_error_t header structure, or NULL upon
 * an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_error_t *http_error_make(su_home_t *home, char const *s)
     __attribute__((__malloc__));

/**Make a erroneous headers from formatting result.
 *
 * The function http_error_format() makes a new
 * erroneous headers object using formatting result as its
 * value.  The function first prints the arguments according to
 * the format @a fmt specified.  Then it allocates a new header
 * structure, and uses the formatting result as the header
 * value.
 *
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 *
 * @note This function is usually implemented as a macro calling
 * msg_header_format().
 *
 * @return
 * The function http_error_format() returns a pointer to newly
 * makes header structure, or NULL upon an error.
 *
 * @HIDE
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_error_t *http_error_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__malloc__, __format__ (printf, 2, 3)));


/* Inlined functions */
#if SU_HAVE_INLINE
su_inline
http_error_t *http_error_format(su_home_t *home, char const *fmt, ...)
{
  http_header_t *h;
  va_list ap;

  va_start(ap, fmt);
  h = http_header_vformat(home, http_error_class, fmt, ap);
  va_end(ap);

  return (http_error_t *)h;
}

su_inline
http_error_t *http_error_dup(su_home_t *home, http_error_t const *o)
{
  return (http_error_t *)
    msg_header_dup_as(home, http_error_class, (msg_header_t const *)o);
}

su_inline
http_error_t *http_error_copy(su_home_t *home, http_error_t const *o)
{
  return (http_error_t *)
    msg_header_copy_as(home, http_error_class, (msg_header_t const *)o);
}

su_inline
http_error_t *http_error_make(su_home_t *home, char const *s)
{
  return (http_error_t *)http_header_make(home, http_error_class, s);
}
#endif

#endif /* !define HTTP_HCLASSES_ONLY */

/** @} */


/* Declare internal prototypes for separator line between headers and body */

/**@addtogroup http_separator*/ /** @{ */

enum {
  /** Hash of separator line between headers and body. @internal*/
  http_separator_hash = -5
};

/**Header class for HTTP separator line between headers and body.
 *
 * The header class http_separator_class defines how a HTTP
 * separator line between headers and body is parsed and printed.  It also
 * contains methods used by HTTP parser and other functions
 * to manipulate the http_separator_t header structure.
 *
 */
SOFIAPUBVAR msg_hclass_t http_separator_class[];

#ifndef HTTP_HCLASSES_ONLY

/** Decode (parse) a separator line between headers and body. @internal */
SOFIAPUBFUN msg_parse_f http_separator_d;

/** Encode (print) a separator line between headers and body. @internal */
SOFIAPUBFUN msg_print_f http_separator_e;

/**Initializer for structure http_separator_t.
 *
 * A static http_separator_t structure must be initialized
 * with the HTTP_SEPARATOR_INIT() macro. For instance,
 * @code
 *
 *  http_separator_t http_separator = HTTP_SEPARATOR_INIT;
 *
 * @endcode
 * @HI
 */
#define HTTP_SEPARATOR_INIT() HTTP_HDR_INIT(separator)

/**Initialize a structure http_separator_t.
 *
 * An http_separator_t structure can be initialized with the
 * http_separator_init() function/macro. For instance,
 * @code
 *
 *  http_separator_t http_separator;
 *
 *  http_separator_init(&http_separator);
 *
 * @endcode
 * @HI
 */
#if SU_HAVE_INLINE
su_inline http_separator_t *http_separator_init(http_separator_t x[1])
{
  return HTTP_HEADER_INIT(x, http_separator_class, sizeof(http_separator_t));
}
#else
#define http_separator_init(x) \
  HTTP_HEADER_INIT(x, http_separator_class, sizeof(http_separator_t))
#endif

/**Test if header object is instance of http_separator_t.
 *
 * The function http_is_separator() returns true (nonzero) if
 * the header class is an instance of separator line between headers and body
 * object and false (zero) otherwise.
 *
 * @param header pointer to the header structure to be tested
 *
 * @return
 * The function http_is_xseparator() returns true (nonzero) if
 * the header object is an instance of header separator and
 * false (zero) otherwise.
 */
#if SU_HAVE_INLINE
su_inline
int http_is_separator(http_header_t const *header)
{
  return header && header->sh_class->hc_hash == http_separator_hash;
}
#else
#define http_is_separator(h) \
 ((h) && ((msg_common_t *)(h))->h_class->hc_hash == http_separator_hash)
#endif

/**Duplicate (deep copy) @c http_separator_t.
 *
 * The function http_separator_dup() duplicates a header
 * structure @a hdr.  If the header structure @a hdr
 * contains a reference (@c hdr->x_next) to a list of
 * headers, all the headers in the list are duplicated, too.
 *
 * @param home  memory home used to allocate new structure
 * @param hdr   header structure to be duplicated
 *
 * When duplicating, all parameter lists and non-constant
 * strings attached to the header are copied, too.  The
 * function uses given memory @a home to allocate all the
 * memory areas used to copy the header.
 *
 * @par Example
 * @code
 *
 *   separator = http_separator_dup(home, http->http_separator);
 *
 * @endcode
 *
 * @return
 * The function http_separator_dup() returns a pointer to the
 * newly duplicated http_separator_t header structure, or NULL
 * upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_separator_t *http_separator_dup(su_home_t *home,
				   http_separator_t const *hdr)
     __attribute__((__malloc__));

/**Copy a http_separator_t header structure.
 *
 * The function http_separator_copy() copies a header structure @a
 * hdr.  If the header structure @a hdr contains a reference (@c
 * hdr->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home
 * to allocate all the memory areas used to copy the header
 * structure @a hdr.
 *
 * @param home    memory home used to allocate new structure
 * @param hdr     pointer to the header structure to be duplicated
 *
 * When copying, only the header structure and parameter lists
 * attached to it are duplicated.  The new header structure
 * retains all the references to the strings within the old @a
 * header, including the encoding of the old header, if present.
 *
 * @par Example
 * @code
 *
 *   separator = http_separator_copy(home, http->http_separator);
 *
 * @endcode
 *
 * @return
 * The function http_separator_copy() returns a pointer to
 * newly copied header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_separator_t *http_separator_copy(su_home_t *home,
				    http_separator_t const *hdr)
     __attribute__((__malloc__));

/**Make a header structure http_separator_t.
 *
 * The function http_separator_make() makes a new
 * http_separator_t header structure.  It allocates a new
 * header structure, and decodes the string @a s as the
 * value of the structure.
 *
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 *
 * @note This function is usually implemented as a macro calling
 * http_header_make().
 *
 * @return
 * The function http_separator_make() returns a pointer to
 * newly maked http_separator_t header structure, or NULL upon
 * an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_separator_t *http_separator_make(su_home_t *home, char const *s)
     __attribute__((__malloc__));

/**Make a separator line between headers and body from formatting result.
 *
 * The function http_separator_format() makes a new
 * separator line between headers and body object using formatting result as its
 * value.  The function first prints the arguments according to
 * the format @a fmt specified.  Then it allocates a new header
 * structure, and uses the formatting result as the header
 * value.
 *
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 *
 * @note This function is usually implemented as a macro calling
 * msg_header_format().
 *
 * @return
 * The function http_separator_format() returns a pointer to newly
 * makes header structure, or NULL upon an error.
 *
 * @HIDE
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_separator_t *http_separator_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__malloc__, __format__ (printf, 2, 3)));


/* Inlined functions */
#if SU_HAVE_INLINE
su_inline
http_separator_t *http_separator_format(su_home_t *home, char const *fmt, ...)
{
  http_header_t *h;
  va_list ap;

  va_start(ap, fmt);
  h = http_header_vformat(home, http_separator_class, fmt, ap);
  va_end(ap);

  return (http_separator_t *)h;
}

su_inline
http_separator_t *http_separator_dup(su_home_t *home, http_separator_t const *o)
{
  return (http_separator_t *)
    msg_header_dup_as(home, http_separator_class, (msg_header_t const *)o);
}

su_inline
http_separator_t *http_separator_copy(su_home_t *home, http_separator_t const *o)
{
  return (http_separator_t *)
    msg_header_copy_as(home, http_separator_class, (msg_header_t const *)o);
}

su_inline
http_separator_t *http_separator_make(su_home_t *home, char const *s)
{
  return (http_separator_t *)http_header_make(home, http_separator_class, s);
}
#endif

#endif /* !define HTTP_HCLASSES_ONLY */

/** @} */


/* Declare internal prototypes for message payload */

/**@addtogroup http_payload*/ /** @{ */

enum {
  /** Hash of message payload. @internal*/
  http_payload_hash = -6
};

/**Header class for HTTP message payload.
 *
 * The header class http_payload_class defines how a HTTP
 * message payload is parsed and printed.  It also
 * contains methods used by HTTP parser and other functions
 * to manipulate the http_payload_t header structure.
 *
 */
SOFIAPUBVAR msg_hclass_t http_payload_class[];

#ifndef HTTP_HCLASSES_ONLY

/** Decode (parse) a message payload. @internal */
SOFIAPUBFUN msg_parse_f http_payload_d;

/** Encode (print) a message payload. @internal */
SOFIAPUBFUN msg_print_f http_payload_e;

/**Initializer for structure http_payload_t.
 *
 * A static http_payload_t structure must be initialized
 * with the HTTP_PAYLOAD_INIT() macro. For instance,
 * @code
 *
 *  http_payload_t http_payload = HTTP_PAYLOAD_INIT;
 *
 * @endcode
 * @HI
 */
#define HTTP_PAYLOAD_INIT() HTTP_HDR_INIT(payload)

/**Initialize a structure http_payload_t.
 *
 * An http_payload_t structure can be initialized with the
 * http_payload_init() function/macro. For instance,
 * @code
 *
 *  http_payload_t http_payload;
 *
 *  http_payload_init(&http_payload);
 *
 * @endcode
 * @HI
 */
#if SU_HAVE_INLINE
su_inline http_payload_t *http_payload_init(http_payload_t x[1])
{
  return HTTP_HEADER_INIT(x, http_payload_class, sizeof(http_payload_t));
}
#else
#define http_payload_init(x) \
  HTTP_HEADER_INIT(x, http_payload_class, sizeof(http_payload_t))
#endif

/**Test if header object is instance of http_payload_t.
 *
 * The function http_is_payload() returns true (nonzero) if
 * the header class is an instance of message payload
 * object and false (zero) otherwise.
 *
 * @param header pointer to the header structure to be tested
 *
 * @return
 * The function http_is_xpayload() returns true (nonzero) if
 * the header object is an instance of header payload and
 * false (zero) otherwise.
 */
#if SU_HAVE_INLINE
su_inline
int http_is_payload(http_header_t const *header)
{
  return header && header->sh_class->hc_hash == http_payload_hash;
}
#else
#define http_is_payload(h) \
 ((h) && ((msg_common_t *)(h))->h_class->hc_hash == http_payload_hash)
#endif

/**Duplicate (deep copy) @c http_payload_t.
 *
 * The function http_payload_dup() duplicates a header
 * structure @a hdr.  If the header structure @a hdr
 * contains a reference (@c hdr->x_next) to a list of
 * headers, all the headers in the list are duplicated, too.
 *
 * @param home  memory home used to allocate new structure
 * @param hdr   header structure to be duplicated
 *
 * When duplicating, all parameter lists and non-constant
 * strings attached to the header are copied, too.  The
 * function uses given memory @a home to allocate all the
 * memory areas used to copy the header.
 *
 * @par Example
 * @code
 *
 *   payload = http_payload_dup(home, http->http_payload);
 *
 * @endcode
 *
 * @return
 * The function http_payload_dup() returns a pointer to the
 * newly duplicated http_payload_t header structure, or NULL
 * upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_payload_t *http_payload_dup(su_home_t *home,
				   http_payload_t const *hdr)
     __attribute__((__malloc__));

/**Copy a http_payload_t header structure.
 *
 * The function http_payload_copy() copies a header structure @a
 * hdr.  If the header structure @a hdr contains a reference (@c
 * hdr->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home
 * to allocate all the memory areas used to copy the header
 * structure @a hdr.
 *
 * @param home    memory home used to allocate new structure
 * @param hdr     pointer to the header structure to be duplicated
 *
 * When copying, only the header structure and parameter lists
 * attached to it are duplicated.  The new header structure
 * retains all the references to the strings within the old @a
 * header, including the encoding of the old header, if present.
 *
 * @par Example
 * @code
 *
 *   payload = http_payload_copy(home, http->http_payload);
 *
 * @endcode
 *
 * @return
 * The function http_payload_copy() returns a pointer to
 * newly copied header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_payload_t *http_payload_copy(su_home_t *home,
				    http_payload_t const *hdr)
     __attribute__((__malloc__));

/**Make a header structure http_payload_t.
 *
 * The function http_payload_make() makes a new
 * http_payload_t header structure.  It allocates a new
 * header structure, and decodes the string @a s as the
 * value of the structure.
 *
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 *
 * @note This function is usually implemented as a macro calling
 * http_header_make().
 *
 * @return
 * The function http_payload_make() returns a pointer to
 * newly maked http_payload_t header structure, or NULL upon
 * an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_payload_t *http_payload_make(su_home_t *home, char const *s)
     __attribute__((__malloc__));

/**Make a message payload from formatting result.
 *
 * The function http_payload_format() makes a new
 * message payload object using formatting result as its
 * value.  The function first prints the arguments according to
 * the format @a fmt specified.  Then it allocates a new header
 * structure, and uses the formatting result as the header
 * value.
 *
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 *
 * @note This function is usually implemented as a macro calling
 * msg_header_format().
 *
 * @return
 * The function http_payload_format() returns a pointer to newly
 * makes header structure, or NULL upon an error.
 *
 * @HIDE
 */
#if SU_HAVE_INLINE
su_inline
#endif
http_payload_t *http_payload_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__malloc__, __format__ (printf, 2, 3)));


/* Inlined functions */
#if SU_HAVE_INLINE
su_inline
http_payload_t *http_payload_format(su_home_t *home, char const *fmt, ...)
{
  http_header_t *h;
  va_list ap;

  va_start(ap, fmt);
  h = http_header_vformat(home, http_payload_class, fmt, ap);
  va_end(ap);

  return (http_payload_t *)h;
}

su_inline
http_payload_t *http_payload_dup(su_home_t *home, http_payload_t const *o)
{
  return (http_payload_t *)
    msg_header_dup_as(home, http_payload_class, (msg_header_t const *)o);
}

su_inline
http_payload_t *http_payload_copy(su_home_t *home, http_payload_t const *o)
{
  return (http_payload_t *)
    msg_header_copy_as(home, http_payload_class, (msg_header_t const *)o);
}

su_inline
http_payload_t *http_payload_make(su_home_t *home, char const *s)
{
  return (http_payload_t *)http_header_make(home, http_payload_class, s);
}
#endif

#endif /* !define HTTP_HCLASSES_ONLY */

/** @} */


SOFIA_END_DECLS
#endif /* !defined(HTTP_PROTOS_H) */
