/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import net.sf.jasperreports.engine.fill.JRAbstractExtendedIncrementerFactory;
import net.sf.jasperreports.engine.fill.JRByteAverageIncrementer;
import net.sf.jasperreports.engine.fill.JRByteCountIncrementer;
import net.sf.jasperreports.engine.fill.JRByteDistinctCountIncrementer;
import net.sf.jasperreports.engine.fill.JRByteStandardDeviationIncrementer;
import net.sf.jasperreports.engine.fill.JRByteSumIncrementer;
import net.sf.jasperreports.engine.fill.JRByteVarianceIncrementer;
import net.sf.jasperreports.engine.fill.JRComparableIncrementerFactory;
import net.sf.jasperreports.engine.fill.JRDefaultIncrementerFactory;
import net.sf.jasperreports.engine.fill.JRExtendedIncrementer;

public class JRByteIncrementerFactory
extends JRAbstractExtendedIncrementerFactory {
    protected static final Byte ZERO = new Byte(0);
    private static JRByteIncrementerFactory mainInstance = new JRByteIncrementerFactory();

    private JRByteIncrementerFactory() {
    }

    public static JRByteIncrementerFactory getInstance() {
        return mainInstance;
    }

    public JRExtendedIncrementer getExtendedIncrementer(byte calculation) {
        JRExtendedIncrementer incrementer = null;
        switch (calculation) {
            case 1: {
                incrementer = JRByteCountIncrementer.getInstance();
                break;
            }
            case 2: {
                incrementer = JRByteSumIncrementer.getInstance();
                break;
            }
            case 3: {
                incrementer = JRByteAverageIncrementer.getInstance();
                break;
            }
            case 4: 
            case 5: {
                incrementer = JRComparableIncrementerFactory.getInstance().getExtendedIncrementer(calculation);
                break;
            }
            case 6: {
                incrementer = JRByteStandardDeviationIncrementer.getInstance();
                break;
            }
            case 7: {
                incrementer = JRByteVarianceIncrementer.getInstance();
                break;
            }
            case 10: {
                incrementer = JRByteDistinctCountIncrementer.getInstance();
                break;
            }
            default: {
                incrementer = JRDefaultIncrementerFactory.getInstance().getExtendedIncrementer(calculation);
            }
        }
        return incrementer;
    }
}

