/*
 * Decompiled with CFR 0.152.
 */
package au.com.trgtd.tr.autoupdate.members;

import au.com.trgtd.tr.autoupdate.members.MemberUtils;
import au.com.trgtd.tr.autoupdate.members.prefs.MemberPrefs;
import java.util.Date;
import java.util.logging.Logger;
import org.netbeans.api.autoupdate.UpdateUnitProvider;

public class MemberCheckThread
extends Thread {
    private static final Logger LOG = Logger.getLogger("au.com.trgtd.tr.autoupdate.members.MemberCheckTimerTask");
    private static final String NAME = "Check ThinkingRock membership";

    public MemberCheckThread() {
        super(NAME);
    }

    public void run() {
        LOG.info("Started at: " + new Date());
        this.process();
        LOG.info("Finished at: " + new Date());
    }

    private void process() {
        UpdateUnitProvider uc;
        if (!MemberPrefs.isGetUpdates() && !MemberPrefs.isGetBetaUpdates()) {
            LOG.info("Member module updates are not required so removing member update centers.");
            MemberUtils.getDefault().removeMemberUpdateCenter();
            MemberUtils.getDefault().removeMemberBetaUpdateCenter();
            return;
        }
        String username = MemberPrefs.getMemberUsername();
        String password = MemberPrefs.getMemberPassword();
        Boolean isMember = MemberUtils.getDefault().isMember(username, password);
        if (isMember == null) {
            LOG.info("User membership can not be validated so removing member update centers.");
            MemberUtils.getDefault().removeMemberUpdateCenter();
            MemberUtils.getDefault().removeMemberBetaUpdateCenter();
            return;
        }
        if (!isMember.booleanValue()) {
            LOG.info("User is not an active member so removing member update centers.");
            MemberUtils.getDefault().removeMemberUpdateCenter();
            MemberUtils.getDefault().removeMemberBetaUpdateCenter();
            return;
        }
        LOG.info("User is an active member.");
        if (MemberPrefs.isGetUpdates()) {
            LOG.info("Adding member update center.");
            uc = MemberUtils.getDefault().getMemberUpdateCenter();
            if (uc == null) {
                uc = MemberUtils.getDefault().createMemberUpdateCenter();
            }
            if (uc == null) {
                LOG.warning("Could not create member update center.");
            } else {
                uc.setEnable(true);
            }
        } else {
            MemberUtils.getDefault().removeMemberUpdateCenter();
        }
        if (MemberPrefs.isGetBetaUpdates()) {
            LOG.info("Adding member beta update center.");
            uc = MemberUtils.getDefault().getMemberBetaUpdateCenter();
            if (uc == null) {
                uc = MemberUtils.getDefault().createMemberBetaUpdateCenter();
            }
            if (uc == null) {
                LOG.warning("Could not create member beta update center.");
            } else {
                uc.setEnable(true);
            }
        } else {
            MemberUtils.getDefault().removeMemberBetaUpdateCenter();
        }
    }
}

