/*
 * Decompiled with CFR 0.152.
 */
package org.jparsec;

import java.util.ArrayList;
import java.util.Collections;
import org.jparsec.ParseTree;
import org.jparsec.internal.util.Checks;

final class TreeNode {
    private final String name;
    private final int beginIndex;
    private final TreeNode parent;
    private final TreeNode previous;
    private int endIndex = 0;
    private Object result = null;
    TreeNode latestChild = null;

    TreeNode(String name, int beginIndex) {
        this.name = name;
        this.beginIndex = beginIndex;
        this.parent = null;
        this.previous = null;
    }

    TreeNode(String name, int beginIndex, TreeNode parent, TreeNode previous) {
        this.name = name;
        this.beginIndex = beginIndex;
        this.parent = parent;
        this.previous = previous;
    }

    void setEndIndex(int index) {
        Checks.checkArgument(index >= this.beginIndex, "endIndex < beginIndex");
        this.endIndex = index;
    }

    void setResult(Object result) {
        this.result = result;
    }

    TreeNode parent() {
        Checks.checkState(this.parent != null, "Root node has no parent");
        return this.parent;
    }

    TreeNode addChild(String childName, int childIndex) {
        TreeNode child;
        this.latestChild = child = new TreeNode(childName, childIndex, this, this.latestChild);
        return child;
    }

    TreeNode orphanize() {
        if (this.parent == null) {
            return this;
        }
        this.parent.latestChild = this.previous;
        return this.parent;
    }

    TreeNode freeze(int index) {
        TreeNode node = this;
        node.setEndIndex(index);
        while (node.parent != null) {
            node.parent.latestChild = node;
            node = node.parent;
            node.setEndIndex(index);
        }
        return node;
    }

    ParseTree toParseTree() {
        ArrayList<ParseTree> children = new ArrayList<ParseTree>();
        TreeNode child = this.latestChild;
        while (child != null) {
            children.add(child.toParseTree());
            child = child.previous;
        }
        Collections.reverse(children);
        return new ParseTree(this.name, this.beginIndex, this.endIndex, this.result, children);
    }

    public String toString() {
        return this.name;
    }
}

