/*
 * Decompiled with CFR 0.152.
 */
package org.traccar;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.ReferenceCountUtil;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import javax.inject.Inject;
import org.traccar.NetworkMessage;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.helper.DataConverter;
import org.traccar.model.Position;

public abstract class ExtendedObjectDecoder
extends ChannelInboundHandlerAdapter {
    private Config config;

    public Config getConfig() {
        return this.config;
    }

    @Inject
    public void setConfig(Config config) {
        this.config = config;
        this.init();
    }

    protected void init() {
    }

    private void saveOriginal(Object decodedMessage, Object originalMessage) {
        if (this.getConfig().getBoolean(Keys.DATABASE_SAVE_ORIGINAL) && decodedMessage instanceof Position) {
            Position position = (Position)decodedMessage;
            if (originalMessage instanceof ByteBuf) {
                ByteBuf buf = (ByteBuf)originalMessage;
                position.set("raw", ByteBufUtil.hexDump((ByteBuf)buf, (int)0, (int)buf.writerIndex()));
            } else if (originalMessage instanceof String) {
                position.set("raw", DataConverter.printHex(((String)originalMessage).getBytes(StandardCharsets.US_ASCII)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        NetworkMessage networkMessage = (NetworkMessage)msg;
        Object originalMessage = networkMessage.getMessage();
        try {
            Object decodedMessage = this.decode(ctx.channel(), networkMessage.getRemoteAddress(), originalMessage);
            this.onMessageEvent(ctx.channel(), networkMessage.getRemoteAddress(), originalMessage, decodedMessage);
            if (decodedMessage == null) {
                decodedMessage = this.handleEmptyMessage(ctx.channel(), networkMessage.getRemoteAddress(), originalMessage);
            }
            if (decodedMessage != null) {
                if (decodedMessage instanceof Collection) {
                    for (Object o : (Collection)decodedMessage) {
                        this.saveOriginal(o, originalMessage);
                        ctx.fireChannelRead(o);
                    }
                } else {
                    this.saveOriginal(decodedMessage, originalMessage);
                    ctx.fireChannelRead(decodedMessage);
                }
            }
        }
        finally {
            ReferenceCountUtil.release((Object)originalMessage);
        }
    }

    protected void onMessageEvent(Channel channel, SocketAddress remoteAddress, Object originalMessage, Object decodedMessage) {
    }

    protected Object handleEmptyMessage(Channel channel, SocketAddress remoteAddress, Object msg) {
        return null;
    }

    protected abstract Object decode(Channel var1, SocketAddress var2, Object var3) throws Exception;
}

