/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.handler;

import io.netty.channel.ChannelHandler;
import javax.inject.Inject;
import org.traccar.BaseDataHandler;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.helper.model.AttributeUtil;
import org.traccar.model.Position;
import org.traccar.session.cache.CacheManager;

@ChannelHandler.Sharable
public class CopyAttributesHandler
extends BaseDataHandler {
    private final boolean enabled;
    private final CacheManager cacheManager;

    @Inject
    public CopyAttributesHandler(Config config, CacheManager cacheManager) {
        this.enabled = config.getBoolean(Keys.PROCESSING_COPY_ATTRIBUTES_ENABLE);
        this.cacheManager = cacheManager;
    }

    @Override
    protected Position handlePosition(Position position) {
        if (this.enabled) {
            String attributesString = AttributeUtil.lookup(this.cacheManager, Keys.PROCESSING_COPY_ATTRIBUTES, position.getDeviceId());
            Position last = this.cacheManager.getPosition(position.getDeviceId());
            if (last != null && attributesString != null) {
                for (String attribute : attributesString.split("[ ,]")) {
                    if (!last.hasAttribute(attribute) || position.hasAttribute(attribute)) continue;
                    position.getAttributes().put(attribute, last.getAttributes().get(attribute));
                }
            }
        }
        return position;
    }
}

