/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class DualcamProtocolDecoder
extends BaseProtocolDecoder {
    public static final int MSG_INIT = 0;
    public static final int MSG_START = 1;
    public static final int MSG_RESUME = 2;
    public static final int MSG_SYNC = 3;
    public static final int MSG_DATA = 4;
    public static final int MSG_COMPLETE = 5;
    public static final int MSG_FILE_REQUEST = 8;
    public static final int MSG_INIT_REQUEST = 9;
    private String uniqueId;
    private int packetCount;
    private int currentPacket;
    private ByteBuf photo;

    public DualcamProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        int type = buf.readUnsignedShort();
        switch (type) {
            case 0: {
                buf.readUnsignedShort();
                this.uniqueId = String.valueOf(buf.readLong());
                DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, this.uniqueId);
                long settings = buf.readUnsignedInt();
                if (channel == null) return null;
                if (deviceSession == null) return null;
                ByteBuf response = Unpooled.buffer();
                if (BitUtil.between(settings, 26, 28) > 0L) {
                    response.writeShort(8);
                    String file = BitUtil.check(settings, 26) ? "%photof" : "%photor";
                    response.writeShort(file.length());
                    response.writeCharSequence((CharSequence)file, StandardCharsets.US_ASCII);
                } else {
                    response.writeShort(5);
                }
                channel.writeAndFlush((Object)new NetworkMessage(response, remoteAddress));
                return null;
            }
            case 1: {
                buf.readUnsignedShort();
                this.packetCount = buf.readInt();
                this.currentPacket = 1;
                this.photo = Unpooled.buffer();
                if (channel == null) return null;
                ByteBuf response = Unpooled.buffer();
                response.writeShort(2);
                response.writeShort(4);
                response.writeInt(this.currentPacket);
                channel.writeAndFlush((Object)new NetworkMessage(response, remoteAddress));
                return null;
            }
            case 4: {
                buf.readUnsignedShort();
                this.photo.writeBytes(buf, buf.readableBytes() - 2);
                if (this.currentPacket != this.packetCount) {
                    ++this.currentPacket;
                    return null;
                }
                DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, new String[0]);
                Position position = new Position(this.getProtocolName());
                position.setDeviceId(deviceSession.getDeviceId());
                this.getLastLocation(position, null);
                try {
                    position.set("image", this.writeMediaFile(this.uniqueId, this.photo, "jpg"));
                }
                finally {
                    this.photo.release();
                    this.photo = null;
                }
                if (channel == null) return position;
                ByteBuf response = Unpooled.buffer();
                response.writeShort(9);
                channel.writeAndFlush((Object)new NetworkMessage(response, remoteAddress));
                return position;
            }
        }
        return null;
    }
}

