/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import io.netty.channel.socket.DatagramChannel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class EskyProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN = new PatternBuilder().expression("..;").number("d+;").number("(d+);").text("R;").number("(d+)[+;]").number("(dd)(dd)(dd)").number("(dd)(dd)(dd)[+;]").number("(-?d+.d+)[+;]").number("(-?d+.d+)[+;]").number("(d+.d+)[+;]").number("(d+)[+;]").groupBegin().text("0x").number("(d+)[+;]").number("(d+)[+;]").number("(d+)[+;]").groupEnd("?").number("(d+)[+;]").number("(d+)").any().compile();

    public EskyProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        String sentence = (String)msg;
        Parser parser = new Parser(PATTERN, sentence);
        if (!parser.matches()) {
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.set("sat", parser.nextInt());
        position.setValid(true);
        position.setTime(parser.nextDateTime());
        position.setLatitude(parser.nextDouble());
        position.setLongitude(parser.nextDouble());
        position.setSpeed(UnitsConverter.knotsFromMps(parser.nextDouble()));
        position.setCourse(parser.nextDouble());
        if (parser.hasNext(3)) {
            int input = parser.nextHexInt();
            position.set("ignition", !BitUtil.check(input, 0));
            position.set("in1", !BitUtil.check(input, 1));
            position.set("in2", !BitUtil.check(input, 2));
            position.set("event", parser.nextInt());
            position.set("odometer", parser.nextInt());
        }
        position.set("adc1", parser.nextInt());
        position.set("battery", (double)parser.nextInt().intValue() * 0.01);
        int index = sentence.lastIndexOf(43);
        if (index > 0 && channel instanceof DatagramChannel) {
            channel.writeAndFlush((Object)new NetworkMessage("ACK," + sentence.substring(index + 1) + "#", remoteAddress));
        }
        return position;
    }
}

