// Generated by gmmproc 2.72.1 -- DO NOT MODIFY!
#ifndef _ATKMM_COMPONENT_H
#define _ATKMM_COMPONENT_H

#include <atkmmconfig.h>


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* $Id: component.hg,v 1.5 2004/03/12 20:35:53 murrayc Exp $ */

/* Copyright (C) 2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <glibmm/interface.h>
#include <glibmm/value.h>

#ifndef DOXYGEN_SHOULD_SKIP_THIS
extern "C"
{
  typedef struct _AtkComponentIface AtkComponentIface;
  typedef struct _AtkObject         AtkObject;
  typedef void (* AtkFocusHandler) (AtkObject*, gboolean);
}
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
using AtkComponent = struct _AtkComponent;
using AtkComponentClass = struct _AtkComponentClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Atk
{ class ATKMM_API Component_Class; } // namespace Atk
#endif // DOXYGEN_SHOULD_SKIP_THIS

namespace Atk
{


/** @addtogroup atkmmEnums atkmm Enums and Flags */

/** 
 *  @var CoordType SCREEN
 * Specifies xy coordinates relative to the screen.
 * 
 *  @var CoordType WINDOW
 * Specifies xy coordinates relative to the widget's
 * top-level window.
 * 
 *  @var CoordType PARENT
 * Specifies xy coordinates relative to the widget's
 * immediate parent. @newin{2,30}
 * 
 *  @enum CoordType
 * 
 * Specifies how xy coordinates are to be interpreted. Used by functions such
 * as Atk::Component::get_position() and Atk::Text::get_character_extents()
 *
 * @ingroup atkmmEnums
 */
enum class CoordType
{
  SCREEN,
  WINDOW,
  PARENT
};


} // namespace Atk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class ATKMM_API Value<Atk::CoordType> : public Glib::Value_Enum<Atk::CoordType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Atk
{

/** 
 *  @var Layer INVALID
 * The object does not have a layer.
 * 
 *  @var Layer BACKGROUND
 * This layer is reserved for the desktop background.
 * 
 *  @var Layer CANVAS
 * This layer is used for Canvas components.
 * 
 *  @var Layer WIDGET
 * This layer is normally used for components.
 * 
 *  @var Layer MDI
 * This layer is used for layered components.
 * 
 *  @var Layer POPUP
 * This layer is used for popup components, such as menus.
 * 
 *  @var Layer OVERLAY
 * This layer is reserved for future use.
 * 
 *  @var Layer WINDOW
 * This layer is used for toplevel windows.
 * 
 *  @enum Layer
 * 
 * Describes the layer of a component
 * 
 * These enumerated "layer values" are used when determining which UI
 * rendering layer a component is drawn into, which can help in making
 * determinations of when components occlude one another.
 *
 * @ingroup atkmmEnums
 */
enum class Layer
{
  INVALID,
  BACKGROUND,
  CANVAS,
  WIDGET,
  MDI,
  POPUP,
  OVERLAY,
  WINDOW
};


} // namespace Atk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class ATKMM_API Value<Atk::Layer> : public Glib::Value_Enum<Atk::Layer>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Atk
{


class ATKMM_API Object;


/** The ATK interface provided by UI components which occupy a physical area on the screen.
 * This should be implemented by most if not all UI elements with an actual on-screen presence, i.e. components which
 * can be said to have a screen-coordinate bounding box. Virtually all widgets will need to have Atk::Component
 * implementations provided for their corresponding Atk::Object class. In short, only UI elements which are *not* GUI
 * elements will omit this ATK interface.
 * 
 * A possible exception might be textual information with a transparent background, in which case text glyph bounding
 * box information is provided by Atk::Text.
 */

class ATKMM_API Component : public Glib::Interface
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  using CppObjectType = Component;
  using CppClassType = Component_Class;
  using BaseObjectType = AtkComponent;
  using BaseClassType = AtkComponentIface;

  // noncopyable
  Component(const Component&) = delete;
  Component& operator=(const Component&) = delete;

private:
  friend class Component_Class;
  static CppClassType component_class_;

#endif /* DOXYGEN_SHOULD_SKIP_THIS */
protected:
  /**
   * You should derive from this class to use it.
   */
  Component();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  /** Called by constructors of derived classes. Provide the result of
   * the Class init() function to ensure that it is properly
   * initialized.
   *
   * @param interface_class The Class object for the derived type.
   */
  explicit Component(const Glib::Interface_Class& interface_class);

public:
  // This is public so that C++ wrapper instances can be
  // created for C instances of unwrapped types.
  // For instance, if an unexpected C type implements the C interface.
  explicit Component(AtkComponent* castitem);

protected:
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  Component(Component&& src) noexcept;
  Component& operator=(Component&& src) noexcept;

  ~Component() noexcept override;

  static void add_interface(GType gtype_implementer);

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  AtkComponent*       gobj()       { return reinterpret_cast<AtkComponent*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const AtkComponent* gobj() const { return reinterpret_cast<AtkComponent*>(gobject_); }

private:

  
public:
  
  
  /** Checks whether the specified point is within the extent of the @a component.
   * 
   * Toolkit implementor note: ATK provides a default implementation for
   * this virtual method. In general there are little reason to
   * re-implement it.
   * 
   * @param x X coordinate.
   * @param y Y coordinate.
   * @param coord_type Specifies whether the coordinates are relative to the screen
   * or to the components top level window.
   * @return <tt>true</tt> or <tt>false</tt> indicating whether the specified point is within
   * the extent of the @a component or not.
   */
  bool contains(int x, int y, CoordType coord_type) const;
  
  /** Gets a reference to the accessible child, if one exists, at the
   * coordinate point specified by @a x and @a y.
   * 
   * @param x X coordinate.
   * @param y Y coordinate.
   * @param coord_type Specifies whether the coordinates are relative to the screen
   * or to the components top level window.
   * @return A reference to the accessible
   * child, if one exists.
   */
  Glib::RefPtr<Atk::Object> get_accessible_at_point(int x, int y, CoordType coord_type);
  
  /** Gets the rectangle which gives the extent of the @a component.
   * 
   * If the extent can not be obtained (e.g. a non-embedded plug or missing
   * support), all of x, y, width, height are set to -1.
   * 
   * @param x Address of <tt>int</tt> to put x coordinate.
   * @param y Address of <tt>int</tt> to put y coordinate.
   * @param width Address of <tt>int</tt> to put width.
   * @param height Address of <tt>int</tt> to put height.
   * @param coord_type Specifies whether the coordinates are relative to the screen
   * or to the components top level window.
   */
  void get_extents(int& x, int& y, int& width, int& height, CoordType coord_type) const;
  
  
  /** Gets the layer of the component.
   * 
   * @return An Atk::Layer which is the layer of the component.
   */
  Layer get_layer() const;
  
  /** Gets the zorder of the component. The value G_MININT will be returned 
   * if the layer of the component is not ATK_LAYER_MDI or ATK_LAYER_WINDOW.
   * 
   * @return A <tt>int</tt> which is the zorder of the component, i.e. the depth at 
   * which the component is shown in relation to other components in the same 
   * container.
   */
  int get_mdi_zorder() const;
  
  /** Grabs focus for this @a component.
   * 
   * @return <tt>true</tt> if successful, <tt>false</tt> otherwise.
   */
  bool grab_focus();
  
  
  /** Sets the extents of @a component.
   * 
   * @param x X coordinate.
   * @param y Y coordinate.
   * @param width Width to set for @a component.
   * @param height Height to set for @a component.
   * @param coord_type Specifies whether the coordinates are relative to the screen
   * or to the components top level window.
   * @return <tt>true</tt> or <tt>false</tt> whether the extents were set or not.
   */
  bool set_extents(int x, int y, int width, int height, CoordType coord_type);
  
  /** Sets the position of @a component.
   * 
   * Contrary to atk_component_scroll_to, this does not trigger any scrolling,
   * this just moves @a component in its parent.
   * 
   * @param x X coordinate.
   * @param y Y coordinate.
   * @param coord_type Specifies whether the coordinates are relative to the screen
   * or to the component's top level window.
   * @return <tt>true</tt> or <tt>false</tt> whether or not the position was set or not.
   */
  bool set_position(int x, int y, CoordType coord_type);
  
  /** Set the size of the @a component in terms of width and height.
   * 
   * @param width Width to set for @a component.
   * @param height Height to set for @a component.
   * @return <tt>true</tt> or <tt>false</tt> whether the size was set or not.
   */
  bool set_size(int width, int height);

protected:
    virtual guint add_focus_handler_vfunc(AtkFocusHandler handler);

    virtual bool contains_vfunc(int x, int y, CoordType coord_type) const;


    virtual Glib::RefPtr<Atk::Object> get_accessible_at_point_vfunc(int x, int y, CoordType coord_type);


    virtual void get_extents_vfunc(int& x, int& y, int& width, int& height, CoordType coord_type) const;


  //deprecated:
  //_IGNORE_VFUNC(get_position)
  //_IGNORE_VFUNC(get_size)

    virtual Layer get_layer_vfunc() const;

    virtual int get_mdi_zorder_vfunc() const;

    virtual bool grab_focus_vfunc();


  //deprecated:
  //_IGNORE_VFUNC(remove_focus_handler)

    virtual bool set_extents_vfunc(int x, int y, int width, int height, CoordType coord_type);

    virtual bool set_position_vfunc(int x, int y, CoordType coord_type);

    virtual bool set_size_vfunc(int width, int height);


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Atk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Atk::Component
   */
  ATKMM_API
  Glib::RefPtr<Atk::Component> wrap(AtkComponent* object, bool take_copy = false);

} // namespace Glib


#endif /* _ATKMM_COMPONENT_H */

