%% Generated by lilypond-book
%% Options: [exampleindent=10.16\mm,indent=0\mm,line-width=160\mm]
\include "lilypond-book-preamble.ly"


% ****************************************************************
% Start cut-&-pastable-section
% ****************************************************************



\paper {
  indent = 0\mm
  line-width = 160\mm
  % offset the left padding, also add 1mm as lilypond creates cropped
  % images with a little space on the right
  line-width = #(- line-width (* mm  3.000000) (* mm 1))
}

\layout {
  
}





% ****************************************************************
% ly snippet:
% ****************************************************************
\sourcefilename "snippets/score-for-diatonic-accordion.ly"
\sourcefileline 0
%% DO NOT EDIT this file manually; it is automatically
%% generated from LSR http://lsr.di.unimi.it
%% Make any changes in LSR itself, or in Documentation/snippets/new/ ,
%% and then run scripts/auxiliar/makelsr.py
%%
%% This file is in the public domain.
\version "2.21.2"

\header {
%% Translation of GIT committish: 0cc270b871321ae5aa8622cea8d8262aafd16641
  texidocja = "
ダイアトニック アコーディオンの楽譜を作成するためのテンプレートです。

- アコーディオンを押す (太い線) か引く (細い線) かを示す 1 本の譜線があります。

- ベース ボタンを押すことを示す小さなリズム譜があります。上にはテキストが@c
配置されています。グリッド線も表示されています。

- ダイアトニック アコーディオンのタブ譜があります。これはボタンの位置を@c
視覚的に表したもので、(他の楽器のタブ譜と同じように)
音符のピッチは表していません。アコーディオンのメロディ側の鍵盤は、@c
3 列 12 行ほどで表示されます。

タブ譜では、一番外側の列で演奏される音は線と線の間にある音符として、@c
一番内側の列で演奏される音は線と線にある音符にクロス臨時記号を付けた@c
ものとして、@c
中央の列で演奏される音は線上にある音符として表示されます。譜の中央の線は、@c
中央列の中心にある音を表します。


ピアノ曲をアコーディオンに編曲する際に注意することがいくつかあります:

1. ダイアトニック アコーディオンで演奏できる調は限られています
(例えば、C メジャーと F メジャーのみといったように)。そのため、対応している@c
調のどれかに移調する必要があります。
出力だけではなくソース コード自体の音高を変更する必要があります。@c
後にコードをタブ譜のために変換する必要があるからです。@c
これは @code{displayLilyMusic} コマンドで行うことができます。

2. 押し引きの向きを定期的に変える必要があります。@c
ずっと押し続けることや引き続けることはアコーディオンでは不可能であるからです。@c
一方、ハーモニーによってはどちらかの向きでしか実現できないものがあります。@c
これらを考慮し、メロディのどの部分を押す部分あるいは引く部分にするかを決定する@c
必要があります。

3. 押す部分と引く部分それぞれで、ピッチをアコーディオン用の表現に@c
置き換えます。
"
  doctitleja = "ダイアトニック アコーディオンの楽譜"

%% Translation of GIT committish: 00f0ca84dbb015617f8ce36dd13db59bbfef8f11
  texidoces = "
Plantilla para escribir una partitura para acordeón diatónico.

- Hay una pauta horizontal que indica si el acordeón se debe cerrar
(línea gruesa) o abrir (línea delgada).

- Hay una pauta rítmica pequeña con letra que describe los botones que
hay que pulsar en el bajo. Las barras de compás están hechas a partir
de líneas de rejilla.

- La pauta del tabulador para acordeones diatónicos muestra la
posición geográfica de los botones y no (como en otros instrumentos)
la altura de las notas; las llaves sobre el lado de la melodía del
acordeón se ponen en tres columnas y unas doce filas.

En la notación de pauta del tabulador, la columna más externa se
describe con notas entre líneas, la columnas más interna se describe
con notas entre líneas y unas aspas como alteración accidental, y la
columna central se describe con notas sobre una línea, mientras que la
fila del medio se representa sobre la línea central del pentagrama.

A continuación algunas notas sobre la forma de transcribir notas de
piano a acordeón diatónico:

1. Todo acordeón diatónico está construido para un cierto conjunto de
tonalidades solamente (por ejemplo, para las tonalidades de Do mayor y
Fa mayor), por lo que es importante transportar una melodía de piano
que corresponda exactamente a una de esas tonalidades.  Transporte el
código fuente, no solamente la salida porque este código se necesita
después para traducirlo de nuevo a la pauta del tabulador.  Esto se
puede hacer con la instrucción @code{displayLilyMusic}.


2. Tenemos que alternar las direcciones de abrir y de cerrar el fuelle
de forma regular.  Si el intérprete tiene un período de abrir el
fuelle excesivamente largo, el acordeón puede romperse.  Por otro
lado, algunas armonías solamente están disponibles en una dirección.
Teniendo esto en cuenta, debemos decidir qué partes de la melodía son
las partes de cerrar y cuáles las de abrir.


3. Para cada una de las partes de abrir o cerrar, transcriba las notas
del piano a la representación de tablatura correspondiente.

"
  doctitlees = "Partitura para acordeón diatónico"

  lsrtags = "real-music, specific-notation, template"

  texidoc = "
A template to write a score for a diatonic accordion.

- There is a horizontal staff indicating if the accordion must be
pushed (thick line) or pulled (thin line)

- There is a small rhythmic staff with lyrics that describes the bass
buttons to press. The bar lines are made from gridlines

- The tabulator staff for diatonic accordions shows the geographic
position of the buttons and not (as for every other instrument) the
pitch of the notes; the keys on the melody-side of the accordion are
placed in three columns and about 12 rows

In the tabulator staff notation the outermost column is described with
notes between lines, the innermost column is described with notes
between lines and a cross as accidental, and the middle column is
described with notes on a line, whereby the row in the middle is
represented on the middle line in the staff.

Some words to transpose piano notes to the diatonic accordion:

1. Every diatonic accordion is built for some keys only (for example,
for the keys of C major and F major), so it is important to transpose a
piano melody to match one of these keys. Transpose the source code, not
only the output because this code is required later on to translate it
once more to the tabulator staff. This can be done with the command
@code{displayLilyMusic}.

2. You have to alternate the push- and pull-direction of the accordion
regularly. If the player has a too long part to pull the accordion gets
broken. On the other hand, some harmonies are only available in one
direction. Considering this, decide which parts of the melody are the
push-parts and which the pull-parts.

3. For each pull- or push-part translate the piano notes to the
according tabulature representation.

"
  doctitle = "Score for diatonic accordion"
} % begin verbatim

verse = \lyricmode { Wie gross bist du! Wie gross bist du! }

harmonies = \new ChordNames \chordmode {
  \germanChords
  \set chordChanges = ##t
  bes8 bes8 bes8
  es2 f
  bes1
}

NoStem = { \hide Stem }
NoNoteHead = \hide NoteHead
ZeroBeam = \override Beam.positions = #'(0 . 0)

staffTabLine = \new Staff \with {
  \remove "Time_signature_engraver"
  \remove "Clef_engraver"
} {
  \override Staff.StaffSymbol.line-positions = #'(0)
  % Shows one horizontal line. The vertical line
  %  (simulating a bar-line) is simulated with a gridline
  \set Staff.midiInstrument = #"choir aahs"
  \key c \major
  \relative c''
  {
    % disable the following line to see the noteheads while writing the song
    \NoNoteHead
    \override NoteHead.no-ledgers = ##t

    % The beam between 8th-notes is used to draw the push-line
    %How to fast write the push-lines:
    %  1. write repeatedly 'c c c c c c c c |' for the whole length of the song
    %  2. uncomment the line \NoNoteHead
    %  3. compile
    %  4. Mark the positions on which push/pull changes.
    %     In the score-picture click on the position
    %        the push- or pull-part starts
    %           (on the noteHead, the cursor will change to a hand-icon).
    %     The cursor in the source code will jump just at this position.
    %   a) If a push-part starts there, replace the 'c' by an 'e['
    %   b) If a pull-part starts there, replace the 'c' by an 's'
    %  5. Switch into 'overwrite-mode' by pressing the 'ins' key.
    %  6. For the pull-parts overwrite the 'c' with 's'
    %  7. For every push-part replace the last 'c' with 'e]'
    %        8. Switch into 'insert-mode' again
    %  9. At last it should look like e.g.
    %        (s s e[ c | c c c c c c c c | c c c c c c e] s s)
    % 10. re-enable the line \NoNoteHead
    \autoBeamOff
    \ZeroBeam
    s8 s s e[ c c c c c c e] | s s s s s
  }
}

% Accordion melody in tabulator score
% 1. Place a copy of the piano melody below
% 2. Separate piano melody into pull- and push-parts
%      according to the staffTabLine you've already made
% 3. For each line: Double the line. Remark the 1st one
%      (Keeps unchanged as reference) and then change the second
%      line using the transformation paper
%    or the macros 'conv2diaton push.bsh' and 'conv2diaton pull.bsh'
% Tips:
% - In jEdit Search & Replace mark the Option 'Keep Dialog'

AccordionTabTwoCBesDur = {
  % pull 1
  %<f' bes'>8 <f' a'>8 <d' bes'>8 |
  <g'' a''>8 <g'' b''>8 <e'' a''>8 |
  % push 2
  %<g' c''>4 <f' d''> <g' ees''> <f' a'> |
  <g'' a''>4 <d'' eisis''> <g'' bisis''> <d'' f''> |
  % pull 3
  % <f' bes'>2 r8 }
  <g'' a''>2 r8 }

AccordionTab= { \dynamicUp
  % 1. Place a copy of the piano melody above
  % 2. Separate piano melody into pull- and push-parts
  %      according to the staffTabLine you've already made
  % 3. For each line: Double the line. Remark the 1st one
  %      (Keeps unchanged as reference) and then
  %      change the second line using the transformation paper
  % Tips:
  % - In jEdit Search & Replace mark the Option 'Keep Dialog'
  % -
  \AccordionTabTwoCBesDur
}



\layout {
  \context {
    \Score
    % The vertical line (simulating a bar-line) in
    % the staffBassRhytm is a gridline
    \consists "Grid_line_span_engraver"
  }
  \context {
    \Staff
    \consists "Grid_point_engraver"
    gridInterval = #(ly:make-moment 4/4) % 4/4 - tact. How many beats per bar
    % The following line has to be adjusted O-F-T-E-N.
    \override GridPoint.Y-extent = #'(-2 . -21)
  }
  \context {
    \ChoirStaff
    \remove "System_start_delimiter_engraver"
  }
}

staffVoice = \new Staff = astaffvoice  {
  \time 4/4
  \set Staff.instrumentName = "Voice"
  \set Staff.midiInstrument = "voice oohs"
  \key bes \major
  \partial 8*3
  \clef treble
  {
    \context Voice = "melodyVoi"
    {
      <f' bes'>8 <f' a'>8 <d' bes'>8 |
      <g' c''>4 <f' d''> <g' es''> <f' a'> |
      <f' bes'>2 r8
    }
    \bar "|."
  }
}

staffAccordionMel =
\new Staff  \with { \remove "Clef_engraver" } {
  \accidentalStyle forget %Set the accidentals (Vorzeichen) for each note,
  %do not remember them for the rest of the measure.
  \time 4/4
  \set Staff.instrumentName="Accordion"
  \set Staff.midiInstrument="voice oohs"
  \key c \major
  \clef treble
  { \AccordionTab \bar "|." }
}

AltOn =
#(define-music-function (mag) (number?)
  #{ \override Stem.length = #(* 7.0 mag)
      \override NoteHead.font-size =
#(inexact->exact (* (/ 6.0 (log 2.0)) (log mag))) #})

AltOff = {
  \revert Stem.length
  \revert NoteHead.font-size
}

BassRhytm = {s4 s8 | c2 c2 | c2 s8 }
LyricBassRhythmI=  \lyricmode { c b | c }

staffBassRhytm =
\new Staff = staffbass \with { \remove "Clef_engraver" } {
  % This is not a RhythmicStaff  because it must be possible to append lyrics.

  \override Score.GridLine.extra-offset = #'( 13.0 . 0.0 ) % x.y
  \override Staff.StaffSymbol.line-positions = #'( 0 )
  % Shows one horizontal line. The vertical line
  %  (simulating a bar-line) is simulated by a grid
  % Search for 'grid' in this page to find all related functions
  \time 4/4
  {
    \context Voice = "VoiceBassRhytm"
    \stemDown \AltOn #0.6
    \relative c''
    {
      \BassRhytm
    }
    \AltOff
    \bar "|."
  }
}

\score {
  \new ChoirStaff <<
    \harmonies
    \staffVoice
    \context Lyrics = "lmelodyVoi"
      \with { alignBelowContext = astaffvoice }
      \lyricsto melodyVoi \verse
    \staffAccordionMel
    \staffTabLine
    \staffBassRhytm
    \context Lyrics = "lBassRhytmAboveI"
      \with { alignAboveContext = staffbass }
      \lyricsto VoiceBassRhytm \LyricBassRhythmI
  >>
}



% ****************************************************************
% end ly snippet
% ****************************************************************
