#!/usr/bin/python
# -*- coding: utf-8 -*-
# Copyright 2021 Red Hat
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

#############################################
#                WARNING                    #
#############################################
#
# This file is auto generated by the resource
#   module builder playbook.
#
# Do not edit this file manually.
#
# Changes to this file will be over written
#   by the resource module builder.
#
# Changes should be made in the model used to
#   generate this file or in the resource module
#   builder template.
#
#############################################

"""
The module file for junos_snmp_server
"""

from __future__ import absolute_import, division, print_function

__metaclass__ = type

ANSIBLE_METADATA = {
    "metadata_version": "1.1",
    "status": ["preview"],
    "supported_by": "network",
}

DOCUMENTATION = """
---
module: junos_snmp_server
version_added: 2.9.0
short_description: Manage SNMP server configuration on Junos devices.
description: This module manages SNMP server configuration on devices running Junos.
author: Rohit Thakur (@rohitthakur2590)
requirements:
  - ncclient (>=v0.6.4)
  - xmltodict (>=0.12.0)
notes:
  - This module requires the netconf system service be enabled on the device being managed.
  - This module works with connection C(netconf).
  - See L(the Junos OS Platform Options,https://docs.ansible.com/ansible/latest/network/user_guide/platform_junos.html).
  - Tested against JunOS v18.4R1
options:
  running_config:
    description:
    - This option is used only with state I(parsed).
    - The value of this option should be the output received from the Junos device
      by executing the command B(show system snmp).
    - The state I(parsed) reads the configuration from C(running_config) option and
      transforms it into Ansible structured data as per the resource module's argspec
      and the value is then returned in the I(parsed) key within the result.
    type: str
  config:
    description: A dictionary of SNMP server configuration.
    type: dict
    suboptions:
      arp:
        description: Specify JVision arp setting.
        type: dict
        suboptions:
          set:
            description: Set JVision arp.
            type: bool
          host_name_resolution:
            description: Enable host name resolution.
            type: bool
      client_lists:
        description: Specify client list.
        type: list
        elements: dict
        suboptions:
          name:
            description: Specify client list name.
            type: str
          addresses:
            description: Specify list of addresses/prefixes.
            type: list
            elements: dict
            suboptions:
              address:
                description: Specify address or prefix.
                type: str
              restrict:
                description: Deny access.
                type: bool
      routing_instance_access: &routing_instance_access
        description: SNMP routing-instance options.
        type: dict
        suboptions:
          set:
            description: Set routing_instance_access.
            type: bool
          access_lists:
            description: Allow/Deny SNMP access to routing-instances.
            type: list
            elements: str
      communities:
        description: Specify list of community string.
        type: list
        elements: dict
        suboptions:
          name:
            description: Specify name of the community.
            type: str
          authorization:
            description: Specify Authorization type.
            type: str
            choices: ["read-only", "read-write"]
          client_list_name: &client_list_name
            description: Specify the name of client list or prefix list.
            type: str
          clients: &clients
            description: Specify List of source address prefix ranges to accept.
            type: list
            elements: dict
            suboptions:
              address:
                description: Specify address or prefix.
                type: str
              restrict:
                description: Deny access.
                type: bool
          routing_instances: &routing_instances
            description: Use routing-instance name for v1/v2c clients.
            type: list
            elements: dict
            suboptions:
              name:
                description: Specify routing-instances.
                type: str
              client_list_name: *client_list_name
              clients: *clients
          logical_system: &logical_system
            description: Use logical-system name for v1/v2c clients.
            type: list
            elements: str
          view:
            description: Specify view name.
            type: str
      contact:
        description: Specify contact information for administrator.
        type: str
      customization:
         description: Customize SNMP behaviour based on knob.
         type: dict
         suboptions:
           ether_stats_ifd_only:
             description: To stop exposing IFLs as part of etherStatsTable.
             type: bool
      description:
        description: System description.
        type: str
      engine_id:
        description: Specify SNMPv3 engine ID
        type: dict
        suboptions:
          local:
            description: Local engine ID.
            type: str
          use_default_ip_address:
            description: Use default IP address for the engine ID.
            type: bool
          use_mac_address:
            description: Uses management interface MAC Address for the engine ID.
            type: bool
      filter_duplicates:
        description: Filter requests with duplicate source address/port and request ID.
        type: bool
      filter_interfaces:
        description: List of interfaces that needs to be filtered.
        type: dict
        suboptions:
          set:
            description: Set filter-interfaces.
            type: bool
          all_internal_interfaces:
            description: Filter all internal interfaces.
            type: bool
          interfaces:
            description: Specify filter specified interfaces.
            type: list
            elements: str
      health_monitor:
        description: Specify health monitoring configuration.
        type: dict
        suboptions:
          set:
            description: Set health-monitor configuration.
            type: bool
          falling_threshold:
            description: Falling threshold applied to all monitored objects.
            type: int
          rising_threshold:
            description: Rising threshold applied to all monitored objects.
            type: int
          idp:
            description: IDP health monitor configuration.
            type: bool
          interval:
            description: Interval between samples.
            type: int
      if_count_with_filter_interfaces:
         description: Filter interfaces config for ifNumber and ipv6Interfaces.
         type: bool
      interfaces:
        description: Restrict SNMP requests to interfaces.
        type: list
        elements: str
      location:
        description: Specify physical location of system.
        type: str
      logical_system_trap_filter:
        description:  Allow only logical-system specific traps.
        type: bool
      name:
        description: System name override.
        type: str
      nonvolatile:
        description: Configure the handling of nonvolatile SNMP Set requests.
        type: dict
        suboptions:
          commit_delay:
            description: Delay between affirmative SNMP Set reply and start of commit (seconds).
            type: int
      proxies:
        description: SNMP proxy configuration.
        type: list
        elements: dict
        suboptions:
          name:
            description: Specify proxy name.
            type: str
          device_name:
            description: Satellite/Proxied Device name or IP address.
            type: str
          logical_system: *logical_system
          routing_instances: *routing_instances
          version_v1:
            description: Specify For v1 proxy configuration define snmp-community.
            type: dict
            suboptions:
              no_default_comm_to_v3_config:
                description: Specify No default snmp-community and v3 configuration.
                type: bool
              snmp_community:
                description: Specify community name.
                type: str
          version_v2c:
            description: For v2c proxy configuration define snmp-community.
            type: dict
            suboptions:
              no_default_comm_to_v3_config:
                description: Specify No default snmp-community and v3 configuration.
                type: bool
              snmp_community:
                description: Specify community name.
                type: str
          version_v3:
            description: For v3 proxy configuration define security-name.
            type: dict
            suboptions:
              context:
                description: pecify context name associated to this security-name.
                type: bool
              security_name:
                description: Specify v3 security-name.
                type: str
      rmon:
        description: Specify Remote Monitoring configuration.
        type: dict
        suboptions:
          set:
            description: Set Remote monitoring configuration.
            type: bool
          alarms:
            description: RMON alarm entries.
            type: list
            elements: dict
            suboptions:
              id:
                description: Specify alarm ID.
                type: str
              description:
                description:  General description of alarm (stored in alarmOwner).
                type: str
              falling_event_index:
                description: Event triggered after falling threshold is crossed.
                type: int
              falling_threshold:
                description: Specify falling-threshold.
                type: int
              falling_threshold_interval:
                description: Interval between samples during falling-threshold test.
                type: int
              interval:
                description: Interval between samples.
                type: int
              request_type:
                description: Type of SNMP request to issue for alarm.
                type: str
                choices: ["get-next-request", "get-request", "walk-request"]
              rising_event_index:
                description: Event triggered after rising threshold is crossed.
                type: int
              rising_threshold:
                description: The rising threshold.
                type: int
              sample_type:
                description: Method of sampling the selected variable.
                type: str
                choices: ["absolute-value", "delta-value"]
              startup_alarm:
                description: The alarm that may be sent upon entry startup.
                type: str
                choices: ["falling-alarm", "rising-alarm", "rising-or-falling-alarm"]
              syslog_subtag:
                description: Tag to be added to syslog messages.
                type: str
              variable:
                description: OID of MIB variable to be monitored.
                type: str
          events:
            description: RMON event entries.
            type: list
            elements: dict
            suboptions:
              id:
                description: Specify event ID.
                type: int
              community:
                description: The community (trap group) for outgoing traps.
                type: str
              description:
                description: General description of event.
                type: str
              type:
                description: The type of notification for this event.
                type: str
                choices: ["log", "log-and-trap", "none", "snmptrap"]
      subagent:
        description: SNMP subagent configuration.
        type: dict
        suboptions:
          tcp:
            description: Allow SNMP subagent tcp connection.
            type: dict
            suboptions:
              set:
                description: Set SNMP subagent TCP.
                type: bool
              routing_instances_default:
                description: Specify routing-instance name for tcp connection.
                type: bool
      traceoptions:
        description: Configure trace options for SNMP.
        type: dict
        suboptions:
          file:
            description: Specify trace file options.
            type: dict
            suboptions:
              match:
                description: Regular expression for lines to be logged.
                type: str
              files:
                description: Specify maximum number of trace files.
                type: int
              no_world_readable:
                description: Don't allow any user to read the log file.
                type: bool
              world_readable:
                description: Allow any user to read the log file.
                type: bool
              size:
                description: Specify maximum trace file size.
                type: int
          flag:
            description: Specify flag traceoptions.
            type: dict
            suboptions:
              all:
                description: Trace everything.
                type: bool
              general:
                description: Trace general events.
                type: bool
              interface_stats:
                description: Trace interface statistics (logical and physical).
                type: bool
              nonvolatile_sets:
                description: Nonvolatile SNMP set request handling.
                type: bool
              pdu:
                description: Dump SNMP request/response packets.
                type: bool
              protocol_timeouts:
                description: Trace SNMP request timeouts.
                type: bool
              routing_socket:
                description: Trace routing socket calls.
                type: bool
              subagent:
                description: Trace master-agent interations with sub-agents.
                type: bool
              timer:
                description: Trace internal timer events.
                type: bool
              varbind_error:
                description: Trace varbind errors.
                type: bool
          memory_trace:
            description: Memory tracing information.
            type: dict
            suboptions:
              set:
                description: set memory traceoptions.
                type: bool
              size:
                description: Specify Memory size reserved for tracing.
                type: int
          no_remote_trace:
            description: Disable remote tracing.
            type: bool
      trap_groups:
        description: Specify SNMP trap options.
        type: list
        elements: dict
        suboptions:
          name:
            description: Specify trap group name.
            type: str
          categories:
            description: Specify Trap categories.
            type: dict
            suboptions:
              authentication:
                description: Specify Authentication failures.
                type: bool
              chassis:
                description: Specify Chassis or environment notifications.
                type: bool
              chassis_cluster:
                description: Specify Clustering notifications.
                type: bool
              configuration:
                description: Configuration notifications.
                type: bool
              dot3oam_events:
                description: Specify 802.3ah notifications.
                type: bool
              link:
                description: Link up-down transitions.
                type: bool
              otn_alarms:
                description: OTN alarm trap subcategories.
                type: dict
                suboptions:
                  set:
                    description: Set otn_alarms.
                    type: bool
                  oc_lof:
                    description: Loss of frame alarm notifications.
                    type: bool
                  oc_lom:
                    description: Loss of multiframe alarm notification.
                    type: bool
                  oc_los:
                    description: Loss of signal alarm notification.
                    type: bool
                  odu_ais:
                    description: ODU Alarm indication signal alarm notification.
                    type: bool
                  odu_bbe_threshold:
                    description: ODU Background block error threshold alarm notification.
                    type: bool
                  odu_bdi:
                    description: ODU Backward defect indication alarm notification.
                    type: bool
                  odu_bdodu_es_threshold:
                    description: ODU Errored Second threshold alarm notification.
                    type: bool
                  odu_lck:
                    description: ODU Locked alarm notification.
                    type: bool
                  odu_oci:
                    description: ODU Open connection indicator alarm notifications.
                    type: bool
                  odu_rx_aps_change:
                    description: ODU Receive APS change notifications.
                    type: bool
                  odu_sd:
                    description: ODU Signal degrade alarm notifications.
                    type: bool
                  odu_ses_threshold:
                    description: ODU Severely Errored Second threshold alarm notification.
                    type: bool
                  odu_sf:
                    description: ODU Signal fail alarm notification.
                    type: bool
                  odu_ttim:
                    description: ODU Trace identification mismatch alarm notification.
                    type: bool
                  odu_uas_threshold:
                    description: ODU Unavailable Second threshold alarm notification.
                    type: bool
                  opu_ptm:
                    description: ODU Payload Type Mismatch alarm notification.
                    type: bool
                  otu_ais:
                    description: OTU Alarm indication signal alarm notification.
                    type: bool
                  otu_bbe_threshold:
                    description: OTU Background block error threshold alarm notification.
                    type: bool
                  otu_bdi:
                    description: OTU Backward defect indication alarm notification.
                    type: bool
                  otu_es_threshold:
                    description: OTU Errored Second threshold alarm notification.
                    type: bool
                  otu_fec_deg:
                    description: OTU Fec degraded errors alarm notification.
                    type: bool
                  otu_fec_exe:
                    description: OTU Fec excessive errors alarm notification.
                    type: bool
                  otu_iae:
                    description: OTU Incoming alignment error alarm notification.
                    type: bool
                  otu_sd:
                    description: OTU Signal degrade alarm notification.
                    type: bool
                  otu_ses_threshold:
                    description: OTU Severely Errored Second threshold alarm notification.
                    type: bool
                  otu_sf:
                    description: OTU Signal fail alarm notification.
                    type: bool
                  otu_ttim:
                    description: OTU Trace identification mismatch alarm notification.
                    type: bool
                  otu_uas_threshold:
                    description: OTU Unavailable Second threshold alarm notification.
                    type: bool
                  wavelength_lock:
                    description: Wavelength lock alarm notification.
                    type: bool
              remote_operations:
                description: Remote operations.
                type: bool
              rmon_alarm:
                description: RMON rising and falling alarms.
                type: bool
              routing:
                description: Routing protocol notifications.
                type: bool
              services:
                description: Services notifications.
                type: bool
              startup:
                description: System warm and cold starts.
                type: bool
              vrrp_events:
                description: VRRP notifications.
                type: bool
          destination_port:
            description: SNMP trap receiver port number
            type: int
          logical_system: *logical_system
          routing_instance:
            description: Routing instance for trap destination.
            type: str
          targets:
            description: Targets for trap messages
            type: list
            elements: str
          version:
            description: SNMP version.
            type: str
            choices: ["all", "v1", "v2"]
      trap_options:
        description: SNMP trap options.
        type: dict
        suboptions:
          set:
            description: Set trap options.
            type: bool
          agent_address:
            description: Agent address for v1 trap PDUs.
            type: dict
            suboptions:
              outgoing_interface:
                description: Use address on outgoing interfaces.
                type: bool
          context_oid:
            description: Add context oid in varbind of all traps at the end.
            type: bool
          enterprise_oid:
            description: Add snmpTrapEnterprise oid in varbind of all traps.
            type: bool
          logical_system: *logical_system
          routing_instance:
            description: Specify routing-instance.
            type: str
          source_address:
            description: IPv4/IPv6 source address for trap PDUs.
            type: dict
            suboptions:
              address:
                description: Use specified address.
                type: str
              lowest_loopback:
                description: Use lowest address on loopback interfaces.
                type: bool
      snmp_v3:
        description: SNMPv3 configuration information.
        type: dict
        suboptions:
          notify:
            description: Used to select management targets for notifications as well as the type of notifications.
            type: list
            elements: dict
            suboptions:
              name:
                description: Specify notify name.
                type: str
              tag:
                description: Notifications will be sent to all targets configured with this tag.
                type: str
              type:
                description: Notification type.
                type: str
          notify_filter:
            description: Filters to apply to SNMP notifications.
            type: list
            elements: dict
            suboptions:
              name:
                description: Specify notify filter name.
                type: str
              oids:
                description: OID to include/exclude from notify filter.
                type: list
                elements: dict
                suboptions:
                  oid:
                    description: Specify OID.
                    type: str
                  exclude:
                    description: Exclude this OID from the notify filtered.
                    type: bool
                  include:
                    description: Include this OID in the notify filter.
                    type: bool
          snmp_community:
            description: SNMP community and view-based access control model configuration.
            type: list
            elements: dict
            suboptions:
              community_index:
                description: Unique index value in this community table entry.
                type: str
              security_name:
                description: Security name used when performing access control.
                type: str
              community_name:
                description: SNMPv1/v2c community name (default is same as community-index).
                type: str
              context:
                description: Context used when performing access control.
                type: str
              tag:
                description: Tag identifier for set of targets allowed to use this community string.
                type: str
          target_addresses:
            description: Identifies notification targets as well as allowed management stations.
            type: list
            elements: dict
            suboptions:
              name:
                description: SNMP target address name.
                type: str
              address:
                description: SNMP target address.
                type: str
              address_mask:
                description: Mask range of addresses for community string access control.
                type: str
              logical_system:
                description: Logical-system name for trap destination.
                type: str
              port:
                description: SNMP target port number.
                type: int
              retry_count:
                description: Maximum retry count for confirmed SNMP notifications.
                type: int
              routing_instance:
                description: Routing instance for trap destination.
                type: str
              tag_list:
                description: SNMP tag list used to select target addresses.
                type: str
              target_parameters:
                description: SNMPv3 target parameter name in the target parameters table.
                type: str
              timeout:
                description: Acknowledgment timeout for confirmed SNMP notifications (seconds).
                type: int
          target_parameters:
            description: SNMPv3 target parameter name in the target parameters table.
            type: list
            elements: dict
            suboptions:
              name:
                description: SNMPv3 target parameters name.
                type: str
              notify_filter:
                description: Notify filter with filter name to apply to notifications.
                type: str
              parameters:
                description: Parameters used when sending notifications.
                type: dict
                suboptions:
                  message_processing_model:
                    description: The message processing model to be used when generating SNMP notifications.
                    type: str
                    choices: ["v1", "v2c", "v3"]
                  security_level:
                    description: Security-level used when generating SNMP notifications.
                    type: str
                    choices: ["authentication", "none", "privacy"]
                  security_model:
                    description: Security-model used when generating SNMP notifications.
                    type: str
                    choices: ["usm", "v1", "v2c"]
                  security_name:
                    description: Security name used when generating SNMP notifications.
                    type: str
          usm:
            description: User-based security model (USM) information.
            type: dict
            suboptions:
              local_engine:
                description: Local engine user configuration.
                type: dict
                suboptions:
                  users: &users
                    description: SNMPv3 USM user information.
                    type: list
                    elements: dict
                    suboptions:
                      name:
                        description: User name.
                        type: str
                      authentication_md5:
                        description: Configure MD5 authentication.
                        type: dict
                        suboptions:
                          key:
                            description: Encrypted key used for user authentication.
                            type: str
                          password:
                            description: User's authentication password
                            type: str
                      authentication_none:
                        description: Set no authentication for the user.
                        type: bool
                      authentication_sha:
                        description: Configure SHA authentication.
                        type: dict
                        suboptions:
                          key:
                            description: Encrypted key used for user authentication.
                            type: str
                          password:
                            description: User's authentication password
                            type: str
                      privacy_3des:
                        description: Configure Triple DES privacy.
                        type: dict
                        suboptions:
                          key:
                            description: Encrypted key used for user privacy.
                            type: str
                          password:
                            description: User's privacy password
                            type: str
                      privacy_aes128:
                        description: Configure AES128 privacy.
                        type: dict
                        suboptions:
                          key:
                            description: Encrypted key used for user privacy.
                            type: str
                          password:
                            description: User's privacy password
                            type: str
                      privacy_des:
                        description: Configure DES privacy.
                        type: dict
                        suboptions:
                          key:
                            description: Encrypted key used for user privacy.
                            type: str
                          password:
                            description: User's privacy password
                            type: str
                      privacy_none:
                        description: Set no privacy for the user.
                        type: bool
              remote_engine:
                description: Remote engine user configuration.
                type: list
                elements: dict
                suboptions:
                  id:
                    description:  Remote engine id.
                    type: str
                  users: *users
      views:
        description: Define MIB views.
        type: list
        elements: dict
        suboptions:
          name:
            description: MIB view name.
            type: str
          oids:
            description: OID include/exclude list
            type: list
            elements: dict
            suboptions:
              oid:
                description: OID to include or exclude from view.
                type: str
              exclude:
                description: Exclude this OID from the view.
                type: bool
              include:
                description: Include this OID from the view.
                type: bool
  state:
    description:
    - The state the configuration should be left in.
    - Refer to examples for more details.
    type: str
    choices:
    - merged
    - replaced
    - deleted
    - overridden
    - parsed
    - gathered
    - rendered
    default: merged
"""
EXAMPLES = """
# Using merged
#
# Before state
# ------------
#
# vagrant@vsrx# show routing-instances
# clv1 {
#     description clv1;
# }
# clv2 {
#     description clv2;
# }
- name: Merge provided SNMP configuration into running configuration.
  junipernetworks.junos.junos_snmp_server:
    config:
      arp:
        set: true
        host_name_resolution: true
      client_lists:   # ATTR-----2
         - name: cl1
           addresses:
             - address: "192.16.1.0/24"
             - address: "192.16.2.0/24"
             - address: "11.11.11.11"
               restrict: true
         - name: cl2
           addresses:
             - address: "192.16.4.0/24"
      routing_instance_access:  # ATTR-----3
        set: true
        access_lists:
          - "clv1"
          - "clv2"
    state: merged
#
# -------------------------
# Module Execution Result
# -------------------------
#     "after": {
#         "arp": {
#             "host_name_resolution": true
#         },
#         "client_lists": [
#             {
#                 "addresses": [
#                     {
#                         "address": "192.16.1.0/24"
#                     },
#                     {
#                         "address": "192.16.2.0/24"
#                     },
#                     {
#                         "address": "11.11.11.11/32",
#                         "restrict": true
#                     }
#                 ],
#                 "name": "cl1"
#             },
#             {
#                 "addresses": [
#                     {
#                         "address": "192.16.4.0/24"
#                     }
#                 ],
#                 "name": "cl2"
#             }
#         ],
#         "routing_instance_access": {
#             "access_lists": [
#                 "clv1",
#                 "clv2"
#             ]
#         }
#     },
#     "before": {},
#     "changed": true,
#     "commands": [
#           "<nc:snmp xmlns:nc=\"urn:ietf:params:xml:ns:netconf:base:1.0\">"
#           "<nc:arp><nc:host-name-resolution/></nc:arp><nc:client-list><nc:name>cl1</nc:name>"
#           "<nc:client-address-list><nc:name>192.16.1.0/24</nc:name></nc:client-address-list>"
#           "<nc:client-address-list><nc:name>192.16.2.0/24</nc:name></nc:client-address-list><nc:client-address-list>"
#           "<nc:name>11.11.11.11</nc:name><nc:restrict/></nc:client-address-list></nc:client-list><nc:client-list>"
#           "<nc:name>cl2</nc:name><nc:client-address-list><nc:name>192.16.4.0/24</nc:name></nc:client-address-list>"
#           "</nc:client-list><nc:routing-instance-access><nc:access-list><nc:name>clv1</nc:name></nc:access-list>"
#           "<nc:access-list><nc:name>clv2</nc:name></nc:access-list></nc:routing-instance-access></nc:snmp>"
#     ]
# After state
# -----------
#
# vagrant@vsrx# show snmp
# client-list cl1 {
#     192.16.1.0/24;
#     192.16.2.0/24;
#     11.11.11.11/32 {
#         restrict;
#     }
# }
# client-list cl2 {
#     192.16.4.0/24;
# }
# routing-instance-access {
#     access-list {
#         clv1;
#         clv2;
#     }
# }
# arp {
#     host-name-resolution;
# }
# vagrant@vsrx# show routing-instances
# clv1 {
#     description clv1;
# }
# clv2 {
#     description clv2;
# }
#
# Using Replaced
# Before state
# ------------
#
# vagrant@vsrx# show snmp
# client-list cl1 {
#     192.16.1.0/24;
#     192.16.2.0/24;
#     11.11.11.11/32 {
#         restrict;
#     }
# }
# client-list cl2 {
#     192.16.4.0/24;
# }
# routing-instance-access {
#     access-list {
#         clv1;
#         clv2;
#     }
# }
# arp {
#     host-name-resolution;
# }
# vagrant@vsrx# show routing-instances
# clv1 {
#     description clv1;
# }
# clv2 {
#     description clv2;
# }

- name: Replaced running SNMP server configuration with provided configuration
  junipernetworks.junos.junos_snmp_server:
    config:
      contact: "ansiblesupport11@redhat.com"
      customization:
        ether_stats_ifd_only: True
      description: "Local SNMP Server"
      engine_id:
        local: "local1"
        use_default_ip_address: True
        use_mac_address: True
      filter_duplicates: True
      filter_interfaces:
        set: True
        all_internal_interfaces: True
        interfaces:
          - "eth1"
          - "eth2"
    state: replaced
#
# -------------------------
# Module Execution Result
# -------------------------
#     "after": {
#         "contact": "ansiblesupport11@redhat.com",
#         "customization": {
#             "ether_stats_ifd_only": true
#         },
#         "description": "Local SNMP Server",
#         "engine_id": {
#             "use_mac_address": true
#         },
#         "filter_duplicates": true,
#         "filter_interfaces": {
#             "all_internal_interfaces": true,
#             "interfaces": [
#                 "eth1",
#                 "eth2"
#             ]
#         }
#     },
#     "before":
#      {
#         "arp": {
#             "host_name_resolution": true
#         },
#         "client_lists": [
#             {
#                 "addresses": [
#                     {
#                         "address": "192.16.1.0/24"
#                     },
#                     {
#                         "address": "192.16.2.0/24"
#                     },
#                     {
#                         "address": "11.11.11.11/32",
#                         "restrict": true
#                     }
#                 ],
#                 "name": "cl1"
#             },
#             {
#                 "addresses": [
#                     {
#                         "address": "192.16.4.0/24"
#                     }
#                 ],
#                 "name": "cl2"
#             }
#         ],
#         "routing_instance_access": {
#             "access_lists": [
#                 "clv1",
#                 "clv2"
#             ]
#         }
#     },
#     "changed": true,
#     "commands": [
#         "<nc:snmp xmlns:nc=\"urn:ietf:params:xml:ns:netconf:base:1.0\"/>",
#         "<nc:snmp xmlns:nc=\"urn:ietf:params:xml:ns:netconf:base:1.0\" delete=\"delete\"/>",
#         "<nc:snmp xmlns:nc=\"urn:ietf:params:xml:ns:netconf:base:1.0\">"
#         "<nc:contact>ansiblesupport11@redhat.com</nc:contact><nc:customization>"
#         "<nc:ether-stats-ifd-only/></nc:customization><nc:description>Local SNMP Server</nc:description>"
#         "<nc:engine-id><nc:local>local1</nc:local><nc:use-default-ip-address/><nc:use-mac-address/>"
#         "</nc:engine-id><nc:filter-duplicates/><nc:filter-interfaces><nc:all-internal-interfaces/><nc:interfaces>"
#         "<nc:name>eth1</nc:name></nc:interfaces><nc:interfaces><nc:name>eth2</nc:name></nc:interfaces>"
#         "</nc:filter-interfaces></nc:snmp>"
#     ]
# After state
# -----------
#
# vagrant@vsrx# show routing-instances
# clv1 {
#     description clv1;
# }
# clv2 {
#     description clv2;
# }
# vagrant@vsrx# show snmp
# description "Local SNMP Server";
# contact "ansiblesupport11@redhat.com";
# filter-interfaces {
#     interfaces {
#         eth1;
#         eth2;
#     }
#     all-internal-interfaces;
# }
# filter-duplicates;
# engine-id {
#     use-mac-address;
# }
# customization {
#     ether-stats-ifd-only;
# }

# Using overridden
#
# Before state
# ------------
#
# vagrant@vsrx# show snmp
# client-list cl1 {
#     192.16.1.0/24;
#     192.16.2.0/24;
#     11.11.11.11/32 {
#         restrict;
#     }
# }
# client-list cl2 {
#     192.16.4.0/24;
# }
# routing-instance-access {
#     access-list {
#         clv1;
#         clv2;
#     }
# }
# arp {
#     host-name-resolution;
# }
# vagrant@vsrx# show routing-instances
# clv1 {
#     description clv1;
# }
# clv2 {
#     description clv2;
# }
- name: Override running SNMP server configuration with provided configuration
  junipernetworks.junos.junos_snmp_server:
    config:
      contact: "ansiblesupport11@redhat.com"
      customization:
        ether_stats_ifd_only: True
      description: "Local SNMP Server"
      engine_id:
        local: "local1"
        use_default_ip_address: True
        use_mac_address: True
      filter_duplicates: True
      filter_interfaces:
        set: True
        all_internal_interfaces: True
        interfaces:
          - "eth1"
          - "eth2"
    state:  overridden
#
# -------------------------
# Module Execution Result
# -------------------------
#     "after": {
#         "contact": "ansiblesupport11@redhat.com",
#         "customization": {
#             "ether_stats_ifd_only": true
#         },
#         "description": "Local SNMP Server",
#         "engine_id": {
#             "use_mac_address": true
#         },
#         "filter_duplicates": true,
#         "filter_interfaces": {
#             "all_internal_interfaces": true,
#             "interfaces": [
#                 "eth1",
#                 "eth2"
#             ]
#         }
#     },
#     "before":
#      {
#         "arp": {
#             "host_name_resolution": true
#         },
#         "client_lists": [
#             {
#                 "addresses": [
#                     {
#                         "address": "192.16.1.0/24"
#                     },
#                     {
#                         "address": "192.16.2.0/24"
#                     },
#                     {
#                         "address": "11.11.11.11/32",
#                         "restrict": true
#                     }
#                 ],
#                 "name": "cl1"
#             },
#             {
#                 "addresses": [
#                     {
#                         "address": "192.16.4.0/24"
#                     }
#                 ],
#                 "name": "cl2"
#             }
#         ],
#         "routing_instance_access": {
#             "access_lists": [
#                 "clv1",
#                 "clv2"
#             ]
#         }
#     },
#     "changed": true,
#     "commands": [
#         "<nc:snmp xmlns:nc=\"urn:ietf:params:xml:ns:netconf:base:1.0\"/>",
#         "<nc:snmp xmlns:nc=\"urn:ietf:params:xml:ns:netconf:base:1.0\" delete=\"delete\"/>",
#         "<nc:snmp xmlns:nc=\"urn:ietf:params:xml:ns:netconf:base:1.0\">"
#         "<nc:contact>ansiblesupport11@redhat.com</nc:contact><nc:customization>"
#         "<nc:ether-stats-ifd-only/></nc:customization><nc:description>Local SNMP Server</nc:description>"
#         "<nc:engine-id><nc:local>local1</nc:local><nc:use-default-ip-address/><nc:use-mac-address/>"
#         "</nc:engine-id><nc:filter-duplicates/><nc:filter-interfaces><nc:all-internal-interfaces/><nc:interfaces>"
#         "<nc:name>eth1</nc:name></nc:interfaces><nc:interfaces><nc:name>eth2</nc:name></nc:interfaces>"
#         "</nc:filter-interfaces></nc:snmp>"
#     ]
# After state
# -----------
#
# vagrant@vsrx# show routing-instances
# clv1 {
#     description clv1;
# }
# clv2 {
#     description clv2;
# }
# vagrant@vsrx# show snmp
# description "Local SNMP Server";
# contact "ansiblesupport11@redhat.com";
# filter-interfaces {
#     interfaces {
#         eth1;
#         eth2;
#     }
#     all-internal-interfaces;
# }
# filter-duplicates;
# engine-id {
#     use-mac-address;
# }
# customization {
#     ether-stats-ifd-only;
# }
#
# Using deleted
#
# Before state
# ------------
#
# vagrant@vsrx# show routing-instances
# clv1 {
#     description clv1;
# }
# clv2 {
#     description clv2;
# }
# vagrant@vsrx# show snmp
# description "Local SNMP Server";
# contact "ansiblesupport11@redhat.com";
# filter-interfaces {
#     interfaces {
#         eth1;
#         eth2;
#     }
#     all-internal-interfaces;
# }
# filter-duplicates;
# engine-id {
#     use-mac-address;
# }
# customization {
#     ether-stats-ifd-only;
# }
#
- name: Delete running SNMP server configuration
  junipernetworks.junos.junos_snmp_server:
    config:
    state: deleted
#
# -------------------------
# Module Execution Result
# -------------------------
#     "after": {},
#     "before": {
#         "contact": "ansiblesupport11@redhat.com",
#         "customization": {
#             "ether_stats_ifd_only": true
#         },
#         "description": "Local SNMP Server",
#         "engine_id": {
#             "use_mac_address": true
#         },
#         "filter_duplicates": true,
#         "filter_interfaces": {
#             "all_internal_interfaces": true,
#             "interfaces": [
#                 "eth1",
#                 "eth2"
#             ]
#         }
#     },
#     "changed": true,
#     "commands": [
#               "<nc:snmp xmlns:nc=\"urn:ietf:params:xml:ns:netconf:base:1.0\"/>",
#               "<nc:snmp xmlns:nc=\"urn:ietf:params:xml:ns:netconf:base:1.0\" delete=\"delete\"/>"
#     ]
# After state
# -----------
#
# vagrant@vsrx# show routing-instances
# clv1 {
#     description clv1;
# }
# clv2 {
#     description clv2;
# }
# vagrant@vsrx# show snmp
# description "Local SNMP Server";
# contact "ansiblesupport11@redhat.com";
# filter-interfaces {
#     interfaces {
#         eth1;
#         eth2;
#     }
#     all-internal-interfaces;
# }
# filter-duplicates;
# engine-id {
#     use-mac-address;
# }
# customization {
#     ether-stats-ifd-only;
# }
#
- name: Gather running SNMP server configuration
  junipernetworks.junos.junos_snmp_server:
    state: gathered
#
# -------------------------
# Module Execution Result
# -------------------------
#     "gathered": {
#         "contact": "ansiblesupport11@redhat.com",
#         "customization": {
#             "ether_stats_ifd_only": true
#         },
#         "description": "Local SNMP Server",
#         "engine_id": {
#             "use_mac_address": true
#         },
#         "filter_duplicates": true,
#         "filter_interfaces": {
#             "all_internal_interfaces": true,
#             "interfaces": [
#                 "eth1",
#                 "eth2"
#             ]
#         }
#     },
#     "changed": false,
# Using rendered
#
# Before state
# ------------
#
- name: Render xml for provided facts.
  junipernetworks.junos.junos_snmp_server:
    config:
      arp:
        set: true
        host_name_resolution: true
      routing_instance_access:  # ATTR-----3
        set: true
        access_lists:
          - "clv1"
          - "clv2"
    state: rendered
#
# -------------------------
# Module Execution Result
# -------------------------
#     "rendered": [
#           "<nc:snmp xmlns:nc=\"urn:ietf:params:xml:ns:netconf:base:1.0\">"
#           "<nc:arp><nc:host-name-resolution/></nc:arp><nc:routing-instance-access>"
#           "<nc:access-list><nc:name>clv1</nc:name></nc:access-list><nc:access-list><nc:name>clv2</nc:name>"
#           "</nc:access-list></nc:routing-instance-access></nc:snmp>"
#     ]
#
# Using parsed
# parsed.cfg
# ------------
# <?xml version="1.0" encoding="UTF-8"?>
# <rpc-reply message-id="urn:uuid:0cadb4e8-5bba-47f4-986e-72906227007f">
#     <configuration changed-seconds="1590139550" changed-localtime="2020-05-22 09:25:50 UTC">
#         <version>18.4R1-S2.4</version>
#         <system xmlns="http://yang.juniper.net/junos-es/conf/system">
#            <snmp>
#         <client-list>
#             <name>cl1</name>
#             <client-address-list>
#                 <name>192.16.1.0/24</name>
#             </client-address-list>
#             <client-address-list>
#                 <name>192.16.2.0/24</name>
#             </client-address-list>
#             <client-address-list>
#                 <name>11.11.11.11/32</name>
#                 <restrict/>
#             </client-address-list>
#         </client-list>
#         <client-list>
#             <name>cl2</name>
#             <client-address-list>
#                 <name>192.16.4.0/24</name>
#             </client-address-list>
#         </client-list>
#         <routing-instance-access>
#             <access-list>
#                 <name>clv1</name>
#             </access-list>
#             <access-list>
#                 <name>clv2</name>
#             </access-list>
#         </routing-instance-access>
#         <arp>
#             <host-name-resolution/>
#         </arp>
#     </snmp>
#     </system>
#     </configuration>
# </rpc-reply>
#
- name: Parse SNMP server running config
  junipernetworks.junos.junos_snmp_server:
    running_config: "{{ lookup('file', './parsed.cfg') }}"
    state: parsed
#
#
# -------------------------
# Module Execution Result
# -------------------------
#
#
# "parsed":  {
#         "arp": {
#             "host_name_resolution": true
#         },
#         "client_lists": [
#             {
#                 "addresses": [
#                     {
#                         "address": "192.16.1.0/24"
#                     },
#                     {
#                         "address": "192.16.2.0/24"
#                     },
#                     {
#                         "address": "11.11.11.11/32",
#                         "restrict": true
#                     }
#                 ],
#                 "name": "cl1"
#             },
#             {
#                 "addresses": [
#                     {
#                         "address": "192.16.4.0/24"
#                     }
#                 ],
#                 "name": "cl2"
#             }
#         ],
#         "routing_instance_access": {
#             "access_lists": [
#                 "clv1",
#                 "clv2"
#             ]
#         }
#     }
#
#
"""
RETURN = """
before:
  description: The configuration prior to the model invocation.
  returned: always
  sample: >
    The configuration returned will always be in the same format
     of the parameters above.
  type: dict
after:
  description: The resulting configuration model invocation.
  returned: when changed
  sample: >
    The configuration returned will always be in the same format
     of the parameters above.
  type: dict
commands:
  description: The set of commands pushed to the remote device.
  returned: always
  type: list
  sample: ['<nc:arp><nc:host-name-resolution/></nc:arp><nc:routing-instance-access>"',
           '<nc:snmp xmlns:nc=\"urn:ietf:params:xml:ns:netconf:base:1.0\">']
"""


from ansible.module_utils.basic import AnsibleModule
from ansible_collections.junipernetworks.junos.plugins.module_utils.network.junos.argspec.snmp_server.snmp_server import (
    Snmp_serverArgs,
)
from ansible_collections.junipernetworks.junos.plugins.module_utils.network.junos.config.snmp_server.snmp_server import (
    Snmp_server,
)


def main():
    """
    Main entry point for module execution

    :returns: the result form module invocation
    """
    required_if = [
        ("state", "merged", ("config",)),
        ("state", "replaced", ("config",)),
        ("state", "overridden", ("config",)),
        ("state", "rendered", ("config",)),
        ("state", "parsed", ("running_config",)),
    ]
    module = AnsibleModule(
        argument_spec=Snmp_serverArgs.argument_spec,
        required_if=required_if,
        supports_check_mode=True,
    )

    result = Snmp_server(module).execute_module()
    module.exit_json(**result)


if __name__ == "__main__":
    main()
