/*
 * Decompiled with CFR 0.152.
 */
package javolution;

import javolution.Javolution;
import javolution.context.ObjectFactory;
import javolution.context.PoolContext;
import javolution.context.RealtimeObject;
import javolution.lang.MathLib;

final class PerfContext
extends Javolution
implements Runnable {
    Object[] _objects = new Object[1000];
    private static final ObjectFactory CHAR256_FACTORY = new ObjectFactory(){

        public Object create() {
            return new char[256];
        }
    };
    private static final ObjectFactory CHAR512_FACTORY = new ObjectFactory(){

        public Object create() {
            return new char[512];
        }
    };

    PerfContext() {
    }

    public void run() {
        PerfContext.println("//////////////////////////////////");
        PerfContext.println("// Package: javolution.context //");
        PerfContext.println("//////////////////////////////////");
        PerfContext.println("");
        PerfContext.setOutputStream(null);
        this.benchmarkSmallObjects();
        PerfContext.setOutputStream(System.out);
        this.benchmarkSmallObjects();
        PerfContext.setOutputStream(null);
        this.benchmarkHeapArrays();
        PerfContext.setOutputStream(System.out);
        this.benchmarkHeapArrays();
        PerfContext.setOutputStream(null);
        this.benchmarkStackArrays();
        PerfContext.setOutputStream(System.out);
        this.benchmarkStackArrays();
        PerfContext.println("");
    }

    private void benchmarkSmallObjects() {
        int n;
        int n2;
        PerfContext.println("-- Heap versus Stack Allocation (Pool-Context) --");
        PerfContext.print("Small object heap creation: ");
        PerfContext.startTime();
        for (n2 = 0; n2 < 10000; ++n2) {
            n = 0;
            while (n < this._objects.length) {
                this._objects[n++] = new SmallObject();
            }
            this.preventCompilerCodeRemoval();
        }
        PerfContext.println(PerfContext.endTime(10000 * this._objects.length));
        PerfContext.print("Small object stack creation: ");
        PerfContext.startTime();
        for (n2 = 0; n2 < 10000; ++n2) {
            PoolContext.enter();
            n = 0;
            while (n < this._objects.length) {
                this._objects[n++] = SmallObject.FACTORY.object();
            }
            PoolContext.exit();
            this.preventCompilerCodeRemoval();
        }
        PerfContext.println(PerfContext.endTime(10000 * this._objects.length));
    }

    private void benchmarkHeapArrays() {
        int n;
        int n2;
        PerfContext.print("char[256] heap creation: ");
        PerfContext.startTime();
        for (n2 = 0; n2 < 1000; ++n2) {
            n = 0;
            while (n < this._objects.length) {
                this._objects[n++] = new char[256];
            }
            this.preventCompilerCodeRemoval();
        }
        PerfContext.println(PerfContext.endTime(1000 * this._objects.length));
        PerfContext.print("char[512] heap creation: ");
        PerfContext.startTime();
        for (n2 = 0; n2 < 1000; ++n2) {
            n = 0;
            while (n < this._objects.length) {
                this._objects[n++] = new char[512];
            }
            this.preventCompilerCodeRemoval();
        }
        PerfContext.println(PerfContext.endTime(1000 * this._objects.length));
    }

    private void benchmarkStackArrays() {
        int n;
        int n2;
        PerfContext.print("char[256] stack creation: ");
        PerfContext.startTime();
        for (n2 = 0; n2 < 1000; ++n2) {
            PoolContext.enter();
            n = 0;
            while (n < this._objects.length) {
                this._objects[n++] = CHAR256_FACTORY.object();
            }
            PoolContext.exit();
            this.preventCompilerCodeRemoval();
        }
        PerfContext.println(PerfContext.endTime(1000 * this._objects.length));
        PerfContext.print("char[512] stack creation: ");
        PerfContext.startTime();
        for (n2 = 0; n2 < 1000; ++n2) {
            PoolContext.enter();
            n = 0;
            while (n < this._objects.length) {
                this._objects[n++] = CHAR512_FACTORY.object();
            }
            PoolContext.exit();
            this.preventCompilerCodeRemoval();
        }
        PerfContext.println(PerfContext.endTime(1000 * this._objects.length));
    }

    private void preventCompilerCodeRemoval() {
        if (this._objects[MathLib.random(0, this._objects.length - 1)] == null) {
            throw new Error();
        }
    }

    private static final class SmallObject
    extends RealtimeObject {
        long longValue;
        int intValue;
        SmallObject refValue;
        static final RealtimeObject.Factory FACTORY = new RealtimeObject.Factory(){

            public Object create() {
                return new SmallObject();
            }
        };

        private SmallObject() {
        }
    }
}

