/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileItem;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.util.RandomChoice;
import net.sf.freecol.common.util.RandomUtils;
import net.sf.freecol.common.util.StringUtils;

public class LostCityRumour
extends TileItem {
    private static final Logger logger = Logger.getLogger(LostCityRumour.class.getName());
    private static final int MAYAN_PROPHESY_YEAR = 2012;
    private static int rumourNothing = -1;
    private RumourType type = null;
    private String name = null;
    private static final String NAME_TAG = "name";
    private static final String TILE_TAG = "tile";
    private static final String TYPE_TAG = "type";

    public LostCityRumour(Game game, Tile tile) {
        super(game, tile);
    }

    public LostCityRumour(Game game, Tile tile, RumourType type, String name) {
        super(game, tile);
        this.type = type;
        this.name = name;
    }

    public LostCityRumour(Game game, String id) {
        super(game, id);
    }

    public final RumourType getType() {
        return this.type;
    }

    public final void setType(RumourType newType) {
        this.type = newType;
    }

    public final String getName() {
        return this.name;
    }

    public void setTile(Tile tile) {
        this.tile = tile;
    }

    public RumourType chooseType(Unit unit, Random random) {
        Specification spec = this.getSpecification();
        Tile tile = this.getTile();
        boolean allowLearn = unit != null && !unit.getType().getUnitTypesLearntInLostCity().isEmpty();
        int percentBad = spec.getInteger("model.option.badRumour");
        int percentGood = spec.getInteger("model.option.goodRumour");
        if (unit != null) {
            float mod = unit.applyModifiers(1.0f, this.getGame().getTurn(), "model.modifier.exploreLostCityRumour");
            percentBad = Math.round((float)percentBad * mod);
            percentGood = Math.round((float)percentGood * mod);
        }
        if (unit != null && unit.getOwner().hasAbility("model.ability.rumoursAlwaysPositive")) {
            percentBad = 0;
            percentGood = 100;
        }
        int percentNeutral = Math.max(0, 100 - percentBad - percentGood);
        ArrayList c = new ArrayList();
        if (allowLearn) {
            c.add(new RandomChoice<RumourType>(RumourType.LEARN, 30 * percentGood));
            c.add(new RandomChoice<RumourType>(RumourType.TRIBAL_CHIEF, 30 * percentGood));
            c.add(new RandomChoice<RumourType>(RumourType.COLONIST, 20 * percentGood));
        } else {
            c.add(new RandomChoice<RumourType>(RumourType.TRIBAL_CHIEF, 50 * percentGood));
            c.add(new RandomChoice<RumourType>(RumourType.COLONIST, 30 * percentGood));
        }
        if (unit == null || unit.getOwner().getPlayerType() == Player.PlayerType.COLONIAL) {
            c.add(new RandomChoice<RumourType>(RumourType.FOUNTAIN_OF_YOUTH, 2 * percentGood));
        }
        c.add(new RandomChoice<RumourType>(RumourType.MOUNDS, 8 * percentGood));
        c.add(new RandomChoice<RumourType>(RumourType.RUINS, 6 * percentGood));
        c.add(new RandomChoice<RumourType>(RumourType.CIBOLA, 4 * percentGood));
        if (tile.getOwner() != null && tile.getOwner().isIndian()) {
            c.add(new RandomChoice<RumourType>(RumourType.BURIAL_GROUND, 25 * percentBad));
            c.add(new RandomChoice<RumourType>(RumourType.EXPEDITION_VANISHES, 75 * percentBad));
        } else {
            c.add(new RandomChoice<RumourType>(RumourType.EXPEDITION_VANISHES, 100 * percentBad));
        }
        c.add(new RandomChoice<RumourType>(RumourType.NOTHING, 100 * percentNeutral));
        return (RumourType)((Object)RandomChoice.getWeightedRandom(logger, "Choose rumour", c, random));
    }

    public ModelMessage getNothingMessage(Player player, boolean mounds, Random random) {
        int i;
        Game game = this.getGame();
        if (game.getTurn().getYear() % 100 == 12 && RandomUtils.randomInt(logger, "Mayans?", random, 4) == 0) {
            int years = 2012 - game.getTurn().getYear();
            return new ModelMessage(ModelMessage.MessageType.LOST_CITY_RUMOUR, "model.lostCityRumour.nothing.mayans", player).addAmount("%years%", years);
        }
        if (mounds) {
            return new ModelMessage(ModelMessage.MessageType.LOST_CITY_RUMOUR, "model.lostCityRumour.nothing.mounds", player);
        }
        if (rumourNothing < 0) {
            String key;
            i = 0;
            while (Messages.containsKey(key = Messages.descriptionKey("model.lostCityRumour.nothing." + i))) {
                ++i;
            }
            rumourNothing = i;
        }
        i = RandomUtils.randomInt(logger, "Nothing rumour", random, rumourNothing);
        return new ModelMessage(ModelMessage.MessageType.LOST_CITY_RUMOUR, Messages.descriptionKey("model.lostCityRumour.nothing." + i), player);
    }

    @Override
    public String getNameKey() {
        return Messages.nameKey("model.lostCityRumour");
    }

    @Override
    public final int getZIndex() {
        return 500;
    }

    @Override
    public boolean isTileTypeAllowed(TileType tileType) {
        return !tileType.isWater();
    }

    @Override
    public int applyBonus(GoodsType goodsType, UnitType unitType, int potential) {
        return potential;
    }

    @Override
    public boolean canProduce(GoodsType goodsType, UnitType unitType) {
        return false;
    }

    @Override
    public List<Modifier> getProductionModifiers(GoodsType goodsType, UnitType unitType) {
        return Collections.emptyList();
    }

    @Override
    public boolean isNatural() {
        return false;
    }

    @Override
    public boolean isComplete() {
        return true;
    }

    @Override
    public int checkIntegrity(boolean fix) {
        return this.type == RumourType.NO_SUCH_RUMOUR ? -1 : 1;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(TILE_TAG, this.getTile());
        if (this.type != null) {
            xw.writeAttribute(TYPE_TAG, this.getType());
        }
        if (this.name != null) {
            xw.writeAttribute(NAME_TAG, this.name);
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.tile = xr.findFreeColGameObject(this.getGame(), TILE_TAG, Tile.class, null, false);
        this.type = xr.getAttribute(TYPE_TAG, RumourType.class, null);
        this.name = xr.getAttribute(NAME_TAG, null);
    }

    @Override
    public String getXMLTagName() {
        return LostCityRumour.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "lostCityRumour";
    }

    public static enum RumourType {
        NO_SUCH_RUMOUR,
        BURIAL_GROUND,
        EXPEDITION_VANISHES,
        NOTHING,
        LEARN,
        TRIBAL_CHIEF,
        COLONIST,
        MOUNDS,
        RUINS,
        CIBOLA,
        FOUNTAIN_OF_YOUTH;


        private String getKey() {
            return "lostCityRumour." + StringUtils.getEnumKey(this);
        }

        public String getDescriptionKey() {
            return Messages.descriptionKey("model." + this.getKey());
        }

        public String getAlternateDescriptionKey(String variant) {
            return Messages.descriptionKey("model." + this.getKey() + "." + variant);
        }
    }
}

