/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.calculation;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.calculation.Calculation;
import ca.odell.glazedlists.calculation.Count;
import ca.odell.glazedlists.calculation.Division;
import ca.odell.glazedlists.calculation.Sum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Calculations {
    private Calculations() {
    }

    public static Calculation<Integer> count(EventList elements) {
        return new Count(elements);
    }

    public static Calculation<Float> sumFloats(EventList<? extends Number> numbers) {
        return new Sum.SumFloat<Number>(numbers);
    }

    public static Calculation<Double> sumDoubles(EventList<? extends Number> numbers) {
        return new Sum.SumDouble<Number>(numbers);
    }

    public static Calculation<Integer> sumIntegers(EventList<? extends Number> numbers) {
        return new Sum.SumInteger<Number>(numbers);
    }

    public static Calculation<Long> sumLongs(EventList<? extends Number> numbers) {
        return new Sum.SumLong<Number>(numbers);
    }

    public static Calculation<Float> divideFloats(Calculation<? extends Number> numerator, Calculation<? extends Number> denominator) {
        return new Division.DivisionFloat(numerator, denominator);
    }

    public static Calculation<Double> divideDoubles(Calculation<? extends Number> numerator, Calculation<? extends Number> denominator) {
        return new Division.DivisionDouble(numerator, denominator);
    }

    public static Calculation<Float> meanFloats(EventList<? extends Number> numbers) {
        return Calculations.divideFloats(Calculations.sumFloats(numbers), Calculations.count(numbers));
    }

    public static Calculation<Double> meanDoubles(EventList<? extends Number> numbers) {
        return Calculations.divideDoubles(Calculations.sumDoubles(numbers), Calculations.count(numbers));
    }
}

