/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.swt;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.swt.GlazedListsSWT;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Combo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventComboViewer<E>
implements ListEventListener<E> {
    private Combo combo = null;
    private TransformedList<E, E> swtSource = null;
    private ILabelProvider labelProvider = null;

    public EventComboViewer(EventList<E> source, Combo combo) {
        this(source, combo, (ILabelProvider)new LabelProvider());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventComboViewer(EventList<E> source, Combo combo, ILabelProvider labelProvider) {
        source.getReadWriteLock().readLock().lock();
        try {
            this.swtSource = GlazedListsSWT.swtThreadProxyList(source, combo.getDisplay());
            this.combo = combo;
            this.labelProvider = labelProvider;
            int n = source.size();
            for (int i = 0; i < n; ++i) {
                this.addRow(i, source.get(i));
            }
            this.swtSource.addListEventListener(this);
        }
        finally {
            source.getReadWriteLock().readLock().unlock();
        }
    }

    public Combo getCombo() {
        return this.combo;
    }

    private void addRow(int row, Object value) {
        this.combo.add(this.labelProvider.getText(value), row);
    }

    private void updateRow(int row, Object value) {
        this.combo.setItem(row, this.labelProvider.getText(value));
    }

    private void deleteRow(int row) {
        this.combo.remove(row);
    }

    @Override
    public void listChanged(ListEvent listChanges) {
        while (listChanges.next()) {
            int changeIndex = listChanges.getIndex();
            int changeType = listChanges.getType();
            if (changeType == 2) {
                this.addRow(changeIndex, this.swtSource.get(changeIndex));
                continue;
            }
            if (changeType == 1) {
                this.updateRow(changeIndex, this.swtSource.get(changeIndex));
                continue;
            }
            if (changeType != 0) continue;
            this.deleteRow(changeIndex);
        }
    }

    public void dispose() {
        this.swtSource.removeListEventListener(this);
        this.swtSource.dispose();
    }
}

