/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup.layers;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.net.UnknownServiceException;
import org.netbeans.core.startup.layers.NbinstURLMapper;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class NbinstURLStreamHandlerFactory
implements URLStreamHandlerFactory {
    public URLStreamHandler createURLStreamHandler(String string) {
        if ("nbinst".equals(string)) {
            return new NbinstURLStreamHandler();
        }
        return null;
    }

    private static class NbinstURLConnection
    extends URLConnection {
        private FileObject fo;
        private InputStream iStream;

        public NbinstURLConnection(URL uRL) {
            super(uRL);
        }

        public void connect() throws IOException {
            if (this.fo == null) {
                FileObject[] fileObjectArray = NbinstURLMapper.decodeURL(this.url);
                if (fileObjectArray != null && fileObjectArray.length > 0) {
                    this.fo = fileObjectArray[0];
                } else {
                    throw new FileNotFoundException("Cannot find: " + this.url);
                }
            }
            if (this.fo.isFolder()) {
                throw new UnknownServiceException();
            }
        }

        public int getContentLength() {
            try {
                this.connect();
                return (int)this.fo.getSize();
            }
            catch (IOException iOException) {
                return -1;
            }
        }

        public InputStream getInputStream() throws IOException {
            this.connect();
            if (this.iStream == null) {
                this.iStream = this.fo.getInputStream();
            }
            return this.iStream;
        }

        public String getHeaderField(String string) {
            if ("content-type".equals(string)) {
                try {
                    this.connect();
                    return this.fo.getMIMEType();
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
            return super.getHeaderField(string);
        }
    }

    private static class NbinstURLStreamHandler
    extends URLStreamHandler {
        private NbinstURLStreamHandler() {
        }

        protected URLConnection openConnection(URL uRL) throws IOException {
            return new NbinstURLConnection(uRL);
        }
    }
}

