/*
 * Decompiled with CFR 0.152.
 */
package tr.prefs.recurrence;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.miginfocom.swing.MigLayout;
import org.openide.util.NbBundle;
import tr.prefs.recurrence.RecurrenceOptionsPanelController;
import tr.prefs.recurrence.RecurrencePrefs;

final class RecurrencePanel
extends JPanel {
    private final RecurrenceOptionsPanelController controller;
    private ChangeListener changeListener = new ChangeListener(){

        public void stateChanged(ChangeEvent evt) {
            RecurrencePanel.this.controller.changed();
        }
    };
    private JLabel dayLabel;
    private JSpinner dayField;
    private JLabel headingLabel;
    private JLabel monthLabel;
    private JSpinner monthField;
    private JLabel weekLabel;
    private JSpinner weekField;
    private JLabel weekdayLabel;
    private JSpinner weekdayField;
    private JLabel yearLabel;
    private JSpinner yearField;

    RecurrencePanel(RecurrenceOptionsPanelController controller) {
        this.controller = controller;
        this.initComponents();
        this.add((Component)this.getView(), "Center");
    }

    private JComponent getView() {
        this.headingLabel = new JLabel(this.getMsg("nbr.future"));
        this.headingLabel.setFont(this.headingLabel.getFont().deriveFont(1));
        this.weekdayLabel = new JLabel(this.getMsg("nbr.future.weekday"));
        this.weekdayField = new JSpinner();
        this.weekdayField.addChangeListener(this.changeListener);
        this.dayLabel = new JLabel(this.getMsg("nbr.future.day"));
        this.dayField = new JSpinner();
        this.dayField.addChangeListener(this.changeListener);
        this.weekLabel = new JLabel(this.getMsg("nbr.future.week"));
        this.weekField = new JSpinner();
        this.weekField.addChangeListener(this.changeListener);
        this.monthLabel = new JLabel(this.getMsg("nbr.future.month"));
        this.monthField = new JSpinner();
        this.monthField.addChangeListener(this.changeListener);
        this.yearLabel = new JLabel(this.getMsg("nbr.future.year"));
        this.yearField = new JSpinner();
        this.yearField.addChangeListener(this.changeListener);
        JPanel panel = new JPanel((LayoutManager)new MigLayout("", "0[]2[]2[]2[]2[]2[]0", "0[]2[]2[]0"));
        panel.add((Component)this.headingLabel, "align left, span, wrap");
        panel.add((Component)this.weekdayLabel, "align right, gapleft 12");
        panel.add((Component)this.weekdayField, "align left, w 60!");
        panel.add((Component)this.dayLabel, "align right, gapleft 12");
        panel.add((Component)this.dayField, "align left, w 60!");
        panel.add((Component)this.weekLabel, "align right, gapleft 12");
        panel.add((Component)this.weekField, "align left, w 60!, wrap");
        panel.add((Component)this.monthLabel, "align right, gapleft 12");
        panel.add((Component)this.monthField, "align left, w 60!");
        panel.add((Component)this.yearLabel, "align right, gapleft 12");
        panel.add((Component)this.yearField, "align left, w 60!, wrap");
        JScrollPane scrollPane = new JScrollPane(panel);
        scrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        return scrollPane;
    }

    private String getMsg(String key) {
        return NbBundle.getMessage(this.getClass(), (String)key);
    }

    void load() {
        this.weekdayField.setValue(RecurrencePrefs.getNbrFutureWeekday());
        this.dayField.setValue(RecurrencePrefs.getNbrFutureDay());
        this.weekField.setValue(RecurrencePrefs.getNbrFutureWeek());
        this.monthField.setValue(RecurrencePrefs.getNbrFutureMonth());
        this.yearField.setValue(RecurrencePrefs.getNbrFutureYear());
    }

    void store() {
        RecurrencePrefs.setNbrFutureWeekday((Integer)this.weekdayField.getValue());
        RecurrencePrefs.setNbrFutureDay((Integer)this.dayField.getValue());
        RecurrencePrefs.setNbrFutureWeek((Integer)this.weekField.getValue());
        RecurrencePrefs.setNbrFutureMonth((Integer)this.monthField.getValue());
        RecurrencePrefs.setNbrFutureYear((Integer)this.yearField.getValue());
    }

    boolean valid() {
        return true;
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }
}

