/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.tree.matcher.matchers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import java.util.List;
import java.util.Stack;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.exception.JsonQueryTypeException;
import net.thisptr.jackson.jq.internal.misc.Functional;
import net.thisptr.jackson.jq.internal.misc.Pair;
import net.thisptr.jackson.jq.internal.tree.matcher.PatternMatcher;

public class ArrayMatcher
implements PatternMatcher {
    private List<PatternMatcher> matchers;

    public ArrayMatcher(List<PatternMatcher> matchers) {
        this.matchers = matchers;
    }

    private void recursive(Scope scope, JsonNode in, Functional.Consumer<List<Pair<String, JsonNode>>> out, Stack<Pair<String, JsonNode>> accumulate, int index) throws JsonQueryException {
        if (index >= this.matchers.size()) {
            out.accept(accumulate);
            return;
        }
        PatternMatcher matcher = this.matchers.get(index);
        JsonNode value = in.get(index);
        matcher.match(scope, (JsonNode)(value != null ? value : NullNode.getInstance()), match -> this.recursive(scope, in, out, accumulate, index + 1), accumulate);
    }

    @Override
    public void match(Scope scope, JsonNode in, Functional.Consumer<List<Pair<String, JsonNode>>> out, Stack<Pair<String, JsonNode>> accumulate) throws JsonQueryException {
        if (!in.isArray() && !in.isNull()) {
            throw JsonQueryTypeException.format("Cannot index %s with number", in.getNodeType());
        }
        this.recursive(scope, in, out, accumulate, 0);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        String sep = "";
        for (PatternMatcher matcher : this.matchers) {
            sb.append(sep);
            sb.append(matcher);
            sep = ", ";
        }
        sb.append("]");
        return sb.toString();
    }
}

