/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.ltr.norm;

import java.util.LinkedHashMap;
import org.apache.solr.ltr.norm.Normalizer;
import org.apache.solr.ltr.norm.NormalizerException;

public class MinMaxNormalizer
extends Normalizer {
    private float min = Float.NEGATIVE_INFINITY;
    private float max = Float.POSITIVE_INFINITY;
    private float delta = this.max - this.min;

    private void updateDelta() {
        this.delta = this.max - this.min;
    }

    public float getMin() {
        return this.min;
    }

    public void setMin(float min) {
        this.min = min;
        this.updateDelta();
    }

    public void setMin(String min) {
        this.min = Float.parseFloat(min);
        this.updateDelta();
    }

    public float getMax() {
        return this.max;
    }

    public void setMax(float max) {
        this.max = max;
        this.updateDelta();
    }

    public void setMax(String max) {
        this.max = Float.parseFloat(max);
        this.updateDelta();
    }

    @Override
    protected void validate() throws NormalizerException {
        if (this.delta == 0.0f) {
            throw new NormalizerException("MinMax Normalizer delta must not be zero | min = " + this.min + ",max = " + this.max + ",delta = " + this.delta);
        }
    }

    @Override
    public float normalize(float value) {
        return (value - this.min) / this.delta;
    }

    @Override
    public LinkedHashMap<String, Object> paramsToMap() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>(2, 1.0f);
        params.put("min", Float.toString(this.min));
        params.put("max", Float.toString(this.max));
        return params;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append(this.getClass().getSimpleName()).append('(');
        sb.append("min=").append(this.min);
        sb.append(",max=").append(this.max).append(')');
        return sb.toString();
    }
}

