/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.languagemodel;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import opennlp.tools.cmdline.BasicCmdLineTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.PerformanceMonitor;
import opennlp.tools.cmdline.SystemInputStreamFactory;
import opennlp.tools.languagemodel.NGramLanguageModel;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.PlainTextByLineStream;

public class NGramLanguageModelTool
extends BasicCmdLineTool {
    @Override
    public String getShortDescription() {
        return "gives the probability and most probable next token(s) of a sequence of tokens in a language model";
    }

    @Override
    public void run(String[] args) {
        File lmFile = new File(args[0]);
        try (FileInputStream stream = new FileInputStream(lmFile);){
            NGramLanguageModel nGramLanguageModel = new NGramLanguageModel(stream);
            PerformanceMonitor perfMon = null;
            try {
                String line;
                PlainTextByLineStream lineStream = new PlainTextByLineStream((InputStreamFactory)new SystemInputStreamFactory(), SystemInputStreamFactory.encoding());
                perfMon = new PerformanceMonitor(System.err, "nglm");
                perfMon.start();
                while ((line = (String)lineStream.read()) != null) {
                    Object[] predicted;
                    double probability;
                    Object[] tokens = line.split(" ");
                    try {
                        probability = nGramLanguageModel.calculateProbability((String[])tokens);
                        predicted = nGramLanguageModel.predictNextTokens((String[])tokens);
                    }
                    catch (Exception e) {
                        System.err.println("Error:" + e.getLocalizedMessage());
                        System.err.println(line);
                        continue;
                    }
                    System.out.println(Arrays.toString(tokens) + " -> prob:" + probability + ", next:" + Arrays.toString(predicted));
                    perfMon.incrementCounter();
                }
            }
            catch (IOException e) {
                CmdLineUtil.handleStdinIoError(e);
            }
            perfMon.stopAndPrintFinalResult();
        }
        catch (IOException e) {
            System.err.println(e.getLocalizedMessage());
        }
    }

    @Override
    public String getHelp() {
        return "Usage: opennlp " + this.getName() + " model";
    }
}

