/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.opentracingshim;

import io.opentelemetry.opentracingshim.BaseShimObject;
import io.opentelemetry.opentracingshim.NoopSpanBuilderShim;
import io.opentelemetry.opentracingshim.Propagation;
import io.opentelemetry.opentracingshim.ScopeManagerShim;
import io.opentelemetry.opentracingshim.ShimUtil;
import io.opentelemetry.opentracingshim.SpanBuilderShim;
import io.opentelemetry.opentracingshim.SpanContextShim;
import io.opentelemetry.opentracingshim.TelemetryInfo;
import io.opentracing.Scope;
import io.opentracing.ScopeManager;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMapExtract;
import io.opentracing.propagation.TextMapInject;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

final class TracerShim
extends BaseShimObject
implements Tracer {
    private static final Logger logger = Logger.getLogger(TracerShim.class.getName());
    private final ScopeManager scopeManagerShim;
    private final Propagation propagation;
    private volatile boolean isClosed;

    TracerShim(TelemetryInfo telemetryInfo) {
        super(telemetryInfo);
        this.scopeManagerShim = new ScopeManagerShim(telemetryInfo);
        this.propagation = new Propagation(telemetryInfo);
    }

    public ScopeManager scopeManager() {
        return this.scopeManagerShim;
    }

    public Span activeSpan() {
        return this.scopeManagerShim.activeSpan();
    }

    public Scope activateSpan(Span span) {
        return this.scopeManagerShim.activate(span);
    }

    public Tracer.SpanBuilder buildSpan(String operationName) {
        if (this.isClosed) {
            return new NoopSpanBuilderShim(this.telemetryInfo(), operationName);
        }
        return new SpanBuilderShim(this.telemetryInfo, operationName);
    }

    public <C> void inject(SpanContext context, Format<C> format, C carrier) {
        if (context == null) {
            logger.log(Level.INFO, "Cannot inject a null span context.");
            return;
        }
        SpanContextShim contextShim = ShimUtil.getContextShim(context);
        if (contextShim == null) {
            return;
        }
        if (format == Format.Builtin.TEXT_MAP || format == Format.Builtin.TEXT_MAP_INJECT || format == Format.Builtin.HTTP_HEADERS) {
            this.propagation.injectTextMap(contextShim, format, (TextMapInject)carrier);
        }
    }

    @Nullable
    public <C> SpanContext extract(Format<C> format, C carrier) {
        try {
            if (format == Format.Builtin.TEXT_MAP || format == Format.Builtin.TEXT_MAP_EXTRACT || format == Format.Builtin.HTTP_HEADERS) {
                return this.propagation.extractTextMap(format, (TextMapExtract)carrier);
            }
        }
        catch (RuntimeException e) {
            logger.log(Level.INFO, "Exception caught while extracting span context; returning null. Exception: [{0}] Message: [{1}]", new String[]{e.getClass().getName(), e.getMessage()});
        }
        return null;
    }

    public void close() {
        this.isClosed = true;
    }
}

