/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import java.util.HashMap;
import java.util.Locale;
import javax.inject.Inject;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.cloud.overseer.SliceMutator;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.admin.CollectionsHandler;
import org.apache.solr.handler.admin.api.AdminAPIBase;
import org.apache.solr.jersey.JacksonReflectMapWriter;
import org.apache.solr.jersey.PermissionName;
import org.apache.solr.jersey.SolrJerseyResponse;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.PermissionNameProvider;

@Path(value="/collections/{collName}/shards/{shardName}/replicas/{replicaName}/properties/{propName}")
public class AddReplicaPropertyAPI
extends AdminAPIBase {
    @Inject
    public AddReplicaPropertyAPI(CoreContainer coreContainer, SolrQueryRequest solrQueryRequest, SolrQueryResponse solrQueryResponse) {
        super(coreContainer, solrQueryRequest, solrQueryResponse);
    }

    @PUT
    @Produces(value={"application/json", "application/xml", "application/vnd.apache.solr.javabin"})
    @PermissionName(value=PermissionNameProvider.Name.COLL_EDIT_PERM)
    public SolrJerseyResponse addReplicaProperty(@Parameter(description="The name of the collection the replica belongs to.", required=true) @PathParam(value="collName") String collName, @Parameter(description="The name of the shard the replica belongs to.", required=true) @PathParam(value="shardName") String shardName, @Parameter(description="The replica, e.g., `core_node1`.", required=true) @PathParam(value="replicaName") String replicaName, @Parameter(description="The name of the property to add.", required=true) @PathParam(value="propName") String propertyName, @RequestBody(description="The value of the replica property to create or update", required=true) AddReplicaPropertyRequestBody requestBody) throws Exception {
        SolrJerseyResponse response = this.instantiateJerseyResponse(SolrJerseyResponse.class);
        CoreContainer coreContainer = this.fetchAndValidateZooKeeperAwareCoreContainer();
        AddReplicaPropertyAPI.recordCollectionForLogAndTracing(collName, this.solrQueryRequest);
        ZkNodeProps remoteMessage = this.createRemoteMessage(collName, shardName, replicaName, propertyName, requestBody);
        SolrResponse remoteResponse = CollectionsHandler.submitCollectionApiCommand(coreContainer, coreContainer.getDistributedCollectionCommandRunner(), remoteMessage, CollectionParams.CollectionAction.ADDREPLICAPROP, CollectionsHandler.DEFAULT_COLLECTION_OP_TIMEOUT);
        if (remoteResponse.getException() != null) {
            throw remoteResponse.getException();
        }
        this.disableResponseCaching();
        return response;
    }

    public ZkNodeProps createRemoteMessage(String collName, String shardName, String replicaName, String propertyName, AddReplicaPropertyRequestBody requestBody) {
        boolean uniquePerSlice;
        HashMap<String, Object> remoteMessage = new HashMap<String, Object>();
        remoteMessage.put("collection", collName);
        remoteMessage.put("property", propertyName);
        remoteMessage.put("shard", shardName);
        remoteMessage.put("replica", replicaName);
        remoteMessage.put("property.value", requestBody.value);
        remoteMessage.put("operation", CollectionParams.CollectionAction.ADDREPLICAPROP.toLower());
        if (requestBody.shardUnique != null) {
            remoteMessage.put("shardUnique", requestBody.shardUnique);
        }
        String prefixedPropertyName = "property." + propertyName;
        boolean bl = uniquePerSlice = requestBody.shardUnique == null ? false : requestBody.shardUnique;
        if (requestBody.shardUnique != null && SliceMutator.SLICE_UNIQUE_BOOLEAN_PROPERTIES.contains(prefixedPropertyName.toLowerCase(Locale.ROOT)) && !uniquePerSlice) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Overseer replica property command received for property " + prefixedPropertyName + " with the shardUnique parameter set to something other than 'true'. No action taken.");
        }
        return new ZkNodeProps(remoteMessage);
    }

    public static class AddReplicaPropertyRequestBody
    implements JacksonReflectMapWriter {
        @Schema(description="The value to assign to the property.", required=true)
        @JsonProperty(value="value")
        public String value;
        @Schema(description="If `true`, then setting this property in one replica will remove the property from all other replicas in that shard. The default is `false`.\\nThere is one pre-defined property `preferredLeader` for which `shardUnique` is forced to `true` and an error returned if `shardUnique` is explicitly set to `false`.", defaultValue="false")
        @JsonProperty(value="shardUnique")
        public Boolean shardUnique;

        public AddReplicaPropertyRequestBody() {
        }

        public AddReplicaPropertyRequestBody(String value) {
            this.value = value;
        }
    }
}

