/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.analysis.core.KeywordTokenizerFactory;
import org.apache.lucene.analysis.custom.CustomAnalyzer;
import org.apache.lucene.analysis.pattern.PatternReplaceFilterFactory;
import org.apache.lucene.util.ResourceLoader;
import org.apache.solr.analysis.TokenizerChain;
import org.apache.solr.common.SolrException;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SortableTextField;

public class NestPathField
extends SortableTextField {
    @Override
    public void setArgs(IndexSchema schema, Map<String, String> args) {
        CustomAnalyzer customAnalyzer;
        args.putIfAbsent("stored", "false");
        args.putIfAbsent("multiValued", "false");
        args.putIfAbsent("omitTermFreqAndPositions", "true");
        args.putIfAbsent("omitNorms", "true");
        args.putIfAbsent("maxCharsForDocValues", "-1");
        super.setArgs(schema, args);
        try {
            customAnalyzer = CustomAnalyzer.builder((ResourceLoader)schema.getResourceLoader()).withDefaultMatchVersion(schema.getDefaultLuceneMatchVersion()).withTokenizer(KeywordTokenizerFactory.class, new String[0]).addTokenFilter(PatternReplaceFilterFactory.class, new String[]{"pattern", "#\\d*", "replace", "all"}).build();
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
        this.setIndexAnalyzer(new TokenizerChain(customAnalyzer));
    }
}

