/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.FixedBitSet;
import org.apache.solr.search.BitDocSet;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.SortedIntDocSet;

public abstract class DocSet
implements Accountable,
Cloneable {
    DocSet() {
        assert (this instanceof BitDocSet || this instanceof SortedIntDocSet);
    }

    public static DocSet empty() {
        return EmptyLazyHolder.INSTANCE;
    }

    public abstract int size();

    public abstract boolean exists(int var1);

    public abstract DocIterator iterator();

    public abstract DocIdSetIterator iterator(LeafReaderContext var1);

    public abstract DocSet intersection(DocSet var1);

    public abstract int intersectionSize(DocSet var1);

    public abstract boolean intersects(DocSet var1);

    public abstract DocSet union(DocSet var1);

    public int unionSize(DocSet other) {
        return this.size() + other.size() - this.intersectionSize(other);
    }

    public abstract DocSet andNot(DocSet var1);

    public int andNotSize(DocSet other) {
        return this.size() - this.intersectionSize(other);
    }

    public abstract Query makeQuery();

    public abstract void addAllTo(FixedBitSet var1);

    public abstract DocSet clone();

    public abstract Bits getBits();

    protected abstract FixedBitSet getFixedBitSet();

    protected abstract FixedBitSet getFixedBitSetClone();

    private static class EmptyLazyHolder {
        static final DocSet INSTANCE = new SortedIntDocSet(new int[0]);

        private EmptyLazyHolder() {
        }
    }
}

