/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.similarities;

import org.apache.lucene.search.similarities.BM25Similarity;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.schema.SimilarityFactory;

public class BM25SimilarityFactory
extends SimilarityFactory {
    private BM25Similarity similarity;

    @Override
    public void init(SolrParams params) {
        super.init(params);
        boolean discountOverlaps = params.getBool("discountOverlaps", true);
        float k1 = params.getFloat("k1", 1.2f);
        float b = params.getFloat("b", 0.75f);
        this.similarity = new BM25Similarity(k1, b, discountOverlaps);
    }

    @Override
    public Similarity getSimilarity() {
        return this.similarity;
    }
}

