/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.Terms;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.util.BitUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.SuppressForbidden;
import org.apache.solr.index.SlowCompositeReaderWrapper;
import org.apache.solr.legacy.LegacyNumericUtils;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.update.TimedVersionBucket;
import org.apache.solr.update.UpdateLog;
import org.apache.solr.update.VersionBucket;
import org.apache.solr.util.RefCounted;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionInfo {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String SYS_PROP_BUCKET_VERSION_LOCK_TIMEOUT_MS = "bucketVersionLockTimeoutMs";
    private final UpdateLog ulog;
    private final VersionBucket[] buckets;
    private SchemaField versionField;
    final ReadWriteLock lock = new ReentrantReadWriteLock(true);
    private int versionBucketLockTimeoutMs;
    private long vclock;
    private final Object clockSync = new Object();

    public static SchemaField getAndCheckVersionField(IndexSchema schema) throws SolrException {
        String errPrefix = "_version_ field must exist in schema and be searchable (indexed or docValues) and retrievable(stored or docValues) and not multiValued";
        SchemaField sf = schema.getFieldOrNull("_version_");
        if (null == sf) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "_version_ field must exist in schema and be searchable (indexed or docValues) and retrievable(stored or docValues) and not multiValued (_version_ does not exist)");
        }
        if (!sf.indexed() && !sf.hasDocValues()) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "_version_ field must exist in schema and be searchable (indexed or docValues) and retrievable(stored or docValues) and not multiValued (_version_ not searchable");
        }
        if (!sf.stored() && !sf.hasDocValues()) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "_version_ field must exist in schema and be searchable (indexed or docValues) and retrievable(stored or docValues) and not multiValued (_version_ not retrievable");
        }
        if (sf.multiValued()) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "_version_ field must exist in schema and be searchable (indexed or docValues) and retrievable(stored or docValues) and not multiValued (_version_ is multiValued");
        }
        return sf;
    }

    public VersionInfo(UpdateLog ulog, int nBuckets) {
        this.ulog = ulog;
        IndexSchema schema = ulog.uhandler.core.getLatestSchema();
        this.versionField = VersionInfo.getAndCheckVersionField(schema);
        this.versionBucketLockTimeoutMs = ulog.uhandler.core.getSolrConfig().get("updateHandler").get("versionBucketLockTimeoutMs").intVal(Integer.parseInt(System.getProperty(SYS_PROP_BUCKET_VERSION_LOCK_TIMEOUT_MS, "0")));
        this.buckets = new VersionBucket[BitUtil.nextHighestPowerOfTwo((int)nBuckets)];
        for (int i = 0; i < this.buckets.length; ++i) {
            this.buckets[i] = this.versionBucketLockTimeoutMs > 0 ? new TimedVersionBucket() : new VersionBucket();
        }
    }

    public int getVersionBucketLockTimeoutMs() {
        return this.versionBucketLockTimeoutMs;
    }

    public void reload() {
    }

    public SchemaField getVersionField() {
        return this.versionField;
    }

    public void lockForUpdate() {
        this.lock.readLock().lock();
    }

    public void unlockForUpdate() {
        this.lock.readLock().unlock();
    }

    public void blockUpdates() {
        this.lock.writeLock().lock();
    }

    public void unblockUpdates() {
        this.lock.writeLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressForbidden(reason="need currentTimeMillis just for getting realistic version stamps, does not assume monotonicity")
    public long getNewClock() {
        Object object = this.clockSync;
        synchronized (object) {
            long time = System.currentTimeMillis();
            long result = time << 20;
            if (result <= this.vclock) {
                result = this.vclock + 1L;
            }
            this.vclock = result;
            return this.vclock;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getOldClock() {
        Object object = this.clockSync;
        synchronized (object) {
            return this.vclock;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateClock(long clock) {
        Object object = this.clockSync;
        synchronized (object) {
            this.vclock = Math.max(this.vclock, clock);
        }
    }

    public VersionBucket bucket(int hash) {
        int slot = hash & this.buckets.length - 1;
        return this.buckets[slot];
    }

    public Long lookupVersion(BytesRef idBytes) {
        return this.ulog.lookupVersion(idBytes);
    }

    public Long getVersionFromIndex(BytesRef idBytes) {
        RefCounted<SolrIndexSearcher> newestSearcher = this.ulog.uhandler.core.getRealtimeSearcher();
        try {
            SolrIndexSearcher searcher = newestSearcher.get();
            long lookup = searcher.lookupId(idBytes);
            if (lookup < 0L) {
                Long l = null;
                return l;
            }
            ValueSource vs = this.versionField.getType().getValueSource(this.versionField, null);
            Map context = ValueSource.newContext((IndexSearcher)searcher);
            vs.createWeight(context, (IndexSearcher)searcher);
            FunctionValues fv = vs.getValues(context, (LeafReaderContext)searcher.getTopReaderContext().leaves().get((int)(lookup >> 32)));
            long ver = fv.longVal((int)lookup);
            Long l = ver;
            return l;
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error reading version from index", (Throwable)e);
        }
        finally {
            if (newestSearcher != null) {
                newestSearcher.decref();
            }
        }
    }

    public Long getMaxVersionFromIndex(IndexSearcher searcher) throws IOException {
        String versionFieldName = this.versionField.getName();
        log.debug("Refreshing highest value of {} for {} version buckets from index", (Object)versionFieldName, (Object)this.buckets.length);
        if (this.versionField.indexed()) {
            if (this.versionField.getType().isPointField()) {
                return this.getMaxVersionFromIndexedPoints(searcher);
            }
            return this.getMaxVersionFromIndexedTerms(searcher);
        }
        long maxVersionInIndex = 0L;
        ValueSource vs = this.versionField.getType().getValueSource(this.versionField, null);
        Map funcContext = ValueSource.newContext((IndexSearcher)searcher);
        vs.createWeight(funcContext, searcher);
        for (LeafReaderContext ctx : searcher.getTopReaderContext().leaves()) {
            int maxDoc = ctx.reader().maxDoc();
            FunctionValues fv = vs.getValues(funcContext, ctx);
            for (int doc = 0; doc < maxDoc; ++doc) {
                long v = fv.longVal(doc);
                maxVersionInIndex = Math.max(v, maxVersionInIndex);
            }
        }
        return maxVersionInIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void seedBucketsWithHighestVersion(long highestVersion) {
        for (int i = 0; i < this.buckets.length; ++i) {
            VersionBucket versionBucket = this.buckets[i];
            synchronized (versionBucket) {
                if (this.buckets[i].highest < highestVersion) {
                    this.buckets[i].highest = highestVersion;
                }
                continue;
            }
        }
    }

    private long getMaxVersionFromIndexedTerms(IndexSearcher searcher) throws IOException {
        Long max;
        assert (!this.versionField.getType().isPointField());
        String versionFieldName = this.versionField.getName();
        LeafReader leafReader = SlowCompositeReaderWrapper.wrap(searcher.getIndexReader());
        Terms versionTerms = leafReader.terms(versionFieldName);
        Long l = max = versionTerms != null ? LegacyNumericUtils.getMaxLong(versionTerms) : null;
        if (null != max) {
            log.debug("Found MAX value {} from Terms for {} in index", (Object)max, (Object)versionFieldName);
            return max;
        }
        return 0L;
    }

    private long getMaxVersionFromIndexedPoints(IndexSearcher searcher) throws IOException {
        assert (this.versionField.getType().isPointField());
        String versionFieldName = this.versionField.getName();
        byte[] maxBytes = PointValues.getMaxPackedValue((IndexReader)searcher.getIndexReader(), (String)versionFieldName);
        if (null == maxBytes) {
            return 0L;
        }
        Object maxObj = this.versionField.getType().toObject(this.versionField, new BytesRef(maxBytes));
        if (null == maxObj || !(maxObj instanceof Number)) {
            log.error("Unable to convert MAX byte[] from Points for {} in index", (Object)versionFieldName);
            return 0L;
        }
        long max = ((Number)maxObj).longValue();
        log.debug("Found MAX value {} from Points for {} in index", (Object)max, (Object)versionFieldName);
        return max;
    }
}

