/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.tools;

import java.nio.ByteBuffer;
import org.mp4parser.IsoFile;
import org.mp4parser.MemoryAllocationException;
import org.mp4parser.tools.CastUtils;

public class MemoryUtils {
    public static ByteBuffer allocateByteBuffer(long lengthLong, long max) throws MemoryAllocationException {
        long localMax;
        if (lengthLong < 0L) {
            throw new IllegalArgumentException("Length must be >= 0");
        }
        long l = localMax = IsoFile.MAX_RECORD_SIZE_OVERRIDE > -1L ? IsoFile.MAX_RECORD_SIZE_OVERRIDE : max;
        if (lengthLong > localMax) {
            throw new MemoryAllocationException(lengthLong, localMax);
        }
        int length = CastUtils.l2i(lengthLong);
        return ByteBuffer.allocate(length);
    }

    public static byte[] allocateByteArray(long lengthLong, long max) throws MemoryAllocationException {
        long localMax;
        if (lengthLong < 0L) {
            throw new IllegalArgumentException("Length must be >=0");
        }
        long l = localMax = IsoFile.MAX_RECORD_SIZE_OVERRIDE > -1L ? IsoFile.MAX_RECORD_SIZE_OVERRIDE : max;
        if (lengthLong > localMax) {
            throw new MemoryAllocationException(lengthLong, localMax);
        }
        int length = CastUtils.l2i(lengthLong);
        return new byte[length];
    }
}

