/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.request;

import java.util.Arrays;
import java.util.TreeSet;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.NoOpResponseParser;
import org.apache.solr.client.solrj.response.DelegationTokenResponse;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;

public abstract class DelegationTokenRequest<Q extends DelegationTokenRequest<Q, R>, R extends DelegationTokenResponse>
extends SolrRequest<R> {
    protected static final String OP_KEY = "op";
    protected static final String TOKEN_KEY = "token";

    public DelegationTokenRequest(SolrRequest.METHOD m) {
        super(m, "/admin/collections");
    }

    protected abstract Q getThis();

    @Override
    protected abstract R createResponse(SolrClient var1);

    public static class Cancel
    extends DelegationTokenRequest<Cancel, DelegationTokenResponse.Cancel> {
        protected String token;

        public Cancel(String token) {
            super(SolrRequest.METHOD.PUT);
            this.token = token;
            this.setResponseParser(new NoOpResponseParser());
            this.setQueryParams(new TreeSet<String>(Arrays.asList(DelegationTokenRequest.OP_KEY, DelegationTokenRequest.TOKEN_KEY)));
        }

        @Override
        protected Cancel getThis() {
            return this;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.set(DelegationTokenRequest.OP_KEY, "CANCELDELEGATIONTOKEN");
            params.set(DelegationTokenRequest.TOKEN_KEY, this.token);
            return params;
        }

        @Override
        public DelegationTokenResponse.Cancel createResponse(SolrClient client) {
            return new DelegationTokenResponse.Cancel();
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }
    }

    public static class Renew
    extends DelegationTokenRequest<Renew, DelegationTokenResponse.Renew> {
        protected String token;

        @Override
        protected Renew getThis() {
            return this;
        }

        public Renew(String token) {
            super(SolrRequest.METHOD.PUT);
            this.token = token;
            this.setResponseParser(new DelegationTokenResponse.JsonMapResponseParser());
            this.setQueryParams(new TreeSet<String>(Arrays.asList(DelegationTokenRequest.OP_KEY, DelegationTokenRequest.TOKEN_KEY)));
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.set(DelegationTokenRequest.OP_KEY, "RENEWDELEGATIONTOKEN");
            params.set(DelegationTokenRequest.TOKEN_KEY, this.token);
            return params;
        }

        @Override
        public DelegationTokenResponse.Renew createResponse(SolrClient client) {
            return new DelegationTokenResponse.Renew();
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }
    }

    public static class Get
    extends DelegationTokenRequest<Get, DelegationTokenResponse.Get> {
        protected String renewer;

        public Get() {
            this((String)null);
        }

        public Get(String renewer) {
            super(SolrRequest.METHOD.GET);
            this.renewer = renewer;
            this.setResponseParser(new DelegationTokenResponse.JsonMapResponseParser());
            this.setQueryParams(new TreeSet<String>(Arrays.asList(DelegationTokenRequest.OP_KEY)));
        }

        @Override
        protected Get getThis() {
            return this;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.set(DelegationTokenRequest.OP_KEY, "GETDELEGATIONTOKEN");
            if (this.renewer != null) {
                params.set("renewer", this.renewer);
            }
            return params;
        }

        @Override
        public DelegationTokenResponse.Get createResponse(SolrClient client) {
            return new DelegationTokenResponse.Get();
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }
    }
}

