/*
 * Decompiled with CFR 0.152.
 */
package org.gagravarr.theora;

import org.gagravarr.ogg.HighLevelOggStreamPacket;
import org.gagravarr.ogg.IOUtils;
import org.gagravarr.ogg.OggPacket;
import org.gagravarr.theora.TheoraPacket;
import org.gagravarr.theora.TheoraPacketFactory;

public class TheoraInfo
extends HighLevelOggStreamPacket
implements TheoraPacket {
    private int majorVersion;
    private int minorVersion;
    private int revisionVersion;
    private int frameWidthMB;
    private int frameHeightMB;
    private long frameNumSuperBlocks;
    private long frameNumBlocks;
    private long frameNumMacroBlocks;
    private long pictureRegionWidth;
    private long pictureRegionHeight;
    private int pictureRegionXOffset;
    private int pictureRegionYOffset;
    private long frameRateNumerator;
    private long frameRateDenominator;
    private long pixelAspectNumerator;
    private long pixelAspectDenomerator;
    private int colourSpace;
    private int pixelFormat;
    private long nominalBitrate;
    private int qualityHint;
    private int keyFrameNumberGranuleShift;

    public TheoraInfo() {
        this.majorVersion = 3;
        this.minorVersion = 2;
        this.revisionVersion = 1;
    }

    public TheoraInfo(OggPacket pkt) {
        super(pkt);
        byte[] data = this.getData();
        this.majorVersion = data[7];
        this.minorVersion = data[8];
        this.revisionVersion = data[9];
        if (this.majorVersion != 3) {
            throw new IllegalArgumentException("Unsupported Theora version " + this.getVersion() + " detected");
        }
        this.frameWidthMB = IOUtils.getInt2BE(data, 10);
        this.frameHeightMB = IOUtils.getInt2BE(data, 12);
        this.pictureRegionWidth = IOUtils.getInt3BE(data, 14);
        this.pictureRegionHeight = IOUtils.getInt3BE(data, 17);
        this.pictureRegionXOffset = data[20];
        this.pictureRegionYOffset = data[21];
        this.frameRateNumerator = IOUtils.getInt4BE(data, 22);
        this.frameRateDenominator = IOUtils.getInt4BE(data, 26);
        this.pixelAspectNumerator = IOUtils.getInt3BE(data, 30);
        this.pixelAspectDenomerator = IOUtils.getInt3BE(data, 33);
        this.colourSpace = data[36];
        this.nominalBitrate = IOUtils.getInt3BE(data, 37);
        int lastTwo = IOUtils.getInt2BE(data, 40);
        this.qualityHint = lastTwo >> 10;
        this.keyFrameNumberGranuleShift = lastTwo >> 5 & 0x1F;
        this.pixelFormat = lastTwo >> 3 & 3;
    }

    public OggPacket write() {
        byte[] data = new byte[42];
        TheoraPacketFactory.populateMetadataHeader(data, 128, data.length);
        data[7] = IOUtils.fromInt(this.majorVersion);
        data[8] = IOUtils.fromInt(this.minorVersion);
        data[9] = IOUtils.fromInt(this.revisionVersion);
        IOUtils.putInt2BE(data, 10, this.frameWidthMB);
        IOUtils.putInt2BE(data, 12, this.frameHeightMB);
        IOUtils.putInt3BE(data, 14, this.pictureRegionWidth);
        IOUtils.putInt3BE(data, 17, this.pictureRegionHeight);
        data[20] = IOUtils.fromInt(this.pictureRegionXOffset);
        data[21] = IOUtils.fromInt(this.pictureRegionYOffset);
        IOUtils.putInt4BE(data, 22, this.frameRateNumerator);
        IOUtils.putInt4BE(data, 26, this.frameRateDenominator);
        IOUtils.putInt3BE(data, 30, this.pixelAspectNumerator);
        IOUtils.putInt3BE(data, 33, this.pixelAspectDenomerator);
        data[36] = IOUtils.fromInt(this.colourSpace);
        IOUtils.putInt3BE(data, 37, this.nominalBitrate);
        int lastTwo = (this.qualityHint << 6) + this.keyFrameNumberGranuleShift;
        lastTwo = (lastTwo << 2) + this.pixelFormat;
        IOUtils.putInt2BE(data, 40, lastTwo <<= 3);
        this.setData(data);
        return super.write();
    }

    public String getVersion() {
        return this.majorVersion + "." + this.minorVersion + "." + this.revisionVersion;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public int getRevisionVersion() {
        return this.revisionVersion;
    }

    public int getFrameWidth() {
        return this.frameWidthMB << 4;
    }

    public int getFrameHeight() {
        return this.frameHeightMB << 4;
    }

    public int getFrameWidthMB() {
        return this.frameWidthMB;
    }

    public void setFrameWidthMB(int frameWidthMB) {
        this.frameWidthMB = frameWidthMB;
    }

    public int getFrameHeightMB() {
        return this.frameHeightMB;
    }

    public void setFrameHeightMB(int frameHeightMB) {
        this.frameHeightMB = frameHeightMB;
    }

    public long getFrameNumSuperBlocks() {
        return this.frameNumSuperBlocks;
    }

    public void setFrameNumSuperBlocks(long frameNumSuperBlocks) {
        this.frameNumSuperBlocks = frameNumSuperBlocks;
    }

    public long getFrameNumBlocks() {
        return this.frameNumBlocks;
    }

    public void setFrameNumBlocks(long frameNumBlocks) {
        this.frameNumBlocks = frameNumBlocks;
    }

    public long getFrameNumMacroBlocks() {
        return this.frameNumMacroBlocks;
    }

    public void setFrameNumMacroBlocks(long frameNumMacroBlocks) {
        this.frameNumMacroBlocks = frameNumMacroBlocks;
    }

    public long getPictureRegionWidth() {
        return this.pictureRegionWidth;
    }

    public void setPictureRegionWidth(long pictureRegionWidth) {
        this.pictureRegionWidth = pictureRegionWidth;
    }

    public long getPictureRegionHeight() {
        return this.pictureRegionHeight;
    }

    public void setPictureRegionHeight(long pictureRegionHeight) {
        this.pictureRegionHeight = pictureRegionHeight;
    }

    public int getPictureRegionXOffset() {
        return this.pictureRegionXOffset;
    }

    public void setPictureRegionXOffset(int pictureRegionXOffset) {
        this.pictureRegionXOffset = pictureRegionXOffset;
    }

    public int getPictureRegionYOffset() {
        return this.pictureRegionYOffset;
    }

    public void setPictureRegionYOffset(int pictureRegionYOffset) {
        this.pictureRegionYOffset = pictureRegionYOffset;
    }

    public long getFrameRateNumerator() {
        return this.frameRateNumerator;
    }

    public void setFrameRateNumerator(long frameRateNumerator) {
        this.frameRateNumerator = frameRateNumerator;
    }

    public long getFrameRateDenominator() {
        return this.frameRateDenominator;
    }

    public void setFrameRateDenominator(long frameRateDenominator) {
        this.frameRateDenominator = frameRateDenominator;
    }

    public long getPixelAspectNumerator() {
        return this.pixelAspectNumerator;
    }

    public void setPixelAspectNumerator(long pixelAspectNumerator) {
        this.pixelAspectNumerator = pixelAspectNumerator;
    }

    public long getPixelAspectDenomerator() {
        return this.pixelAspectDenomerator;
    }

    public void setPixelAspectDenomerator(long pixelAspectDenomerator) {
        this.pixelAspectDenomerator = pixelAspectDenomerator;
    }

    public int getColourSpace() {
        return this.colourSpace;
    }

    public void setColourSpace(int colourSpace) {
        this.colourSpace = colourSpace;
    }

    public int getPixelFormat() {
        return this.pixelFormat;
    }

    public void setPixelFormat(int pixelFormat) {
        this.pixelFormat = pixelFormat;
    }

    public long getNominalBitrate() {
        return this.nominalBitrate;
    }

    public void setNominalBitrate(long nominalBitrate) {
        this.nominalBitrate = nominalBitrate;
    }

    public int getQualityHint() {
        return this.qualityHint;
    }

    public void setQualityHint(int qualityHint) {
        this.qualityHint = qualityHint;
    }

    public int getKeyFrameNumberGranuleShift() {
        return this.keyFrameNumberGranuleShift;
    }

    public void setKeyFrameNumberGranuleShift(int keyFrameNumberGranuleShift) {
        this.keyFrameNumberGranuleShift = keyFrameNumberGranuleShift;
    }
}

