/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.util;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ConcurrentModificationException;
import java.util.IdentityHashMap;
import org.apache.sis.util.resources.Errors;

public final class Cloner {
    private Class<?> type;
    private Method method;
    private final boolean isCloneRequired;
    private final IdentityHashMap<Object, Object> cloneResults;

    public Cloner() {
        this(true);
    }

    public Cloner(boolean bl) {
        this.isCloneRequired = bl;
        this.cloneResults = new IdentityHashMap();
    }

    private Object cloneArray(Object object, Class<?> clazz) throws CloneNotSupportedException {
        int n = Array.getLength(object);
        Object object2 = Array.newInstance(clazz, n);
        if (this.cloneResults.put(object, object2) != null) {
            throw new ConcurrentModificationException();
        }
        if (clazz.isPrimitive()) {
            System.arraycopy(object, 0, object2, 0, n);
        } else {
            for (int i = 0; i < n; ++i) {
                Array.set(object2, i, this.clone(Array.get(object, i)));
            }
        }
        return object2;
    }

    public Object clone(Object object) throws CloneNotSupportedException {
        if (object == null) {
            return null;
        }
        Object object2 = this.cloneResults.get(object);
        if (object2 != null) {
            return object2;
        }
        Class<?> clazz = object.getClass();
        Class<?> clazz2 = clazz.getComponentType();
        if (clazz2 != null) {
            return this.cloneArray(object, clazz2);
        }
        SecurityException securityException = null;
        object2 = object;
        try {
            if (clazz != this.type) {
                this.method = clazz.getMethod("clone", null);
                this.type = clazz;
                if (!Modifier.isPublic(this.method.getDeclaringClass().getModifiers())) {
                    try {
                        this.method.setAccessible(true);
                    }
                    catch (SecurityException securityException2) {
                        securityException = securityException2;
                    }
                }
            }
            if (this.method != null) {
                object2 = this.method.invoke(object, (Object[])null);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            if (this.isCloneRequired) {
                throw Cloner.fail(noSuchMethodException, clazz);
            }
            this.method = null;
            this.type = clazz;
        }
        catch (IllegalAccessException illegalAccessException) {
            if (securityException != null) {
                illegalAccessException.addSuppressed(securityException);
            }
            throw Cloner.fail(illegalAccessException, clazz);
        }
        catch (InvocationTargetException invocationTargetException) {
            Cloner.rethrow(invocationTargetException.getCause());
            throw Cloner.fail(invocationTargetException, clazz);
        }
        catch (SecurityException securityException3) {
            throw Cloner.fail(securityException3, clazz);
        }
        if (this.cloneResults.put(object, object2) != null) {
            throw new ConcurrentModificationException();
        }
        return object2;
    }

    private static void rethrow(Throwable throwable) throws CloneNotSupportedException {
        if (throwable instanceof CloneNotSupportedException) {
            throw (CloneNotSupportedException)throwable;
        }
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
    }

    private static CloneNotSupportedException fail(Throwable throwable, Class<?> clazz) {
        return (CloneNotSupportedException)new CloneNotSupportedException(Errors.format((short)20, clazz)).initCause(throwable);
    }

    public static Object cloneIfPublic(Object object) throws CloneNotSupportedException {
        if (object != null) {
            Class<?> clazz = object.getClass();
            Class<?> clazz2 = clazz.getComponentType();
            if (clazz2 != null) {
                if (clazz2.isPrimitive()) {
                    int n = Array.getLength(object);
                    Object object2 = Array.newInstance(clazz2, n);
                    System.arraycopy(object, 0, object2, 0, n);
                    return object2;
                }
                return new Cloner().cloneArray(object, clazz2);
            }
            try {
                Method method = clazz.getMethod("clone", null);
                if (Modifier.isPublic(method.getModifiers())) {
                    return method.invoke(object, (Object[])null);
                }
            }
            catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
                throw new AssertionError((Object)reflectiveOperationException);
            }
            catch (InvocationTargetException invocationTargetException) {
                Cloner.rethrow(invocationTargetException.getCause());
                throw Cloner.fail(invocationTargetException, clazz);
            }
            catch (SecurityException securityException) {
                throw Cloner.fail(securityException, clazz);
            }
        }
        return object;
    }
}

