/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cluster.placement.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import org.apache.solr.cluster.placement.CollectionMetrics;
import org.apache.solr.cluster.placement.ReplicaMetric;
import org.apache.solr.cluster.placement.ReplicaMetrics;
import org.apache.solr.cluster.placement.ShardMetrics;

public class CollectionMetricsBuilder {
    final Map<String, ShardMetricsBuilder> shardMetricsBuilders = new HashMap<String, ShardMetricsBuilder>();

    public Map<String, ShardMetricsBuilder> getShardMetricsBuilders() {
        return this.shardMetricsBuilders;
    }

    public CollectionMetrics build() {
        final HashMap metricsMap = new HashMap();
        this.shardMetricsBuilders.forEach((shard, builder) -> metricsMap.put(shard, builder.build()));
        return new CollectionMetrics(){

            @Override
            public Optional<ShardMetrics> getShardMetrics(String shardName) {
                return Optional.ofNullable((ShardMetrics)metricsMap.get(shardName));
            }

            @Override
            public Iterator<ShardMetrics> iterator() {
                return metricsMap.values().iterator();
            }
        };
    }

    public static class ReplicaMetricsBuilder {
        final Map<ReplicaMetric<?>, Object> metrics = new HashMap();
        final String replicaName;
        boolean leader;

        public ReplicaMetricsBuilder(String replicaName) {
            this.replicaName = replicaName;
        }

        public ReplicaMetricsBuilder setLeader(boolean leader) {
            this.leader = leader;
            return this;
        }

        public ReplicaMetricsBuilder addMetric(ReplicaMetric<?> metric, Object value) {
            if ((value = metric.convert(value)) != null) {
                this.metrics.put(metric, value);
            }
            return this;
        }

        public ReplicaMetrics build() {
            return new ReplicaMetrics(){

                @Override
                public String getReplicaName() {
                    return replicaName;
                }

                @Override
                public <T> Optional<T> getReplicaMetric(ReplicaMetric<T> metric) {
                    return Optional.ofNullable(metrics.get(metric));
                }

                @Override
                public Iterator<Map.Entry<ReplicaMetric<?>, Object>> iterator() {
                    return metrics.entrySet().iterator();
                }
            };
        }
    }

    public static class ShardMetricsBuilder {
        final Map<String, ReplicaMetricsBuilder> replicaMetricsBuilders = new HashMap<String, ReplicaMetricsBuilder>();
        final String shardName;
        ReplicaMetricsBuilder leaderMetricsBuilder;

        public ShardMetricsBuilder(String shardName) {
            this.shardName = shardName;
        }

        public Map<String, ReplicaMetricsBuilder> getReplicaMetricsBuilders() {
            return this.replicaMetricsBuilders;
        }

        public ShardMetricsBuilder setLeaderMetrics(ReplicaMetricsBuilder replicaMetricsBuilder) {
            this.leaderMetricsBuilder = replicaMetricsBuilder;
            if (this.leaderMetricsBuilder != null) {
                this.replicaMetricsBuilders.put(this.leaderMetricsBuilder.replicaName, this.leaderMetricsBuilder);
            }
            return this;
        }

        public ShardMetrics build() {
            final HashMap metricsMap = new HashMap();
            this.replicaMetricsBuilders.forEach((name, replicaBuilder) -> {
                ReplicaMetrics metrics = replicaBuilder.build();
                metricsMap.put(name, metrics);
                if (replicaBuilder.leader) {
                    if (this.leaderMetricsBuilder == null) {
                        this.leaderMetricsBuilder = replicaBuilder;
                    } else if (!this.leaderMetricsBuilder.replicaName.equals(replicaBuilder.replicaName)) {
                        throw new RuntimeException("two replicas claim to be the shard leader! existing=" + this.leaderMetricsBuilder + " and current " + replicaBuilder);
                    }
                }
            });
            final ReplicaMetrics finalLeaderMetrics = this.leaderMetricsBuilder != null ? this.leaderMetricsBuilder.build() : null;
            return new ShardMetrics(){

                @Override
                public String getShardName() {
                    return shardName;
                }

                @Override
                public Optional<ReplicaMetrics> getLeaderMetrics() {
                    return Optional.ofNullable(finalLeaderMetrics);
                }

                @Override
                public Optional<ReplicaMetrics> getReplicaMetrics(String replicaName) {
                    return Optional.ofNullable((ReplicaMetrics)metricsMap.get(replicaName));
                }

                @Override
                public Iterator<ReplicaMetrics> iterator() {
                    return metricsMap.values().iterator();
                }
            };
        }
    }
}

