/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.Parameter;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.ContentStreamBase;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.admin.api.AdminAPIBase;
import org.apache.solr.jersey.ExperimentalResponse;
import org.apache.solr.jersey.JacksonReflectMapWriter;
import org.apache.solr.jersey.PermissionName;
import org.apache.solr.jersey.SolrJerseyResponse;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.PermissionNameProvider;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;

@Path(value="/cluster/zookeeper/")
public class ZookeeperReadAPI
extends AdminAPIBase {
    private static final String EMPTY = "empty";

    @Inject
    public ZookeeperReadAPI(CoreContainer coreContainer, SolrQueryRequest req, SolrQueryResponse rsp) {
        super(coreContainer, req, rsp);
    }

    @GET
    @Path(value="/data{zkPath:.+}")
    @Produces(value={"application/vnd.apache.solr.raw", "application/json"})
    @PermissionName(value=PermissionNameProvider.Name.ZK_READ_PERM)
    public ZooKeeperFileResponse readNode(@Parameter(description="The path of the node to read from ZooKeeper") @PathParam(value="zkPath") String zkPath) {
        zkPath = this.sanitizeZkPath(zkPath);
        return this.readNodeAndAddToResponse(zkPath);
    }

    @GET
    @Path(value="/data/security.json")
    @Produces(value={"application/vnd.apache.solr.raw", "application/json"})
    @PermissionName(value=PermissionNameProvider.Name.SECURITY_READ_PERM)
    public ZooKeeperFileResponse readSecurityJsonNode() {
        return this.readNodeAndAddToResponse("/security.json");
    }

    private String sanitizeZkPath(String zkPath) {
        if (zkPath == null || zkPath.isEmpty()) {
            return "/";
        }
        if (zkPath.length() > 1 && zkPath.endsWith("/")) {
            return zkPath.substring(0, zkPath.length() - 1);
        }
        return zkPath;
    }

    @GET
    @Path(value="/children{zkPath:.*}")
    @Produces(value={"application/json", "application/javabin"})
    @PermissionName(value=PermissionNameProvider.Name.ZK_READ_PERM)
    public ListZkChildrenResponse listNodes(@Parameter(description="The path of the ZooKeeper node to stat and list children of") @PathParam(value="zkPath") String zkPath, @Parameter(description="Controls whether stat information for child nodes is included in the response. 'true' by default.") @QueryParam(value="children") Boolean includeChildren) throws Exception {
        ListZkChildrenResponse listResponse = this.instantiateJerseyResponse(ListZkChildrenResponse.class);
        zkPath = this.sanitizeZkPath(zkPath);
        try {
            Stat stat = this.coreContainer.getZkController().getZkClient().exists(zkPath, null, true);
            listResponse.stat = new AnnotatedStat(stat);
            if (includeChildren != null && !includeChildren.booleanValue()) {
                return listResponse;
            }
            List l = this.coreContainer.getZkController().getZkClient().getChildren(zkPath, null, false);
            Object prefix = zkPath.endsWith("/") ? zkPath : zkPath + "/";
            LinkedHashMap<String, Stat> stats = new LinkedHashMap<String, Stat>();
            for (String s : l) {
                try {
                    stats.put(s, this.coreContainer.getZkController().getZkClient().exists((String)prefix + s, null, false));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            HashMap<String, AnnotatedStat> childStats = new HashMap<String, AnnotatedStat>();
            for (Map.Entry e : stats.entrySet()) {
                childStats.put((String)e.getKey(), new AnnotatedStat((Stat)e.getValue()));
            }
            listResponse.unknownFields.put(zkPath, childStats);
            return listResponse;
        }
        catch (KeeperException.NoNodeException e) {
            throw new SolrException(SolrException.ErrorCode.NOT_FOUND, "No such node :" + zkPath);
        }
    }

    private String guessMime(byte firstByte) {
        switch (firstByte) {
            case 123: {
                return "application/json";
            }
            case 60: 
            case 63: {
                return "application/xml; charset=UTF-8";
            }
        }
        return "application/octet-stream";
    }

    private ZooKeeperFileResponse readNodeAndAddToResponse(String zkPath) {
        ZooKeeperFileResponse zkFileResponse = this.instantiateJerseyResponse(ZooKeeperFileResponse.class);
        byte[] d = this.readPathFromZookeeper(zkPath);
        if (d == null || d.length == 0) {
            zkFileResponse.zkData = EMPTY;
            return zkFileResponse;
        }
        zkFileResponse.output = new ContentStreamBase.ByteArrayStream(d, null, this.guessMime(d[0]));
        return zkFileResponse;
    }

    private byte[] readPathFromZookeeper(String path) {
        byte[] d;
        try {
            d = this.coreContainer.getZkController().getZkClient().getData(path, null, null, false);
        }
        catch (KeeperException.NoNodeException e) {
            throw new SolrException(SolrException.ErrorCode.NOT_FOUND, "No such node: " + path);
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unexpected error", (Throwable)e);
        }
        return d;
    }

    public static class ZooKeeperFileResponse
    extends SolrJerseyResponse {
        @JsonProperty(value="content")
        public ContentStream output;
        @JsonProperty(value="zkData")
        public String zkData;
    }

    public static class AnnotatedStat
    implements JacksonReflectMapWriter {
        @JsonProperty(value="version")
        public int version;
        @JsonProperty(value="aversion")
        public int aversion;
        @JsonProperty(value="children")
        public int children;
        @JsonProperty(value="ctime")
        public long ctime;
        @JsonProperty(value="cversion")
        public int cversion;
        @JsonProperty(value="czxid")
        public long czxid;
        @JsonProperty(value="ephemeralOwner")
        public long ephemeralOwner;
        @JsonProperty(value="mtime")
        public long mtime;
        @JsonProperty(value="mzxid")
        public long mzxid;
        @JsonProperty(value="pzxid")
        public long pzxid;
        @JsonProperty(value="dataLength")
        public int dataLength;

        public AnnotatedStat(Stat stat) {
            this.version = stat.getVersion();
            this.aversion = stat.getAversion();
            this.children = stat.getNumChildren();
            this.ctime = stat.getCtime();
            this.cversion = stat.getCversion();
            this.czxid = stat.getCzxid();
            this.ephemeralOwner = stat.getEphemeralOwner();
            this.mtime = stat.getMtime();
            this.mzxid = stat.getMzxid();
            this.pzxid = stat.getPzxid();
            this.dataLength = stat.getDataLength();
        }

        public AnnotatedStat() {
        }
    }

    public static class ListZkChildrenResponse
    extends ExperimentalResponse {
        @JsonProperty(value="stat")
        public AnnotatedStat stat;
        private Map<String, Map<String, AnnotatedStat>> unknownFields = new HashMap<String, Map<String, AnnotatedStat>>();

        @JsonAnyGetter
        public Map<String, Map<String, AnnotatedStat>> unknownProperties() {
            return this.unknownFields;
        }

        @JsonAnySetter
        public void setUnknownProperty(String field, Map<String, AnnotatedStat> value) {
            this.unknownFields.put(field, value);
        }
    }
}

