/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.jersey;

import java.lang.invoke.MethodHandles;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.apache.solr.common.SolrException;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.jersey.RequestContextKeys;
import org.apache.solr.jersey.SolrJerseyResponse;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.servlet.ResponseUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatchAllExceptionMapper
implements ExceptionMapper<Exception> {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Context
    public ResourceContext resourceContext;

    public Response toResponse(Exception exception) {
        ContainerRequestContext containerRequestContext = (ContainerRequestContext)this.resourceContext.getResource(ContainerRequestContext.class);
        SolrQueryResponse solrQueryResponse = (SolrQueryResponse)containerRequestContext.getProperty(RequestContextKeys.SOLR_QUERY_RESPONSE);
        SolrQueryRequest solrQueryRequest = (SolrQueryRequest)containerRequestContext.getProperty(RequestContextKeys.SOLR_QUERY_REQUEST);
        if (exception instanceof WebApplicationException) {
            WebApplicationException wae = (WebApplicationException)exception;
            SolrException solrException = new SolrException(SolrException.ErrorCode.getErrorCode((int)wae.getResponse().getStatus()), wae.getMessage());
            solrQueryResponse.setException((Exception)((Object)solrException));
        } else {
            solrQueryResponse.setException(exception);
        }
        if (exception instanceof WebApplicationException) {
            return this.processWebApplicationException((WebApplicationException)exception);
        }
        return CatchAllExceptionMapper.processAndRespondToException(exception, solrQueryRequest, containerRequestContext);
    }

    public static Response processAndRespondToException(Exception exception, SolrQueryRequest solrQueryRequest, ContainerRequestContext containerRequestContext) {
        Exception normalizedException = RequestHandlerBase.normalizeReceivedException(solrQueryRequest, exception);
        RequestHandlerBase.HandlerMetrics metrics = (RequestHandlerBase.HandlerMetrics)containerRequestContext.getProperty(RequestContextKeys.HANDLER_METRICS);
        if (metrics != null) {
            RequestHandlerBase.processErrorMetricsOnException(normalizedException, metrics);
        }
        return CatchAllExceptionMapper.buildExceptionResponse(normalizedException, solrQueryRequest, containerRequestContext);
    }

    public static Response buildExceptionResponse(Exception normalizedException, SolrQueryRequest solrQueryRequest, ContainerRequestContext containerRequestContext) {
        SolrJerseyResponse response = containerRequestContext.getProperty(RequestContextKeys.SOLR_JERSEY_RESPONSE) == null ? new SolrJerseyResponse() : (SolrJerseyResponse)containerRequestContext.getProperty(RequestContextKeys.SOLR_JERSEY_RESPONSE);
        response.error = ResponseUtils.getTypedErrorInfo(normalizedException, log);
        response.responseHeader.status = response.error.code;
        String mediaType = CatchAllExceptionMapper.getMediaType(solrQueryRequest);
        return Response.status((int)response.error.code).type(mediaType).entity((Object)response).build();
    }

    private static String getMediaType(SolrQueryRequest solrQueryRequest) {
        String wtParam = solrQueryRequest.getParams().get("wt");
        if (wtParam == null) {
            return "application/json";
        }
        switch (wtParam) {
            case "xml": {
                return "application/xml";
            }
            case "javabin": {
                return "application/vnd.apache.solr.javabin";
            }
        }
        return "application/json";
    }

    private Response processWebApplicationException(WebApplicationException wae) {
        return wae.getResponse();
    }
}

