/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.common.SolrException;
import org.apache.solr.response.TextResponseWriter;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.uninverting.UninvertingReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryField
extends FieldType {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    public void checkSchemaField(SchemaField field) {
        super.checkSchemaField(field);
        if (field.isLarge()) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Field type " + this + " is 'large'; not supported (yet)");
        }
    }

    private String toBase64String(ByteBuffer buf) {
        return new String(Base64.getEncoder().encode(ByteBuffer.wrap(buf.array(), buf.arrayOffset() + buf.position(), buf.limit() - buf.position()).array()), StandardCharsets.ISO_8859_1);
    }

    @Override
    public void write(TextResponseWriter writer, String name, IndexableField f) throws IOException {
        writer.writeStr(name, this.toBase64String(this.toObject(f)), false);
    }

    @Override
    public SortField getSortField(SchemaField field, boolean top) {
        throw new RuntimeException("Cannot sort on a Binary field");
    }

    @Override
    public UninvertingReader.Type getUninversionType(SchemaField sf) {
        if (sf.multiValued()) {
            return UninvertingReader.Type.SORTED_SET_BINARY;
        }
        return UninvertingReader.Type.BINARY;
    }

    @Override
    public String toExternal(IndexableField f) {
        return this.toBase64String(this.toObject(f));
    }

    @Override
    public ByteBuffer toObject(IndexableField f) {
        BytesRef bytes = f.binaryValue();
        return ByteBuffer.wrap(bytes.bytes, bytes.offset, bytes.length);
    }

    @Override
    public IndexableField createField(SchemaField field, Object val) {
        if (val == null) {
            return null;
        }
        if (!field.stored()) {
            log.trace("Ignoring unstored binary field: {}", (Object)field);
            return null;
        }
        byte[] buf = null;
        int offset = 0;
        int len = 0;
        if (val instanceof byte[]) {
            buf = (byte[])val;
            len = buf.length;
        } else if (val instanceof ByteBuffer && ((ByteBuffer)val).hasArray()) {
            ByteBuffer byteBuf = (ByteBuffer)val;
            buf = byteBuf.array();
            offset = byteBuf.arrayOffset() + byteBuf.position();
            len = byteBuf.limit() - byteBuf.position();
        } else {
            String strVal = val.toString();
            buf = Base64.getDecoder().decode(strVal);
            offset = 0;
            len = buf.length;
        }
        return new StoredField(field.getName(), buf, offset, len);
    }

    @Override
    public Object toNativeType(Object val) {
        if (val instanceof byte[]) {
            return ByteBuffer.wrap((byte[])val);
        }
        if (val instanceof CharSequence) {
            CharSequence valAsCharSequence = (CharSequence)val;
            return ByteBuffer.wrap(Base64.getDecoder().decode(valAsCharSequence.toString()));
        }
        return super.toNativeType(val);
    }
}

