/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public final class TabularOutput {
    private final String columnSeparator;
    private final List<Object> currentRow = new ArrayList<Object>();
    private final List<List<Object>> data = new ArrayList<List<Object>>();
    private final Writer writer;
    private final int flushCount;
    private final boolean outputHeader;
    private final List<ColumnData> columns;

    public static Builder to(Writer writer) {
        return new Builder(writer);
    }

    public TabularOutput(Writer writer, LinkedHashMap<String, ColumnSpec> columns, String colSeparator, int flushCount, boolean outputHeader) {
        this.writer = writer;
        this.outputHeader = outputHeader;
        this.flushCount = flushCount;
        this.columnSeparator = colSeparator;
        this.columns = columns.entrySet().stream().map(e -> new ColumnData((String)e.getKey(), (ColumnSpec)e.getValue())).collect(Collectors.toList());
    }

    public TabularOutput append(Object ... values) {
        this.currentRow.addAll(Arrays.asList(values));
        if (this.currentRow.size() > this.columns.size()) {
            throw new RuntimeException("Current row has more values than declared columns: " + this.currentRow);
        }
        return this;
    }

    public TabularOutput nextRow() {
        while (this.currentRow.size() < this.columns.size()) {
            this.currentRow.add(null);
        }
        this.data.add(new ArrayList<Object>(this.currentRow));
        this.currentRow.clear();
        if (this.data.size() >= this.flushCount) {
            this.flush();
        }
        return this;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public TabularOutput flush() {
        try {
            this.flush0();
            this.getWriter().flush();
            return this;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void flush0() throws IOException {
        if (!this.currentRow.isEmpty()) {
            throw new RuntimeException("Unflushed data in the current row. Very likely a bug.");
        }
        if (this.data.isEmpty()) {
            return;
        }
        ArrayList formatted = new ArrayList();
        boolean columnWidthsChanged = false;
        for (List<Object> list : this.data) {
            ArrayList<String> formattedRow = new ArrayList<String>();
            formatted.add(formattedRow);
            assert (list.size() == this.columns.size());
            for (int i = 0; i < list.size(); ++i) {
                ColumnData colData = this.columns.get(i);
                String value = this.formatValue(colData, list.get(i));
                formattedRow.add(value);
                int vlen = value.length();
                if (vlen <= colData.width) continue;
                colData.width = vlen;
                columnWidthsChanged = true;
            }
        }
        this.data.clear();
        if (columnWidthsChanged && this.outputHeader) {
            for (ColumnData columnData : this.columns) {
                columnData.width = Math.max(columnData.name.length(), columnData.width);
            }
            this.writer.write(String.join((CharSequence)this.columnSeparator, this.columns.stream().map(d -> this.align(d.spec.alignment, d.name, d.width)).collect(Collectors.toList())));
            this.writer.write("\n");
        }
        for (List list : formatted) {
            for (int i = 0; i < this.columns.size(); ++i) {
                ColumnData cd = this.columns.get(i);
                list.set(i, this.align(cd.spec.alignment, (String)list.get(i), cd.width));
            }
            this.writer.write(String.join((CharSequence)this.columnSeparator, list));
            this.writer.write("\n");
        }
    }

    private String align(Alignment alignment, String string, int width) {
        switch (alignment) {
            case LEFT: {
                return TabularOutput.padEnd(string, width, ' ');
            }
            case RIGHT: {
                return TabularOutput.padStart(string, width, ' ');
            }
        }
        return this.center(string, width);
    }

    private String formatValue(ColumnData columnData, Object v) {
        String value = (v = this.toStringAdapter(v)) == null ? "--" : String.format(Locale.ROOT, columnData.spec.format, v);
        return value;
    }

    private Object toStringAdapter(Object object) {
        if (object == null) {
            return object;
        }
        if (object instanceof char[]) {
            return new String((char[])object);
        }
        if (object instanceof byte[]) {
            return Arrays.toString((byte[])object);
        }
        if (object instanceof short[]) {
            return Arrays.toString((short[])object);
        }
        if (object instanceof int[]) {
            return Arrays.toString((int[])object);
        }
        if (object instanceof long[]) {
            return Arrays.toString((long[])object);
        }
        if (object instanceof float[]) {
            return Arrays.toString((float[])object);
        }
        if (object instanceof double[]) {
            return Arrays.toString((double[])object);
        }
        return object;
    }

    private static String padStart(String string, int minLength, char padChar) {
        Objects.requireNonNull(string);
        if (string.length() >= minLength) {
            return string;
        }
        StringBuilder sb = new StringBuilder(minLength);
        for (int i = string.length(); i < minLength; ++i) {
            sb.append(padChar);
        }
        sb.append(string);
        return sb.toString();
    }

    private static String padEnd(String string, int minLength, char padChar) {
        Objects.requireNonNull(string);
        if (string.length() >= minLength) {
            return string;
        }
        StringBuilder sb = new StringBuilder(minLength);
        sb.append(string);
        for (int i = string.length(); i < minLength; ++i) {
            sb.append(padChar);
        }
        return sb.toString();
    }

    private String center(String s, int size) {
        StringBuilder sb = new StringBuilder(size);
        for (int i = (size - s.length()) / 2; i > 0; --i) {
            sb.append(' ');
        }
        sb.append(s);
        while (sb.length() < size) {
            sb.append(' ');
        }
        return sb.toString();
    }

    public static class Builder {
        private Writer writer;
        private boolean outputHeader = true;
        private int flushCount = 1;
        private String columnSeparator = " ";
        private LinkedHashMap<String, ColumnSpec> columnsByName = new LinkedHashMap();

        public Builder(Writer writer) {
            this.writer = Objects.requireNonNull(writer);
        }

        public Builder outputHeaders(boolean outputHeader) {
            this.outputHeader = outputHeader;
            return this;
        }

        public Builder flushEvery(int n) {
            this.flushCount = n;
            return this;
        }

        public Builder noAutoFlush() {
            return this.flushEvery(Integer.MAX_VALUE);
        }

        public Builder columnSeparator(String separator) {
            this.columnSeparator = separator;
            return this;
        }

        public Builder addColumn(String name, Consumer<ColumnSpec> columnConfig) {
            if (this.columnsByName.containsKey(name)) {
                throw new IllegalArgumentException("Two columns with the same name: " + name);
            }
            ColumnSpec cs = new ColumnSpec();
            columnConfig.accept(cs);
            this.columnsByName.put(name, cs);
            return this;
        }

        public Builder addColumn(String name) {
            return this.addColumn(name, t -> {});
        }

        public TabularOutput build() {
            return new TabularOutput(this.writer, this.columnsByName, this.columnSeparator, this.flushCount, this.outputHeader);
        }

        public Builder addColumns(String ... names) {
            Arrays.stream(names).forEach(name -> this.addColumn((String)name));
            return this;
        }
    }

    public static final class ColumnSpec {
        Alignment alignment = Alignment.LEFT;
        String format = "%s";

        public ColumnSpec alignLeft() {
            this.alignment = Alignment.LEFT;
            return this;
        }

        public ColumnSpec alignRight() {
            this.alignment = Alignment.RIGHT;
            return this;
        }

        public ColumnSpec alignCenter() {
            this.alignment = Alignment.CENTER;
            return this;
        }

        public ColumnSpec format(String formatString) {
            this.format = Objects.requireNonNull(formatString);
            return this;
        }
    }

    public static enum Alignment {
        LEFT,
        RIGHT,
        CENTER;

    }

    private static final class ColumnData {
        final String name;
        final ColumnSpec spec;
        int width;

        public ColumnData(String name, ColumnSpec spec) {
            this.name = name;
            this.spec = spec;
        }
    }
}

