/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.provider;

import javax.xml.bind.annotation.XmlTransient;
import org.apache.sis.internal.referencing.provider.AbstractProvider;
import org.apache.sis.internal.referencing.provider.GeodeticOperation;
import org.apache.sis.internal.referencing.provider.Geographic3Dto2D;
import org.apache.sis.internal.referencing.provider.GeographicRedimension;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.util.FactoryException;

@XmlTransient
public final class Geographic2Dto3D
extends GeographicRedimension {
    private static final long serialVersionUID = -1198461394243672064L;
    public static final ParameterDescriptor<Double> HEIGHT;
    public static final ParameterDescriptorGroup PARAMETERS;

    public Geographic2Dto3D() {
        this((GeodeticOperation[])null);
    }

    Geographic2Dto3D(GeodeticOperation[] geodeticOperationArray) {
        super(2, 3, PARAMETERS, geodeticOperationArray);
    }

    Class<Geographic3Dto2D> variant3D() {
        return Geographic3Dto2D.class;
    }

    @Override
    public AbstractProvider inverse() {
        return Geographic3Dto2D.getMethod(Geographic3Dto2D.PARAMETERS);
    }

    @Override
    public MathTransform createMathTransform(MathTransformFactory mathTransformFactory, ParameterValueGroup parameterValueGroup) throws FactoryException {
        Parameters parameters = Parameters.castOrWrap(parameterValueGroup);
        MatrixSIS matrixSIS = Matrices.createDiagonal(4, 3);
        matrixSIS.setElement(2, 2, parameters.doubleValue(HEIGHT));
        matrixSIS.setElement(3, 2, 1.0);
        return mathTransformFactory.createAffineTransform((Matrix)matrixSIS);
    }

    static {
        ParameterBuilder parameterBuilder = (ParameterBuilder)Geographic2Dto3D.builder().setCodeSpace(Citations.SIS, "SIS");
        HEIGHT = Geographic2Dto3D.createShift((ParameterBuilder)parameterBuilder.addName("height"));
        PARAMETERS = ((ParameterBuilder)parameterBuilder.addName("Geographic2D to 3D conversion")).createGroup(new GeneralParameterDescriptor[]{HEIGHT});
    }
}

