/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.opennlp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.opennlp.OpenNLPTokenizer;
import org.apache.lucene.analysis.opennlp.tools.NLPPOSTaggerOp;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.FlagsAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.IgnoreRandomChains;

@IgnoreRandomChains(reason="LUCENE-10352: add argument providers for this one")
public final class OpenNLPPOSFilter
extends TokenFilter {
    private List<AttributeSource> sentenceTokenAttrs = new ArrayList<AttributeSource>();
    String[] tags = null;
    private int tokenNum = 0;
    private boolean moreTokensAvailable = true;
    private final NLPPOSTaggerOp posTaggerOp;
    private final TypeAttribute typeAtt = (TypeAttribute)this.addAttribute(TypeAttribute.class);
    private final FlagsAttribute flagsAtt = (FlagsAttribute)this.addAttribute(FlagsAttribute.class);
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);

    public OpenNLPPOSFilter(TokenStream input, NLPPOSTaggerOp posTaggerOp) {
        super(input);
        this.posTaggerOp = posTaggerOp;
    }

    public final boolean incrementToken() throws IOException {
        if (!this.moreTokensAvailable) {
            this.clear();
            return false;
        }
        if (this.tokenNum == this.sentenceTokenAttrs.size()) {
            String[] sentenceTokens = this.nextSentence();
            if (sentenceTokens == null) {
                this.clear();
                return false;
            }
            this.tags = this.posTaggerOp.getPOSTags(sentenceTokens);
            this.tokenNum = 0;
        }
        this.clearAttributes();
        this.sentenceTokenAttrs.get(this.tokenNum).copyTo((AttributeSource)this);
        this.typeAtt.setType(this.tags[this.tokenNum++]);
        return true;
    }

    private String[] nextSentence() throws IOException {
        ArrayList<String> termList = new ArrayList<String>();
        this.sentenceTokenAttrs.clear();
        boolean endOfSentence = false;
        while (!endOfSentence && (this.moreTokensAvailable = this.input.incrementToken())) {
            termList.add(this.termAtt.toString());
            endOfSentence = 0 != (this.flagsAtt.getFlags() & OpenNLPTokenizer.EOS_FLAG_BIT);
            this.sentenceTokenAttrs.add(this.input.cloneAttributes());
        }
        return termList.size() > 0 ? termList.toArray(new String[termList.size()]) : null;
    }

    public void reset() throws IOException {
        super.reset();
        this.moreTokensAvailable = true;
        this.clear();
    }

    private void clear() {
        this.sentenceTokenAttrs.clear();
        this.tags = null;
        this.tokenNum = 0;
    }
}

