/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import java.io.Reader;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.processor.DetectedLanguage;
import org.apache.solr.update.processor.LanguageIdentifierUpdateProcessor;
import org.apache.solr.update.processor.SolrInputDocumentReader;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.tika.language.LanguageIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TikaLanguageIdentifierUpdateProcessor
extends LanguageIdentifierUpdateProcessor {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public TikaLanguageIdentifierUpdateProcessor(SolrQueryRequest req, SolrQueryResponse rsp, UpdateRequestProcessor next) {
        super(req, rsp, next);
    }

    @Override
    protected List<DetectedLanguage> detectLanguage(Reader solrDocReader) {
        String content = SolrInputDocumentReader.asString(solrDocReader);
        ArrayList<DetectedLanguage> languages = new ArrayList<DetectedLanguage>();
        if (content.length() != 0) {
            LanguageIdentifier identifier = new LanguageIdentifier(content);
            Double distance = Double.parseDouble(this.tikaSimilarityPattern.matcher(identifier.toString()).replaceFirst("$1"));
            Double certainty = 1.0 - 5.0 * distance;
            if (certainty < 0.0) {
                certainty = 0.0;
            }
            DetectedLanguage language = new DetectedLanguage(identifier.getLanguage(), certainty);
            languages.add(language);
            if (log.isDebugEnabled()) {
                log.debug("Language detected as {} with a certainty of {} (Tika distance={})", new Object[]{language, language.getCertainty(), identifier});
            }
        } else {
            log.debug("No input text to detect language from, returning empty list");
        }
        return languages;
    }
}

