/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.tracklink.codelinks.cache.impl;

import com.almworks.tracklink.codelinks.cache.impl.DataInputStream;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Random;
import org.jetbrains.annotations.NonNls;

public class DataFile {
    @NonNls
    private static final String BACKUP_SUFFIX = ".bak";
    private final File myStorage;
    private boolean myDirty = false;
    @NonNls
    private static final String DAT_EXTENSION = "dat";

    public DataFile(File storage) throws IOException {
        File bak;
        this.myStorage = storage;
        if (!this.myStorage.exists()) {
            this.reset();
        }
        if ((bak = this.getBakFile()).exists()) {
            FileUtil.rename((File)bak, (File)this.myStorage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] bytes) throws IOException {
        File bak = this.getBakFile();
        if (bak.exists() && !bak.delete()) {
            throw new IOException("Can't delete " + bak.getAbsolutePath());
        }
        if (this.myStorage.exists()) {
            FileUtil.rename((File)this.myStorage, (File)bak);
        }
        FileOutputStream stream = new FileOutputStream(this.myStorage);
        try {
            stream.write(bytes);
        }
        finally {
            stream.close();
        }
        if (!bak.delete() && bak.exists()) {
            throw new IOException("Can't delete " + bak.getAbsolutePath());
        }
        this.myDirty = false;
    }

    public void setDirty() {
        this.myDirty = true;
    }

    public boolean isDirty() {
        return this.myDirty;
    }

    public byte[] read() throws IOException {
        return FileUtil.loadFileBytes((File)this.myStorage);
    }

    public DataInputStream getInputStream() throws IOException {
        return new DataInputStream(this.read());
    }

    public String getReferenceName() {
        return this.myStorage.getName();
    }

    private File getBakFile() {
        return new File(this.myStorage.getParentFile(), this.myStorage.getName() + BACKUP_SUFFIX);
    }

    public static DataFile fromConfig(String name, File parent, @NonNls String prefix) throws IOException {
        return new DataFile(DataFile.fileFromConfig(name, parent, prefix, DAT_EXTENSION));
    }

    public static DataFile newUnique(File parent, @NonNls String prefix, int any) throws IOException {
        return new DataFile(DataFile.newUniquFile(parent, prefix, DAT_EXTENSION, any));
    }

    public static File fileFromConfig(String name, File parent, String prefix, String extension) {
        if (name != null) {
            return new File(parent, name + extension);
        }
        return DataFile.newUniquFile(parent, prefix, extension, System.identityHashCode(name));
    }

    public static File newUniquFile(File parent, String prefix, String extension, int any) {
        File file;
        Random random = new Random(any);
        while ((file = new File(parent, prefix + random.nextInt() + "." + extension)).exists()) {
        }
        return file;
    }

    public long length() {
        return this.myStorage.length();
    }

    public void reset() {
        this.myStorage.delete();
        File parent = this.myStorage.getParentFile();
        if (parent == null) {
            throw new RuntimeException(this.myStorage.getAbsolutePath());
        }
        parent.mkdirs();
        try {
            this.myStorage.createNewFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

